/*
 * Decompiled with CFR 0.152.
 */
package io.stepuplabs.spaydkmp.formatter;

import io.stepuplabs.spaydkmp.formatter.FormatToken;
import io.stepuplabs.spaydkmp.formatter.Formatter;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0011\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00072\b\u0010\f\u001a\u0004\u0018\u00010\u0001J\b\u0010\r\u001a\u00020\nH\u0002J\b\u0010\u000e\u001a\u00020\nH\u0002J\u001c\u0010\u000f\u001a\u00020\n2\n\u0010\u0010\u001a\u00060\u0011j\u0002`\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\b\u0010\u0015\u001a\u00020\nH\u0002J\u0018\u0010\u0016\u001a\u00060\u0011j\u0002`\u00122\n\u0010\u0017\u001a\u00060\u0011j\u0002`\u0012H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\u0001X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lio/stepuplabs/spaydkmp/formatter/Transformer;", "", "formatter", "Lio/stepuplabs/spaydkmp/formatter/Formatter;", "<init>", "(Lio/stepuplabs/spaydkmp/formatter/Formatter;)V", "formatToken", "Lio/stepuplabs/spaydkmp/formatter/FormatToken;", "arg", "transform", "", "token", "argument", "transformFromString", "transformFromPercent", "padding", "source", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "startIndex", "", "transformFromInteger", "wrapParentheses", "result", "shared_release"})
public final class Transformer {
    @NotNull
    private final Formatter formatter;
    @Nullable
    private FormatToken formatToken;
    @Nullable
    private Object arg;

    public Transformer(@NotNull Formatter formatter) {
        Intrinsics.checkNotNullParameter((Object)formatter, (String)"formatter");
        this.formatter = formatter;
    }

    @NotNull
    public final String transform(@NotNull FormatToken token, @Nullable Object argument) {
        Intrinsics.checkNotNullParameter((Object)token, (String)"token");
        this.formatToken = token;
        this.arg = argument;
        String result = switch (token.getConversionType()) {
            case 'S', 's' -> this.transformFromString();
            case 'X', 'd', 'o', 'x' -> this.transformFromInteger();
            case '%' -> this.transformFromPercent();
            default -> throw new Exception(String.valueOf(token.getConversionType()));
        };
        if (Character.isUpperCase(token.getConversionType())) {
            String string = result.toUpperCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toUpperCase(...)");
            return string;
        }
        return result;
    }

    private final String transformFromString() {
        StringBuilder result = new StringBuilder();
        int startIndex = 0;
        FormatToken formatToken = this.formatToken;
        Intrinsics.checkNotNull((Object)formatToken);
        int flags = formatToken.getFlags();
        FormatToken formatToken2 = this.formatToken;
        Intrinsics.checkNotNull((Object)formatToken2);
        if (formatToken2.isFlagSet(1)) {
            FormatToken formatToken3 = this.formatToken;
            Intrinsics.checkNotNull((Object)formatToken3);
            if (!formatToken3.isWidthSet()) {
                FormatToken formatToken4 = this.formatToken;
                Intrinsics.checkNotNull((Object)formatToken4);
                throw new Exception("-" + formatToken4.getConversionType());
            }
        }
        if (flags != 0 && 1 != flags) {
            throw new Exception();
        }
        result.append(this.arg);
        return this.padding(result, startIndex);
    }

    private final String transformFromPercent() {
        StringBuilder result = new StringBuilder("%");
        int startIndex = 0;
        FormatToken formatToken = this.formatToken;
        Intrinsics.checkNotNull((Object)formatToken);
        int flags = formatToken.getFlags();
        FormatToken formatToken2 = this.formatToken;
        Intrinsics.checkNotNull((Object)formatToken2);
        if (formatToken2.isFlagSet(1)) {
            FormatToken formatToken3 = this.formatToken;
            Intrinsics.checkNotNull((Object)formatToken3);
            if (!formatToken3.isWidthSet()) {
                FormatToken formatToken4 = this.formatToken;
                Intrinsics.checkNotNull((Object)formatToken4);
                throw new Exception("-" + formatToken4.getConversionType());
            }
        }
        if (flags != 0 && 1 != flags) {
            throw new Exception();
        }
        FormatToken formatToken5 = this.formatToken;
        Intrinsics.checkNotNull((Object)formatToken5);
        if (formatToken5.isPrecisionSet()) {
            throw new Exception();
        }
        return this.padding(result, startIndex);
    }

    private final String padding(StringBuilder source, int startIndex) {
        StringBuilder src = source;
        int start = startIndex;
        FormatToken formatToken = this.formatToken;
        Boolean paddingRight = formatToken != null ? Boolean.valueOf(formatToken.isFlagSet(1)) : null;
        int paddingChar = 32;
        FormatToken formatToken2 = this.formatToken;
        Intrinsics.checkNotNull((Object)formatToken2);
        if (formatToken2.isFlagSet(16)) {
            paddingChar = 48;
        } else {
            start = 0;
        }
        FormatToken formatToken3 = this.formatToken;
        Intrinsics.checkNotNull((Object)formatToken3);
        int width = formatToken3.getWidth();
        FormatToken formatToken4 = this.formatToken;
        Intrinsics.checkNotNull((Object)formatToken4);
        int precision = formatToken4.getPrecision();
        int length = src.length();
        if (precision >= 0) {
            length = Math.min(length, precision);
            src = new StringBuilder(src.substring(0, length) + src.substring(src.length()));
        }
        if (width > 0) {
            width = Math.max(src.length(), width);
        }
        if (length >= width) {
            String string = src.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            return string;
        }
        int n = 0;
        int n2 = width - length;
        char[] cArray = new char[n2];
        while (n < n2) {
            int n3 = n++;
            cArray[n3] = paddingChar;
        }
        char[] paddings = cArray;
        String insertString = StringsKt.concatToString((char[])paddings);
        Boolean bl = paddingRight;
        Intrinsics.checkNotNull((Object)bl);
        StringBuilder stringBuilder = bl != false ? src.append(insertString) : src.insert(start, insertString);
        String string = src.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    private final String transformFromInteger() {
        long value;
        char currentConversionType;
        StringBuilder result;
        boolean isNegative;
        int startIndex;
        block37: {
            block38: {
                long l;
                block36: {
                    block35: {
                        startIndex = 0;
                        isNegative = false;
                        result = new StringBuilder();
                        FormatToken formatToken = this.formatToken;
                        Intrinsics.checkNotNull((Object)formatToken);
                        currentConversionType = formatToken.getConversionType();
                        FormatToken formatToken2 = this.formatToken;
                        Intrinsics.checkNotNull((Object)formatToken2);
                        if (formatToken2.isFlagSet(1)) break block35;
                        FormatToken formatToken3 = this.formatToken;
                        Intrinsics.checkNotNull((Object)formatToken3);
                        if (!formatToken3.isFlagSet(16)) break block36;
                    }
                    FormatToken formatToken = this.formatToken;
                    Intrinsics.checkNotNull((Object)formatToken);
                    if (!formatToken.isWidthSet()) {
                        throw new Exception();
                    }
                }
                FormatToken formatToken = this.formatToken;
                Intrinsics.checkNotNull((Object)formatToken);
                if (formatToken.isFlagSet(4)) {
                    FormatToken formatToken4 = this.formatToken;
                    Intrinsics.checkNotNull((Object)formatToken4);
                    if (formatToken4.isFlagSet(8)) {
                        FormatToken formatToken5 = this.formatToken;
                        Intrinsics.checkNotNull((Object)formatToken5);
                        throw new Exception(formatToken5.getStrFlags());
                    }
                }
                FormatToken formatToken6 = this.formatToken;
                Intrinsics.checkNotNull((Object)formatToken6);
                if (formatToken6.isPrecisionSet()) {
                    throw new Exception();
                }
                Object object = this.arg;
                if (object instanceof Long) {
                    Object object2 = this.arg;
                    Intrinsics.checkNotNull((Object)object2, (String)"null cannot be cast to non-null type kotlin.Long");
                    l = (Long)object2;
                } else if (object instanceof Integer) {
                    Object object3 = this.arg;
                    Intrinsics.checkNotNull((Object)object3, (String)"null cannot be cast to non-null type kotlin.Int");
                    l = ((Integer)object3).intValue();
                } else if (object instanceof Short) {
                    Object object4 = this.arg;
                    Intrinsics.checkNotNull((Object)object4, (String)"null cannot be cast to non-null type kotlin.Short");
                    l = ((Short)object4).shortValue();
                } else if (object instanceof Byte) {
                    Object object5 = this.arg;
                    Intrinsics.checkNotNull((Object)object5, (String)"null cannot be cast to non-null type kotlin.Byte");
                    l = ((Byte)object5).byteValue();
                } else {
                    throw new IllegalStateException(("Value not supported [" + this.arg + "] for type `" + currentConversionType + "'").toString());
                }
                value = l;
                if ('d' == currentConversionType) break block37;
                FormatToken formatToken7 = this.formatToken;
                Intrinsics.checkNotNull((Object)formatToken7);
                if (formatToken7.isFlagSet(4)) break block38;
                FormatToken formatToken8 = this.formatToken;
                Intrinsics.checkNotNull((Object)formatToken8);
                if (formatToken8.isFlagSet(8)) break block38;
                FormatToken formatToken9 = this.formatToken;
                Intrinsics.checkNotNull((Object)formatToken9);
                if (formatToken9.isFlagSet(32)) break block38;
                FormatToken formatToken10 = this.formatToken;
                Intrinsics.checkNotNull((Object)formatToken10);
                if (!formatToken10.isFlagSet(64)) break block37;
            }
            throw new Exception();
        }
        FormatToken formatToken = this.formatToken;
        Intrinsics.checkNotNull((Object)formatToken);
        if (formatToken.isFlagSet(2)) {
            startIndex += (switch (currentConversionType) {
                case 'd' -> throw new Exception();
                case 'o' -> {
                    result.append("0");
                    yield 1;
                }
                default -> {
                    result.append("0x");
                    yield 2;
                }
            });
        }
        FormatToken formatToken11 = this.formatToken;
        Intrinsics.checkNotNull((Object)formatToken11);
        if (formatToken11.isFlagSet(1)) {
            FormatToken formatToken12 = this.formatToken;
            Intrinsics.checkNotNull((Object)formatToken12);
            if (formatToken12.isFlagSet(16)) {
                FormatToken formatToken13 = this.formatToken;
                Intrinsics.checkNotNull((Object)formatToken13);
                throw new Exception(formatToken13.getStrFlags());
            }
        }
        if (value < 0L) {
            isNegative = true;
        }
        if ('d' == currentConversionType) {
            result.append(String.valueOf(this.arg));
        } else {
            isNegative = false;
        }
        if (!isNegative) {
            FormatToken formatToken14 = this.formatToken;
            Intrinsics.checkNotNull((Object)formatToken14);
            if (formatToken14.isFlagSet(4)) {
                result.insert(0, '+');
                ++startIndex;
            }
            FormatToken formatToken15 = this.formatToken;
            Intrinsics.checkNotNull((Object)formatToken15);
            if (formatToken15.isFlagSet(8)) {
                result.insert(0, ' ');
                ++startIndex;
            }
        }
        if (isNegative) {
            FormatToken formatToken16 = this.formatToken;
            Intrinsics.checkNotNull((Object)formatToken16);
            if (formatToken16.isFlagSet(64)) {
                result = this.wrapParentheses(result);
                String string = result.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
                return string;
            }
        }
        if (isNegative) {
            FormatToken formatToken17 = this.formatToken;
            Intrinsics.checkNotNull((Object)formatToken17);
            if (formatToken17.isFlagSet(16)) {
                ++startIndex;
            }
        }
        return this.padding(result, startIndex);
    }

    private final StringBuilder wrapParentheses(StringBuilder result) {
        Intrinsics.checkNotNullExpressionValue((Object)result.deleteCharAt(0), (String)"deleteCharAt(...)");
        result.insert(0, '(');
        FormatToken formatToken = this.formatToken;
        Intrinsics.checkNotNull((Object)formatToken);
        if (formatToken.isFlagSet(16)) {
            FormatToken formatToken2 = this.formatToken;
            Intrinsics.checkNotNull((Object)formatToken2);
            FormatToken formatToken3 = formatToken2;
            formatToken3.setWidth(formatToken3.getWidth() - 1);
            this.padding(result, 1);
            v2 = result.append(')');
        } else {
            result.append(')');
            v2 = this.padding(result, 0);
        }
        return result;
    }
}

