/*
 * Decompiled with CFR 0.152.
 */
package io.streamlayer.common.data.voximplant;

import com.voximplant.sdk.call.CallSettings;
import com.voximplant.sdk.call.ICall;
import com.voximplant.sdk.call.ICallListener;
import com.voximplant.sdk.call.VideoCodec;
import com.voximplant.sdk.call.VideoFlags;
import com.voximplant.sdk.client.AuthParams;
import com.voximplant.sdk.client.ClientState;
import com.voximplant.sdk.client.IClient;
import com.voximplant.sdk.client.IClientLoginListener;
import com.voximplant.sdk.client.IClientSessionListener;
import com.voximplant.sdk.client.LoginError;
import io.streamlayer.common.data.voximplant.AuthError;
import io.streamlayer.common.data.voximplant.VoxClientManagerKt;
import io.streamlayer.common.utils.SLRLog;
import io.streamlayer.sdk.model.auth.VoximplantUser;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, bv={1, 0, 3}, k=1, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010!\n\u0002\b\t\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002:\u00019B\u000f\u0012\u0006\u0010+\u001a\u00020*\u00a2\u0006\u0004\b7\u00108J\n\u0010\u0004\u001a\u0004\u0018\u00010\u0003H\u0002J\b\u0010\u0006\u001a\u00020\u0005H\u0002J\u0018\u0010\n\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u00032\b\u0010\t\u001a\u0004\u0018\u00010\bJ\u000e\u0010\u000b\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u0003J\u000e\u0010\f\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\bJ\u0006\u0010\r\u001a\u00020\u0005J \u0010\u0011\u001a\u00020\u00052\u0018\b\u0002\u0010\u0010\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u000f\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u000eJ\b\u0010\u0012\u001a\u00020\u0005H\u0016J\u0012\u0010\u0015\u001a\u00020\u00052\b\u0010\u0014\u001a\u0004\u0018\u00010\u0013H\u0016J\b\u0010\u0016\u001a\u00020\u0005H\u0016J\u001a\u0010\u001a\u001a\u00020\u00052\u0006\u0010\u0017\u001a\u00020\u00132\b\u0010\u0019\u001a\u0004\u0018\u00010\u0018H\u0016J\u0010\u0010\u001d\u001a\u00020\u00052\u0006\u0010\u001c\u001a\u00020\u001bH\u0016J\u0010\u0010\u001f\u001a\u00020\u00052\u0006\u0010\u001e\u001a\u00020\u0013H\u0016J\u0010\u0010 \u001a\u00020\u00052\u0006\u0010\u001c\u001a\u00020\u001bH\u0016J\u0010\u0010!\u001a\u00020\u00052\u0006\u0010\u0019\u001a\u00020\u0018H\u0016J\"\u0010'\u001a\u0004\u0018\u00010&2\u0006\u0010\"\u001a\u00020\u00132\u0006\u0010$\u001a\u00020#2\b\u0010\u0007\u001a\u0004\u0018\u00010%J\u0018\u0010)\u001a\u00020\u00052\u0006\u0010(\u001a\u00020&2\b\u0010\u0007\u001a\u0004\u0018\u00010%R\u0019\u0010+\u001a\u00020*8\u0006@\u0006\u00a2\u0006\f\n\u0004\b+\u0010,\u001a\u0004\b-\u0010.R\u0018\u0010/\u001a\u0004\u0018\u00010\b8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b/\u00100R\u001c\u00102\u001a\b\u0012\u0004\u0012\u00020\u0013018\u0002@\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b2\u00103R&\u00104\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u000f\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u000e8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b4\u00105R\u001c\u00106\u001a\b\u0012\u0004\u0012\u00020\u0003018\u0002@\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b6\u00103\u00a8\u0006:"}, d2={"Lio/streamlayer/common/data/voximplant/VoxClientManager;", "Lcom/voximplant/sdk/client/IClientSessionListener;", "Lcom/voximplant/sdk/client/IClientLoginListener;", "Lio/streamlayer/common/data/voximplant/VoxClientManager$Listener;", "getSubscribedListener", "", "internalConnectAndLogin", "listener", "Lio/streamlayer/sdk/model/auth/VoximplantUser;", "user", "register", "unregister", "login", "logout", "Lkotlin/Function1;", "Lio/streamlayer/common/data/voximplant/AuthError;", "completion", "connect", "onConnectionEstablished", "", "p0", "onConnectionFailed", "onConnectionClosed", "displayName", "Lcom/voximplant/sdk/client/AuthParams;", "authParams", "onLoginSuccessful", "Lcom/voximplant/sdk/client/LoginError;", "reason", "onLoginFailed", "key", "onOneTimeKeyGenerated", "onRefreshTokenFailed", "onRefreshTokenSuccess", "topicId", "", "isVideoEnabled", "Lcom/voximplant/sdk/call/ICallListener;", "Lcom/voximplant/sdk/call/ICall;", "createCall", "call", "endCall", "Lcom/voximplant/sdk/client/IClient;", "client", "Lcom/voximplant/sdk/client/IClient;", "getClient", "()Lcom/voximplant/sdk/client/IClient;", "voximplantUser", "Lio/streamlayer/sdk/model/auth/VoximplantUser;", "", "servers", "Ljava/util/List;", "reconnectCompletion", "Lkotlin/jvm/functions/Function1;", "listeners", "<init>", "(Lcom/voximplant/sdk/client/IClient;)V", "Listener", "sdk_originalRelease"})
public final class VoxClientManager
implements IClientSessionListener,
IClientLoginListener {
    @NotNull
    private final IClient client;
    @Nullable
    private VoximplantUser voximplantUser;
    @NotNull
    private final List<String> servers;
    @Nullable
    private Function1<? super AuthError, Unit> reconnectCompletion;
    @NotNull
    private final List<Listener> listeners;

    public VoxClientManager(@NotNull IClient object) {
        ArrayList arrayList;
        ArrayList arrayList2;
        IClient iClient = object;
        Intrinsics.checkNotNullParameter((Object)object, (String)"client");
        this.client = object;
        object = arrayList2;
        arrayList2 = new ArrayList();
        this.servers = object;
        object = arrayList;
        arrayList = new ArrayList();
        this.listeners = object;
        iClient.setClientLoginListener((IClientLoginListener)this);
        iClient.setClientSessionListener((IClientSessionListener)this);
    }

    private final Listener getSubscribedListener() {
        Object var1_1;
        block1: {
            for (Object e : ((VoxClientManager)this).listeners) {
                var1_1 = e;
                if (!((Listener)e).isSubscribed()) continue;
                break block1;
            }
            var1_1 = null;
        }
        return var1_1;
    }

    public static /* synthetic */ void connect$default(VoxClientManager voxClientManager, Function1 function1, int n, Object object) {
        if ((n & 1) != 0) {
            function1 = null;
        }
        voxClientManager.connect((Function1<? super AuthError, Unit>)function1);
    }

    private final void internalConnectAndLogin() {
        Object object = SLRLog.INSTANCE;
        ((SLRLog)object).i("VoxClientManager", Intrinsics.stringPlus((String)"internalConnectAndLogin ", (Object)this.client.getClientState()));
        if (this.client.getClientState() == ClientState.DISCONNECTED) {
            ((SLRLog)object).i("VoxClientManager", "internalConnectAndLogin init connect");
            IClient iClient = this.client;
            boolean bl = false;
            try {
                iClient.connect(bl, this.servers);
            }
            catch (IllegalStateException illegalStateException) {
                this.onConnectionFailed(AuthError.NetworkIssues.getDescription());
            }
        }
        if (this.client.getClientState() == ClientState.CONNECTED) {
            Unit unit;
            SLRLog.INSTANCE.i("VoxClientManager", "internalConnectAndLogin init login");
            object = this.voximplantUser;
            if (object == null) {
                unit = null;
            } else {
                Object object2 = object;
                object = ((VoximplantUser)object2).getUsername();
                this.getClient().login((String)object, ((VoximplantUser)object2).getPassword());
                unit = Unit.INSTANCE;
            }
            if (unit == null) {
                this.onLoginFailed(LoginError.INVALID_USERNAME);
            }
        }
    }

    @NotNull
    public final IClient getClient() {
        return this.client;
    }

    public final void register(@NotNull Listener listener2, @Nullable VoximplantUser voximplantUser2) {
        VoxClientManager voxClientManager = this;
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        SLRLog.INSTANCE.d("VoxClientManager", "register " + listener2 + ' ' + voximplantUser2);
        boolean bl = voxClientManager.listeners.isEmpty();
        if (voxClientManager.listeners.isEmpty() ^ true) {
            Iterator iterator = this.listeners.iterator();
            while (iterator.hasNext()) {
                ((Listener)iterator.next()).updateSubscription(false);
            }
        }
        this.listeners.add(listener2);
        listener2.updateSubscription(true);
        if (bl && voximplantUser2 != null) {
            this.login(voximplantUser2);
        }
    }

    public final void unregister(@NotNull Listener listener2) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        SLRLog.INSTANCE.d("VoxClientManager", Intrinsics.stringPlus((String)"unregister ", (Object)listener2));
        this.listeners.remove(listener2);
        listener2.updateSubscription(false);
        if (this.listeners.isEmpty()) {
            this.logout();
        } else {
            ((Listener)CollectionsKt.last(this.listeners)).updateSubscription(true);
        }
    }

    public final void login(@NotNull VoximplantUser voximplantUser2) {
        Intrinsics.checkNotNullParameter((Object)voximplantUser2, (String)"user");
        SLRLog.INSTANCE.i("VoxClientManager", "login " + voximplantUser2 + ' ' + this.client.getClientState());
        if (Intrinsics.areEqual((Object)this.voximplantUser, (Object)voximplantUser2)) {
            return;
        }
        this.voximplantUser = voximplantUser2;
        this.internalConnectAndLogin();
    }

    public final void logout() {
        SLRLog.INSTANCE.i("VoxClientManager", Intrinsics.stringPlus((String)"logout ", (Object)this.client.getClientState()));
        if (this.client.getClientState() == ClientState.LOGGED_IN) {
            this.client.disconnect();
        }
        this.voximplantUser = null;
    }

    public final void connect(@Nullable Function1<? super AuthError, Unit> function1) {
        SLRLog.INSTANCE.i("VoxClientManager", Intrinsics.stringPlus((String)"connect ", (Object)this.client.getClientState()));
        if (this.client.getClientState() == ClientState.LOGGED_IN) {
            if (function1 != null) {
                function1.invoke(null);
            }
            return;
        }
        if (this.voximplantUser == null) {
            if (function1 != null) {
                function1.invoke((Object)AuthError.InvalidUsername);
            }
            return;
        }
        this.reconnectCompletion = function1;
        this.internalConnectAndLogin();
    }

    public void onConnectionEstablished() {
        this.internalConnectAndLogin();
    }

    public void onConnectionFailed(@Nullable String function1) {
        SLRLog.INSTANCE.i("VoxClientManager", Intrinsics.stringPlus((String)"onConnectionFailed ", (Object)function1));
        function1 = this.getSubscribedListener();
        if (function1 != null) {
            function1.onConnectionFailed(AuthError.NetworkIssues);
        }
        function1 = this.reconnectCompletion;
        if (function1 != null) {
            function1.invoke((Object)AuthError.NetworkIssues);
        }
        this.reconnectCompletion = null;
    }

    public void onConnectionClosed() {
        SLRLog.INSTANCE.i("VoxClientManager", "onConnectionClosed");
        Function1<? super AuthError, Unit> function1 = this.getSubscribedListener();
        if (function1 != null) {
            function1.onConnectionClosed();
        }
        function1 = this.reconnectCompletion;
        if (function1 != null) {
            function1.invoke((Object)AuthError.NetworkIssues);
        }
        this.reconnectCompletion = null;
    }

    public void onLoginSuccessful(@NotNull String function1, @Nullable AuthParams authParams) {
        Intrinsics.checkNotNullParameter((Object)function1, (String)"displayName");
        SLRLog.INSTANCE.i("VoxClientManager", Intrinsics.stringPlus((String)"onLoginSuccessful ", (Object)function1));
        function1 = this.reconnectCompletion;
        if (function1 != null) {
            function1.invoke(null);
        }
        this.reconnectCompletion = null;
    }

    public void onLoginFailed(@NotNull LoginError object) {
        LoginError loginError = object;
        Intrinsics.checkNotNullParameter((Object)loginError, (String)"reason");
        object = VoxClientManagerKt.access$makeAuthError(loginError);
        SLRLog.INSTANCE.i("VoxClientManager", Intrinsics.stringPlus((String)"onLoginFailed ", (Object)object));
        Function1<? super AuthError, Unit> function1 = this.reconnectCompletion;
        if (function1 != null) {
            function1.invoke(object);
        }
        this.reconnectCompletion = null;
    }

    public void onOneTimeKeyGenerated(@NotNull String string2) {
        Intrinsics.checkNotNullParameter((Object)string2, (String)"key");
    }

    public void onRefreshTokenFailed(@NotNull LoginError loginError) {
        Intrinsics.checkNotNullParameter((Object)loginError, (String)"reason");
    }

    public void onRefreshTokenSuccess(@NotNull AuthParams authParams) {
        Intrinsics.checkNotNullParameter((Object)authParams, (String)"authParams");
    }

    @Nullable
    public final ICall createCall(@NotNull String string2, boolean bl, @Nullable ICallListener iCallListener) {
        CallSettings callSettings;
        VoxClientManager voxClientManager = voxClientManager2;
        Intrinsics.checkNotNullParameter((Object)string2, (String)"topicId");
        SLRLog.INSTANCE.i("VoxClientManager", Intrinsics.stringPlus((String)"createCall ", (Object)string2));
        VoxClientManager voxClientManager2 = callSettings;
        new CallSettings().videoFlags = new VideoFlags(true, bl);
        new CallSettings().preferredVideoCodec = VideoCodec.AUTO;
        voxClientManager2 = voxClientManager.client.callConference(Intrinsics.stringPlus((String)"conf_", (Object)string2), (CallSettings)voxClientManager2);
        if (voxClientManager2 != null) {
            VoxClientManager voxClientManager3 = voxClientManager2;
            voxClientManager3.addCallListener(iCallListener);
            voxClientManager3.start();
        }
        return voxClientManager2;
    }

    public final void endCall(@NotNull ICall iCall, @Nullable ICallListener iCallListener) {
        Intrinsics.checkNotNullParameter((Object)iCall, (String)"call");
        if (iCallListener != null) {
            iCall.removeCallListener(iCallListener);
        }
        iCall.hangup(null);
    }

    @Metadata(mv={1, 5, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\bf\u0018\u00002\u00020\u0001J\b\u0010\u0003\u001a\u00020\u0002H&J\u0010\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0004\u001a\u00020\u0002H&J\u0010\u0010\t\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u0007H&J\b\u0010\n\u001a\u00020\u0005H&\u00a8\u0006\u000b"}, d2={"Lio/streamlayer/common/data/voximplant/VoxClientManager$Listener;", "", "", "isSubscribed", "isActive", "", "updateSubscription", "Lio/streamlayer/common/data/voximplant/AuthError;", "error", "onConnectionFailed", "onConnectionClosed", "sdk_originalRelease"})
    public static interface Listener {
        public boolean isSubscribed();

        public void updateSubscription(boolean var1);

        public void onConnectionFailed(@NotNull AuthError var1);

        public void onConnectionClosed();
    }
}

