/*
 * Decompiled with CFR 0.152.
 */
package io.streamlayer.common.views.keyboard;

import android.content.Context;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.inputmethod.InputMethodManager;
import android.widget.PopupWindow;
import androidx.appcompat.widget.AppCompatEditText;
import androidx.core.content.ContextCompat;
import androidx.core.view.ViewCompat;
import androidx.core.view.WindowInsetsCompat;
import io.streamlayer.common.utils.SLRLog;
import io.streamlayer.common.views.keyboard.KeyboardEmojiView;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, bv={1, 0, 3}, k=1, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\n\b\u0000\u0018\u00002\u00020\u0001:\u00012B!\u0012\u0006\u0010\r\u001a\u00020\f\u0012\b\u0010\u0012\u001a\u0004\u0018\u00010\u0011\u0012\u0006\u0010\u0017\u001a\u00020\u0016\u00a2\u0006\u0004\b0\u00101J\b\u0010\u0003\u001a\u00020\u0002H\u0002J\u0010\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0004H\u0002J\u0010\u0010\t\u001a\u00020\u00022\b\u0010\b\u001a\u0004\u0018\u00010\u0007J\u0006\u0010\n\u001a\u00020\u0002J\u0006\u0010\u000b\u001a\u00020\u0002R\u0019\u0010\r\u001a\u00020\f8\u0006@\u0006\u00a2\u0006\f\n\u0004\b\r\u0010\u000e\u001a\u0004\b\u000f\u0010\u0010R\u001b\u0010\u0012\u001a\u0004\u0018\u00010\u00118\u0006@\u0006\u00a2\u0006\f\n\u0004\b\u0012\u0010\u0013\u001a\u0004\b\u0014\u0010\u0015R\u0019\u0010\u0017\u001a\u00020\u00168\u0006@\u0006\u00a2\u0006\f\n\u0004\b\u0017\u0010\u0018\u001a\u0004\b\u0019\u0010\u001aR\u001e\u0010\u001d\u001a\n \u001c*\u0004\u0018\u00010\u001b0\u001b8\u0002@\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001d\u0010\u001eR\u0016\u0010 \u001a\u00020\u001f8\u0002@\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b \u0010!R\u0018\u0010\"\u001a\u0004\u0018\u00010\u00078\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\"\u0010#R\u0019\u0010%\u001a\u00020$8\u0006@\u0006\u00a2\u0006\f\n\u0004\b%\u0010&\u001a\u0004\b'\u0010(R\"\u0010*\u001a\u00020)8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b*\u0010+\u001a\u0004\b*\u0010,\"\u0004\b-\u0010.R\u0016\u0010/\u001a\u00020)8B@\u0002X\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b/\u0010,\u00a8\u00063"}, d2={"Lio/streamlayer/common/views/keyboard/KeyboardPopUp;", "", "", "showPopup", "", "margin", "setRootBottomMargin", "Lio/streamlayer/common/views/keyboard/KeyboardPopUp$KeyboardDismissListener;", "listener", "setOnDismissListener", "show", "hide", "Landroid/view/View;", "activityView", "Landroid/view/View;", "getActivityView", "()Landroid/view/View;", "Landroid/view/ViewGroup;", "rootView", "Landroid/view/ViewGroup;", "getRootView", "()Landroid/view/ViewGroup;", "Landroidx/appcompat/widget/AppCompatEditText;", "editText", "Landroidx/appcompat/widget/AppCompatEditText;", "getEditText", "()Landroidx/appcompat/widget/AppCompatEditText;", "Landroid/content/Context;", "kotlin.jvm.PlatformType", "context", "Landroid/content/Context;", "Landroid/widget/PopupWindow;", "popUp", "Landroid/widget/PopupWindow;", "dismissListener", "Lio/streamlayer/common/views/keyboard/KeyboardPopUp$KeyboardDismissListener;", "Lio/streamlayer/common/views/keyboard/KeyboardEmojiView;", "keyboardEmojiView", "Lio/streamlayer/common/views/keyboard/KeyboardEmojiView;", "getKeyboardEmojiView", "()Lio/streamlayer/common/views/keyboard/KeyboardEmojiView;", "", "isVisible", "Z", "()Z", "setVisible", "(Z)V", "isPortrait", "<init>", "(Landroid/view/View;Landroid/view/ViewGroup;Landroidx/appcompat/widget/AppCompatEditText;)V", "KeyboardDismissListener", "sdk_originalRelease"})
public final class KeyboardPopUp {
    @NotNull
    private final View activityView;
    @Nullable
    private final ViewGroup rootView;
    @NotNull
    private final AppCompatEditText editText;
    private final Context context;
    @NotNull
    private final PopupWindow popUp;
    @Nullable
    private KeyboardDismissListener dismissListener;
    @NotNull
    private final KeyboardEmojiView keyboardEmojiView;
    private boolean isVisible;

    public KeyboardPopUp(@NotNull View view2, @Nullable ViewGroup viewGroup, @NotNull AppCompatEditText appCompatEditText) {
        PopupWindow popupWindow;
        Intrinsics.checkNotNullParameter((Object)view2, (String)"activityView");
        Intrinsics.checkNotNullParameter((Object)appCompatEditText, (String)"editText");
        this.activityView = view2;
        this.rootView = viewGroup;
        this.editText = appCompatEditText;
        viewGroup = view2.getContext();
        this.context = viewGroup;
        AppCompatEditText appCompatEditText2 = appCompatEditText = popupWindow;
        AppCompatEditText appCompatEditText3 = appCompatEditText;
        AppCompatEditText appCompatEditText4 = appCompatEditText;
        super((Context)viewGroup);
        this.popUp = appCompatEditText4;
        ViewGroup viewGroup2 = viewGroup;
        Intrinsics.checkNotNullExpressionValue((Object)viewGroup2, (String)"context");
        KeyboardEmojiView keyboardEmojiView = new KeyboardEmojiView((Context)viewGroup2, null, 0, 6, null);
        keyboardEmojiView.setEditText(this.getEditText());
        this.keyboardEmojiView = keyboardEmojiView;
        view2.postDelayed(() -> KeyboardPopUp._init_$lambda-1(this), 100L);
        appCompatEditText3.setFocusable(true);
        appCompatEditText3.setInputMethodMode(2);
        appCompatEditText2.setContentView((View)this.getKeyboardEmojiView());
        appCompatEditText2.setWidth(-1);
        appCompatEditText2.setBackgroundDrawable((Drawable)new ColorDrawable(0));
        appCompatEditText2.setOutsideTouchable(false);
        appCompatEditText2.setFocusable(false);
        popupWindow.setOnDismissListener(() -> KeyboardPopUp.lambda-4$lambda-2(this));
        this.getEditText().setOnTouchListener((arg_0, arg_1) -> KeyboardPopUp.lambda-4$lambda-3(this, arg_0, arg_1));
    }

    private final boolean isPortrait() {
        return this.context.getResources().getConfiguration().orientation == 1;
    }

    private final void showPopup() {
        this.editText.post(() -> KeyboardPopUp.showPopup$lambda-6(this));
    }

    private final void setRootBottomMargin(int n) {
        SLRLog sLRLog = SLRLog.INSTANCE;
        sLRLog.d("ChatViewModel", Intrinsics.stringPlus((String)"KeyboardPopUp setRootBottomMargin ", (Object)n));
        WindowInsetsCompat windowInsetsCompat = ViewCompat.getRootWindowInsets((View)keyboardPopUp2.activityView);
        if (windowInsetsCompat != null) {
            boolean bl = windowInsetsCompat.isVisible(WindowInsetsCompat.Type.ime());
            sLRLog.d("ChatViewModel", Intrinsics.stringPlus((String)"KeyboardPopUp imeVisible ", (Object)bl));
            if (bl && (keyboardPopUp2 = keyboardPopUp2.getRootView()) != null) {
                sLRLog = keyboardPopUp2.getLayoutParams();
                if (sLRLog != null) {
                    KeyboardPopUp keyboardPopUp = keyboardPopUp2;
                    KeyboardPopUp keyboardPopUp2 = (ViewGroup.MarginLayoutParams)sLRLog;
                    ((ViewGroup.MarginLayoutParams)sLRLog).bottomMargin = n;
                    keyboardPopUp.setLayoutParams((ViewGroup.LayoutParams)keyboardPopUp2);
                } else {
                    throw new NullPointerException("null cannot be cast to non-null type android.view.ViewGroup.MarginLayoutParams");
                }
            }
        }
    }

    private static final void _init_$lambda-1(KeyboardPopUp keyboardPopUp) {
        Intrinsics.checkNotNullParameter((Object)keyboardPopUp, (String)"this$0");
        Context context = keyboardPopUp.context;
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"context");
        if (KeyboardEmojiView.LayoutKeyboardConfiguration.INSTANCE.getHeight(context) == 0) {
            KeyboardPopUp keyboardPopUp2 = keyboardPopUp;
            keyboardPopUp2.getEditText().requestFocus();
            Context context2 = keyboardPopUp2.context;
            Intrinsics.checkNotNullExpressionValue((Object)context2, (String)"context");
            InputMethodManager inputMethodManager = (InputMethodManager)ContextCompat.getSystemService((Context)context2, InputMethodManager.class);
            if (inputMethodManager != null) {
                inputMethodManager.showSoftInput((View)keyboardPopUp.getEditText(), 0);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private static final void lambda-4$lambda-2(KeyboardPopUp object) {
        Object object2 = object;
        Intrinsics.checkNotNullParameter((Object)object2, (String)"this$0");
        ((KeyboardPopUp)object2).setVisible(false);
        WindowInsetsCompat windowInsetsCompat = ViewCompat.getRootWindowInsets((View)((KeyboardPopUp)object2).getActivityView());
        if (windowInsetsCompat != null && !windowInsetsCompat.isVisible(WindowInsetsCompat.Type.ime())) {
            super.setRootBottomMargin(0);
        }
        if ((object = ((KeyboardPopUp)object).dismissListener) == null) {
            return;
        }
        object.onKeyboardDismiss();
    }

    private static final boolean lambda-4$lambda-3(KeyboardPopUp keyboardPopUp, View view2, MotionEvent motionEvent) {
        Intrinsics.checkNotNullParameter((Object)keyboardPopUp, (String)"this$0");
        if (motionEvent.getAction() == 1) {
            view2.requestFocus();
            keyboardPopUp.popUp.dismiss();
        }
        return false;
    }

    private static final void showPopup$lambda-6$lambda-5(KeyboardPopUp keyboardPopUp) {
        KeyboardPopUp keyboardPopUp2 = keyboardPopUp;
        Intrinsics.checkNotNullParameter((Object)keyboardPopUp2, (String)"this$0");
        keyboardPopUp2.getEditText().requestFocus();
    }

    private static final void showPopup$lambda-6(KeyboardPopUp keyboardPopUp) {
        Intrinsics.checkNotNullParameter((Object)keyboardPopUp, (String)"this$0");
        SLRLog sLRLog = SLRLog.INSTANCE;
        sLRLog.d("ChatViewModel", "KeyboardPopUp show " + keyboardPopUp.isVisible() + " isPortrait " + keyboardPopUp.isPortrait());
        Context context = keyboardPopUp.context;
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"context");
        int n = KeyboardEmojiView.LayoutKeyboardConfiguration.INSTANCE.getHeight(context);
        sLRLog.d("ChatViewModel", Intrinsics.stringPlus((String)"KeyboardPopUp show ", (Object)n));
        if (n == 0) {
            Context context2 = keyboardPopUp.context;
            Intrinsics.checkNotNullExpressionValue((Object)context2, (String)"context");
            sLRLog = (InputMethodManager)ContextCompat.getSystemService((Context)context2, InputMethodManager.class);
            if (sLRLog != null) {
                sLRLog.showSoftInput((View)keyboardPopUp.getEditText(), 2);
            }
            keyboardPopUp.showPopup();
            return;
        }
        KeyboardPopUp keyboardPopUp2 = keyboardPopUp;
        int n2 = keyboardPopUp.context.getResources().getDisplayMetrics().heightPixels;
        keyboardPopUp2.popUp.showAtLocation(keyboardPopUp.getActivityView(), 0, 0, n2);
        if (!keyboardPopUp2.getEditText().hasFocus()) {
            keyboardPopUp.getEditText().postDelayed(() -> KeyboardPopUp.showPopup$lambda-6$lambda-5(keyboardPopUp), 50L);
        }
    }

    @NotNull
    public final View getActivityView() {
        return this.activityView;
    }

    @Nullable
    public final ViewGroup getRootView() {
        return this.rootView;
    }

    @NotNull
    public final AppCompatEditText getEditText() {
        return this.editText;
    }

    @NotNull
    public final KeyboardEmojiView getKeyboardEmojiView() {
        return this.keyboardEmojiView;
    }

    public final boolean isVisible() {
        return this.isVisible;
    }

    public final void setVisible(boolean bl) {
        this.isVisible = bl;
    }

    public final void setOnDismissListener(@Nullable KeyboardDismissListener keyboardDismissListener) {
        this.dismissListener = keyboardDismissListener;
    }

    public final void show() {
        Object object;
        SLRLog.INSTANCE.d("ChatViewModel", "KeyboardPopUp show " + this.isVisible + " isPortrait " + this.isPortrait());
        this.isVisible = true;
        if (!this.isPortrait()) {
            Context context = this.context;
            Intrinsics.checkNotNullExpressionValue((Object)context, (String)"context");
            this.setRootBottomMargin(KeyboardEmojiView.LayoutKeyboardConfiguration.INSTANCE.getHeight(context));
        }
        if (this.editText.requestFocus()) {
            Context context = this.context;
            Intrinsics.checkNotNullExpressionValue((Object)context, (String)"context");
            object = (InputMethodManager)ContextCompat.getSystemService((Context)context, InputMethodManager.class);
            if (object != null) {
                object.showSoftInput((View)this.editText, 2);
            }
        }
        if ((object = this.context.getSystemService("input_method")) != null) {
            InputMethodManager inputMethodManager = (InputMethodManager)object;
            inputMethodManager.restartInput((View)this.editText);
            inputMethodManager.showSoftInput((View)this.editText, 0);
            this.showPopup();
            return;
        }
        throw new NullPointerException("null cannot be cast to non-null type android.view.inputmethod.InputMethodManager");
    }

    public final void hide() {
        KeyboardPopUp keyboardPopUp = this;
        keyboardPopUp.isVisible = false;
        keyboardPopUp.popUp.dismiss();
        if (!keyboardPopUp.isPortrait()) {
            this.setRootBottomMargin(0);
        }
    }

    @Metadata(mv={1, 5, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\bf\u0018\u00002\u00020\u0001J\b\u0010\u0003\u001a\u00020\u0002H&\u00a8\u0006\u0004"}, d2={"Lio/streamlayer/common/views/keyboard/KeyboardPopUp$KeyboardDismissListener;", "", "", "onKeyboardDismiss", "sdk_originalRelease"})
    public static interface KeyboardDismissListener {
        public void onKeyboardDismiss();
    }
}

