/*
 * Decompiled with CFR 0.152.
 */
package io.streamlayer.sdk.calls.call.view.minified;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.os.Build;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.AttributeSet;
import android.util.TypedValue;
import android.view.FocusFinder;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.view.VelocityTracker;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.view.accessibility.AccessibilityEvent;
import android.view.accessibility.AccessibilityRecord;
import android.view.animation.AnimationUtils;
import android.widget.EdgeEffect;
import android.widget.FrameLayout;
import android.widget.OverScroller;
import android.widget.ScrollView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import androidx.core.view.AccessibilityDelegateCompat;
import androidx.core.view.NestedScrollingChild3;
import androidx.core.view.NestedScrollingChildHelper;
import androidx.core.view.NestedScrollingParent3;
import androidx.core.view.NestedScrollingParentHelper;
import androidx.core.view.ScrollingView;
import androidx.core.view.ViewCompat;
import androidx.core.view.accessibility.AccessibilityNodeInfoCompat;
import androidx.core.view.accessibility.AccessibilityRecordCompat;
import androidx.core.widget.EdgeEffectCompat;
import io.streamlayer.common.utils.SLRLog;
import java.util.ArrayList;

public class TwoWayNestedScrollView
extends FrameLayout
implements NestedScrollingParent3,
NestedScrollingChild3,
ScrollingView {
    static final int ANIMATED_SCROLL_GAP = 250;
    static final float MAX_SCROLL_FACTOR = 0.5f;
    private static final String TAG = "TwoWayNestedScrollView";
    private static final int DEFAULT_SMOOTH_SCROLL_DURATION = 250;
    private static final int INVALID_POINTER = -1;
    private static final AccessibilityDelegate ACCESSIBILITY_DELEGATE = new AccessibilityDelegate();
    private static final int[] SCROLLVIEW_STYLEABLE = new int[]{16843130};
    private long mLastScroll;
    private final Rect mTempRect;
    private OverScroller mScroller;
    private EdgeEffect mEdgeGlowLeft;
    private EdgeEffect mEdgeGlowTop;
    private EdgeEffect mEdgeGlowRight;
    private EdgeEffect mEdgeGlowBottom;
    private int mLastMotionX;
    private int mLastMotionY;
    private boolean mIsLayoutDirty;
    private boolean mIsLaidOut;
    private View mChildToScrollTo;
    private boolean mIsBeingDragged;
    private VelocityTracker mVelocityTracker;
    private boolean mFillViewport;
    private boolean mSmoothScrollingEnabled;
    private int mTouchSlop;
    private int mMinimumVelocity;
    private int mMaximumVelocity;
    private int mActivePointerId;
    private final int[] mScrollOffset;
    private final int[] mScrollConsumed;
    private int mNestedXOffset;
    private int mNestedYOffset;
    private int mLastScrollerX;
    private int mLastScrollerY;
    private boolean mIsLocked;
    private SavedState mSavedState;
    private final NestedScrollingParentHelper mParentHelper;
    private final NestedScrollingChildHelper mChildHelper;
    private float mHorizontalScrollFactor;
    private float mVerticalScrollFactor;
    private OnScrollChangeListener mOnScrollChangeListener;

    public TwoWayNestedScrollView(@NonNull Context context) {
        this(context, null);
    }

    public TwoWayNestedScrollView(@NonNull Context context, @Nullable AttributeSet attributeSet) {
        this(context, attributeSet, 0);
    }

    public TwoWayNestedScrollView(@NonNull Context context, @Nullable AttributeSet attributeSet, int n) {
        TwoWayNestedScrollView twoWayNestedScrollView = this;
        TwoWayNestedScrollView twoWayNestedScrollView2 = this;
        super(context, attributeSet, n);
        twoWayNestedScrollView2.mTempRect = new Rect();
        twoWayNestedScrollView2.mIsLayoutDirty = true;
        twoWayNestedScrollView2.mIsLaidOut = false;
        twoWayNestedScrollView2.mChildToScrollTo = null;
        twoWayNestedScrollView2.mIsBeingDragged = false;
        twoWayNestedScrollView2.mSmoothScrollingEnabled = true;
        twoWayNestedScrollView2.mActivePointerId = -1;
        twoWayNestedScrollView2.mScrollOffset = new int[2];
        twoWayNestedScrollView2.mScrollConsumed = new int[2];
        twoWayNestedScrollView2.initScrollView();
        TypedArray typedArray = context.obtainStyledAttributes(attributeSet, SCROLLVIEW_STYLEABLE, n, 0);
        this.setFillViewport(typedArray.getBoolean(0, false));
        typedArray.recycle();
        twoWayNestedScrollView.mParentHelper = new NestedScrollingParentHelper((ViewGroup)this);
        twoWayNestedScrollView.mChildHelper = new NestedScrollingChildHelper((View)this);
        twoWayNestedScrollView.setNestedScrollingEnabled(true);
        ViewCompat.setAccessibilityDelegate((View)twoWayNestedScrollView, (AccessibilityDelegateCompat)ACCESSIBILITY_DELEGATE);
    }

    private void onNestedScrollInternal(int n, int n2, int n3, @Nullable int[] nArray) {
        TwoWayNestedScrollView twoWayNestedScrollView = this;
        TwoWayNestedScrollView twoWayNestedScrollView2 = this;
        int n4 = twoWayNestedScrollView2.getScrollX();
        int n5 = twoWayNestedScrollView2.getScrollY();
        twoWayNestedScrollView.scrollBy(n, n2);
        n4 = twoWayNestedScrollView.getScrollX() - n4;
        n5 = twoWayNestedScrollView.getScrollY() - n5;
        if (nArray != null) {
            int[] nArray2 = nArray;
            nArray2[0] = nArray[0] + n4;
            nArray2[1] = nArray[1] + n5;
        }
        int n6 = n - n4;
        n = n2 - n5;
        this.mChildHelper.dispatchNestedScroll(n4, n5, n6, n, null, n3, nArray);
    }

    private void initScrollView() {
        TwoWayNestedScrollView twoWayNestedScrollView = twoWayNestedScrollView2;
        twoWayNestedScrollView.mScroller = new OverScroller(twoWayNestedScrollView2.getContext());
        twoWayNestedScrollView.setFocusable(true);
        twoWayNestedScrollView.setDescendantFocusability(262144);
        twoWayNestedScrollView.setWillNotDraw(false);
        TwoWayNestedScrollView twoWayNestedScrollView2 = ViewConfiguration.get((Context)twoWayNestedScrollView.getContext());
        twoWayNestedScrollView.mTouchSlop = twoWayNestedScrollView2.getScaledTouchSlop();
        twoWayNestedScrollView.mMinimumVelocity = twoWayNestedScrollView2.getScaledMinimumFlingVelocity();
        twoWayNestedScrollView.mMaximumVelocity = twoWayNestedScrollView2.getScaledMaximumFlingVelocity();
    }

    private boolean canScrollX() {
        if (this.getChildCount() > 0) {
            View view2 = this.getChildAt(0);
            FrameLayout.LayoutParams layoutParams = (FrameLayout.LayoutParams)view2.getLayoutParams();
            return view2.getWidth() + layoutParams.leftMargin + layoutParams.rightMargin > this.getWidth() - this.getPaddingLeft() - this.getPaddingRight();
        }
        return false;
    }

    private boolean canScrollY() {
        if (this.getChildCount() > 0) {
            View view2 = this.getChildAt(0);
            FrameLayout.LayoutParams layoutParams = (FrameLayout.LayoutParams)view2.getLayoutParams();
            return view2.getHeight() + layoutParams.topMargin + layoutParams.bottomMargin > this.getHeight() - this.getPaddingTop() - this.getPaddingBottom();
        }
        return false;
    }

    private boolean inChild(int n, int n2) {
        if (this.getChildCount() > 0) {
            TwoWayNestedScrollView twoWayNestedScrollView = this;
            int n3 = twoWayNestedScrollView.getScrollX();
            int n4 = twoWayNestedScrollView.getScrollY();
            View view2 = twoWayNestedScrollView.getChildAt(0);
            return n2 >= view2.getTop() - n4 && n2 < view2.getBottom() - n4 && n >= view2.getLeft() - n3 && n < view2.getRight() - n3;
        }
        return false;
    }

    private void initOrResetVelocityTracker() {
        VelocityTracker velocityTracker = this.mVelocityTracker;
        if (velocityTracker == null) {
            this.mVelocityTracker = VelocityTracker.obtain();
        } else {
            velocityTracker.clear();
        }
    }

    private void initVelocityTrackerIfNotExists() {
        if (this.mVelocityTracker == null) {
            this.mVelocityTracker = VelocityTracker.obtain();
        }
    }

    private void recycleVelocityTracker() {
        VelocityTracker velocityTracker = this.mVelocityTracker;
        if (velocityTracker != null) {
            velocityTracker.recycle();
            this.mVelocityTracker = null;
        }
    }

    private void onSecondaryPointerUp(MotionEvent motionEvent) {
        MotionEvent motionEvent2 = motionEvent;
        int n = motionEvent2.getActionIndex();
        if (motionEvent2.getPointerId(n) == twoWayNestedScrollView.mActivePointerId) {
            n = n == 0 ? 1 : 0;
            twoWayNestedScrollView.mLastMotionX = (int)motionEvent.getX(n);
            twoWayNestedScrollView.mLastMotionY = (int)motionEvent.getY(n);
            twoWayNestedScrollView.mActivePointerId = motionEvent.getPointerId(n);
            TwoWayNestedScrollView twoWayNestedScrollView = twoWayNestedScrollView.mVelocityTracker;
            if (twoWayNestedScrollView != null) {
                twoWayNestedScrollView.clear();
            }
        }
    }

    private float getHorizontalScrollFactorCompat() {
        if (this.mHorizontalScrollFactor == 0.0f) {
            TypedValue typedValue;
            TypedValue typedValue2 = typedValue;
            typedValue = new TypedValue();
            Context context = this.getContext();
            if (context.getTheme().resolveAttribute(16842829, typedValue2, true)) {
                this.mHorizontalScrollFactor = typedValue2.getDimension(context.getResources().getDisplayMetrics());
            } else {
                throw new IllegalStateException("Expected theme to define listPreferredItemHeight.");
            }
        }
        return this.mHorizontalScrollFactor;
    }

    private float getVerticalScrollFactorCompat() {
        if (this.mVerticalScrollFactor == 0.0f) {
            TypedValue typedValue;
            TypedValue typedValue2 = typedValue;
            typedValue = new TypedValue();
            Context context = this.getContext();
            if (context.getTheme().resolveAttribute(16842829, typedValue2, true)) {
                this.mVerticalScrollFactor = typedValue2.getDimension(context.getResources().getDisplayMetrics());
            } else {
                throw new IllegalStateException("Expected theme to define listPreferredItemHeight.");
            }
        }
        return this.mVerticalScrollFactor;
    }

    private View findFocusableViewInBounds(boolean bl, int n, int n2) {
        ArrayList arrayList = arrayList.getFocusables(2);
        View view2 = null;
        boolean bl2 = false;
        int n3 = arrayList.size();
        for (int i = 0; i < n3; ++i) {
            View view3 = (View)arrayList.get(i);
            int n4 = view3.getTop();
            int n5 = view3.getBottom();
            if (n >= n5 || n4 >= n2) continue;
            boolean bl3 = n < n4 && n5 < n2;
            if (view2 == null) {
                bl2 = bl3;
                view2 = view3;
                continue;
            }
            n4 = bl && n4 < view2.getTop() || !bl && n5 > view2.getBottom() ? 1 : 0;
            if (bl2) {
                if (!bl3 || n4 == 0) continue;
            } else {
                if (bl3) {
                    boolean bl4;
                    bl2 = bl4 = true;
                    view2 = view3;
                    continue;
                }
                if (n4 == 0) continue;
            }
            view2 = view3;
        }
        return view2;
    }

    private boolean scrollAndFocus(int n, int n2, int n3) {
        TwoWayNestedScrollView twoWayNestedScrollView = this;
        boolean bl = true;
        int n4 = twoWayNestedScrollView.getHeight();
        int n5 = twoWayNestedScrollView.getScrollY();
        n4 = n5 + n4;
        boolean bl2 = n == 33;
        Object object = this.findFocusableViewInBounds(bl2, n2, n3);
        if (object == null) {
            object = this;
        }
        if (n2 >= n5 && n3 <= n4) {
            bl = false;
        } else {
            n2 = bl2 ? (n2 -= n5) : n3 - n4;
            this.doScroll(0, n2);
        }
        if (object != this.findFocus()) {
            object.requestFocus(n);
        }
        return bl;
    }

    private boolean isOffScreen(View view2) {
        TwoWayNestedScrollView twoWayNestedScrollView = this;
        int n = twoWayNestedScrollView.getWidth();
        int n2 = twoWayNestedScrollView.getHeight();
        return this.isWithinDeltaOfScreen(view2, 0, n, 0, n2) ^ true;
    }

    private boolean isWithinDeltaOfScreen(View view2, int n, int n2, int n3, int n4) {
        TwoWayNestedScrollView twoWayNestedScrollView = this;
        view2.getDrawingRect(this.mTempRect);
        twoWayNestedScrollView.offsetDescendantRectToMyCoords(view2, this.mTempRect);
        return twoWayNestedScrollView.mTempRect.bottom + n3 >= this.getScrollY() && this.mTempRect.top - n3 <= this.getScrollY() + n4 && this.mTempRect.right + n >= this.getScrollX() && this.mTempRect.left - n <= this.getScrollX() + n2;
    }

    private void doScroll(int n, int n2) {
        if (n != 0 || n2 != 0) {
            if (this.mSmoothScrollingEnabled) {
                this.smoothScrollBy(n, n2);
            } else {
                this.scrollBy(n, n2);
            }
        }
    }

    private void smoothScrollBy(int n, int n2, int n3, boolean bl) {
        if (this.getChildCount() == 0) {
            return;
        }
        if (AnimationUtils.currentAnimationTimeMillis() - this.mLastScroll > 250L) {
            TwoWayNestedScrollView twoWayNestedScrollView = this;
            View view2 = twoWayNestedScrollView.getChildAt(0);
            FrameLayout.LayoutParams layoutParams = (FrameLayout.LayoutParams)view2.getLayoutParams();
            int n4 = view2.getWidth() + layoutParams.leftMargin + layoutParams.rightMargin;
            int n5 = view2.getHeight() + layoutParams.topMargin + layoutParams.bottomMargin;
            int n6 = twoWayNestedScrollView.getWidth() - this.getPaddingLeft() - this.getPaddingRight();
            int n7 = twoWayNestedScrollView.getHeight() - this.getPaddingTop() - this.getPaddingBottom();
            int n8 = twoWayNestedScrollView.getScrollX();
            int n9 = twoWayNestedScrollView.getScrollY();
            int n10 = n2;
            int n11 = n;
            n = Math.max(0, n4 - n6);
            n2 = Math.max(0, n5 - n7);
            n = Math.max(0, Math.min(n8 + n11, n)) - n8;
            n2 = Math.max(0, Math.min(n9 + n10, n2)) - n9;
            twoWayNestedScrollView.mScroller.startScroll(n8, n9, n, n2, n3);
            this.runAnimatedScroll(bl);
        } else {
            if (!this.mScroller.isFinished()) {
                this.abortAnimatedScroll();
            }
            this.scrollBy(n, n2);
        }
        this.mLastScroll = AnimationUtils.currentAnimationTimeMillis();
    }

    private void runAnimatedScroll(boolean bl) {
        if (bl) {
            this.startNestedScroll(3, 1);
        } else {
            this.stopNestedScroll(1);
        }
        TwoWayNestedScrollView twoWayNestedScrollView = this;
        twoWayNestedScrollView.mLastScrollerX = twoWayNestedScrollView.getScrollX();
        twoWayNestedScrollView.mLastScrollerY = twoWayNestedScrollView.getScrollY();
        ViewCompat.postInvalidateOnAnimation((View)twoWayNestedScrollView);
    }

    private void abortAnimatedScroll() {
        TwoWayNestedScrollView twoWayNestedScrollView = this;
        twoWayNestedScrollView.mScroller.abortAnimation();
        twoWayNestedScrollView.stopNestedScroll(1);
    }

    private void scrollToChild(View view2) {
        TwoWayNestedScrollView twoWayNestedScrollView = this;
        view2.getDrawingRect(this.mTempRect);
        twoWayNestedScrollView.offsetDescendantRectToMyCoords(view2, this.mTempRect);
        int n = twoWayNestedScrollView.computeScrollDeltaToGetChildRectOnScreenX(twoWayNestedScrollView.mTempRect);
        TwoWayNestedScrollView twoWayNestedScrollView2 = this;
        int n2 = twoWayNestedScrollView2.computeScrollDeltaToGetChildRectOnScreenY(twoWayNestedScrollView2.mTempRect);
        if (n != 0 || n2 != 0) {
            this.scrollBy(n, n2);
        }
    }

    private boolean scrollToChildRect(Rect rect, boolean bl) {
        int n = this.computeScrollDeltaToGetChildRectOnScreenX(rect);
        int n2 = this.computeScrollDeltaToGetChildRectOnScreenY(rect);
        boolean bl2 = n != 0;
        boolean bl3 = n2 != 0;
        if (bl2 || bl3) {
            if (bl) {
                this.scrollBy(n, n2);
            } else {
                this.smoothScrollBy(n, n2);
            }
        }
        return bl2 || bl3;
    }

    private static boolean isViewDescendantOf(View view2, View view3) {
        if (view2 == view3) {
            return true;
        }
        return (view2 = view2.getParent()) instanceof ViewGroup && TwoWayNestedScrollView.isViewDescendantOf(view2, view3);
    }

    private void endDrag() {
        TwoWayNestedScrollView twoWayNestedScrollView = this;
        twoWayNestedScrollView.mIsBeingDragged = false;
        twoWayNestedScrollView.recycleVelocityTracker();
        twoWayNestedScrollView.stopNestedScroll(0);
        if (twoWayNestedScrollView.mEdgeGlowTop != null) {
            TwoWayNestedScrollView twoWayNestedScrollView2 = this;
            twoWayNestedScrollView2.mEdgeGlowLeft.onRelease();
            twoWayNestedScrollView2.mEdgeGlowTop.onRelease();
            twoWayNestedScrollView2.mEdgeGlowRight.onRelease();
            twoWayNestedScrollView2.mEdgeGlowBottom.onRelease();
        }
    }

    private void ensureGlows() {
        if (twoWayNestedScrollView.getOverScrollMode() != 2) {
            if (twoWayNestedScrollView.mEdgeGlowTop == null) {
                EdgeEffect edgeEffect;
                EdgeEffect edgeEffect2;
                EdgeEffect edgeEffect3;
                EdgeEffect edgeEffect4;
                TwoWayNestedScrollView twoWayNestedScrollView = twoWayNestedScrollView.getContext();
                EdgeEffect edgeEffect5 = edgeEffect4;
                edgeEffect4 = new EdgeEffect((Context)twoWayNestedScrollView);
                v1.mEdgeGlowLeft = edgeEffect5;
                edgeEffect5 = edgeEffect3;
                edgeEffect3 = new EdgeEffect((Context)twoWayNestedScrollView);
                v1.mEdgeGlowTop = edgeEffect5;
                edgeEffect5 = edgeEffect2;
                edgeEffect2 = new EdgeEffect((Context)twoWayNestedScrollView);
                v1.mEdgeGlowRight = edgeEffect5;
                edgeEffect5 = edgeEffect;
                edgeEffect = new EdgeEffect((Context)twoWayNestedScrollView);
                v1.mEdgeGlowBottom = edgeEffect5;
            }
        } else {
            TwoWayNestedScrollView twoWayNestedScrollView = twoWayNestedScrollView;
            twoWayNestedScrollView.mEdgeGlowTop = null;
            twoWayNestedScrollView.mEdgeGlowBottom = null;
        }
    }

    private static int clamp(int n, int n2, int n3) {
        if (n2 < n3 && n >= 0) {
            if (n2 + n > n3) {
                return n3 - n2;
            }
            return n;
        }
        return 0;
    }

    public void dispatchNestedScroll(int n, int n2, int n3, int n4, @Nullable int[] nArray, int n5, @NonNull int[] nArray2) {
        this.mChildHelper.dispatchNestedScroll(n, n2, n3, n4, nArray, n5, nArray2);
    }

    public boolean startNestedScroll(int n, int n2) {
        return this.mChildHelper.startNestedScroll(n, n2);
    }

    public void stopNestedScroll(int n) {
        this.mChildHelper.stopNestedScroll(n);
    }

    public boolean hasNestedScrollingParent(int n) {
        return this.mChildHelper.hasNestedScrollingParent(n);
    }

    public boolean dispatchNestedScroll(int n, int n2, int n3, int n4, int[] nArray, int n5) {
        return this.mChildHelper.dispatchNestedScroll(n, n2, n3, n4, nArray, n5);
    }

    public boolean dispatchNestedPreScroll(int n, int n2, int[] nArray, int[] nArray2, int n3) {
        return this.mChildHelper.dispatchNestedPreScroll(n, n2, nArray, nArray2, n3);
    }

    public void setNestedScrollingEnabled(boolean bl) {
        this.mChildHelper.setNestedScrollingEnabled(bl);
    }

    public boolean isNestedScrollingEnabled() {
        return this.mChildHelper.isNestedScrollingEnabled();
    }

    public boolean startNestedScroll(int n) {
        return this.startNestedScroll(n, 0);
    }

    public void stopNestedScroll() {
        this.stopNestedScroll(0);
    }

    public boolean hasNestedScrollingParent() {
        return this.hasNestedScrollingParent(0);
    }

    public boolean dispatchNestedScroll(int n, int n2, int n3, int n4, int[] nArray) {
        return this.mChildHelper.dispatchNestedScroll(n, n2, n3, n4, nArray);
    }

    public boolean dispatchNestedPreScroll(int n, int n2, int[] nArray, int[] nArray2) {
        return this.dispatchNestedPreScroll(n, n2, nArray, nArray2, 0);
    }

    public boolean dispatchNestedFling(float f, float f2, boolean bl) {
        return this.mChildHelper.dispatchNestedFling(f, f2, bl);
    }

    public boolean dispatchNestedPreFling(float f, float f2) {
        return this.mChildHelper.dispatchNestedPreFling(f, f2);
    }

    public void onNestedScroll(@NonNull View view2, int n, int n2, int n3, int n4, int n5, @NonNull int[] nArray) {
        this.onNestedScrollInternal(n3, n4, n5, nArray);
    }

    public boolean onStartNestedScroll(@NonNull View view2, @NonNull View view3, int n, int n2) {
        return (n & 3) != 0;
    }

    public void onNestedScrollAccepted(@NonNull View view2, @NonNull View view3, int n, int n2) {
        TwoWayNestedScrollView twoWayNestedScrollView = this;
        twoWayNestedScrollView.mParentHelper.onNestedScrollAccepted(view2, view3, n, n2);
        twoWayNestedScrollView.startNestedScroll(3, n2);
    }

    public void onStopNestedScroll(@NonNull View view2, int n) {
        this.mParentHelper.onStopNestedScroll(view2, n);
        this.stopNestedScroll(n);
    }

    public void onNestedScroll(@NonNull View view2, int n, int n2, int n3, int n4, int n5) {
        this.onNestedScrollInternal(n3, n4, n5, null);
    }

    public void onNestedPreScroll(@NonNull View view2, int n, int n2, @NonNull int[] nArray, int n3) {
        this.dispatchNestedPreScroll(n, n2, nArray, null, n3);
    }

    public boolean onStartNestedScroll(@NonNull View view2, @NonNull View view3, int n) {
        return this.onStartNestedScroll(view2, view3, n, 0);
    }

    public void onNestedScrollAccepted(@NonNull View view2, @NonNull View view3, int n) {
        this.onNestedScrollAccepted(view2, view3, n, 0);
    }

    public void onStopNestedScroll(@NonNull View view2) {
        this.onStopNestedScroll(view2, 0);
    }

    public void onNestedScroll(@NonNull View view2, int n, int n2, int n3, int n4) {
        this.onNestedScrollInternal(n3, n4, 0, null);
    }

    public void onNestedPreScroll(@NonNull View view2, int n, int n2, @NonNull int[] nArray) {
        this.onNestedPreScroll(view2, n, n2, nArray, 0);
    }

    public boolean onNestedFling(@NonNull View view2, float f, float f2, boolean bl) {
        if (!bl) {
            this.dispatchNestedFling(f, f2, true);
            int n = (int)f;
            this.fling(n, (int)f2);
            return true;
        }
        return false;
    }

    public boolean onNestedPreFling(@NonNull View view2, float f, float f2) {
        return this.dispatchNestedPreFling(f, f2);
    }

    public int getNestedScrollAxes() {
        return this.mParentHelper.getNestedScrollAxes();
    }

    public boolean shouldDelayChildPressedState() {
        return true;
    }

    protected float getLeftFadingEdgeStrength() {
        if (this.getChildCount() == 0) {
            return 0.0f;
        }
        TwoWayNestedScrollView twoWayNestedScrollView = this;
        int n = twoWayNestedScrollView.getHorizontalFadingEdgeLength();
        int n2 = twoWayNestedScrollView.getScrollX();
        if (n2 < n) {
            return (float)n2 / (float)n;
        }
        return 1.0f;
    }

    protected float getTopFadingEdgeStrength() {
        if (this.getChildCount() == 0) {
            return 0.0f;
        }
        TwoWayNestedScrollView twoWayNestedScrollView = this;
        int n = twoWayNestedScrollView.getVerticalFadingEdgeLength();
        int n2 = twoWayNestedScrollView.getScrollY();
        if (n2 < n) {
            return (float)n2 / (float)n;
        }
        return 1.0f;
    }

    protected float getRightFadingEdgeStrength() {
        if (this.getChildCount() == 0) {
            return 0.0f;
        }
        TwoWayNestedScrollView twoWayNestedScrollView = this;
        View view2 = twoWayNestedScrollView.getChildAt(0);
        FrameLayout.LayoutParams layoutParams = (FrameLayout.LayoutParams)view2.getLayoutParams();
        int n = twoWayNestedScrollView.getHorizontalFadingEdgeLength();
        int n2 = this.getWidth() - this.getPaddingRight();
        int n3 = view2.getRight() + layoutParams.rightMargin - this.getScrollX() - n2;
        if (n3 < n) {
            return (float)n3 / (float)n;
        }
        return 1.0f;
    }

    protected float getBottomFadingEdgeStrength() {
        if (this.getChildCount() == 0) {
            return 0.0f;
        }
        TwoWayNestedScrollView twoWayNestedScrollView = this;
        View view2 = twoWayNestedScrollView.getChildAt(0);
        FrameLayout.LayoutParams layoutParams = (FrameLayout.LayoutParams)view2.getLayoutParams();
        int n = twoWayNestedScrollView.getVerticalFadingEdgeLength();
        int n2 = this.getHeight() - this.getPaddingBottom();
        int n3 = view2.getBottom() + layoutParams.bottomMargin - this.getScrollY() - n2;
        if (n3 < n) {
            return (float)n3 / (float)n;
        }
        return 1.0f;
    }

    public void setLocked(boolean bl) {
        this.mIsLocked = bl;
    }

    public int getMaxScrollAmountX() {
        return (int)((float)this.getWidth() * 0.5f);
    }

    public int getMaxScrollAmountY() {
        return (int)((float)this.getHeight() * 0.5f);
    }

    public void addView(View view2) {
        if (this.getChildCount() <= 0) {
            super.addView(view2);
            return;
        }
        throw new IllegalStateException("ScrollView can host only one direct child");
    }

    public void addView(View view2, int n) {
        if (this.getChildCount() <= 0) {
            super.addView(view2, n);
            return;
        }
        throw new IllegalStateException("ScrollView can host only one direct child");
    }

    public void addView(View view2, ViewGroup.LayoutParams layoutParams) {
        if (this.getChildCount() <= 0) {
            super.addView(view2, layoutParams);
            return;
        }
        throw new IllegalStateException("ScrollView can host only one direct child");
    }

    public void addView(View view2, int n, ViewGroup.LayoutParams layoutParams) {
        if (this.getChildCount() <= 0) {
            super.addView(view2, n, layoutParams);
            return;
        }
        throw new IllegalStateException("ScrollView can host only one direct child");
    }

    public void setOnScrollChangeListener(@Nullable OnScrollChangeListener onScrollChangeListener) {
        this.mOnScrollChangeListener = onScrollChangeListener;
    }

    public boolean isFillViewport() {
        return this.mFillViewport;
    }

    public void setFillViewport(boolean bl) {
        if (bl != this.mFillViewport) {
            this.mFillViewport = bl;
            this.requestLayout();
        }
    }

    public boolean isSmoothScrollingEnabled() {
        return this.mSmoothScrollingEnabled;
    }

    public void setSmoothScrollingEnabled(boolean bl) {
        this.mSmoothScrollingEnabled = bl;
    }

    protected void onScrollChanged(int n, int n2, int n3, int n4) {
        TwoWayNestedScrollView twoWayNestedScrollView = this;
        super.onScrollChanged(n, n2, n3, n4);
        OnScrollChangeListener onScrollChangeListener = twoWayNestedScrollView.mOnScrollChangeListener;
        if (onScrollChangeListener != null) {
            onScrollChangeListener.onScrollChange(this, n, n2, n3, n4);
        }
    }

    protected void onMeasure(int n, int n2) {
        TwoWayNestedScrollView twoWayNestedScrollView = this;
        super.onMeasure(n, n2);
        if (!twoWayNestedScrollView.mFillViewport) {
            return;
        }
        int n3 = View.MeasureSpec.getMode((int)n);
        n = View.MeasureSpec.getMode((int)n2);
        if (n3 == 0 && n == 0) {
            return;
        }
        if (this.getChildCount() > 0) {
            View view2 = this.getChildAt(0);
            FrameLayout.LayoutParams layoutParams = (FrameLayout.LayoutParams)view2.getLayoutParams();
            int n4 = view2.getMeasuredWidth();
            int n5 = this.getMeasuredWidth() - this.getPaddingLeft() - this.getPaddingRight() - layoutParams.leftMargin - layoutParams.rightMargin;
            int n6 = view2.getMeasuredHeight();
            int n7 = this.getMeasuredHeight() - this.getPaddingTop() - this.getPaddingBottom() - layoutParams.topMargin - layoutParams.bottomMargin;
            if (n4 < n5 || n6 < n7) {
                int n8 = n7;
                n7 = View.MeasureSpec.makeMeasureSpec((int)Math.max(n5, n4), (int)0x40000000);
                view2.measure(n7, View.MeasureSpec.makeMeasureSpec((int)Math.max(n8, n6), (int)0x40000000));
            }
        }
    }

    public boolean dispatchKeyEvent(KeyEvent keyEvent) {
        return super.dispatchKeyEvent(keyEvent) || this.executeKeyEvent(keyEvent);
    }

    public boolean executeKeyEvent(@NonNull KeyEvent keyEvent) {
        TwoWayNestedScrollView twoWayNestedScrollView = this;
        twoWayNestedScrollView.mTempRect.setEmpty();
        if (!twoWayNestedScrollView.canScrollX() && !this.canScrollY()) {
            if (this.isFocused() && keyEvent.getKeyCode() != 4) {
                keyEvent = this.findFocus();
                if (keyEvent == this) {
                    keyEvent = null;
                }
                return (keyEvent = FocusFinder.getInstance().findNextFocus((ViewGroup)this, (View)keyEvent, 130)) != null && keyEvent != this && keyEvent.requestFocus(130);
            }
            return false;
        }
        boolean bl = false;
        if (keyEvent.getAction() == 0) {
            int n = keyEvent.getKeyCode();
            if (n != 62) {
                switch (n) {
                    default: {
                        break;
                    }
                    case 22: {
                        if (!keyEvent.isAltPressed()) {
                            bl = this.arrowScroll(66);
                            break;
                        }
                        bl = this.fullScroll(66);
                        break;
                    }
                    case 21: {
                        if (!keyEvent.isAltPressed()) {
                            bl = this.arrowScroll(17);
                            break;
                        }
                        bl = this.fullScroll(17);
                        break;
                    }
                    case 20: {
                        if (!keyEvent.isAltPressed()) {
                            bl = this.arrowScroll(130);
                            break;
                        }
                        bl = this.fullScroll(130);
                        break;
                    }
                    case 19: {
                        if (!keyEvent.isAltPressed()) {
                            bl = this.arrowScroll(33);
                            break;
                        }
                        bl = this.fullScroll(33);
                        break;
                    }
                }
            } else {
                int n2 = keyEvent.isShiftPressed() ? 33 : 130;
                this.pageScroll(n2);
            }
        }
        return bl;
    }

    public void requestDisallowInterceptTouchEvent(boolean bl) {
        if (bl) {
            this.recycleVelocityTracker();
        }
        super.requestDisallowInterceptTouchEvent(bl);
    }

    public boolean onInterceptTouchEvent(MotionEvent motionEvent) {
        if (this.mIsLocked) {
            return false;
        }
        int n = motionEvent.getAction();
        if (n == 2 && this.mIsBeingDragged) {
            return true;
        }
        switch (n & 0xFF) {
            default: {
                break;
            }
            case 6: {
                this.onSecondaryPointerUp(motionEvent);
                break;
            }
            case 2: {
                n = this.mActivePointerId;
                if (n == -1) break;
                int n2 = motionEvent.findPointerIndex(n);
                if (n2 == -1) {
                    SLRLog.INSTANCE.e(TAG, "Invalid pointerId=" + n + " in onInterceptTouchEvent");
                    break;
                }
                n = (int)motionEvent.getX(n2);
                n2 = (int)motionEvent.getY(n2);
                int n3 = Math.abs(n2 - this.mLastMotionY);
                boolean bl = Math.abs(n - this.mLastMotionX) > this.mTouchSlop && (this.getNestedScrollAxes() & 1) == 0;
                n3 = n3 > this.mTouchSlop && (this.getNestedScrollAxes() & 2) == 0 ? 1 : 0;
                if (!bl && n3 == 0) break;
                TwoWayNestedScrollView twoWayNestedScrollView = this;
                this.mIsBeingDragged = true;
                this.mLastMotionX = n;
                twoWayNestedScrollView.mLastMotionY = n2;
                twoWayNestedScrollView.initVelocityTrackerIfNotExists();
                twoWayNestedScrollView.mVelocityTracker.addMovement(motionEvent);
                twoWayNestedScrollView.mNestedXOffset = 0;
                twoWayNestedScrollView.mNestedYOffset = 0;
                motionEvent = twoWayNestedScrollView.getParent();
                if (motionEvent == null) break;
                motionEvent.requestDisallowInterceptTouchEvent(true);
                break;
            }
            case 1: 
            case 3: {
                TwoWayNestedScrollView twoWayNestedScrollView = this;
                twoWayNestedScrollView.mIsBeingDragged = false;
                twoWayNestedScrollView.mActivePointerId = -1;
                twoWayNestedScrollView.recycleVelocityTracker();
                TwoWayNestedScrollView twoWayNestedScrollView2 = this;
                int n4 = twoWayNestedScrollView2.getScrollX();
                n = twoWayNestedScrollView2.getScrollY();
                int n5 = twoWayNestedScrollView2.getScrollRangeX();
                int n6 = twoWayNestedScrollView2.getScrollRangeY();
                if (twoWayNestedScrollView.mScroller.springBack(n4, n, 0, n5, 0, n6)) {
                    ViewCompat.postInvalidateOnAnimation((View)this);
                }
                this.stopNestedScroll(0);
                break;
            }
            case 0: {
                n = (int)motionEvent.getX();
                int n7 = (int)motionEvent.getY();
                if (!this.inChild(n, n7)) {
                    this.mIsBeingDragged = false;
                    this.recycleVelocityTracker();
                    break;
                }
                TwoWayNestedScrollView twoWayNestedScrollView = this;
                this.mLastMotionX = n;
                this.mLastMotionY = n7;
                twoWayNestedScrollView.mActivePointerId = motionEvent.getPointerId(0);
                twoWayNestedScrollView.initOrResetVelocityTracker();
                twoWayNestedScrollView.mVelocityTracker.addMovement(motionEvent);
                twoWayNestedScrollView.mScroller.computeScrollOffset();
                twoWayNestedScrollView.mIsBeingDragged = twoWayNestedScrollView.mScroller.isFinished() ^ true;
                twoWayNestedScrollView.startNestedScroll(3, 0);
            }
        }
        return this.mIsBeingDragged;
    }

    public boolean onTouchEvent(MotionEvent motionEvent) {
        if (twoWayNestedScrollView.mIsLocked) {
            return false;
        }
        twoWayNestedScrollView.initVelocityTrackerIfNotExists();
        int n = motionEvent.getActionMasked();
        if (n == 0) {
            TwoWayNestedScrollView twoWayNestedScrollView = twoWayNestedScrollView;
            twoWayNestedScrollView.mNestedXOffset = 0;
            twoWayNestedScrollView.mNestedYOffset = 0;
        }
        MotionEvent motionEvent2 = MotionEvent.obtain((MotionEvent)motionEvent);
        motionEvent2.offsetLocation((float)twoWayNestedScrollView.mNestedXOffset, (float)twoWayNestedScrollView.mNestedYOffset);
        switch (n) {
            default: {
                break;
            }
            case 6: {
                MotionEvent motionEvent3 = motionEvent;
                MotionEvent motionEvent4 = motionEvent;
                TwoWayNestedScrollView twoWayNestedScrollView = twoWayNestedScrollView;
                twoWayNestedScrollView.onSecondaryPointerUp(motionEvent);
                twoWayNestedScrollView.mLastMotionX = (int)motionEvent4.getX(motionEvent4.findPointerIndex(twoWayNestedScrollView.mActivePointerId));
                twoWayNestedScrollView.mLastMotionY = (int)motionEvent3.getY(motionEvent3.findPointerIndex(twoWayNestedScrollView.mActivePointerId));
                break;
            }
            case 5: {
                MotionEvent motionEvent5 = motionEvent;
                int n2 = motionEvent5.getActionIndex();
                twoWayNestedScrollView.mLastMotionX = (int)motionEvent5.getX(n2);
                twoWayNestedScrollView.mLastMotionY = (int)motionEvent.getY(n2);
                twoWayNestedScrollView.mActivePointerId = motionEvent.getPointerId(n2);
                break;
            }
            case 3: {
                if (twoWayNestedScrollView.mIsBeingDragged && twoWayNestedScrollView.getChildCount() > 0) {
                    int n3;
                    int n4;
                    int n5;
                    TwoWayNestedScrollView twoWayNestedScrollView = twoWayNestedScrollView;
                    int n6 = twoWayNestedScrollView.getScrollX();
                    if (twoWayNestedScrollView.mScroller.springBack(n6, n5 = twoWayNestedScrollView.getScrollY(), 0, n4 = twoWayNestedScrollView.getScrollRangeX(), 0, n3 = twoWayNestedScrollView.getScrollRangeY())) {
                        ViewCompat.postInvalidateOnAnimation((View)twoWayNestedScrollView);
                    }
                }
                twoWayNestedScrollView.mActivePointerId = -1;
                twoWayNestedScrollView.endDrag();
                break;
            }
            case 2: {
                Object object;
                int n7 = motionEvent.findPointerIndex(twoWayNestedScrollView.mActivePointerId);
                if (n7 == -1) {
                    SLRLog.INSTANCE.e(TAG, "Invalid pointerId=" + twoWayNestedScrollView.mActivePointerId + " in onTouchEvent");
                    break;
                }
                TwoWayNestedScrollView twoWayNestedScrollView = twoWayNestedScrollView;
                int n8 = (int)motionEvent.getX(n7);
                int n9 = (int)motionEvent.getY(n7);
                int n10 = twoWayNestedScrollView.mLastMotionX - n8;
                int n11 = twoWayNestedScrollView.mLastMotionY - n9;
                if (!(twoWayNestedScrollView.mIsBeingDragged || Math.abs(n11) <= twoWayNestedScrollView.mTouchSlop && Math.abs(n10) <= twoWayNestedScrollView.mTouchSlop)) {
                    object = twoWayNestedScrollView.getParent();
                    if (object != null) {
                        object.requestDisallowInterceptTouchEvent(true);
                    }
                    twoWayNestedScrollView.mIsBeingDragged = true;
                    n10 = n10 > 0 ? (n10 -= twoWayNestedScrollView.mTouchSlop) : (n10 += twoWayNestedScrollView.mTouchSlop);
                    n11 = n11 > 0 ? (n11 -= twoWayNestedScrollView.mTouchSlop) : (n11 += twoWayNestedScrollView.mTouchSlop);
                }
                if (!twoWayNestedScrollView.mIsBeingDragged) break;
                TwoWayNestedScrollView twoWayNestedScrollView2 = twoWayNestedScrollView;
                object = twoWayNestedScrollView2.mScrollConsumed;
                int[] nArray = twoWayNestedScrollView2.mScrollOffset;
                if (twoWayNestedScrollView.dispatchNestedPreScroll(n10, n11, (int[])object, nArray, 0)) {
                    TwoWayNestedScrollView twoWayNestedScrollView3 = twoWayNestedScrollView;
                    n10 -= twoWayNestedScrollView.mScrollConsumed[0];
                    n11 -= twoWayNestedScrollView.mScrollConsumed[1];
                    object = twoWayNestedScrollView.mScrollOffset;
                    twoWayNestedScrollView3.mNestedXOffset += twoWayNestedScrollView.mScrollOffset[0];
                    twoWayNestedScrollView3.mNestedYOffset += object[1];
                }
                TwoWayNestedScrollView twoWayNestedScrollView4 = twoWayNestedScrollView;
                int[] nArray2 = twoWayNestedScrollView.mScrollOffset;
                twoWayNestedScrollView.mLastMotionX = n8 - nArray2[0];
                twoWayNestedScrollView4.mLastMotionY = n9 - twoWayNestedScrollView.mScrollOffset[1];
                n8 = twoWayNestedScrollView4.getScrollX();
                int n12 = twoWayNestedScrollView4.getScrollY();
                int n13 = twoWayNestedScrollView4.getScrollRangeX();
                int n14 = twoWayNestedScrollView4.getScrollRangeY();
                int n15 = twoWayNestedScrollView4.getOverScrollMode();
                boolean bl = n15 == 0 || n15 == 1 && n13 > 0;
                n15 = n15 != 0 && (n15 != 1 || n14 <= 0) ? 0 : 1;
                TwoWayNestedScrollView twoWayNestedScrollView5 = twoWayNestedScrollView;
                int n16 = twoWayNestedScrollView5.getScrollX();
                int n17 = twoWayNestedScrollView5.getScrollY();
                if (twoWayNestedScrollView.overScrollByCompat(n10, n11, n16, n17, n13, n14, 0, 0, true) && !twoWayNestedScrollView.hasNestedScrollingParent(0)) {
                    twoWayNestedScrollView.mVelocityTracker.clear();
                }
                TwoWayNestedScrollView twoWayNestedScrollView6 = twoWayNestedScrollView;
                n16 = twoWayNestedScrollView.getScrollX() - n8;
                n17 = twoWayNestedScrollView.getScrollY() - n12;
                int n18 = n10 - n16;
                int n19 = n11 - n17;
                int[] nArray3 = twoWayNestedScrollView6.mScrollConsumed;
                int[] nArray4 = nArray3;
                nArray3[0] = 0;
                twoWayNestedScrollView6.mScrollConsumed[1] = 0;
                int[] nArray5 = twoWayNestedScrollView6.mScrollOffset;
                twoWayNestedScrollView6.dispatchNestedScroll(n16, n17, n18, n19, nArray5, 0, nArray4);
                int[] nArray6 = twoWayNestedScrollView.mScrollOffset;
                twoWayNestedScrollView6.mLastMotionX -= twoWayNestedScrollView.mScrollOffset[0];
                twoWayNestedScrollView6.mLastMotionY -= nArray6[1];
                twoWayNestedScrollView6.mNestedXOffset += nArray6[0];
                twoWayNestedScrollView6.mNestedYOffset += nArray6[1];
                if (bl) {
                    int n20 = n8;
                    n8 = n10 - twoWayNestedScrollView.mScrollConsumed[0];
                    twoWayNestedScrollView.ensureGlows();
                    n10 = n20 + n8;
                    if (n10 < 0) {
                        TwoWayNestedScrollView twoWayNestedScrollView7 = twoWayNestedScrollView;
                        float f = (float)n8 / (float)twoWayNestedScrollView.getWidth();
                        float f2 = motionEvent.getY(n7) / (float)twoWayNestedScrollView.getHeight();
                        EdgeEffectCompat.onPull((EdgeEffect)twoWayNestedScrollView7.mEdgeGlowLeft, (float)f, (float)(1.0f - f2));
                        if (!twoWayNestedScrollView7.mEdgeGlowRight.isFinished()) {
                            twoWayNestedScrollView.mEdgeGlowRight.onRelease();
                        }
                    } else if (n10 > n13) {
                        TwoWayNestedScrollView twoWayNestedScrollView8 = twoWayNestedScrollView;
                        float f = (float)n8 / (float)twoWayNestedScrollView.getWidth();
                        EdgeEffectCompat.onPull((EdgeEffect)twoWayNestedScrollView8.mEdgeGlowRight, (float)f, (float)(motionEvent.getY(n7) / (float)twoWayNestedScrollView.getHeight()));
                        if (!twoWayNestedScrollView8.mEdgeGlowLeft.isFinished()) {
                            twoWayNestedScrollView.mEdgeGlowLeft.onRelease();
                        }
                    }
                }
                if (n15 != 0) {
                    int n21 = n11 - twoWayNestedScrollView.mScrollConsumed[1];
                    twoWayNestedScrollView.ensureGlows();
                    if ((n12 += n21) < 0) {
                        TwoWayNestedScrollView twoWayNestedScrollView9 = twoWayNestedScrollView;
                        float f = (float)n21 / (float)twoWayNestedScrollView.getHeight();
                        EdgeEffectCompat.onPull((EdgeEffect)twoWayNestedScrollView9.mEdgeGlowTop, (float)f, (float)(motionEvent.getX(n7) / (float)twoWayNestedScrollView.getWidth()));
                        if (!twoWayNestedScrollView9.mEdgeGlowBottom.isFinished()) {
                            twoWayNestedScrollView.mEdgeGlowBottom.onRelease();
                        }
                    } else if (n12 > n14) {
                        TwoWayNestedScrollView twoWayNestedScrollView10 = twoWayNestedScrollView;
                        float f = (float)n21 / (float)twoWayNestedScrollView.getHeight();
                        float f3 = motionEvent.getX(n7) / (float)twoWayNestedScrollView.getWidth();
                        EdgeEffectCompat.onPull((EdgeEffect)twoWayNestedScrollView10.mEdgeGlowBottom, (float)f, (float)(1.0f - f3));
                        if (!twoWayNestedScrollView10.mEdgeGlowTop.isFinished()) {
                            twoWayNestedScrollView.mEdgeGlowTop.onRelease();
                        }
                    }
                }
                if (!bl && n15 == 0 || twoWayNestedScrollView.mEdgeGlowTop == null || twoWayNestedScrollView.mEdgeGlowLeft.isFinished() && twoWayNestedScrollView.mEdgeGlowTop.isFinished() && twoWayNestedScrollView.mEdgeGlowRight.isFinished() && twoWayNestedScrollView.mEdgeGlowBottom.isFinished()) break;
                ViewCompat.postInvalidateOnAnimation((View)twoWayNestedScrollView);
                break;
            }
            case 1: {
                motionEvent = twoWayNestedScrollView.mVelocityTracker;
                motionEvent.computeCurrentVelocity(1000, (float)twoWayNestedScrollView.mMaximumVelocity);
                int n22 = (int)motionEvent.getXVelocity(twoWayNestedScrollView.mActivePointerId);
                int n23 = (int)motionEvent.getYVelocity(twoWayNestedScrollView.mActivePointerId);
                if (Math.abs(n22) < twoWayNestedScrollView.mMinimumVelocity && Math.abs(n23) < twoWayNestedScrollView.mMinimumVelocity) {
                    int n24;
                    int n25;
                    TwoWayNestedScrollView twoWayNestedScrollView = twoWayNestedScrollView;
                    n22 = twoWayNestedScrollView.getScrollX();
                    if (twoWayNestedScrollView.mScroller.springBack(n22, n23 = twoWayNestedScrollView.getScrollY(), 0, n25 = twoWayNestedScrollView.getScrollRangeX(), 0, n24 = twoWayNestedScrollView.getScrollRangeY())) {
                        ViewCompat.postInvalidateOnAnimation((View)twoWayNestedScrollView);
                    }
                } else {
                    float f = n22 = -n22;
                    int n26 = -n23;
                    float f4 = n26;
                    if (!twoWayNestedScrollView.dispatchNestedPreFling(f, f4)) {
                        TwoWayNestedScrollView twoWayNestedScrollView = twoWayNestedScrollView;
                        twoWayNestedScrollView.dispatchNestedFling(f, f4, true);
                        twoWayNestedScrollView.fling(n22, n26);
                    }
                }
                twoWayNestedScrollView.mActivePointerId = -1;
                twoWayNestedScrollView.endDrag();
                break;
            }
            case 0: {
                ViewParent viewParent;
                if (twoWayNestedScrollView.getChildCount() == 0) {
                    return false;
                }
                twoWayNestedScrollView.mIsBeingDragged = twoWayNestedScrollView.mScroller.isFinished() ^ true;
                if (twoWayNestedScrollView.mIsBeingDragged && (viewParent = twoWayNestedScrollView.getParent()) != null) {
                    viewParent.requestDisallowInterceptTouchEvent(true);
                }
                if (!twoWayNestedScrollView.mScroller.isFinished()) {
                    twoWayNestedScrollView.abortAnimatedScroll();
                }
                twoWayNestedScrollView.mLastMotionX = (int)motionEvent.getX();
                twoWayNestedScrollView.mLastMotionY = (int)motionEvent.getY();
                twoWayNestedScrollView.mActivePointerId = motionEvent.getPointerId(0);
                twoWayNestedScrollView.startNestedScroll(3, 0);
            }
        }
        TwoWayNestedScrollView twoWayNestedScrollView = twoWayNestedScrollView.mVelocityTracker;
        if (twoWayNestedScrollView != null) {
            twoWayNestedScrollView.addMovement(motionEvent2);
        }
        motionEvent2.recycle();
        return true;
    }

    public boolean onGenericMotionEvent(MotionEvent motionEvent) {
        if ((motionEvent.getSource() & 2) != 0 && motionEvent.getAction() == 8 && !this.mIsBeingDragged) {
            float f = motionEvent.getAxisValue(10);
            float f2 = motionEvent.getAxisValue(9);
            if (f != 0.0f || f2 != 0.0f) {
                TwoWayNestedScrollView twoWayNestedScrollView = this;
                int n = (int)(f * this.getHorizontalScrollFactorCompat());
                int n2 = (int)(f2 * this.getVerticalScrollFactorCompat());
                int n3 = twoWayNestedScrollView.getScrollRangeX();
                int n4 = twoWayNestedScrollView.getScrollRangeY();
                int n5 = twoWayNestedScrollView.getScrollX();
                int n6 = n;
                n = this.getScrollY();
                int n7 = n5 - n6;
                n2 = n - n2;
                if (n7 < 0) {
                    n3 = 0;
                } else if (n7 <= n3) {
                    n3 = n7;
                }
                if (n2 < 0) {
                    n4 = 0;
                } else if (n2 <= n4) {
                    n4 = n2;
                }
                if (n3 != n5 || n4 != n) {
                    super.scrollTo(n3, n4);
                    return true;
                }
            }
        }
        return false;
    }

    protected void onOverScrolled(int n, int n2, boolean bl, boolean bl2) {
        super.scrollTo(n, n2);
    }

    /*
     * WARNING - void declaration
     */
    boolean overScrollByCompat(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, boolean bl) {
        void var9_13;
        TwoWayNestedScrollView twoWayNestedScrollView = this;
        int n9 = twoWayNestedScrollView.getOverScrollMode();
        boolean bl2 = twoWayNestedScrollView.computeHorizontalScrollRange() > this.computeHorizontalScrollExtent();
        boolean bl3 = this.computeVerticalScrollRange() > this.computeVerticalScrollExtent();
        bl2 = n9 == 0 || n9 == 1 && bl2;
        if (!(n9 == 0 || n9 == 1 && bl3)) {
            boolean bl4 = false;
        } else {
            boolean bl5 = true;
        }
        n = n3 + n;
        if (!bl2) {
            n7 = 0;
        }
        n2 = n4 + n2;
        if (var9_13 == false) {
            n8 = 0;
        }
        int n10 = n8;
        int n11 = n7;
        n3 = -n11;
        n4 = n11 + n5;
        n5 = -n10;
        n6 = n10 + n6;
        n7 = 0;
        if (n > n4) {
            n7 = 1;
            n = n4;
        } else if (n < n3) {
            n7 = 1;
            n = n3;
        }
        n3 = 0;
        if (n2 > n6) {
            n3 = 1;
            n2 = n6;
        } else if (n2 < n5) {
            n3 = 1;
            n2 = n5;
        }
        if (!(n7 == 0 && n3 == 0 || this.hasNestedScrollingParent(1))) {
            TwoWayNestedScrollView twoWayNestedScrollView2 = this;
            n4 = twoWayNestedScrollView2.getScrollRangeX();
            n5 = twoWayNestedScrollView2.getScrollRangeY();
            this.mScroller.springBack(n, n2, 0, n4, 0, n5);
        }
        this.onOverScrolled(n, n2, n7 != 0, n3 != 0);
        return n7 != 0 || n3 != 0;
    }

    int getScrollRangeX() {
        int n = 0;
        if (this.getChildCount() > 0) {
            View view2 = this.getChildAt(0);
            FrameLayout.LayoutParams layoutParams = (FrameLayout.LayoutParams)view2.getLayoutParams();
            n = Math.max(0, view2.getWidth() + layoutParams.leftMargin + layoutParams.rightMargin - (this.getWidth() - this.getPaddingLeft() - this.getPaddingRight()));
        }
        return n;
    }

    int getScrollRangeY() {
        int n = 0;
        if (this.getChildCount() > 0) {
            View view2 = this.getChildAt(0);
            FrameLayout.LayoutParams layoutParams = (FrameLayout.LayoutParams)view2.getLayoutParams();
            n = Math.max(0, view2.getHeight() + layoutParams.topMargin + layoutParams.bottomMargin - (this.getHeight() - this.getPaddingTop() - this.getPaddingBottom()));
        }
        return n;
    }

    public boolean pageScroll(int n) {
        int n2 = this.getHeight();
        if (n == 130) {
            this.mTempRect.top = this.getScrollY() + n2;
            int n3 = this.getChildCount();
            if (n3 > 0) {
                TwoWayNestedScrollView twoWayNestedScrollView = this;
                View view2 = twoWayNestedScrollView.getChildAt(n3 - 1);
                FrameLayout.LayoutParams layoutParams = (FrameLayout.LayoutParams)view2.getLayoutParams();
                int n4 = view2.getBottom() + layoutParams.bottomMargin + this.getPaddingBottom();
                Rect rect = twoWayNestedScrollView.mTempRect;
                if (rect.top + n2 > n4) {
                    rect.top = n4 - n2;
                }
            }
        } else {
            this.mTempRect.top = this.getScrollY() - n2;
            Rect rect = this.mTempRect;
            if (rect.top < 0) {
                rect.top = 0;
            }
        }
        int n5 = n;
        int n6 = this.mTempRect.top;
        this.mTempRect.bottom = n = n6 + n2;
        return this.scrollAndFocus(n5, n6, n);
    }

    public boolean fullScroll(int n) {
        int n2;
        TwoWayNestedScrollView twoWayNestedScrollView = this;
        int n3 = twoWayNestedScrollView.getHeight();
        Rect rect = twoWayNestedScrollView.mTempRect;
        rect.top = 0;
        rect.bottom = n3;
        if (n == 130 && (n2 = this.getChildCount()) > 0) {
            TwoWayNestedScrollView twoWayNestedScrollView2 = this;
            View view2 = twoWayNestedScrollView2.getChildAt(n2 - 1);
            FrameLayout.LayoutParams layoutParams = (FrameLayout.LayoutParams)view2.getLayoutParams();
            twoWayNestedScrollView2.mTempRect.bottom = view2.getBottom() + layoutParams.bottomMargin + this.getPaddingBottom();
            twoWayNestedScrollView2.mTempRect.top = twoWayNestedScrollView2.mTempRect.bottom - n3;
        }
        Rect rect2 = this.mTempRect;
        int n4 = rect2.top;
        return this.scrollAndFocus(n, n4, rect2.bottom);
    }

    public boolean arrowScroll(int n) {
        block20: {
            View view2;
            block16: {
                int n2;
                block19: {
                    block18: {
                        int n3;
                        block17: {
                            View view3;
                            block15: {
                                int n4;
                                view2 = this.findFocus();
                                if (view2 == this) {
                                    view2 = null;
                                }
                                view3 = FocusFinder.getInstance().findNextFocus((ViewGroup)this, view2, n);
                                TwoWayNestedScrollView twoWayNestedScrollView = this;
                                n3 = twoWayNestedScrollView.getMaxScrollAmountX();
                                n2 = twoWayNestedScrollView.getMaxScrollAmountY();
                                if (view3 == null) break block15;
                                TwoWayNestedScrollView twoWayNestedScrollView2 = this;
                                int n5 = twoWayNestedScrollView2.getWidth();
                                if (!this.isWithinDeltaOfScreen(view3, n3, n5, n2, n4 = twoWayNestedScrollView2.getHeight())) break block15;
                                int n6 = n;
                                TwoWayNestedScrollView twoWayNestedScrollView3 = this;
                                view3.getDrawingRect(this.mTempRect);
                                twoWayNestedScrollView3.offsetDescendantRectToMyCoords(view3, this.mTempRect);
                                n = twoWayNestedScrollView3.computeScrollDeltaToGetChildRectOnScreenX(twoWayNestedScrollView3.mTempRect);
                                twoWayNestedScrollView3.doScroll(n, twoWayNestedScrollView3.computeScrollDeltaToGetChildRectOnScreenY(twoWayNestedScrollView3.mTempRect));
                                view3.requestFocus(n6);
                                break block16;
                            }
                            if (n == 33 && this.getScrollY() < n2) {
                                n2 = this.getScrollY();
                            } else if (n == 130) {
                                if (this.getChildCount() > 0) {
                                    View view4 = this.getChildAt(0);
                                    view3 = (FrameLayout.LayoutParams)view4.getLayoutParams();
                                    n2 = Math.min(view4.getBottom() + view3.bottomMargin - (this.getScrollY() + this.getHeight() - this.getPaddingBottom()), n2);
                                }
                            } else if (n == 17 && this.getScrollX() < n3) {
                                n3 = this.getScrollX();
                            } else if (n == 66 && this.getChildCount() > 0) {
                                View view5 = this.getChildAt(0);
                                view3 = (FrameLayout.LayoutParams)view5.getLayoutParams();
                                n3 = Math.min(view5.getRight() + view3.rightMargin - (this.getScrollX() + this.getWidth() - this.getPaddingRight()), n3);
                            }
                            if (n3 == 0 && n2 == 0) {
                                return false;
                            }
                            if (n != 66) break block17;
                            this.doScroll(n3, 0);
                            break block16;
                        }
                        if (n != 17) break block18;
                        this.doScroll(-n3, 0);
                        break block16;
                    }
                    if (n != 130) break block19;
                    this.doScroll(0, n2);
                    break block16;
                }
                if (n != 33) break block20;
                this.doScroll(0, -n2);
            }
            if (view2 != null && view2.isFocused() && this.isOffScreen(view2)) {
                TwoWayNestedScrollView twoWayNestedScrollView = this;
                int n7 = twoWayNestedScrollView.getDescendantFocusability();
                twoWayNestedScrollView.setDescendantFocusability(131072);
                twoWayNestedScrollView.requestFocus();
                twoWayNestedScrollView.setDescendantFocusability(n7);
            }
            return true;
        }
        return false;
    }

    public final void smoothScrollBy(int n, int n2) {
        this.smoothScrollBy(n, n2, 250, false);
    }

    public final void smoothScrollBy(int n, int n2, int n3) {
        this.smoothScrollBy(n, n2, n3, false);
    }

    public final void smoothScrollTo(int n, int n2) {
        this.smoothScrollTo(n, n2, 250, false);
    }

    public final void smoothScrollTo(int n, int n2, int n3) {
        this.smoothScrollTo(n, n2, n3, false);
    }

    void smoothScrollTo(int n, int n2, boolean bl) {
        this.smoothScrollTo(n, n2, 250, bl);
    }

    void smoothScrollTo(int n, int n2, int n3, boolean bl) {
        int n4 = n - this.getScrollX();
        this.smoothScrollBy(n4, n2 - this.getScrollY(), n3, bl);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP_PREFIX})
    public int computeVerticalScrollRange() {
        int n = twoWayNestedScrollView2.getHeight() - twoWayNestedScrollView2.getPaddingBottom() - twoWayNestedScrollView2.getPaddingTop();
        if (twoWayNestedScrollView2.getChildCount() == 0) {
            return n;
        }
        TwoWayNestedScrollView twoWayNestedScrollView = twoWayNestedScrollView2;
        View view2 = twoWayNestedScrollView.getChildAt(0);
        TwoWayNestedScrollView twoWayNestedScrollView2 = (FrameLayout.LayoutParams)view2.getLayoutParams();
        int n2 = view2.getBottom() + ((FrameLayout.LayoutParams)twoWayNestedScrollView2).bottomMargin;
        int n3 = twoWayNestedScrollView.getScrollY();
        n = Math.max(0, n2 - n);
        if (n3 < 0) {
            n2 -= n3;
        } else if (n3 > n) {
            n2 += n3 - n;
        }
        return n2;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP_PREFIX})
    public int computeVerticalScrollOffset() {
        return Math.max(0, super.computeVerticalScrollOffset());
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP_PREFIX})
    public int computeVerticalScrollExtent() {
        return super.computeVerticalScrollExtent();
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP_PREFIX})
    public int computeHorizontalScrollRange() {
        int n = twoWayNestedScrollView2.getWidth() - twoWayNestedScrollView2.getPaddingRight() - twoWayNestedScrollView2.getPaddingLeft();
        if (twoWayNestedScrollView2.getChildCount() == 0) {
            return n;
        }
        TwoWayNestedScrollView twoWayNestedScrollView = twoWayNestedScrollView2;
        View view2 = twoWayNestedScrollView.getChildAt(0);
        TwoWayNestedScrollView twoWayNestedScrollView2 = (FrameLayout.LayoutParams)view2.getLayoutParams();
        int n2 = view2.getRight() + ((FrameLayout.LayoutParams)twoWayNestedScrollView2).rightMargin;
        int n3 = twoWayNestedScrollView.getScrollX();
        n = Math.max(0, n2 - n);
        if (n3 < 0) {
            n2 -= n3;
        } else if (n3 > n) {
            n2 += n3 - n;
        }
        return n2;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP_PREFIX})
    public int computeHorizontalScrollOffset() {
        return Math.max(0, super.computeHorizontalScrollOffset());
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP_PREFIX})
    public int computeHorizontalScrollExtent() {
        return super.computeHorizontalScrollExtent();
    }

    protected void measureChild(View view2, int n, int n2) {
        int n3 = View.MeasureSpec.makeMeasureSpec((int)0, (int)0);
        view2.measure(n3, n3);
    }

    protected void measureChildWithMargins(View view2, int n, int n2, int n3, int n4) {
        View view3 = view2;
        TwoWayNestedScrollView twoWayNestedScrollView = (ViewGroup.MarginLayoutParams)view3.getLayoutParams();
        view3.measure(View.MeasureSpec.makeMeasureSpec((int)(((ViewGroup.MarginLayoutParams)twoWayNestedScrollView).leftMargin + ((ViewGroup.MarginLayoutParams)twoWayNestedScrollView).rightMargin), (int)0), View.MeasureSpec.makeMeasureSpec((int)(((ViewGroup.MarginLayoutParams)twoWayNestedScrollView).topMargin + ((ViewGroup.MarginLayoutParams)twoWayNestedScrollView).bottomMargin), (int)0));
    }

    public void computeScroll() {
        int n;
        if (this.mScroller.isFinished()) {
            return;
        }
        TwoWayNestedScrollView twoWayNestedScrollView = this;
        twoWayNestedScrollView.mScroller.computeScrollOffset();
        int n2 = twoWayNestedScrollView.mScroller.getCurrX();
        TwoWayNestedScrollView twoWayNestedScrollView2 = this;
        int n3 = twoWayNestedScrollView2.mScroller.getCurrY();
        int n4 = n2 - twoWayNestedScrollView2.mLastScrollerX;
        TwoWayNestedScrollView twoWayNestedScrollView3 = this;
        TwoWayNestedScrollView twoWayNestedScrollView4 = this;
        int n5 = n2;
        n2 = n3 - this.mLastScrollerY;
        this.mLastScrollerX = n5;
        twoWayNestedScrollView4.mLastScrollerY = n3;
        int[] nArray = twoWayNestedScrollView4.mScrollConsumed;
        int[] nArray2 = nArray;
        nArray[0] = 0;
        twoWayNestedScrollView4.mScrollConsumed[1] = 0;
        twoWayNestedScrollView3.dispatchNestedPreScroll(n4, n2, nArray2, null, 1);
        nArray2 = twoWayNestedScrollView3.mScrollConsumed;
        TwoWayNestedScrollView twoWayNestedScrollView5 = this;
        int n6 = twoWayNestedScrollView5.getScrollRangeX();
        int n7 = twoWayNestedScrollView5.getScrollRangeY();
        if ((n4 -= twoWayNestedScrollView3.mScrollConsumed[0]) != 0 || (n2 -= nArray2[1]) != 0) {
            int n8 = n2;
            int n9 = n4;
            TwoWayNestedScrollView twoWayNestedScrollView6 = this;
            int n10 = n4;
            TwoWayNestedScrollView twoWayNestedScrollView7 = this;
            n4 = twoWayNestedScrollView7.getScrollX();
            n = twoWayNestedScrollView7.getScrollY();
            twoWayNestedScrollView6.overScrollByCompat(n10, n2, twoWayNestedScrollView7.getScrollX(), n, n6, n7, 0, 0, false);
            n2 = twoWayNestedScrollView6.getScrollX() - n4;
            n4 = this.getScrollY() - n;
            n = n9 - n2;
            int n11 = n8 - n4;
            TwoWayNestedScrollView twoWayNestedScrollView8 = this;
            TwoWayNestedScrollView twoWayNestedScrollView9 = this;
            int[] nArray3 = twoWayNestedScrollView9.mScrollConsumed;
            int[] nArray4 = nArray3;
            nArray3[0] = 0;
            twoWayNestedScrollView9.mScrollConsumed[1] = 0;
            int[] nArray5 = twoWayNestedScrollView9.mScrollOffset;
            twoWayNestedScrollView8.dispatchNestedScroll(n2, n4, n, n11, nArray5, 1, nArray4);
            n4 = n - twoWayNestedScrollView8.mScrollConsumed[0];
            n2 = n11 - twoWayNestedScrollView8.mScrollConsumed[1];
        }
        if (n4 != 0 || n2 != 0) {
            n = this.getOverScrollMode();
            n6 = n != 0 && (n != 1 || n6 <= 0) ? 0 : 1;
            n7 = n != 0 && (n != 1 || n7 <= 0) ? 0 : 1;
            if (n6 != 0) {
                this.ensureGlows();
                if (n4 < 0) {
                    if (this.mEdgeGlowLeft.isFinished()) {
                        this.mEdgeGlowLeft.onAbsorb((int)this.mScroller.getCurrVelocity());
                    }
                } else if (this.mEdgeGlowRight.isFinished()) {
                    this.mEdgeGlowRight.onAbsorb((int)this.mScroller.getCurrVelocity());
                }
            }
            if (n7 != 0) {
                this.ensureGlows();
                if (n2 < 0) {
                    if (this.mEdgeGlowTop.isFinished()) {
                        this.mEdgeGlowTop.onAbsorb((int)this.mScroller.getCurrVelocity());
                    }
                } else if (this.mEdgeGlowBottom.isFinished()) {
                    this.mEdgeGlowBottom.onAbsorb((int)this.mScroller.getCurrVelocity());
                }
            }
            this.abortAnimatedScroll();
        }
        if (!this.mScroller.isFinished()) {
            ViewCompat.postInvalidateOnAnimation((View)this);
        } else {
            this.stopNestedScroll(1);
        }
    }

    protected int computeScrollDeltaToGetChildRectOnScreenX(Rect rect) {
        if (this.getChildCount() == 0) {
            return 0;
        }
        TwoWayNestedScrollView twoWayNestedScrollView = this;
        int n = twoWayNestedScrollView.getWidth();
        int n2 = twoWayNestedScrollView.getScrollX();
        int n3 = n2 + n;
        int n4 = twoWayNestedScrollView.getHorizontalFadingEdgeLength();
        if (rect.left > 0) {
            n2 += n4;
        }
        View view2 = this.getChildAt(0);
        FrameLayout.LayoutParams layoutParams = (FrameLayout.LayoutParams)view2.getLayoutParams();
        n4 = rect.right < view2.getWidth() + layoutParams.leftMargin + layoutParams.rightMargin ? n3 - n4 : n3;
        int n5 = 0;
        int n6 = rect.right;
        if (n6 > n4 && rect.left > n2) {
            n5 = Math.min(rect.width() > n ? rect.left - n2 + n5 : rect.right - n4 + n5, view2.getRight() + layoutParams.rightMargin - n3);
        } else if (rect.left < n2 && n6 < n4) {
            n5 = Math.max(rect.width() > n ? n5 - (n4 - rect.right) : n5 - (n2 - rect.left), -this.getScrollX());
        }
        return n5;
    }

    protected int computeScrollDeltaToGetChildRectOnScreenY(Rect rect) {
        if (this.getChildCount() == 0) {
            return 0;
        }
        TwoWayNestedScrollView twoWayNestedScrollView = this;
        int n = twoWayNestedScrollView.getHeight();
        int n2 = twoWayNestedScrollView.getScrollY();
        int n3 = n2 + n;
        int n4 = twoWayNestedScrollView.getVerticalFadingEdgeLength();
        if (rect.top > 0) {
            n2 += n4;
        }
        View view2 = this.getChildAt(0);
        FrameLayout.LayoutParams layoutParams = (FrameLayout.LayoutParams)view2.getLayoutParams();
        n4 = rect.bottom < view2.getHeight() + layoutParams.topMargin + layoutParams.bottomMargin ? n3 - n4 : n3;
        int n5 = 0;
        int n6 = rect.bottom;
        if (n6 > n4 && rect.top > n2) {
            n5 = Math.min(rect.height() > n ? rect.top - n2 + n5 : rect.bottom - n4 + n5, view2.getBottom() + layoutParams.bottomMargin - n3);
        } else if (rect.top < n2 && n6 < n4) {
            n5 = Math.max(rect.height() > n ? n5 - (n4 - rect.bottom) : n5 - (n2 - rect.top), -this.getScrollY());
        }
        return n5;
    }

    public void requestChildFocus(View view2, View view3) {
        if (!this.mIsLayoutDirty) {
            this.scrollToChild(view3);
        } else {
            this.mChildToScrollTo = view3;
        }
        super.requestChildFocus(view2, view3);
    }

    protected boolean onRequestFocusInDescendants(int n, Rect rect) {
        if (n == 2) {
            n = 130;
        } else if (n == 1) {
            n = 33;
        }
        View view2 = rect == null ? FocusFinder.getInstance().findNextFocus((ViewGroup)this, null, n) : FocusFinder.getInstance().findNextFocusFromRect((ViewGroup)this, rect, n);
        if (view2 == null) {
            return false;
        }
        if (this.isOffScreen(view2)) {
            return false;
        }
        return view2.requestFocus(n, rect);
    }

    public boolean requestChildRectangleOnScreen(View view2, Rect rect, boolean bl) {
        rect.offset(view2.getLeft() - view2.getScrollX(), view2.getTop() - view2.getScrollY());
        return this.scrollToChildRect(rect, bl);
    }

    public void requestLayout() {
        this.mIsLayoutDirty = true;
        super.requestLayout();
    }

    protected void onLayout(boolean bl, int n, int n2, int n3, int n4) {
        TwoWayNestedScrollView twoWayNestedScrollView = this;
        super.onLayout(bl, n, n2, n3, n4);
        twoWayNestedScrollView.mIsLayoutDirty = false;
        Object object = twoWayNestedScrollView.mChildToScrollTo;
        if (object != null && TwoWayNestedScrollView.isViewDescendantOf(object, (View)this)) {
            TwoWayNestedScrollView twoWayNestedScrollView2 = this;
            twoWayNestedScrollView2.scrollToChild(twoWayNestedScrollView2.mChildToScrollTo);
        }
        this.mChildToScrollTo = null;
        if (!this.mIsLaidOut) {
            object = this.mSavedState;
            if (object != null) {
                Object object2 = object;
                int n5 = object2.scrollPositionX;
                this.scrollTo(n5, object2.scrollPositionY);
                this.mSavedState = null;
            }
            int n6 = 0;
            int n7 = 0;
            if (this.getChildCount() > 0) {
                View view2 = this.getChildAt(0);
                FrameLayout.LayoutParams layoutParams = (FrameLayout.LayoutParams)view2.getLayoutParams();
                n7 = view2.getMeasuredWidth() + layoutParams.leftMargin + layoutParams.rightMargin;
                n6 = view2.getMeasuredHeight() + layoutParams.topMargin + layoutParams.bottomMargin;
                int n8 = n7;
                n7 = n6;
                n6 = n8;
            }
            n = n3 - n - this.getPaddingLeft() - this.getPaddingRight();
            n2 = n4 - n2 - this.getPaddingTop() - this.getPaddingBottom();
            n3 = this.getScrollX();
            int n9 = n;
            n = this.getScrollY();
            n6 = TwoWayNestedScrollView.clamp(n3, n9, n6);
            n2 = TwoWayNestedScrollView.clamp(n, n2, n7);
            if (n6 != n3 || n2 != n) {
                this.scrollTo(n6, n2);
            }
        }
        TwoWayNestedScrollView twoWayNestedScrollView3 = this;
        int n10 = twoWayNestedScrollView3.getScrollX();
        twoWayNestedScrollView3.scrollTo(n10, twoWayNestedScrollView3.getScrollY());
        twoWayNestedScrollView3.mIsLaidOut = true;
    }

    public void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.mIsLaidOut = false;
    }

    protected void onSizeChanged(int n, int n2, int n3, int n4) {
        TwoWayNestedScrollView twoWayNestedScrollView = this;
        super.onSizeChanged(n, n2, n3, n4);
        View view2 = twoWayNestedScrollView.findFocus();
        if (view2 != null && this != view2) {
            if (this.isWithinDeltaOfScreen(view2, 0, n3, 0, n4)) {
                TwoWayNestedScrollView twoWayNestedScrollView2 = this;
                view2.getDrawingRect(this.mTempRect);
                twoWayNestedScrollView2.offsetDescendantRectToMyCoords(view2, this.mTempRect);
                int n5 = twoWayNestedScrollView2.computeScrollDeltaToGetChildRectOnScreenX(twoWayNestedScrollView2.mTempRect);
                twoWayNestedScrollView2.doScroll(n5, twoWayNestedScrollView2.computeScrollDeltaToGetChildRectOnScreenY(twoWayNestedScrollView2.mTempRect));
            }
            return;
        }
    }

    public void fling(int n, int n2) {
        if (this.getChildCount() > 0) {
            TwoWayNestedScrollView twoWayNestedScrollView = this;
            TwoWayNestedScrollView twoWayNestedScrollView2 = this;
            int n3 = twoWayNestedScrollView2.getScrollX();
            twoWayNestedScrollView.mScroller.fling(n3, twoWayNestedScrollView2.getScrollY(), n, n2, Integer.MIN_VALUE, Integer.MAX_VALUE, Integer.MIN_VALUE, Integer.MAX_VALUE, 0, 0);
            twoWayNestedScrollView.runAnimatedScroll(true);
        }
    }

    public void scrollTo(int n, int n2) {
        if (this.getChildCount() > 0) {
            TwoWayNestedScrollView twoWayNestedScrollView = this;
            View view2 = twoWayNestedScrollView.getChildAt(0);
            FrameLayout.LayoutParams layoutParams = (FrameLayout.LayoutParams)view2.getLayoutParams();
            int n3 = view2.getWidth() + layoutParams.leftMargin + layoutParams.rightMargin;
            int n4 = this.getHeight() - this.getPaddingTop() - this.getPaddingBottom();
            int n5 = view2.getHeight() + layoutParams.topMargin + layoutParams.bottomMargin;
            n3 = TwoWayNestedScrollView.clamp(n, twoWayNestedScrollView.getWidth() - this.getPaddingLeft() - this.getPaddingRight(), n3);
            n2 = TwoWayNestedScrollView.clamp(n2, n4, n5);
            if (n3 != this.getScrollX() || n2 != this.getScrollY()) {
                super.scrollTo(n3, n2);
            }
        }
    }

    public void draw(Canvas canvas) {
        TwoWayNestedScrollView twoWayNestedScrollView = this;
        super.draw(canvas);
        if (twoWayNestedScrollView.mEdgeGlowTop != null) {
            float f;
            int n;
            int n2;
            int n3;
            int n4;
            TwoWayNestedScrollView twoWayNestedScrollView2 = this;
            int n5 = twoWayNestedScrollView2.getScrollX();
            int n6 = twoWayNestedScrollView2.getScrollY();
            if (!twoWayNestedScrollView2.mEdgeGlowLeft.isFinished()) {
                TwoWayNestedScrollView twoWayNestedScrollView3 = this;
                n4 = canvas.save();
                n3 = twoWayNestedScrollView3.getWidth();
                n2 = twoWayNestedScrollView3.getHeight();
                int n7 = Math.min(0, n5);
                n = Build.VERSION.SDK_INT;
                if (n < 21 || this.getClipToPadding()) {
                    n3 -= this.getPaddingLeft() + this.getPaddingRight();
                    n7 += this.getPaddingLeft();
                }
                if (n >= 21 && this.getClipToPadding()) {
                    n2 -= this.getPaddingTop() + this.getPaddingBottom();
                    n = n6 + this.getPaddingTop();
                } else {
                    n = n6;
                }
                TwoWayNestedScrollView twoWayNestedScrollView4 = this;
                f = n7;
                canvas.translate(f, (float)n);
                float f2 = (float)n2 / 2.0f;
                canvas.rotate(-90.0f, f2, f2);
                twoWayNestedScrollView4.mEdgeGlowLeft.setSize(n2, n3);
                if (twoWayNestedScrollView4.mEdgeGlowLeft.draw(canvas)) {
                    ViewCompat.postInvalidateOnAnimation((View)this);
                }
                canvas.restoreToCount(n4);
            }
            if (!this.mEdgeGlowTop.isFinished()) {
                int n8;
                TwoWayNestedScrollView twoWayNestedScrollView5 = this;
                n4 = canvas.save();
                n3 = twoWayNestedScrollView5.getWidth();
                n2 = twoWayNestedScrollView5.getHeight();
                int n9 = Math.min(0, n6);
                n = Build.VERSION.SDK_INT;
                if (n >= 21 && !this.getClipToPadding()) {
                    n8 = n5;
                } else {
                    n3 -= this.getPaddingLeft() + this.getPaddingRight();
                    n8 = n5 + this.getPaddingLeft();
                }
                if (n >= 21 && this.getClipToPadding()) {
                    n2 -= this.getPaddingTop() + this.getPaddingBottom();
                    n9 += this.getPaddingTop();
                }
                TwoWayNestedScrollView twoWayNestedScrollView6 = this;
                f = n8;
                canvas.translate(f, (float)n9);
                twoWayNestedScrollView6.mEdgeGlowTop.setSize(n3, n2);
                if (twoWayNestedScrollView6.mEdgeGlowTop.draw(canvas)) {
                    ViewCompat.postInvalidateOnAnimation((View)this);
                }
                canvas.restoreToCount(n4);
            }
            if (!this.mEdgeGlowRight.isFinished()) {
                TwoWayNestedScrollView twoWayNestedScrollView7 = this;
                n4 = canvas.save();
                n3 = twoWayNestedScrollView7.getWidth();
                n2 = twoWayNestedScrollView7.getHeight();
                int n10 = Math.max(twoWayNestedScrollView7.getScrollRangeX(), n5) + n3;
                n = Build.VERSION.SDK_INT;
                if (n < 21 || this.getClipToPadding()) {
                    n3 -= this.getPaddingLeft() + this.getPaddingRight();
                    n10 += this.getPaddingLeft();
                }
                if (n >= 21 && this.getClipToPadding()) {
                    n2 -= this.getPaddingTop() + this.getPaddingBottom();
                    n = n6 - this.getPaddingBottom();
                } else {
                    n = n6;
                }
                TwoWayNestedScrollView twoWayNestedScrollView8 = this;
                f = n10 - n3;
                canvas.translate(f, (float)n);
                float f3 = (float)n3 / 2.0f;
                canvas.rotate(90.0f, f3, f3);
                twoWayNestedScrollView8.mEdgeGlowRight.setSize(n2, n3);
                if (twoWayNestedScrollView8.mEdgeGlowRight.draw(canvas)) {
                    ViewCompat.postInvalidateOnAnimation((View)this);
                }
                canvas.restoreToCount(n4);
            }
            if (!this.mEdgeGlowBottom.isFinished()) {
                TwoWayNestedScrollView twoWayNestedScrollView9 = this;
                n4 = canvas.save();
                n3 = twoWayNestedScrollView9.getWidth();
                n2 = twoWayNestedScrollView9.getHeight();
                n6 = Math.max(twoWayNestedScrollView9.getScrollRangeY(), n6) + n2;
                int n11 = Build.VERSION.SDK_INT;
                if (n11 < 21 || this.getClipToPadding()) {
                    n3 -= this.getPaddingLeft() + this.getPaddingRight();
                    n5 += this.getPaddingLeft();
                }
                if (n11 >= 21 && this.getClipToPadding()) {
                    n2 -= this.getPaddingTop() + this.getPaddingBottom();
                    n6 -= this.getPaddingBottom();
                }
                TwoWayNestedScrollView twoWayNestedScrollView10 = this;
                float f4 = n5 - n3;
                canvas.translate(f4, (float)n6);
                canvas.rotate(180.0f, (float)n3, 0.0f);
                twoWayNestedScrollView10.mEdgeGlowBottom.setSize(n3, n2);
                if (twoWayNestedScrollView10.mEdgeGlowBottom.draw(canvas)) {
                    ViewCompat.postInvalidateOnAnimation((View)this);
                }
                canvas.restoreToCount(n4);
            }
        }
    }

    protected void onRestoreInstanceState(Parcelable parcelable) {
        if (!(parcelable instanceof SavedState)) {
            super.onRestoreInstanceState(parcelable);
            return;
        }
        TwoWayNestedScrollView twoWayNestedScrollView = object;
        Object object = (SavedState)parcelable;
        super.onRestoreInstanceState(object.getSuperState());
        twoWayNestedScrollView.mSavedState = object;
        twoWayNestedScrollView.requestLayout();
    }

    protected Parcelable onSaveInstanceState() {
        SavedState savedState;
        Parcelable parcelable = super.onSaveInstanceState();
        SavedState savedState2 = savedState;
        savedState2(parcelable);
        savedState2.scrollPositionX = this.getScrollX();
        savedState.scrollPositionY = this.getScrollY();
        return savedState;
    }

    static class AccessibilityDelegate
    extends AccessibilityDelegateCompat {
        AccessibilityDelegate() {
        }

        public boolean performAccessibilityAction(View view2, int n, Bundle bundle) {
            if (super.performAccessibilityAction(view2, n, bundle)) {
                return true;
            }
            Object object = (TwoWayNestedScrollView)view2;
            if (!object.isEnabled()) {
                return false;
            }
            if (n != 4096) {
                if (n != 8192 && n != 16908344) {
                    if (n != 16908346) {
                        return false;
                    }
                } else {
                    AccessibilityDelegate accessibilityDelegate = object;
                    int n2 = accessibilityDelegate.getHeight() - object.getPaddingBottom() - object.getPaddingTop();
                    n2 = Math.max(accessibilityDelegate.getScrollY() - n2, 0);
                    if (n2 != object.getScrollY()) {
                        ((TwoWayNestedScrollView)((Object)object)).smoothScrollTo(0, n2, true);
                        return true;
                    }
                    return false;
                }
            }
            AccessibilityDelegate accessibilityDelegate = object;
            int n3 = accessibilityDelegate.getHeight() - object.getPaddingBottom() - object.getPaddingTop();
            n3 = Math.min(accessibilityDelegate.getScrollY() + n3, ((TwoWayNestedScrollView)((Object)object)).getScrollRangeY());
            if (n3 != object.getScrollY()) {
                ((TwoWayNestedScrollView)((Object)object)).smoothScrollTo(0, n3, true);
                return true;
            }
            return false;
        }

        public void onInitializeAccessibilityNodeInfo(View view2, AccessibilityNodeInfoCompat accessibilityNodeInfoCompat) {
            int n;
            super.onInitializeAccessibilityNodeInfo(view2, accessibilityNodeInfoCompat);
            TwoWayNestedScrollView twoWayNestedScrollView = (TwoWayNestedScrollView)view2;
            accessibilityNodeInfoCompat.setClassName((CharSequence)ScrollView.class.getName());
            if (twoWayNestedScrollView.isEnabled() && (n = twoWayNestedScrollView.getScrollRangeY()) > 0) {
                accessibilityNodeInfoCompat.setScrollable(true);
                if (twoWayNestedScrollView.getScrollY() > 0) {
                    AccessibilityNodeInfoCompat accessibilityNodeInfoCompat2 = accessibilityNodeInfoCompat;
                    accessibilityNodeInfoCompat2.addAction(AccessibilityNodeInfoCompat.AccessibilityActionCompat.ACTION_SCROLL_BACKWARD);
                    accessibilityNodeInfoCompat2.addAction(AccessibilityNodeInfoCompat.AccessibilityActionCompat.ACTION_SCROLL_UP);
                }
                if (twoWayNestedScrollView.getScrollY() < n) {
                    AccessibilityNodeInfoCompat accessibilityNodeInfoCompat3 = accessibilityNodeInfoCompat;
                    accessibilityNodeInfoCompat3.addAction(AccessibilityNodeInfoCompat.AccessibilityActionCompat.ACTION_SCROLL_FORWARD);
                    accessibilityNodeInfoCompat3.addAction(AccessibilityNodeInfoCompat.AccessibilityActionCompat.ACTION_SCROLL_DOWN);
                }
            }
        }

        public void onInitializeAccessibilityEvent(View view2, AccessibilityEvent accessibilityEvent) {
            super.onInitializeAccessibilityEvent(view2, accessibilityEvent);
            TwoWayNestedScrollView twoWayNestedScrollView = (TwoWayNestedScrollView)view2;
            accessibilityEvent.setClassName((CharSequence)ScrollView.class.getName());
            boolean bl = twoWayNestedScrollView.getScrollRangeY() > 0;
            accessibilityEvent.setScrollable(bl);
            accessibilityEvent.setScrollX(twoWayNestedScrollView.getScrollX());
            accessibilityEvent.setScrollY(twoWayNestedScrollView.getScrollY());
            AccessibilityRecordCompat.setMaxScrollX((AccessibilityRecord)accessibilityEvent, (int)twoWayNestedScrollView.getScrollRangeX());
            AccessibilityRecordCompat.setMaxScrollY((AccessibilityRecord)accessibilityEvent, (int)twoWayNestedScrollView.getScrollRangeY());
        }
    }

    static class SavedState
    extends View.BaseSavedState {
        public static final Parcelable.Creator<SavedState> CREATOR = new Parcelable.Creator<SavedState>(){

            public SavedState createFromParcel(Parcel parcel) {
                return new SavedState(parcel);
            }

            public SavedState[] newArray(int n) {
                return new SavedState[n];
            }
        };
        public int scrollPositionX;
        public int scrollPositionY;

        SavedState(Parcelable parcelable) {
            super(parcelable);
        }

        SavedState(Parcel parcel) {
            super(parcel);
            this.scrollPositionX = parcel.readInt();
            this.scrollPositionY = parcel.readInt();
        }

        public void writeToParcel(Parcel parcel, int n) {
            SavedState savedState = this;
            super.writeToParcel(parcel, n);
            parcel.writeInt(savedState.scrollPositionX);
            parcel.writeInt(this.scrollPositionY);
        }

        @NonNull
        public String toString() {
            return "HorizontalScrollView.SavedState{" + Integer.toHexString(System.identityHashCode((Object)this)) + " scrollPositionX=" + this.scrollPositionX + "} scrollPositionY=" + this.scrollPositionY + "}";
        }
    }

    public static interface OnScrollChangeListener {
        public void onScrollChange(TwoWayNestedScrollView var1, int var2, int var3, int var4, int var5);
    }
}

