/*
 * Decompiled with CFR 0.152.
 */
package io.streamlayer.sdk.twitter.view.internal.format;

public class IntHashMap {
    private Entry[] table;
    private int count;
    private int threshold;
    private float loadFactor;

    public IntHashMap() {
        this(20, 0.75f);
    }

    public IntHashMap(int n) {
        this(n, 0.75f);
    }

    public IntHashMap(int n, float f) {
        if (n >= 0) {
            if (!(f <= 0.0f)) {
                if (n == 0) {
                    n = 1;
                }
                this.loadFactor = f;
                this.table = new Entry[n];
                this.threshold = (int)((float)n * f);
                return;
            }
            throw new IllegalArgumentException("Illegal Load: " + f);
        }
        throw new IllegalArgumentException("Illegal Capacity: " + n);
    }

    public int size() {
        return this.count;
    }

    public boolean isEmpty() {
        return this.count == 0;
    }

    public boolean contains(Object object) {
        object.getClass();
        Entry[] entryArray = entryArray.table;
        int n = entryArray.table.length;
        block0: while (true) {
            int n2 = n;
            n = n2 + -1;
            if (n2 <= 0) break;
            Entry entry = entryArray[n];
            while (true) {
                if (entry == null) continue block0;
                if (entry.value.equals(object)) {
                    return true;
                }
                entry = entry.next;
            }
            break;
        }
        return false;
    }

    public boolean containsValue(Object object) {
        return this.contains(object);
    }

    public boolean containsKey(int n) {
        Object object = ((IntHashMap)object).table[(n & Integer.MAX_VALUE) % ((IntHashMap)object).table.length];
        while (object != null) {
            if (((Entry)object).hash == n) {
                return true;
            }
            object = ((Entry)object).next;
        }
        return false;
    }

    public Object get(int n) {
        Object object = ((IntHashMap)object).table[(n & Integer.MAX_VALUE) % ((IntHashMap)object).table.length];
        while (object != null) {
            if (((Entry)object).hash == n) {
                return ((Entry)object).value;
            }
            object = ((Entry)object).next;
        }
        return null;
    }

    protected void rehash() {
        IntHashMap intHashMap = object;
        Entry[] entryArray = intHashMap.table;
        int n = intHashMap.table.length;
        int n2 = n * 2 + 1;
        Entry[] entryArray2 = new Entry[n2];
        intHashMap.threshold = (int)((float)n2 * ((IntHashMap)object).loadFactor);
        intHashMap.table = entryArray2;
        block0: while (true) {
            int n3 = n;
            n = n3 + -1;
            if (n3 <= 0) break;
            Object object = entryArray[n];
            while (true) {
                if (object == null) continue block0;
                Object object2 = object;
                Entry entry = ((Entry)object2).next;
                int n4 = (((Entry)object2).hash & Integer.MAX_VALUE) % n2;
                ((Entry)object).next = entryArray2[n4];
                entryArray2[n4] = object;
                object = entry;
            }
            break;
        }
    }

    public Object put(int n, Object object) {
        Entry entry;
        Object object2 = ((IntHashMap)((Object)entry3)).table;
        int n2 = n & Integer.MAX_VALUE;
        int n3 = n2 % ((Entry[])object2).length;
        Entry entry2 = ((IntHashMap)((Object)entry3)).table[n3];
        while (entry2 != null) {
            if (entry2.hash == n) {
                entry2.value = object;
                return entry2.value;
            }
            entry2 = entry2.next;
        }
        if (((IntHashMap)((Object)entry3)).count >= ((IntHashMap)((Object)entry3)).threshold) {
            IntHashMap intHashMap = entry3;
            intHashMap.rehash();
            object2 = intHashMap.table;
            n3 = n2 % intHashMap.table.length;
        }
        IntHashMap intHashMap = entry3;
        Entry[] entryArray = object2;
        Entry entry3 = entry;
        object2 = object2[n3];
        entry = new Entry(n, n, object, (Entry)object2);
        entryArray[n3] = entry3;
        ++intHashMap.count;
        return null;
    }

    public Object remove(int n) {
        Entry[] entryArray = this.table;
        int n2 = (n & Integer.MAX_VALUE) % entryArray.length;
        Entry entry = this.table[n2];
        Entry entry2 = null;
        Entry entry3 = entry;
        entry = entry2;
        entry2 = entry3;
        while (entry2 != null) {
            if (entry2.hash == n) {
                if (entry != null) {
                    entry.next = entry2.next;
                } else {
                    entryArray[n2] = entry2.next;
                }
                --this.count;
                entry2.value = null;
                return entry2.value;
            }
            Entry entry4 = entry = entry2.next;
            entry = entry2;
            entry2 = entry4;
        }
        return null;
    }

    public synchronized void clear() {
        Entry[] entryArray = this.table;
        int n = this.table.length;
        while ((n += -1) >= 0) {
            entryArray[n] = null;
        }
        this.count = 0;
    }

    private static class Entry {
        public final int hash;
        public int key;
        public Object value;
        public Entry next;

        protected Entry(int n, int n2, Object object, Entry entry) {
            this.hash = n;
            this.key = n2;
            this.value = object;
            this.next = entry;
        }
    }
}

