/*
 * Decompiled with CFR 0.152.
 */
package io.streamlayer.common.extensions;

import android.content.Context;
import android.graphics.Rect;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.view.inputmethod.InputMethodManager;
import androidx.core.content.ContextCompat;
import androidx.core.view.ViewCompat;
import androidx.core.view.WindowInsetsCompat;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentActivity;
import androidx.lifecycle.DefaultLifecycleObserver;
import androidx.lifecycle.LifecycleObserver;
import androidx.lifecycle.LifecycleOwner;
import io.streamlayer.common.extensions.KeyboardExtensionsKt;
import io.streamlayer.common.extensions.OtherExtensionsKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000<\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\f\u0010\u0002\u001a\u00020\u0003*\u00020\u0004H\u0000\u001a\f\u0010\u0005\u001a\u00020\u0006*\u00020\u0004H\u0000\u001a\n\u0010\u0007\u001a\u00020\b*\u00020\u0004\u001a\f\u0010\t\u001a\u00020\n*\u0004\u0018\u00010\u0003\u001a\n\u0010\u000b\u001a\u00020\f*\u00020\u0004\u001a\n\u0010\r\u001a\u00020\f*\u00020\u0003\u001a(\u0010\u000e\u001a\u00020\n*\u00020\u000f2\b\b\u0002\u0010\u0010\u001a\u00020\f2\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\n0\u0012\u001a\u001e\u0010\u000e\u001a\u00020\n*\u00020\u00042\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\n0\u0012\u001a\f\u0010\u0013\u001a\u00020\n*\u0004\u0018\u00010\u0003\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"KEYBOARD_MIN_HEIGHT_RATIO", "", "getActivityRoot", "Landroid/view/View;", "Landroidx/fragment/app/FragmentActivity;", "getContentRoot", "Landroid/view/ViewGroup;", "getKeyboardHeight", "", "hideKeyboard", "", "isKeyboardVisible", "", "keyboardIsVisible", "setInputKeyboardEventListener", "Landroidx/fragment/app/Fragment;", "needDefault", "listener", "Lkotlin/Function1;", "showKeyboard", "sdk_originalVonageRelease"})
@SourceDebugExtension(value={"SMAP\nKeyboardExtensions.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KeyboardExtensions.kt\nio/streamlayer/common/extensions/KeyboardExtensionsKt\n+ 2 Context.kt\nandroidx/core/content/ContextKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,154:1\n31#2:155\n31#2:156\n1#3:157\n*S KotlinDebug\n*F\n+ 1 KeyboardExtensions.kt\nio/streamlayer/common/extensions/KeyboardExtensionsKt\n*L\n22#1:155\n29#1:156\n*E\n"})
public final class KeyboardExtensionsKt {
    private static final float KEYBOARD_MIN_HEIGHT_RATIO = 0.15f;

    public static final void hideKeyboard(@Nullable View view2) {
        if (view2 != null) {
            Context context = view2.getContext();
            Intrinsics.checkNotNullExpressionValue((Object)context, (String)"context");
            InputMethodManager inputMethodManager = (InputMethodManager)ContextCompat.getSystemService((Context)context, InputMethodManager.class);
            if (inputMethodManager != null) {
                inputMethodManager.hideSoftInputFromWindow(view2.getWindowToken(), 0);
            }
        }
    }

    public static final void showKeyboard(@Nullable View view2) {
        if (view2 != null && view2.requestFocus()) {
            Context context = view2.getContext();
            Intrinsics.checkNotNullExpressionValue((Object)context, (String)"context");
            InputMethodManager inputMethodManager = (InputMethodManager)ContextCompat.getSystemService((Context)context, InputMethodManager.class);
            if (inputMethodManager != null) {
                inputMethodManager.showSoftInput(view2, 0);
            }
        }
    }

    public static final boolean isKeyboardVisible(@NotNull FragmentActivity fragmentActivity) {
        Rect rect;
        FragmentActivity fragmentActivity2 = fragmentActivity;
        Intrinsics.checkNotNullParameter((Object)fragmentActivity2, (String)"<this>");
        fragmentActivity = rect;
        rect = new Rect();
        View view2 = KeyboardExtensionsKt.getActivityRoot(fragmentActivity2);
        view2.getWindowVisibleDisplayFrame((Rect)fragmentActivity);
        int[] nArray = new int[2];
        KeyboardExtensionsKt.getContentRoot(fragmentActivity2).getLocationOnScreen(nArray);
        boolean bl = OtherExtensionsKt.isScreenPortrait((Context)fragmentActivity2);
        View view3 = view2;
        int n = view3.getRootView().getHeight();
        int n2 = view3.getRootView().getWidth();
        if (bl && n2 > n || !bl && n > n2) {
            return false;
        }
        return (float)(n - fragmentActivity.height() - nArray[1]) > (float)n * 0.15f;
    }

    public static final int getKeyboardHeight(@NotNull FragmentActivity fragmentActivity) {
        Rect rect;
        FragmentActivity fragmentActivity2 = fragmentActivity;
        Intrinsics.checkNotNullParameter((Object)fragmentActivity2, (String)"<this>");
        fragmentActivity = rect;
        rect = new Rect();
        View view2 = KeyboardExtensionsKt.getActivityRoot(fragmentActivity2);
        view2.getWindowVisibleDisplayFrame((Rect)fragmentActivity);
        int[] nArray = new int[2];
        KeyboardExtensionsKt.getContentRoot(fragmentActivity2).getLocationOnScreen(nArray);
        boolean bl = OtherExtensionsKt.isScreenPortrait((Context)fragmentActivity2);
        View view3 = view2;
        int n = view3.getRootView().getHeight();
        int n2 = view3.getRootView().getWidth();
        if (bl && n2 > n || !bl && n > n2) {
            return 0;
        }
        return n - fragmentActivity.height() - nArray[1];
    }

    public static final void setInputKeyboardEventListener(@NotNull Fragment fragment, boolean bl, @NotNull Function1<? super Boolean, Unit> function1) {
        Intrinsics.checkNotNullParameter((Object)fragment, (String)"<this>");
        Intrinsics.checkNotNullParameter(function1, (String)"listener");
        FragmentActivity fragmentActivity = fragment.requireActivity();
        Intrinsics.checkNotNullExpressionValue((Object)fragmentActivity, (String)"requireActivity()");
        if ((fragmentActivity.getWindow().getAttributes().softInputMode & 0xF0 & 0x30) != 48) {
            ViewTreeObserver.OnGlobalLayoutListener onGlobalLayoutListener;
            ViewTreeObserver.OnGlobalLayoutListener onGlobalLayoutListener2 = onGlobalLayoutListener;
            onGlobalLayoutListener = new ViewTreeObserver.OnGlobalLayoutListener(bl, fragmentActivity, function1){
                @Nullable
                private Boolean wasOpened;
                final /* synthetic */ FragmentActivity $activity;
                final /* synthetic */ Function1<Boolean, Unit> $listener;
                {
                    this.$activity = fragmentActivity;
                    this.$listener = function1;
                    Boolean bl2 = !bl ? Boolean.FALSE : null;
                    this.wasOpened = bl2;
                }

                public void onGlobalLayout() {
                    boolean bl = KeyboardExtensionsKt.isKeyboardVisible(this.$activity);
                    if (Intrinsics.areEqual((Object)bl, (Object)this.wasOpened)) {
                        return;
                    }
                    this.wasOpened = bl;
                    this.$listener.invoke((Object)bl);
                }
            };
            KeyboardExtensionsKt.getActivityRoot(fragmentActivity).getViewTreeObserver().addOnGlobalLayoutListener(onGlobalLayoutListener2);
            fragment.getViewLifecycleOwner().getLifecycle().addObserver((LifecycleObserver)new DefaultLifecycleObserver(fragment, onGlobalLayoutListener2){
                final /* synthetic */ Fragment $this_setInputKeyboardEventListener;
                final /* synthetic */ setInputKeyboardEventListener.layoutListener.1 $layoutListener;
                {
                    this.$this_setInputKeyboardEventListener = fragment;
                    this.$layoutListener = var2_2;
                }

                public void onDestroy(@NotNull LifecycleOwner lifecycleOwner) {
                    setInputKeyboardEventListener.2 v0 = this;
                    Intrinsics.checkNotNullParameter((Object)lifecycleOwner, (String)"owner");
                    v0.$this_setInputKeyboardEventListener.getViewLifecycleOwner().getLifecycle().removeObserver((LifecycleObserver)this);
                    FragmentActivity fragmentActivity = v0.$this_setInputKeyboardEventListener.requireActivity();
                    Intrinsics.checkNotNullExpressionValue((Object)fragmentActivity, (String)"requireActivity()");
                    KeyboardExtensionsKt.getActivityRoot(fragmentActivity).getViewTreeObserver().removeOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this.$layoutListener);
                }
            });
            return;
        }
        throw new IllegalArgumentException("Parameter:activity window SoftInputMethod is SOFT_INPUT_ADJUST_NOTHING. In this case window will not be resized".toString());
    }

    public static /* synthetic */ void setInputKeyboardEventListener$default(Fragment fragment, boolean bl, Function1 function1, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        KeyboardExtensionsKt.setInputKeyboardEventListener(fragment, bl, (Function1<? super Boolean, Unit>)function1);
    }

    public static final void setInputKeyboardEventListener(@NotNull FragmentActivity fragmentActivity, @NotNull Function1<? super Boolean, Unit> function1) {
        Intrinsics.checkNotNullParameter((Object)fragmentActivity, (String)"<this>");
        Intrinsics.checkNotNullParameter(function1, (String)"listener");
        if ((fragmentActivity.getWindow().getAttributes().softInputMode & 0xF0 & 0x30) != 48) {
            ViewTreeObserver.OnGlobalLayoutListener onGlobalLayoutListener;
            FragmentActivity fragmentActivity2 = fragmentActivity;
            ViewTreeObserver.OnGlobalLayoutListener onGlobalLayoutListener2 = onGlobalLayoutListener;
            onGlobalLayoutListener = new ViewTreeObserver.OnGlobalLayoutListener(fragmentActivity, function1){
                private boolean wasOpened;
                final /* synthetic */ FragmentActivity $this_setInputKeyboardEventListener;
                final /* synthetic */ Function1<Boolean, Unit> $listener;
                {
                    this.$this_setInputKeyboardEventListener = fragmentActivity;
                    this.$listener = function1;
                }

                public void onGlobalLayout() {
                    boolean bl = KeyboardExtensionsKt.isKeyboardVisible(this.$this_setInputKeyboardEventListener);
                    if (bl == this.wasOpened) {
                        return;
                    }
                    this.wasOpened = bl;
                    this.$listener.invoke((Object)bl);
                }
            };
            KeyboardExtensionsKt.getActivityRoot(fragmentActivity2).getViewTreeObserver().addOnGlobalLayoutListener(onGlobalLayoutListener2);
            fragmentActivity2.getLifecycle().addObserver((LifecycleObserver)new DefaultLifecycleObserver(fragmentActivity, onGlobalLayoutListener2){
                final /* synthetic */ FragmentActivity $this_setInputKeyboardEventListener;
                final /* synthetic */ setInputKeyboardEventListener.layoutListener.2 $layoutListener;
                {
                    this.$this_setInputKeyboardEventListener = fragmentActivity;
                    this.$layoutListener = var2_2;
                }

                public void onDestroy(@NotNull LifecycleOwner lifecycleOwner) {
                    setInputKeyboardEventListener.4 v0 = this;
                    Intrinsics.checkNotNullParameter((Object)lifecycleOwner, (String)"owner");
                    v0.$this_setInputKeyboardEventListener.getLifecycle().removeObserver((LifecycleObserver)this);
                    KeyboardExtensionsKt.getActivityRoot(v0.$this_setInputKeyboardEventListener).getViewTreeObserver().removeOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this.$layoutListener);
                }
            });
            return;
        }
        throw new IllegalArgumentException("Parameter:activity window SoftInputMethod is SOFT_INPUT_ADJUST_NOTHING. In this case window will not be resized".toString());
    }

    public static final boolean keyboardIsVisible(@NotNull View view2) {
        View view3 = view2;
        Intrinsics.checkNotNullParameter((Object)view3, (String)"<this>");
        view2 = ViewCompat.getRootWindowInsets((View)view3);
        return view2 != null ? view2.isVisible(WindowInsetsCompat.Type.ime()) : false;
    }

    @NotNull
    public static final View getActivityRoot(@NotNull FragmentActivity fragmentActivity) {
        FragmentActivity fragmentActivity2 = fragmentActivity;
        Intrinsics.checkNotNullParameter((Object)fragmentActivity2, (String)"<this>");
        View view2 = KeyboardExtensionsKt.getContentRoot(fragmentActivity2).getRootView();
        Intrinsics.checkNotNullExpressionValue((Object)view2, (String)"getContentRoot().rootView");
        return view2;
    }

    @NotNull
    public static final ViewGroup getContentRoot(@NotNull FragmentActivity fragmentActivity) {
        FragmentActivity fragmentActivity2 = fragmentActivity;
        Intrinsics.checkNotNullParameter((Object)fragmentActivity2, (String)"<this>");
        View view2 = fragmentActivity2.findViewById(0x1020002);
        Intrinsics.checkNotNullExpressionValue((Object)view2, (String)"findViewById(android.R.id.content)");
        return (ViewGroup)view2;
    }
}

