/*
 * Decompiled with CFR 0.152.
 */
package io.streamlayer.common.views;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Rect;
import android.graphics.RectF;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import io.streamlayer.sdk.R;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0014\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\f\b\u0000\u0018\u00002\u00020\u0001B%\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\u001a\u001a\u00020\u001bH\u0002J\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0014J\u0010\u0010 \u001a\u00020\u000b2\u0006\u0010!\u001a\u00020\"H\u0016J\u0006\u0010#\u001a\u00020\u0007J0\u0010$\u001a\u00020\u001d2\u0006\u0010%\u001a\u00020\u000b2\u0006\u0010&\u001a\u00020\u00072\u0006\u0010'\u001a\u00020\u00072\u0006\u0010(\u001a\u00020\u00072\u0006\u0010)\u001a\u00020\u0007H\u0014J\u0018\u0010*\u001a\u00020\u001d2\u0006\u0010+\u001a\u00020\u00072\u0006\u0010,\u001a\u00020\u0007H\u0014J\u000e\u0010-\u001a\u00020\u001d2\u0006\u0010\t\u001a\u00020\u0007R\u000e\u0010\t\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0013\u001a\u0004\u0018\u00010\u00148F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006."}, d2={"Lio/streamlayer/common/views/RotateLayout;", "Landroid/view/ViewGroup;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "defStyleAttr", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "angle", "angleChanged", "", "childTouchPoint", "", "rotateMatrix", "Landroid/graphics/Matrix;", "tempRectF1", "Landroid/graphics/RectF;", "tempRectF2", "view", "Landroid/view/View;", "getView", "()Landroid/view/View;", "viewRectRotated", "Landroid/graphics/Rect;", "viewTouchPoint", "angleC", "", "dispatchDraw", "", "canvas", "Landroid/graphics/Canvas;", "dispatchTouchEvent", "event", "Landroid/view/MotionEvent;", "getAngle", "onLayout", "changed", "l", "t", "r", "b", "onMeasure", "widthMeasureSpec", "heightMeasureSpec", "setAngle", "sdk_originalVonageRelease"})
public final class RotateLayout
extends ViewGroup {
    private int angle;
    @NotNull
    private final Matrix rotateMatrix;
    @NotNull
    private final Rect viewRectRotated;
    @NotNull
    private final RectF tempRectF1;
    @NotNull
    private final RectF tempRectF2;
    @NotNull
    private final float[] viewTouchPoint;
    @NotNull
    private final float[] childTouchPoint;
    private boolean angleChanged;

    @JvmOverloads
    public RotateLayout(@NotNull Context context, @Nullable AttributeSet attributeSet, int n) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context, attributeSet, n);
        this.rotateMatrix = new Matrix();
        this.viewRectRotated = new Rect();
        this.tempRectF1 = new RectF();
        this.tempRectF2 = new RectF();
        this.viewTouchPoint = new float[2];
        this.childTouchPoint = new float[2];
        this.angleChanged = true;
        TypedArray typedArray = context.obtainStyledAttributes(attributeSet, R.styleable.RotateLayout);
        Intrinsics.checkNotNullExpressionValue((Object)typedArray, (String)"context.obtainStyledAttr\u2026R.styleable.RotateLayout)");
        this.angle = typedArray.getInt(R.styleable.RotateLayout_angle, 0);
        typedArray.recycle();
        this.setWillNotDraw(false);
    }

    public /* synthetic */ RotateLayout(Context context, AttributeSet attributeSet, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            attributeSet = null;
        }
        if ((n2 & 4) != 0) {
            n = 0;
        }
        this(context, attributeSet, n);
    }

    private final double angleC() {
        return (double)this.angle * (Math.PI * 2) / (double)360;
    }

    @JvmOverloads
    public RotateLayout(@NotNull Context context, @Nullable AttributeSet attributeSet) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, attributeSet, 0, 4, null);
    }

    @JvmOverloads
    public RotateLayout(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, null, 0, 6, null);
    }

    public final int getAngle() {
        return this.angle;
    }

    public final void setAngle(int n) {
        if (this.angle != n) {
            RotateLayout rotateLayout = this;
            rotateLayout.angle = n;
            rotateLayout.angleChanged = true;
            rotateLayout.requestLayout();
            rotateLayout.invalidate();
        }
    }

    @Nullable
    public final View getView() {
        return this.getChildCount() > 0 ? this.getChildAt(0) : null;
    }

    protected void onMeasure(int n, int n2) {
        View view2 = this.getView();
        if (view2 != null) {
            if (Math.abs(this.angle % 180) == 90) {
                this.measureChild(view2, n2, n);
                this.setMeasuredDimension(View.resolveSize((int)view2.getMeasuredHeight(), (int)n), View.resolveSize((int)view2.getMeasuredWidth(), (int)n2));
            } else if (Math.abs(this.angle % 180) == 0) {
                this.measureChild(view2, n, n2);
                this.setMeasuredDimension(View.resolveSize((int)view2.getMeasuredWidth(), (int)n), View.resolveSize((int)view2.getMeasuredHeight(), (int)n2));
            } else {
                View view3 = view2;
                this.measureChild(view2, View.MeasureSpec.makeMeasureSpec((int)0, (int)0), View.MeasureSpec.makeMeasureSpec((int)0, (int)0));
                int n3 = (int)Math.ceil((double)view3.getMeasuredWidth() * Math.abs(Math.cos(this.angleC())) + (double)view2.getMeasuredHeight() * Math.abs(Math.sin(this.angleC())));
                int n4 = View.resolveSize((int)n3, (int)n);
                this.setMeasuredDimension(n4, View.resolveSize((int)((int)Math.ceil((double)view3.getMeasuredWidth() * Math.abs(Math.sin(this.angleC())) + (double)view2.getMeasuredHeight() * Math.abs(Math.cos(this.angleC())))), (int)n2));
            }
        } else {
            super.onMeasure(n, n2);
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void onLayout(boolean bl, int n, int n2, int n3, int n4) {
        void var3_7;
        void var5_11;
        void var2_6;
        void rectF2;
        var2_6 = rectF2 - var2_6;
        var3_7 = var5_11 - var3_7;
        if (this.angleChanged || bl) {
            RotateLayout rotateLayout = this;
            RectF rectF = rotateLayout.tempRectF1;
            float f = (float)var2_6;
            float f2 = (float)var3_7;
            rectF.set(0.0f, 0.0f, f, f2);
            RectF rectF3 = rotateLayout.tempRectF2;
            RotateLayout rotateLayout2 = this;
            RectF rectF4 = rectF;
            f2 = this.angle;
            float f3 = rectF4.centerX();
            float f4 = rectF4.centerY();
            rotateLayout2.rotateMatrix.setRotate(f2, f3, f4);
            rotateLayout2.rotateMatrix.mapRect(rectF3, rectF);
            rectF3.round(rotateLayout2.viewRectRotated);
            rotateLayout.angleChanged = false;
        }
        if ((this = this.getView()) != null) {
            void var1_4 = (var2_6 - this.getMeasuredWidth()) / 2;
            var2_6 = (var3_7 - this.getMeasuredHeight()) / 2;
            void n6 = var1_4 + this.getMeasuredWidth();
            void var1_5 = var2_6 + this.getMeasuredHeight();
            this.layout((int)var1_4, (int)var2_6, (int)n6, (int)var1_5);
        }
    }

    protected void dispatchDraw(@NotNull Canvas canvas) {
        Canvas canvas2 = canvas;
        Canvas canvas3 = canvas;
        Intrinsics.checkNotNullParameter((Object)canvas3, (String)"canvas");
        canvas3.save();
        RotateLayout rotateLayout = this;
        float f = (float)rotateLayout.getWidth() / 2.0f;
        canvas2.rotate(-((float)this.angle), f, (float)rotateLayout.getHeight() / 2.0f);
        super.dispatchDraw(canvas2);
        canvas.restore();
    }

    public boolean dispatchTouchEvent(@NotNull MotionEvent motionEvent) {
        MotionEvent motionEvent2 = motionEvent;
        RotateLayout rotateLayout = this;
        Intrinsics.checkNotNullParameter((Object)motionEvent, (String)"event");
        rotateLayout.viewTouchPoint[0] = motionEvent.getX();
        rotateLayout.viewTouchPoint[1] = motionEvent.getY();
        RotateLayout rotateLayout2 = this;
        float[] fArray = rotateLayout2.childTouchPoint;
        rotateLayout.rotateMatrix.mapPoints(fArray, rotateLayout2.viewTouchPoint);
        float f = rotateLayout.childTouchPoint[0];
        motionEvent2.setLocation(f, rotateLayout.childTouchPoint[1]);
        boolean bl = super.dispatchTouchEvent(motionEvent2);
        float f2 = this.viewTouchPoint[0];
        motionEvent.setLocation(f2, this.viewTouchPoint[1]);
        return bl;
    }
}

