/*
 * Decompiled with CFR 0.152.
 */
package io.streamlayer.sdk.statistics.golf;

import android.annotation.SuppressLint;
import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import androidx.core.content.ContextCompat;
import androidx.recyclerview.widget.DiffUtil;
import androidx.recyclerview.widget.RecyclerView;
import com.google.android.material.textview.MaterialTextView;
import io.streamlayer.common.extensions.ViewExtensionsKt;
import io.streamlayer.sdk.R;
import io.streamlayer.sdk.databinding.SlrItemStatisticsGolfSummaryPlayerBinding;
import io.streamlayer.sdk.databinding.SlrItemStatisticsGolfSummaryProjectedCutBinding;
import io.streamlayer.sdk.model.sports.golf.Player;
import io.streamlayer.sdk.statistics.golf.Summary;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0004\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0003\u0015\u0016\u0017B\u0005\u00a2\u0006\u0002\u0010\u0003J\b\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\bH\u0016J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\bH\u0016J\u0018\u0010\u000e\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\bH\u0016J\u0014\u0010\u0012\u001a\u00020\f2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00060\u0014R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lio/streamlayer/sdk/statistics/golf/PlayerAdapter;", "Landroidx/recyclerview/widget/RecyclerView$Adapter;", "Landroidx/recyclerview/widget/RecyclerView$ViewHolder;", "()V", "items", "", "Lio/streamlayer/sdk/statistics/golf/Summary$Item;", "getItemCount", "", "getItemViewType", "position", "onBindViewHolder", "", "holder", "onCreateViewHolder", "parent", "Landroid/view/ViewGroup;", "viewType", "setItems", "list", "", "ItemDiffUtil", "PlayerViewHolder", "ProjectedCutViewHolder", "sdk_originalVonageRelease"})
final class PlayerAdapter
extends RecyclerView.Adapter<RecyclerView.ViewHolder> {
    @NotNull
    private final List<Summary.Item> items;

    public PlayerAdapter() {
        ArrayList arrayList;
        Object object = arrayList;
        arrayList = new ArrayList();
        v1.items = object;
    }

    public int getItemCount() {
        return this.items.size();
    }

    public int getItemViewType(int n) {
        block4: {
            int n2;
            block3: {
                block2: {
                    Object object = object.items.get(n);
                    if (!(object instanceof Summary.Item.Player)) break block2;
                    n2 = 0;
                    break block3;
                }
                if (!(object instanceof Summary.Item.ProjectedCut)) break block4;
                n2 = -1;
            }
            return n2;
        }
        throw new NoWhenBranchMatchedException();
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NotNull
    public RecyclerView.ViewHolder onCreateViewHolder(@NotNull ViewGroup viewGroup, int n) {
        RecyclerView.ViewHolder viewHolder;
        void var2_4;
        void var1_3;
        Intrinsics.checkNotNullParameter((Object)var1_3, (String)"parent");
        if (var2_4 != -1) {
            PlayerViewHolder playerViewHolder;
            if (var2_4 != false) throw new Exception("Unsupported View type");
            viewHolder = playerViewHolder;
            SlrItemStatisticsGolfSummaryPlayerBinding slrItemStatisticsGolfSummaryPlayerBinding = SlrItemStatisticsGolfSummaryPlayerBinding.inflate(LayoutInflater.from((Context)var1_3.getContext()), (ViewGroup)var1_3, false);
            Intrinsics.checkNotNullExpressionValue((Object)slrItemStatisticsGolfSummaryPlayerBinding, (String)"inflate(\n               \u2026  false\n                )");
            playerViewHolder = new PlayerViewHolder(this, slrItemStatisticsGolfSummaryPlayerBinding);
            return viewHolder;
        } else {
            ProjectedCutViewHolder projectedCutViewHolder;
            viewHolder = projectedCutViewHolder;
            SlrItemStatisticsGolfSummaryProjectedCutBinding slrItemStatisticsGolfSummaryProjectedCutBinding = SlrItemStatisticsGolfSummaryProjectedCutBinding.inflate(LayoutInflater.from((Context)var1_3.getContext()), (ViewGroup)var1_3, false);
            Intrinsics.checkNotNullExpressionValue((Object)slrItemStatisticsGolfSummaryProjectedCutBinding, (String)"inflate(\n               \u2026  false\n                )");
            projectedCutViewHolder = new ProjectedCutViewHolder(slrItemStatisticsGolfSummaryProjectedCutBinding);
        }
        return viewHolder;
    }

    public void onBindViewHolder(@NotNull RecyclerView.ViewHolder viewHolder, int n) {
        RecyclerView.ViewHolder viewHolder2 = viewHolder;
        Intrinsics.checkNotNullParameter((Object)viewHolder2, (String)"holder");
        if (viewHolder2 instanceof PlayerViewHolder) {
            PlayerViewHolder playerViewHolder = (PlayerViewHolder)viewHolder;
            Summary.Item item = this.items.get(n);
            Intrinsics.checkNotNull((Object)item, (String)"null cannot be cast to non-null type io.streamlayer.sdk.statistics.golf.Summary.Item.Player");
            playerViewHolder.bind(((Summary.Item.Player)item).getValue());
        }
    }

    public final void setItems(@NotNull List<? extends Summary.Item> list2) {
        Intrinsics.checkNotNullParameter(list2, (String)"list");
        DiffUtil.DiffResult diffResult = DiffUtil.calculateDiff((DiffUtil.Callback)new ItemDiffUtil(this.items, list2));
        PlayerAdapter playerAdapter2 = this;
        Intrinsics.checkNotNullExpressionValue((Object)diffResult, (String)"calculateDiff(ItemDiffUtil(items, list))");
        playerAdapter2.items.clear();
        playerAdapter2.items.addAll(list2);
        diffResult.dispatchUpdatesTo((RecyclerView.Adapter)playerAdapter2);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0007J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\nH\u0002J\u0012\u0010\r\u001a\u00020\n2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lio/streamlayer/sdk/statistics/golf/PlayerAdapter$PlayerViewHolder;", "Landroidx/recyclerview/widget/RecyclerView$ViewHolder;", "binding", "Lio/streamlayer/sdk/databinding/SlrItemStatisticsGolfSummaryPlayerBinding;", "(Lio/streamlayer/sdk/statistics/golf/PlayerAdapter;Lio/streamlayer/sdk/databinding/SlrItemStatisticsGolfSummaryPlayerBinding;)V", "bind", "", "player", "Lio/streamlayer/sdk/model/sports/golf/Player;", "getColor", "", "attrId", "colorId", "getPositiveOrNegativeColor", "value", "", "sdk_originalVonageRelease"})
    public final class PlayerViewHolder
    extends RecyclerView.ViewHolder {
        @NotNull
        private final SlrItemStatisticsGolfSummaryPlayerBinding binding;
        final /* synthetic */ PlayerAdapter this$0;

        public PlayerViewHolder(@NotNull PlayerAdapter playerAdapter2, SlrItemStatisticsGolfSummaryPlayerBinding slrItemStatisticsGolfSummaryPlayerBinding) {
            SlrItemStatisticsGolfSummaryPlayerBinding slrItemStatisticsGolfSummaryPlayerBinding2 = slrItemStatisticsGolfSummaryPlayerBinding;
            Intrinsics.checkNotNullParameter((Object)slrItemStatisticsGolfSummaryPlayerBinding, (String)"binding");
            this.this$0 = playerAdapter2;
            super((View)slrItemStatisticsGolfSummaryPlayerBinding.getRoot());
            this.binding = slrItemStatisticsGolfSummaryPlayerBinding;
            slrItemStatisticsGolfSummaryPlayerBinding2.slPositionTV.setTextColor(this.getColor(R.attr.slrGolfPlayerDefaultColor, R.color.slr_white_alpha_50));
            slrItemStatisticsGolfSummaryPlayerBinding2.slThruTV.setTextColor(this.getColor(R.attr.slrGolfPlayerDefaultColor, R.color.slr_white_alpha_50));
            slrItemStatisticsGolfSummaryPlayerBinding2.slStatusTV.setTextColor(this.getColor(R.attr.slrGolfPlayerDefaultColor, R.color.slr_white_alpha_50));
        }

        private final int getPositiveOrNegativeColor(String string2) {
            return string2 != null && StringsKt.startsWith$default((String)string2, (String)"-", (boolean)false, (int)2, null) ? this.getColor(R.attr.slrGolfPlayerNegativeColor, R.color.slr_red) : this.getColor(R.attr.slrGolfPlayerPositiveColor, R.color.slr_blue);
        }

        private final int getColor(int n, int n2) {
            PlayerViewHolder playerViewHolder = playerViewHolder.binding.getRoot();
            Context context = playerViewHolder.getContext();
            Context context2 = playerViewHolder.getContext();
            Intrinsics.checkNotNullExpressionValue((Object)context2, (String)"context");
            return ContextCompat.getColor((Context)context, (int)ViewExtensionsKt.resoleAttributeResId(context2, n, n2));
        }

        @SuppressLint(value={"SetTextI18n"})
        public final void bind(@NotNull Player player) {
            Intrinsics.checkNotNullParameter((Object)player, (String)"player");
            SlrItemStatisticsGolfSummaryPlayerBinding slrItemStatisticsGolfSummaryPlayerBinding = playerViewHolder.binding;
            Player.Status status = player.getStatus();
            MaterialTextView materialTextView = slrItemStatisticsGolfSummaryPlayerBinding.slPositionTV;
            int[] nArray = WhenMappings.$EnumSwitchMapping$0;
            int n = WhenMappings.$EnumSwitchMapping$0[status.ordinal()];
            Object object = n != 1 ? (n != 2 ? (n != 3 ? player.getPosition() : slrItemStatisticsGolfSummaryPlayerBinding.getRoot().getContext().getString(R.string.slr_statistics_golf_withdrawn_pos)) : slrItemStatisticsGolfSummaryPlayerBinding.getRoot().getContext().getString(R.string.slr_statistics_golf_missed_cut_pos)) : slrItemStatisticsGolfSummaryPlayerBinding.getRoot().getContext().getString(R.string.slr_statistics_golf_disqualified_pos);
            materialTextView.setText((CharSequence)object);
            materialTextView = slrItemStatisticsGolfSummaryPlayerBinding.slNameTV;
            object = player.getAmateur() ? slrItemStatisticsGolfSummaryPlayerBinding.getRoot().getContext().getString(R.string.slr_statistics_golf_amateur_name, new Object[]{player.getDisplayName2()}) : player.getDisplayName2();
            materialTextView.setText((CharSequence)object);
            materialTextView = slrItemStatisticsGolfSummaryPlayerBinding.slTotalTV;
            object = Player.Status.NORMAL;
            String string2 = status == object ? player.getTopar() : null;
            materialTextView.setText((CharSequence)string2);
            materialTextView = slrItemStatisticsGolfSummaryPlayerBinding.slTotalTV;
            Intrinsics.checkNotNullExpressionValue((Object)materialTextView, (String)"slTotalTV");
            boolean bl = status == object;
            SlrItemStatisticsGolfSummaryPlayerBinding slrItemStatisticsGolfSummaryPlayerBinding2 = slrItemStatisticsGolfSummaryPlayerBinding;
            ViewExtensionsKt.visibleIfElse$default((View)materialTextView, bl, 0, 2, null);
            slrItemStatisticsGolfSummaryPlayerBinding2.slTotalTV.setTextColor(playerViewHolder.getPositiveOrNegativeColor(player.getTopar()));
            materialTextView = slrItemStatisticsGolfSummaryPlayerBinding2.slThruTV;
            String string3 = status == object ? player.getThru() : null;
            materialTextView.setText((CharSequence)string3);
            materialTextView = slrItemStatisticsGolfSummaryPlayerBinding.slThruTV;
            Intrinsics.checkNotNullExpressionValue((Object)materialTextView, (String)"slThruTV");
            boolean bl2 = status == object;
            ViewExtensionsKt.visibleIfElse$default((View)materialTextView, bl2, 0, 2, null);
            materialTextView = slrItemStatisticsGolfSummaryPlayerBinding.slTodayTV;
            String string4 = status == object ? player.getToday() : null;
            materialTextView.setText((CharSequence)string4);
            materialTextView = slrItemStatisticsGolfSummaryPlayerBinding.slTodayTV;
            Intrinsics.checkNotNullExpressionValue((Object)materialTextView, (String)"slTodayTV");
            boolean bl3 = status == object;
            SlrItemStatisticsGolfSummaryPlayerBinding slrItemStatisticsGolfSummaryPlayerBinding3 = slrItemStatisticsGolfSummaryPlayerBinding;
            ViewExtensionsKt.visibleIfElse$default((View)materialTextView, bl3, 0, 2, null);
            slrItemStatisticsGolfSummaryPlayerBinding3.slTodayTV.setTextColor(playerViewHolder.getPositiveOrNegativeColor(player.getToday()));
            PlayerViewHolder playerViewHolder = slrItemStatisticsGolfSummaryPlayerBinding3.slStatusTV;
            int n2 = nArray[status.ordinal()];
            Object object2 = n2 != 1 ? (n2 != 2 ? (n2 != 3 ? null : slrItemStatisticsGolfSummaryPlayerBinding.getRoot().getContext().getString(R.string.slr_statistics_golf_withdrawn)) : slrItemStatisticsGolfSummaryPlayerBinding.getRoot().getContext().getString(R.string.slr_statistics_golf_missed_cut)) : slrItemStatisticsGolfSummaryPlayerBinding.getRoot().getContext().getString(R.string.slr_statistics_golf_disqualified);
            playerViewHolder.setText((CharSequence)object2);
            playerViewHolder = slrItemStatisticsGolfSummaryPlayerBinding.slStatusTV;
            Intrinsics.checkNotNullExpressionValue((Object)((Object)playerViewHolder), (String)"slStatusTV");
            boolean bl4 = status != object;
            ViewExtensionsKt.visibleIf((View)playerViewHolder, bl4);
        }

        @Metadata(mv={1, 8, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[Player.Status.values().length];
                int[] nArray2 = nArray;
                try {
                    nArray[Player.Status.DISQUALIFIED.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {}
                try {
                    nArray2[Player.Status.MISSED_CUT.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {}
                try {
                    nArray2[Player.Status.WITHDRAWN.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {}
                $EnumSwitchMapping$0 = nArray2;
            }
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004\u00a8\u0006\u0005"}, d2={"Lio/streamlayer/sdk/statistics/golf/PlayerAdapter$ProjectedCutViewHolder;", "Landroidx/recyclerview/widget/RecyclerView$ViewHolder;", "binding", "Lio/streamlayer/sdk/databinding/SlrItemStatisticsGolfSummaryProjectedCutBinding;", "(Lio/streamlayer/sdk/statistics/golf/PlayerAdapter;Lio/streamlayer/sdk/databinding/SlrItemStatisticsGolfSummaryProjectedCutBinding;)V", "sdk_originalVonageRelease"})
    public final class ProjectedCutViewHolder
    extends RecyclerView.ViewHolder {
        public ProjectedCutViewHolder(SlrItemStatisticsGolfSummaryProjectedCutBinding slrItemStatisticsGolfSummaryProjectedCutBinding) {
            Intrinsics.checkNotNullParameter((Object)slrItemStatisticsGolfSummaryProjectedCutBinding, (String)"binding");
            super((View)slrItemStatisticsGolfSummaryProjectedCutBinding.getRoot());
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\b\u0002\u0018\u00002\u00020\u0001B!\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\rH\u0016J\u0018\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\rH\u0016J\b\u0010\u0010\u001a\u00020\rH\u0016J\b\u0010\u0011\u001a\u00020\rH\u0016R\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\b\u00a8\u0006\u0012"}, d2={"Lio/streamlayer/sdk/statistics/golf/PlayerAdapter$ItemDiffUtil;", "Landroidx/recyclerview/widget/DiffUtil$Callback;", "oldList", "", "Lio/streamlayer/sdk/statistics/golf/Summary$Item;", "newList", "(Ljava/util/List;Ljava/util/List;)V", "getNewList", "()Ljava/util/List;", "getOldList", "areContentsTheSame", "", "oldItemPosition", "", "newItemPosition", "areItemsTheSame", "getNewListSize", "getOldListSize", "sdk_originalVonageRelease"})
    private static final class ItemDiffUtil
    extends DiffUtil.Callback {
        @NotNull
        private final List<Summary.Item> oldList;
        @NotNull
        private final List<Summary.Item> newList;

        public ItemDiffUtil(@NotNull List<? extends Summary.Item> list2, @NotNull List<? extends Summary.Item> list3) {
            Intrinsics.checkNotNullParameter(list2, (String)"oldList");
            Intrinsics.checkNotNullParameter(list3, (String)"newList");
            this.oldList = list2;
            this.newList = list3;
        }

        @NotNull
        public final List<Summary.Item> getOldList() {
            return this.oldList;
        }

        @NotNull
        public final List<Summary.Item> getNewList() {
            return this.newList;
        }

        public int getOldListSize() {
            return this.oldList.size();
        }

        public int getNewListSize() {
            return this.newList.size();
        }

        public boolean areItemsTheSame(int n, int n2) {
            Summary.Item item = object.oldList.get(n);
            Object object = object.newList.get(n2);
            return item instanceof Summary.Item.Player && object instanceof Summary.Item.Player && Intrinsics.areEqual((Object)((Summary.Item.Player)item).getValue().getId(), (Object)((Summary.Item.Player)object).getValue().getId()) || item instanceof Summary.Item.ProjectedCut && object instanceof Summary.Item.ProjectedCut;
        }

        public boolean areContentsTheSame(int n, int n2) {
            Summary.Item item = object.oldList.get(n);
            Object object = object.newList.get(n2);
            return item instanceof Summary.Item.Player && object instanceof Summary.Item.Player && Intrinsics.areEqual((Object)((Summary.Item.Player)item).getValue(), (Object)((Summary.Item.Player)object).getValue()) || item instanceof Summary.Item.ProjectedCut && object instanceof Summary.Item.ProjectedCut;
        }
    }
}

