/*
 * Decompiled with CFR 0.152.
 */
package io.streamlayer.sdk.statistics.soccer.models;

import androidx.collection.ArrayMap;
import com.streamlayer.sports.common.EventTeam;
import com.streamlayer.sports.common.EventTime;
import com.streamlayer.sports.events.LineupResponse;
import com.streamlayer.sports.events.StandingsResponse;
import com.streamlayer.sports.events.SummaryResponse;
import com.streamlayer.sports.soccer.PlayByPlay;
import com.streamlayer.sports.soccer.SoccerLastGame;
import com.streamlayer.sports.soccer.SoccerLastGames;
import com.streamlayer.sports.soccer.SoccerMatchActivityType;
import com.streamlayer.sports.soccer.SoccerMatchFormationMatrix;
import com.streamlayer.sports.soccer.SoccerMatchFormationMatrixPlayer;
import com.streamlayer.sports.soccer.SoccerMatchLineup;
import com.streamlayer.sports.soccer.SoccerMatchPlayer;
import com.streamlayer.sports.soccer.SoccerPerformers;
import com.streamlayer.sports.soccer.TeamStanding;
import io.streamlayer.sdk.model.sports.EventSummary;
import io.streamlayer.sdk.model.sports.EventsKt;
import io.streamlayer.sdk.model.sports.TeamStandings;
import io.streamlayer.sdk.statistics.common.model.PlayByPlayStatistics;
import io.streamlayer.sdk.statistics.soccer.models.GameResult;
import io.streamlayer.sdk.statistics.soccer.models.ModelsKt;
import io.streamlayer.sdk.statistics.soccer.models.SoccerGame;
import io.streamlayer.sdk.statistics.soccer.models.SoccerGameEvent;
import io.streamlayer.sdk.statistics.soccer.models.SoccerGameEventType;
import io.streamlayer.sdk.statistics.soccer.models.SoccerGamePlayerStats;
import io.streamlayer.sdk.statistics.soccer.models.SoccerGameStats;
import io.streamlayer.sdk.statistics.soccer.models.SoccerGameStatsGroup;
import io.streamlayer.sdk.statistics.soccer.models.SoccerGameSummary;
import io.streamlayer.sdk.statistics.soccer.models.SoccerGameTopPlayerStats;
import io.streamlayer.sdk.statistics.soccer.models.SoccerPlayByPlayStatistics;
import io.streamlayer.sdk.statistics.soccer.models.SoccerPregame;
import io.streamlayer.sdk.statistics.soccer.models.SoccerPregameSummary;
import io.streamlayer.sdk.statistics.soccer.models.SoccerTeam;
import io.streamlayer.sdk.statistics.soccer.models.SoccerTeamMember;
import io.streamlayer.sdk.statistics.soccer.models.SoccerTeamStandings;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000\u008a\u0001\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a:\u0010\t\u001a\u0014\u0012\u0004\u0012\u00020\u000b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\f0\n*\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\r0\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\r0\u0010H\u0002\u001a\u0018\u0010\u0012\u001a\u00020\u0013*\u00020\u00142\n\b\u0002\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0000\u001a\u0014\u0010\u0012\u001a\u00020\u0017*\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0000\u001a\f\u0010\u0012\u001a\u00020\u001b*\u00020\u001cH\u0000\u001a\f\u0010\u0012\u001a\u00020\r*\u00020\u001dH\u0000\u001a\f\u0010\u0012\u001a\u00020\u001e*\u00020\u001fH\u0000\u001a\f\u0010\u0012\u001a\u00020 *\u00020!H\u0000\u001a\u0012\u0010\"\u001a\b\u0012\u0004\u0012\u00020 0\u0010*\u00020#H\u0000\u001a\f\u0010\"\u001a\u00020$*\u00020%H\u0000\u001a\f\u0010&\u001a\u00020'*\u00020\u001fH\u0000\u001a$\u0010(\u001a\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00020'0\u0010\u0012\n\u0012\b\u0012\u0004\u0012\u00020'0\u00100)*\u00020*H\u0000\u001a\u0018\u0010+\u001a\u000e\u0012\u0004\u0012\u00020,\u0012\u0004\u0012\u00020,0)*\u00020-H\u0000\"\u001b\u0010\u0000\u001a\u00020\u00018BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0004\u0010\u0005\u001a\u0004\b\u0002\u0010\u0003\"\u001b\u0010\u0006\u001a\u00020\u00018BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\b\u0010\u0005\u001a\u0004\b\u0007\u0010\u0003\u00a8\u0006."}, d2={"dateFormat", "Ljava/text/SimpleDateFormat;", "getDateFormat", "()Ljava/text/SimpleDateFormat;", "dateFormat$delegate", "Lkotlin/Lazy;", "pregameDateFormat", "getPregameDateFormat", "pregameDateFormat$delegate", "soccerTeamFieldPositions", "Landroidx/collection/ArrayMap;", "", "", "Lio/streamlayer/sdk/statistics/soccer/models/SoccerTeamMember;", "Lcom/streamlayer/sports/soccer/SoccerMatchLineup;", "mainTeam", "", "subTeam", "toDomain", "Lio/streamlayer/sdk/statistics/soccer/models/SoccerPregame;", "Lcom/streamlayer/sports/soccer/SoccerLastGame;", "winTeam", "", "Lio/streamlayer/sdk/statistics/soccer/models/SoccerPregameSummary;", "Lcom/streamlayer/sports/soccer/SoccerLastGames;", "summary", "Lio/streamlayer/sdk/model/sports/EventSummary;", "Lio/streamlayer/sdk/statistics/soccer/models/SoccerGameEventType;", "Lcom/streamlayer/sports/soccer/SoccerMatchActivityType;", "Lcom/streamlayer/sports/soccer/SoccerMatchPlayer;", "Lio/streamlayer/sdk/statistics/common/model/PlayByPlayStatistics;", "Lcom/streamlayer/sports/soccer/SoccerPlayByPlayStatistics;", "Lio/streamlayer/sdk/model/sports/TeamStandings;", "Lcom/streamlayer/sports/soccer/TeamStanding;", "toDomainSoccer", "Lcom/streamlayer/sports/events/StandingsResponse$ResponseData$StandingsResponseAttributes;", "Lio/streamlayer/sdk/statistics/soccer/models/SoccerGameSummary;", "Lcom/streamlayer/sports/events/SummaryResponse$ResponseData;", "toDomainSoccerGameEvent", "Lio/streamlayer/sdk/statistics/soccer/models/SoccerGameEvent;", "toDomainSoccerGameEvents", "Lkotlin/Pair;", "Lcom/streamlayer/sports/soccer/PlayByPlay;", "toDomainSoccerLineUp", "Lio/streamlayer/sdk/statistics/soccer/models/SoccerTeam;", "Lcom/streamlayer/sports/events/LineupResponse$ResponseData;", "sdk_originalVonageRelease"})
@SourceDebugExtension(value={"SMAP\nModels.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Models.kt\nio/streamlayer/sdk/statistics/soccer/models/ModelsKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,544:1\n1549#2:545\n1620#2,3:546\n766#2:549\n857#2,2:550\n766#2:552\n857#2,2:553\n1549#2:555\n1620#2,3:556\n766#2:559\n857#2,2:560\n766#2:562\n857#2,2:563\n1549#2:565\n1620#2,3:566\n1549#2:570\n1620#2,3:571\n1549#2:574\n1620#2,3:575\n1549#2:578\n1620#2,3:579\n1864#2,2:582\n1855#2:584\n288#2,2:585\n288#2,2:587\n1856#2:589\n1866#2:590\n1549#2:591\n1620#2,3:592\n1549#2:595\n1620#2,3:596\n1549#2:599\n1620#2,3:600\n1549#2:603\n1620#2,3:604\n288#2,2:607\n288#2,2:609\n1#3:569\n*S KotlinDebug\n*F\n+ 1 Models.kt\nio/streamlayer/sdk/statistics/soccer/models/ModelsKt\n*L\n27#1:545\n27#1:546,3\n74#1:549\n74#1:550,2\n75#1:552\n75#1:553,2\n76#1:555\n76#1:556,3\n77#1:559\n77#1:560,2\n78#1:562\n78#1:563,2\n79#1:565\n79#1:566,3\n217#1:570\n217#1:571,3\n218#1:574\n218#1:575,3\n219#1:578\n219#1:579,3\n236#1:582,2\n238#1:584\n239#1:585,2\n240#1:587,2\n238#1:589\n236#1:590\n261#1:591\n261#1:592,3\n262#1:595\n262#1:596,3\n263#1:599\n263#1:600,3\n264#1:603\n264#1:604,3\n271#1:607,2\n272#1:609,2\n*E\n"})
public final class ModelsKt {
    @NotNull
    private static final Lazy dateFormat$delegate = LazyKt.lazy((Function0)dateFormat.2.INSTANCE);
    @NotNull
    private static final Lazy pregameDateFormat$delegate = LazyKt.lazy((Function0)pregameDateFormat.2.INSTANCE);

    @NotNull
    public static final List<TeamStandings> toDomainSoccer(@NotNull StandingsResponse.ResponseData.StandingsResponseAttributes object) {
        ArrayList<TeamStandings> arrayList;
        StandingsResponse.ResponseData.StandingsResponseAttributes standingsResponseAttributes = object;
        Intrinsics.checkNotNullParameter((Object)standingsResponseAttributes, (String)"<this>");
        object = standingsResponseAttributes.getSoccer().getStandingsList();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"soccer.standingsList");
        ArrayList<TeamStandings> arrayList2 = arrayList;
        arrayList = new ArrayList<TeamStandings>(CollectionsKt.collectionSizeOrDefault((Iterable)object, (int)10));
        object = object.iterator();
        while (object.hasNext()) {
            TeamStanding teamStanding = (TeamStanding)object.next();
            Intrinsics.checkNotNullExpressionValue((Object)teamStanding, (String)"it");
            arrayList2.add(ModelsKt.toDomain(teamStanding));
        }
        return arrayList2;
    }

    @NotNull
    public static final TeamStandings toDomain(@NotNull TeamStanding object) {
        TeamStanding teamStanding = object;
        Intrinsics.checkNotNullParameter((Object)teamStanding, (String)"<this>");
        long l = teamStanding.getId();
        object = teamStanding.getName();
        String string2 = teamStanding.getLogo();
        int n = teamStanding.getWins();
        int n2 = teamStanding.getLosses();
        int n3 = teamStanding.getGamesBehind();
        List list2 = teamStanding.getColorsList();
        int n4 = teamStanding.getTotalGoals();
        int n5 = teamStanding.getTotalGoalsReceived();
        int n6 = teamStanding.getPosition();
        String string3 = teamStanding.getAlias();
        int n7 = teamStanding.getDraws();
        String string4 = teamStanding.getDivision();
        int n8 = teamStanding.getPoints();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"name");
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"logo");
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"colorsList");
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"division");
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"alias");
        return new SoccerTeamStandings(l, (String)object, string2, n, n2, 0.0, n3, list2, n4, n5, n6, string4, n7, string3, n8);
    }

    @NotNull
    public static final Pair<List<SoccerGameEvent>, List<SoccerGameEvent>> toDomainSoccerGameEvents(@NotNull PlayByPlay object) {
        ArrayList arrayList;
        ArrayList arrayList2;
        ArrayList arrayList3;
        ArrayList arrayList4;
        boolean bl;
        ArrayList arrayList5;
        ArrayList arrayList6;
        PlayByPlay playByPlay2 = object;
        Intrinsics.checkNotNullParameter((Object)playByPlay2, (String)"<this>");
        List list2 = playByPlay2.getStatisticsList();
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"statisticsList");
        Object object2 = arrayList6;
        arrayList6 = new ArrayList();
        for (Object t : list2) {
            if (!(((com.streamlayer.sports.soccer.SoccerPlayByPlayStatistics)t).getEventTime().getPeriod() == 1)) continue;
            object2.add(t);
        }
        ArrayList arrayList7 = object2;
        object2 = arrayList5;
        arrayList5 = new ArrayList();
        for (Object t : arrayList7) {
            String string2 = ((com.streamlayer.sports.soccer.SoccerPlayByPlayStatistics)t).getEventTime().getClock();
            bl = string2 == null || string2.length() == 0;
            if (!(bl ^ true)) continue;
            object2.add(t);
        }
        ArrayList arrayList8 = arrayList4;
        arrayList4 = new ArrayList(CollectionsKt.collectionSizeOrDefault(object2, (int)10));
        object2 = object2.iterator();
        while (object2.hasNext()) {
            com.streamlayer.sports.soccer.SoccerPlayByPlayStatistics soccerPlayByPlayStatistics = (com.streamlayer.sports.soccer.SoccerPlayByPlayStatistics)object2.next();
            Intrinsics.checkNotNullExpressionValue((Object)soccerPlayByPlayStatistics, (String)"it");
            arrayList8.add(ModelsKt.toDomainSoccerGameEvent(soccerPlayByPlayStatistics));
        }
        List list3 = object.getStatisticsList();
        Intrinsics.checkNotNullExpressionValue((Object)list3, (String)"statisticsList");
        object = arrayList3;
        arrayList3 = new ArrayList();
        for (Object t : list3) {
            if (!(((com.streamlayer.sports.soccer.SoccerPlayByPlayStatistics)t).getEventTime().getPeriod() == 2)) continue;
            object.add(t);
        }
        Object object3 = object;
        object = arrayList2;
        arrayList2 = new ArrayList();
        object2 = object3.iterator();
        while (object2.hasNext()) {
            Object t;
            t = object2.next();
            String string3 = ((com.streamlayer.sports.soccer.SoccerPlayByPlayStatistics)t).getEventTime().getClock();
            bl = string3 == null || string3.length() == 0;
            if (!(bl ^ true)) continue;
            object.add(t);
        }
        object2 = arrayList;
        arrayList = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)object, (int)10));
        object = object.iterator();
        while (object.hasNext()) {
            com.streamlayer.sports.soccer.SoccerPlayByPlayStatistics soccerPlayByPlayStatistics = (com.streamlayer.sports.soccer.SoccerPlayByPlayStatistics)object.next();
            Intrinsics.checkNotNullExpressionValue((Object)soccerPlayByPlayStatistics, (String)"it");
            object2.add(ModelsKt.toDomainSoccerGameEvent(soccerPlayByPlayStatistics));
        }
        return new Pair((Object)arrayList8, object2);
    }

    @NotNull
    public static final SoccerGameEvent toDomainSoccerGameEvent(@NotNull com.streamlayer.sports.soccer.SoccerPlayByPlayStatistics object) {
        Intrinsics.checkNotNullParameter((Object)object, (String)"<this>");
        com.streamlayer.sports.soccer.SoccerPlayByPlayStatistics soccerPlayByPlayStatistics = object;
        EventTime eventTime = soccerPlayByPlayStatistics.getEventTime();
        Intrinsics.checkNotNullExpressionValue((Object)eventTime, (String)"eventTime");
        object = EventsKt.toDomain(eventTime);
        String string2 = soccerPlayByPlayStatistics.getTeam().getLogo();
        SoccerMatchActivityType soccerMatchActivityType = soccerPlayByPlayStatistics.getType();
        Intrinsics.checkNotNullExpressionValue((Object)soccerMatchActivityType, (String)"type");
        SoccerGameEventType soccerGameEventType = ModelsKt.toDomain(soccerMatchActivityType);
        String string3 = soccerPlayByPlayStatistics.getPlayText();
        return new SoccerGameEvent((io.streamlayer.sdk.model.sports.EventTime)object, string2, soccerGameEventType, string3);
    }

    @NotNull
    public static final SoccerGameEventType toDomain(@NotNull SoccerMatchActivityType soccerMatchActivityType) {
        SoccerGameEventType soccerGameEventType;
        Intrinsics.checkNotNullParameter((Object)soccerMatchActivityType, (String)"<this>");
        switch (WhenMappings.$EnumSwitchMapping$0[soccerMatchActivityType.ordinal()]) {
            default: {
                throw new NoWhenBranchMatchedException();
            }
            case 7: 
            case 8: {
                soccerGameEventType = SoccerGameEventType.NONE;
                break;
            }
            case 6: {
                soccerGameEventType = SoccerGameEventType.FULL_TIME;
                break;
            }
            case 5: {
                soccerGameEventType = SoccerGameEventType.HALF_TIME;
                break;
            }
            case 4: {
                soccerGameEventType = SoccerGameEventType.SUBSTITUTION;
                break;
            }
            case 3: {
                soccerGameEventType = SoccerGameEventType.RED_CARD;
                break;
            }
            case 2: {
                soccerGameEventType = SoccerGameEventType.YELLOW_CARD;
                break;
            }
            case 1: {
                soccerGameEventType = SoccerGameEventType.GOAL;
            }
        }
        return soccerGameEventType;
    }

    @NotNull
    public static final PlayByPlayStatistics toDomain(@NotNull com.streamlayer.sports.soccer.SoccerPlayByPlayStatistics object) {
        Intrinsics.checkNotNullParameter((Object)object, (String)"<this>");
        com.streamlayer.sports.soccer.SoccerPlayByPlayStatistics soccerPlayByPlayStatistics = object;
        EventTeam eventTeam = soccerPlayByPlayStatistics.getTeam();
        Intrinsics.checkNotNullExpressionValue((Object)eventTeam, (String)"team");
        object = EventsKt.toDomain(eventTeam);
        EventTime eventTime = soccerPlayByPlayStatistics.getEventTime();
        Intrinsics.checkNotNullExpressionValue((Object)eventTime, (String)"eventTime");
        io.streamlayer.sdk.model.sports.EventTime eventTime2 = EventsKt.toDomain(eventTime);
        int n = soccerPlayByPlayStatistics.getScoreHome();
        int n2 = soccerPlayByPlayStatistics.getScoreAway();
        String string2 = soccerPlayByPlayStatistics.getPlayText();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"playText");
        boolean bl = soccerPlayByPlayStatistics.getScoring();
        return new SoccerPlayByPlayStatistics((io.streamlayer.sdk.model.sports.EventTeam)object, eventTime2, n, n2, string2, bl);
    }

    private static final SimpleDateFormat getDateFormat() {
        return (SimpleDateFormat)dateFormat$delegate.getValue();
    }

    private static final SimpleDateFormat getPregameDateFormat() {
        return (SimpleDateFormat)pregameDateFormat$delegate.getValue();
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    @NotNull
    public static final SoccerPregame toDomain(@NotNull SoccerLastGame object, @Nullable String string2) {
        void var0_7;
        String string3;
        Object object2;
        int n;
        int n2;
        String string4;
        String string5;
        block9: {
            block8: {
                void var1_8;
                Object object3 = object;
                Intrinsics.checkNotNullParameter((Object)object3, (String)"<this>");
                string5 = object3.getAttributes().getHomeTeam();
                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"attributes.homeTeam");
                string4 = object3.getAttributes().getAwayTeam();
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"attributes.awayTeam");
                n2 = object3.getAttributes().getHomeScore();
                n = object3.getAttributes().getAwayScore();
                object2 = ModelsKt.getDateFormat().parse(object.getAttributes().getDate());
                object2 = object2 != null ? ModelsKt.getPregameDateFormat().format((Date)object2) : null;
                if (object2 == null) {
                    object2 = "";
                }
                string3 = object.getAttributes().getLeague();
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"attributes.league");
                if (var1_8 == null) break block8;
                if (Intrinsics.areEqual((Object)var1_8, (Object)object.getAttributes().getHomeTeam()) && object.getAttributes().getHomeScore() > object.getAttributes().getAwayScore()) {
                    GameResult gameResult = GameResult.WIN;
                    return new SoccerPregame(string5, string4, n2, n, (String)object2, string3, (GameResult)var0_7);
                }
                if (Intrinsics.areEqual((Object)var1_8, (Object)object.getAttributes().getHomeTeam()) && object.getAttributes().getHomeScore() < object.getAttributes().getAwayScore()) {
                    GameResult gameResult = GameResult.LOOSE;
                    return new SoccerPregame(string5, string4, n2, n, (String)object2, string3, (GameResult)var0_7);
                }
                if (Intrinsics.areEqual((Object)var1_8, (Object)object.getAttributes().getAwayTeam()) && object.getAttributes().getAwayScore() > object.getAttributes().getHomeScore()) {
                    GameResult gameResult = GameResult.WIN;
                    return new SoccerPregame(string5, string4, n2, n, (String)object2, string3, (GameResult)var0_7);
                }
                if (Intrinsics.areEqual((Object)var1_8, (Object)object.getAttributes().getAwayTeam()) && object.getAttributes().getAwayScore() < object.getAttributes().getHomeScore()) {
                    GameResult gameResult = GameResult.LOOSE;
                    return new SoccerPregame(string5, string4, n2, n, (String)object2, string3, (GameResult)var0_7);
                }
                if (object.getAttributes().getHomeScore() == object.getAttributes().getAwayScore()) break block9;
            }
            Object var0_1 = null;
            return new SoccerPregame(string5, string4, n2, n, (String)object2, string3, (GameResult)var0_7);
        }
        GameResult gameResult = GameResult.DRAW;
        return new SoccerPregame(string5, string4, n2, n, (String)object2, string3, (GameResult)var0_7);
    }

    public static /* synthetic */ SoccerPregame toDomain$default(SoccerLastGame soccerLastGame, String string2, int n, Object object) {
        if ((n & 1) != 0) {
            string2 = null;
        }
        return ModelsKt.toDomain(soccerLastGame, string2);
    }

    @NotNull
    public static final SoccerPregameSummary toDomain(@NotNull SoccerLastGames object, @NotNull EventSummary object2) {
        ArrayList arrayList;
        ArrayList<SoccerPregame> arrayList2;
        ArrayList<SoccerPregame> arrayList3;
        Intrinsics.checkNotNullParameter((Object)object, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)object2, (String)"summary");
        Iterator iterator = object.getHomeList();
        Intrinsics.checkNotNullExpressionValue((Object)iterator, (String)"homeList");
        ArrayList<SoccerPregame> arrayList4 = arrayList3;
        arrayList3 = new ArrayList<SoccerPregame>(CollectionsKt.collectionSizeOrDefault((Iterable)((Object)iterator), (int)10));
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            SoccerLastGame soccerLastGame = (SoccerLastGame)iterator.next();
            Intrinsics.checkNotNullExpressionValue((Object)soccerLastGame, (String)"it");
            arrayList4.add(ModelsKt.toDomain(soccerLastGame, ((EventSummary)object2).getHomeTeam().getAlias()));
        }
        iterator = object.getAwayList();
        Intrinsics.checkNotNullExpressionValue((Object)iterator, (String)"awayList");
        ArrayList<SoccerPregame> arrayList5 = arrayList2;
        arrayList2 = new ArrayList<SoccerPregame>(CollectionsKt.collectionSizeOrDefault((Iterable)((Object)iterator), (int)10));
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            SoccerLastGame soccerLastGame = (SoccerLastGame)iterator.next();
            Intrinsics.checkNotNullExpressionValue((Object)soccerLastGame, (String)"it");
            arrayList5.add(ModelsKt.toDomain(soccerLastGame, ((EventSummary)object2).getAwayTeam().getAlias()));
        }
        object = object.getHeadToHeadList();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"headToHeadList");
        object2 = arrayList;
        arrayList = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)object, (int)10));
        object = object.iterator();
        while (object.hasNext()) {
            SoccerLastGame soccerLastGame = (SoccerLastGame)object.next();
            Intrinsics.checkNotNullExpressionValue((Object)soccerLastGame, (String)"it");
            object2.add(ModelsKt.toDomain$default(soccerLastGame, null, 1, null));
        }
        return new SoccerPregameSummary(arrayList4, arrayList5, (List<SoccerPregame>)object2);
    }

    @NotNull
    public static final SoccerTeamMember toDomain(@NotNull SoccerMatchPlayer object) {
        SoccerMatchPlayer soccerMatchPlayer = object;
        Intrinsics.checkNotNullParameter((Object)soccerMatchPlayer, (String)"<this>");
        object = soccerMatchPlayer.getLastName();
        String string2 = soccerMatchPlayer.getFirstName();
        int n = soccerMatchPlayer.getJersey();
        String string3 = soccerMatchPlayer.getDisplayName();
        String string4 = soccerMatchPlayer.getPhoto();
        String string5 = soccerMatchPlayer.getPosition();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"firstName");
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"lastName");
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"displayName");
        return new SoccerTeamMember(string2, (String)object, n, string3, string5, string4);
    }

    private static final ArrayMap<Integer, Set<SoccerTeamMember>> soccerTeamFieldPositions(SoccerMatchLineup soccerMatchLineup, List<SoccerTeamMember> list2, List<SoccerTeamMember> list3) {
        ArrayMap arrayMap;
        SoccerMatchLineup soccerMatchLineup2 = soccerMatchLineup;
        soccerMatchLineup = arrayMap;
        arrayMap = new ArrayMap();
        List list4 = soccerMatchLineup2.getFormationMatrixList();
        Intrinsics.checkNotNullExpressionValue((Object)list4, (String)"formationMatrixList");
        int n = 0;
        for (Object object : list4) {
            LinkedHashSet linkedHashSet;
            int n2 = n + 1;
            if (n < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            SoccerMatchFormationMatrix soccerMatchFormationMatrix = (SoccerMatchFormationMatrix)object;
            object = linkedHashSet;
            linkedHashSet = new LinkedHashSet();
            List list5 = soccerMatchFormationMatrix.getRowPlayersList();
            Intrinsics.checkNotNullExpressionValue((Object)list5, (String)"soccerMatchFormationMatrix.rowPlayersList");
            for (Object object2 : list5) {
                SoccerTeamMember soccerTeamMember;
                Object object3;
                String string2;
                block8: {
                    block7: {
                        for (Object t : list2) {
                            string2 = (String)t;
                            if (!(((SoccerTeamMember)t).getNumber() == object2.getJerseyNumber())) continue;
                            break block7;
                        }
                        string2 = null;
                    }
                    object3 = (SoccerTeamMember)((Object)string2);
                    if (object3 != null) {
                        object.add((Object)object3);
                        continue;
                    }
                    for (Object t : list3) {
                        string2 = (String)t;
                        if (!(((SoccerTeamMember)t).getNumber() == object2.getJerseyNumber())) continue;
                        break block8;
                    }
                    string2 = null;
                }
                object3 = (SoccerTeamMember)((Object)string2);
                if (object3 != null) {
                    object.add(object3);
                    continue;
                }
                SoccerMatchFormationMatrixPlayer soccerMatchFormationMatrixPlayer = object2;
                object2 = soccerMatchFormationMatrixPlayer.getPlayerName();
                object3 = soccerMatchFormationMatrixPlayer.getPlayerName();
                string2 = soccerMatchFormationMatrixPlayer.getPlayerName();
                int n3 = soccerMatchFormationMatrixPlayer.getJerseyNumber();
                String string3 = soccerMatchFormationMatrixPlayer.getPhoto();
                SoccerTeamMember soccerTeamMember2 = soccerTeamMember;
                Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"playerName");
                Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"playerName");
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"playerName");
                soccerTeamMember = new SoccerTeamMember((String)object3, (String)object2, n3, string2, null, string3, 16, null);
                object.add(soccerTeamMember2);
            }
            soccerMatchLineup.put(n, object);
            n = n2;
        }
        return soccerMatchLineup;
    }

    @NotNull
    public static final Pair<SoccerTeam, SoccerTeam> toDomainSoccerLineUp(@NotNull LineupResponse.ResponseData object) {
        SoccerTeam soccerTeam;
        SoccerTeam soccerTeam2;
        Object object22;
        ArrayList<SoccerTeamMember> arrayList;
        ArrayList<SoccerTeamMember> arrayList2;
        ArrayList<SoccerTeamMember> arrayList3;
        ArrayList<SoccerTeamMember> arrayList4;
        LineupResponse.ResponseData responseData = object;
        Intrinsics.checkNotNullParameter((Object)responseData, (String)"<this>");
        Object object3 = responseData.getAttributes().getSoccer().getHomeTeam();
        Object object4 = object.getAttributes().getSoccer().getAwayTeam();
        Iterator iterator = object3.getStartPlayersList();
        Intrinsics.checkNotNullExpressionValue((Object)iterator, (String)"homeTeam.startPlayersList");
        Object object5 = arrayList4;
        arrayList4 = new ArrayList<SoccerTeamMember>(CollectionsKt.collectionSizeOrDefault((Iterable)((Object)iterator), (int)10));
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            SoccerMatchPlayer soccerMatchPlayer = (SoccerMatchPlayer)iterator.next();
            Intrinsics.checkNotNullExpressionValue((Object)soccerMatchPlayer, (String)"it");
            object5.add(ModelsKt.toDomain(soccerMatchPlayer));
        }
        iterator = object3.getSubstitutesList();
        Intrinsics.checkNotNullExpressionValue((Object)iterator, (String)"homeTeam.substitutesList");
        ArrayList<SoccerTeamMember> arrayList5 = arrayList3;
        arrayList3 = new ArrayList<SoccerTeamMember>(CollectionsKt.collectionSizeOrDefault((Iterable)((Object)iterator), (int)10));
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            SoccerMatchPlayer soccerMatchPlayer = (SoccerMatchPlayer)iterator.next();
            Intrinsics.checkNotNullExpressionValue((Object)soccerMatchPlayer, (String)"it");
            arrayList5.add(ModelsKt.toDomain(soccerMatchPlayer));
        }
        iterator = object4.getStartPlayersList();
        Intrinsics.checkNotNullExpressionValue((Object)iterator, (String)"awayTeam.startPlayersList");
        ArrayList<SoccerTeamMember> arrayList6 = arrayList2;
        arrayList2 = new ArrayList<SoccerTeamMember>(CollectionsKt.collectionSizeOrDefault((Iterable)((Object)iterator), (int)10));
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            SoccerMatchPlayer soccerMatchPlayer = (SoccerMatchPlayer)iterator.next();
            Intrinsics.checkNotNullExpressionValue((Object)soccerMatchPlayer, (String)"it");
            arrayList6.add(ModelsKt.toDomain(soccerMatchPlayer));
        }
        iterator = object4.getSubstitutesList();
        Intrinsics.checkNotNullExpressionValue((Object)iterator, (String)"awayTeam.substitutesList");
        ArrayList<SoccerTeamMember> arrayList7 = arrayList;
        arrayList = new ArrayList<SoccerTeamMember>(CollectionsKt.collectionSizeOrDefault((Iterable)((Object)iterator), (int)10));
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            SoccerMatchPlayer soccerMatchPlayer = (SoccerMatchPlayer)iterator.next();
            Intrinsics.checkNotNullExpressionValue((Object)soccerMatchPlayer, (String)"it");
            arrayList7.add(ModelsKt.toDomain(soccerMatchPlayer));
        }
        Intrinsics.checkNotNullExpressionValue((Object)object4, (String)"awayTeam");
        iterator = ModelsKt.soccerTeamFieldPositions(object4, arrayList6, arrayList7);
        Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"homeTeam");
        ArrayMap<Integer, Set<SoccerTeamMember>> arrayMap = ModelsKt.soccerTeamFieldPositions(object3, object5, arrayList5);
        Object object6 = null;
        Object object7 = null;
        if (object.getAttributes().getSummary().getHomeTeam().getColorsList() != null && object.getAttributes().getSummary().getAwayTeam().getColorsList() != null) {
            block8: {
                block7: {
                    List list2 = object.getAttributes().getSummary().getHomeTeam().getColorsList();
                    Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"attributes.summary.homeTeam.colorsList");
                    for (Object t : list2) {
                        object7 = t;
                        object22 = (String)t;
                        if (!(object.getAttributes().getSummary().getAwayTeam().getColorsList().contains(object22) ^ true)) continue;
                        break block7;
                    }
                    object7 = null;
                }
                object6 = (String)object7;
                List list3 = object.getAttributes().getSummary().getAwayTeam().getColorsList();
                Intrinsics.checkNotNullExpressionValue((Object)list3, (String)"attributes.summary.awayTeam.colorsList");
                for (Object object22 : list3) {
                    String string2 = (String)object22;
                    if (!(object.getAttributes().getSummary().getHomeTeam().getColorsList().contains(string2) ^ true)) continue;
                    break block8;
                }
                object22 = null;
            }
            object7 = (String)object22;
        }
        LineupResponse.ResponseData responseData2 = object;
        SoccerMatchLineup soccerMatchLineup = object4;
        LineupResponse.ResponseData responseData3 = object;
        object = object.getAttributes().getSummary().getHomeTeam().getLogo();
        object3 = object3.getFormationString();
        object4 = responseData3.getAttributes().getSummary().getHomeTeam().getColorsList();
        object22 = soccerTeam2;
        soccerTeam2 = new SoccerTeam((String)object, (String)object3, arrayMap, (List<SoccerTeamMember>)object5, (List<SoccerTeamMember>)arrayList5, (List<String>)object4, (String)object6);
        object = responseData3.getAttributes().getSummary().getAwayTeam().getLogo();
        object3 = soccerMatchLineup.getFormationString();
        object4 = responseData2.getAttributes().getSummary().getAwayTeam().getColorsList();
        object5 = soccerTeam;
        soccerTeam = new SoccerTeam((String)object, (String)object3, (ArrayMap<Integer, Set<SoccerTeamMember>>)iterator, (List<SoccerTeamMember>)arrayList6, (List<SoccerTeamMember>)arrayList7, (List<String>)object4, (String)object7);
        return new Pair(object22, object5);
    }

    @NotNull
    public static final SoccerGameSummary toDomainSoccer(@NotNull SummaryResponse.ResponseData object) {
        ArrayList arrayList;
        SoccerGameStats soccerGameStats;
        SoccerGameStats soccerGameStats2;
        SoccerGameStats soccerGameStats3;
        SoccerGameStats soccerGameStats4;
        SoccerGameStats soccerGameStats5;
        SoccerGameStats soccerGameStats6;
        SoccerGameStats soccerGameStats7;
        SoccerGameStats soccerGameStats8;
        SoccerGameStats soccerGameStats9;
        SoccerGameStats soccerGameStats10;
        SoccerGameStats soccerGameStats11;
        SoccerGameStats soccerGameStats12;
        SoccerGameStats soccerGameStats13;
        SoccerGameStats soccerGameStats14;
        SoccerGameStats soccerGameStats15;
        SoccerGameStats soccerGameStats16;
        SoccerGameStats soccerGameStats17;
        SoccerGameStats soccerGameStats18;
        ArrayList arrayList2;
        SoccerGame soccerGame;
        SummaryResponse.ResponseData responseData = object;
        Intrinsics.checkNotNullParameter((Object)responseData, (String)"<this>");
        com.streamlayer.sports.common.EventSummary eventSummary2 = responseData.getAttributes().getSummary();
        object = eventSummary2.getHomeTeam().getAlias();
        ArrayList arrayList3 = eventSummary2.getHomeTeam().getLogo();
        Object object2 = eventSummary2.getAwayTeam().getAlias();
        Object object3 = eventSummary2.getAwayTeam().getLogo();
        int n = eventSummary2.getScoreHome();
        int n2 = eventSummary2.getScoreAway();
        String string2 = eventSummary2.getEventTime().getClock();
        Object object4 = eventSummary2.getAwayTeam().getColorsList();
        Object object5 = eventSummary2.getHomeTeam().getColorsList();
        SoccerGame soccerGame2 = soccerGame;
        soccerGame = new SoccerGame((String)((Object)arrayList3), (String)object3, (String)object, (String)object2, n, n2, string2, (List<String>)object5, (List<String>)object4);
        object = responseData.getAttributes().getSoccer().getStatistics();
        arrayList3 = arrayList2;
        Object object6 = object;
        arrayList3();
        object = object6.getHomeStatistics().getTopMatchStats();
        object2 = object6.getAwayStatistics().getTopMatchStats();
        object3 = object6.getHomeStatistics().getAttackingStats();
        Object object7 = object6.getAwayStatistics().getAttackingStats();
        Object object8 = object6.getHomeStatistics().getDefenseStats();
        string2 = object6.getAwayStatistics().getDefenseStats();
        Object[] objectArray = new SoccerGameStats[9];
        object4 = soccerGameStats18;
        object5 = object.getPossession();
        Number number = object2.getPossession();
        soccerGameStats18 = new SoccerGameStats("Possession", (Number)object5, number);
        objectArray[0] = object4;
        object4 = soccerGameStats17;
        object5 = object.getShots();
        number = object2.getShots();
        soccerGameStats17 = new SoccerGameStats("Shots", (Number)object5, number);
        objectArray[1] = object4;
        object4 = soccerGameStats16;
        object5 = object.getShotsOnTarget();
        number = object2.getShotsOnTarget();
        soccerGameStats16 = new SoccerGameStats("Shots on target", (Number)object5, number);
        objectArray[2] = object4;
        object4 = soccerGameStats15;
        object5 = object.getPasses();
        number = object2.getPasses();
        soccerGameStats15 = new SoccerGameStats("Passes", (Number)object5, number);
        objectArray[3] = object4;
        object4 = soccerGameStats14;
        object5 = object.getOffsides();
        number = object2.getOffsides();
        soccerGameStats14 = new SoccerGameStats("Offsides", (Number)object5, number);
        objectArray[4] = object4;
        object4 = soccerGameStats13;
        object5 = object.getYellowCards();
        number = object2.getYellowCards();
        soccerGameStats13 = new SoccerGameStats("Yellow cards", (Number)object5, number);
        objectArray[5] = object4;
        object4 = soccerGameStats12;
        object5 = object.getRedCards();
        number = object2.getRedCards();
        soccerGameStats12 = new SoccerGameStats("Red cards", (Number)object5, number);
        objectArray[6] = object4;
        object4 = soccerGameStats11;
        object5 = object.getCornerKicks();
        number = object2.getCornerKicks();
        soccerGameStats11 = new SoccerGameStats("Corner kicks", (Number)object5, number);
        objectArray[7] = object4;
        object4 = soccerGameStats10;
        object = object.getFreeKicks();
        object2 = object2.getFreeKicks();
        soccerGameStats10 = new SoccerGameStats("Free kicks", (Number)object, (Number)object2);
        objectArray[8] = object4;
        arrayList2.add(new SoccerGameStatsGroup("Top Match Stats", CollectionsKt.listOf((Object[])objectArray)));
        Object[] objectArray2 = new SoccerGameStats[4];
        object = soccerGameStats9;
        object2 = object3.getPossession();
        object4 = object7.getPossession();
        soccerGameStats9 = new SoccerGameStats("Possession", (Number)object2, (Number)object4);
        objectArray2[0] = object;
        object = soccerGameStats8;
        object2 = object3.getPassingAccuracy();
        object4 = object7.getPassingAccuracy();
        soccerGameStats8 = new SoccerGameStats("Passing accuracy", (Number)object2, (Number)object4);
        objectArray2[1] = object;
        object = soccerGameStats7;
        object2 = object3.getChancesCreated();
        object4 = object7.getChancesCreated();
        soccerGameStats7 = new SoccerGameStats("Chances created", (Number)object2, (Number)object4);
        objectArray2[2] = object;
        object = soccerGameStats6;
        object2 = object3.getSuccessfulCrosses();
        object3 = object7.getSuccessfulCrosses();
        soccerGameStats6 = new SoccerGameStats("Successful crosses", (Number)object2, (Number)object3);
        objectArray2[3] = object;
        arrayList2.add(new SoccerGameStatsGroup("Attacking stats", CollectionsKt.listOf((Object[])objectArray2)));
        Object[] objectArray3 = new SoccerGameStats[5];
        object = soccerGameStats5;
        object2 = object8.getTacklesMade();
        object3 = string2.getTacklesMade();
        soccerGameStats5 = new SoccerGameStats("Tackles made", (Number)object2, (Number)object3);
        objectArray3[0] = object;
        object = soccerGameStats4;
        object2 = object8.getInterceptions();
        object3 = string2.getInterceptions();
        soccerGameStats4 = new SoccerGameStats("Interceptions", (Number)object2, (Number)object3);
        objectArray3[1] = object;
        object = soccerGameStats3;
        object2 = object8.getBlockedShots();
        object3 = string2.getBlockedShots();
        soccerGameStats3 = new SoccerGameStats("Blocked shots", (Number)object2, (Number)object3);
        objectArray3[2] = object;
        object = soccerGameStats2;
        object2 = object8.getClearances();
        object3 = string2.getClearances();
        soccerGameStats2 = new SoccerGameStats("Clearances", (Number)object2, (Number)object3);
        objectArray3[3] = object;
        object = soccerGameStats;
        object2 = object8.getDuelsWon();
        object3 = string2.getDuelsWon();
        soccerGameStats = new SoccerGameStats("Duels won", (Number)object2, (Number)object3);
        objectArray3[4] = object;
        arrayList2.add(new SoccerGameStatsGroup("Defence stats", CollectionsKt.listOf((Object[])objectArray3)));
        SoccerPerformers soccerPerformers = responseData.getAttributes().getSoccer().getStatistics().getPerfomers();
        object = soccerPerformers.getAttackPerformer();
        object2 = soccerPerformers.getMidfieldPerformer();
        object3 = soccerPerformers.getDefensePerformer();
        object7 = arrayList;
        arrayList = new ArrayList();
        if (object.hasPerfomer()) {
            SoccerGamePlayerStats soccerGamePlayerStats;
            SoccerGamePlayerStats soccerGamePlayerStats2;
            SoccerGamePlayerStats soccerGamePlayerStats3;
            SoccerGamePlayerStats soccerGamePlayerStats4;
            SoccerGamePlayerStats soccerGamePlayerStats5;
            String string3 = object.getPerfomer().getPhoto();
            String string4 = object.getPerfomer().getName();
            Object[] objectArray4 = new SoccerGamePlayerStats[5];
            object8 = soccerGamePlayerStats5;
            soccerGamePlayerStats5 = new SoccerGamePlayerStats("G", object.getAttackStats().getGoals());
            objectArray4[0] = object8;
            object8 = soccerGamePlayerStats4;
            soccerGamePlayerStats4 = new SoccerGamePlayerStats("A", object.getAttackStats().getAssists());
            objectArray4[1] = object8;
            object8 = soccerGamePlayerStats3;
            soccerGamePlayerStats3 = new SoccerGamePlayerStats("SH", object.getAttackStats().getShots());
            objectArray4[2] = object8;
            object8 = soccerGamePlayerStats2;
            soccerGamePlayerStats2 = new SoccerGamePlayerStats("PKG", object.getAttackStats().getPenaltyKickGoals());
            objectArray4[3] = object8;
            object8 = soccerGamePlayerStats;
            soccerGamePlayerStats = new SoccerGamePlayerStats("SHG", object.getAttackStats().getShotsOnGoal());
            objectArray4[4] = object8;
            object = CollectionsKt.listOf((Object[])objectArray4);
            object7.add(new SoccerGameTopPlayerStats(string3, "Attack", string4, null, (List<SoccerGamePlayerStats>)object));
        }
        if (object2.hasPerfomer()) {
            SoccerGamePlayerStats soccerGamePlayerStats;
            SoccerGamePlayerStats soccerGamePlayerStats6;
            SoccerGamePlayerStats soccerGamePlayerStats7;
            SoccerGamePlayerStats soccerGamePlayerStats8;
            SoccerGamePlayerStats soccerGamePlayerStats9;
            Object[] objectArray5 = new SoccerGamePlayerStats[5];
            object = soccerGamePlayerStats9;
            soccerGamePlayerStats9 = new SoccerGamePlayerStats("G", object2.getMidfieldStats().getGoals());
            objectArray5[0] = object;
            object = soccerGamePlayerStats8;
            soccerGamePlayerStats8 = new SoccerGamePlayerStats("A", object2.getMidfieldStats().getAssists());
            objectArray5[1] = object;
            object = soccerGamePlayerStats7;
            soccerGamePlayerStats7 = new SoccerGamePlayerStats("KEY", object2.getMidfieldStats().getKeyPasses());
            objectArray5[2] = object;
            object = soccerGamePlayerStats6;
            soccerGamePlayerStats6 = new SoccerGamePlayerStats("CRS", object2.getMidfieldStats().getCrosses());
            objectArray5[3] = object;
            object = soccerGamePlayerStats;
            soccerGamePlayerStats = new SoccerGamePlayerStats("COR", object2.getMidfieldStats().getCorners());
            objectArray5[4] = object;
            object = CollectionsKt.listOf((Object[])objectArray5);
            object7.add(new SoccerGameTopPlayerStats(object2.getPerfomer().getPhoto(), "Midfield", object2.getPerfomer().getName(), null, (List<SoccerGamePlayerStats>)object));
        }
        if (object3.hasPerfomer()) {
            SoccerGamePlayerStats soccerGamePlayerStats;
            SoccerGamePlayerStats soccerGamePlayerStats10;
            SoccerGamePlayerStats soccerGamePlayerStats11;
            SoccerGamePlayerStats soccerGamePlayerStats12;
            SoccerGamePlayerStats soccerGamePlayerStats13;
            Object[] objectArray6 = new SoccerGamePlayerStats[5];
            object = soccerGamePlayerStats13;
            soccerGamePlayerStats13 = new SoccerGamePlayerStats("G", object3.getDefenseStats().getGoals());
            objectArray6[0] = object;
            object = soccerGamePlayerStats12;
            soccerGamePlayerStats12 = new SoccerGamePlayerStats("A", object3.getDefenseStats().getAssists());
            objectArray6[1] = object;
            object = soccerGamePlayerStats11;
            soccerGamePlayerStats11 = new SoccerGamePlayerStats("TCK", object3.getDefenseStats().getTacklesMade());
            objectArray6[2] = object;
            object = soccerGamePlayerStats10;
            soccerGamePlayerStats10 = new SoccerGamePlayerStats("INT", object3.getDefenseStats().getInterceptions());
            objectArray6[3] = object;
            object = soccerGamePlayerStats;
            soccerGamePlayerStats = new SoccerGamePlayerStats("BLK", object3.getDefenseStats().getBlockedShots());
            objectArray6[4] = object;
            object = CollectionsKt.listOf((Object[])objectArray6);
            object7.add(new SoccerGameTopPlayerStats(object3.getPerfomer().getPhoto(), "Defense", object3.getPerfomer().getName(), null, (List<SoccerGamePlayerStats>)object));
        }
        return new SoccerGameSummary(soccerGame2, arrayList3, (List)object7, null, 8, null);
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[SoccerMatchActivityType.values().length];
            int[] nArray2 = nArray;
            try {
                nArray[SoccerMatchActivityType.SOCCER_MATCH_ACTIVITY_GOAL.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray2[SoccerMatchActivityType.SOCCER_MATCH_ACTIVITY_YELLOW_CARD.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray2[SoccerMatchActivityType.SOCCER_MATCH_ACTIVITY_RED_CARD.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray2[SoccerMatchActivityType.SOCCER_MATCH_ACTIVITY_SUBSTITUTION.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray2[SoccerMatchActivityType.SOCCER_MATCH_ACTIVITY_HALF_TIME.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray2[SoccerMatchActivityType.SOCCER_MATCH_ACTIVITY_FULL_TIME.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray2[SoccerMatchActivityType.SOCCER_MATCH_ACTIVITY_UNSET.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray2[SoccerMatchActivityType.UNRECOGNIZED.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            $EnumSwitchMapping$0 = nArray2;
        }
    }
}

