/*
 * Decompiled with CFR 0.152.
 */
package io.streamlayer.sdk.twitter.view.internal.media;

import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.graphics.Matrix;
import android.graphics.RectF;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.ScaleGestureDetector;
import android.view.animation.AccelerateDecelerateInterpolator;
import android.widget.ImageView;
import androidx.appcompat.widget.AppCompatImageView;

public class MultiTouchImageView
extends AppCompatImageView {
    private static final long SCALE_ANIMATION_DURATION = 300L;
    private static final float DOUBLE_TAP_SCALE_FACTOR = 2.0f;
    private static final float MINIMUM_SCALE_FACTOR = 1.0f;
    final ScaleGestureDetector scaleGestureDetector;
    final GestureDetector gestureDetector;
    final Matrix drawMatrix = new Matrix();
    final Matrix baseMatrix = new Matrix();
    final Matrix updateMatrix = new Matrix();
    final RectF viewRect = new RectF();
    final RectF drawRect = new RectF();
    final float[] matrixValues = new float[9];
    boolean allowIntercept;

    public MultiTouchImageView(Context context) {
        this(context, null);
    }

    public MultiTouchImageView(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, 0);
    }

    public MultiTouchImageView(Context object, AttributeSet object2, int n) {
        super(object, object2, n);
        GestureDetector.SimpleOnGestureListener simpleOnGestureListener;
        ScaleGestureDetector.SimpleOnScaleGestureListener simpleOnScaleGestureListener;
        object2 = simpleOnScaleGestureListener;
        simpleOnScaleGestureListener = new ScaleGestureDetector.SimpleOnScaleGestureListener(){

            public boolean onScale(ScaleGestureDetector scaleGestureDetector) {
                1 v0 = this;
                ScaleGestureDetector scaleGestureDetector2 = scaleGestureDetector;
                float f = scaleGestureDetector2.getScaleFactor();
                float f2 = scaleGestureDetector2.getFocusX();
                float f3 = scaleGestureDetector2.getFocusY();
                v0.MultiTouchImageView.this.setScale(f, f2, f3);
                v0.MultiTouchImageView.this.setImageMatrix();
                return true;
            }

            public void onScaleEnd(ScaleGestureDetector scaleGestureDetector) {
                if (MultiTouchImageView.this.getScale() < 1.0f) {
                    1 v0 = this;
                    v0.MultiTouchImageView.this.reset();
                    v0.MultiTouchImageView.this.setImageMatrix();
                }
            }
        };
        this.scaleGestureDetector = new ScaleGestureDetector(object, (ScaleGestureDetector.OnScaleGestureListener)object2);
        Context context = object;
        object = simpleOnGestureListener;
        simpleOnGestureListener = new GestureDetector.SimpleOnGestureListener(){

            public boolean onScroll(MotionEvent motionEvent, MotionEvent motionEvent2, float f, float f2) {
                2 v0 = this;
                float f3 = -f;
                v0.MultiTouchImageView.this.setTranslate(f3, -f2);
                v0.MultiTouchImageView.this.setImageMatrix();
                MultiTouchImageView multiTouchImageView = v0.MultiTouchImageView.this;
                if (multiTouchImageView.allowIntercept && !multiTouchImageView.scaleGestureDetector.isInProgress()) {
                    MultiTouchImageView.this.requestDisallowInterceptTouchEvent(false);
                }
                return true;
            }

            public boolean onDoubleTap(MotionEvent motionEvent) {
                Object object;
                if (object.MultiTouchImageView.this.getScale() > 1.0f) {
                    object = object.MultiTouchImageView.this;
                    MotionEvent motionEvent2 = motionEvent;
                    float f = ((MultiTouchImageView)((Object)object)).getScale();
                    float f2 = motionEvent2.getX();
                    float f3 = motionEvent2.getY();
                    ((MultiTouchImageView)((Object)object)).animateScale(f, 1.0f, f2, f3);
                } else {
                    object = object.MultiTouchImageView.this;
                    MotionEvent motionEvent3 = motionEvent;
                    float f = ((MultiTouchImageView)((Object)object)).getScale();
                    float f4 = motionEvent3.getX();
                    float f5 = motionEvent3.getY();
                    ((MultiTouchImageView)((Object)object)).animateScale(f, 2.0f, f4, f5);
                }
                return true;
            }
        };
        this.gestureDetector = new GestureDetector(context, (GestureDetector.OnGestureListener)object);
    }

    boolean isInitializationComplete() {
        return (this = this.getDrawable()) != null && this.getIntrinsicWidth() > 0;
    }

    protected void onLayout(boolean bl, int n, int n2, int n3, int n4) {
        MultiTouchImageView multiTouchImageView = this;
        super.onLayout(bl, n, n2, n3, n4);
        if (multiTouchImageView.isInitializationComplete()) {
            MultiTouchImageView multiTouchImageView2 = this;
            multiTouchImageView2.initializeViewRect();
            multiTouchImageView2.initializeBaseMatrix(multiTouchImageView2.getDrawable());
            multiTouchImageView2.setImageMatrix();
        }
    }

    void initializeViewRect() {
        MultiTouchImageView multiTouchImageView = this;
        float f = multiTouchImageView.getPaddingTop();
        float f2 = multiTouchImageView.getWidth() - this.getPaddingRight();
        float f3 = multiTouchImageView.getHeight() - this.getPaddingBottom();
        this.viewRect.set((float)this.getPaddingLeft(), f, f2, f3);
    }

    void initializeBaseMatrix(Drawable drawable2) {
        RectF rectF;
        MultiTouchImageView multiTouchImageView = this;
        Drawable drawable3 = drawable2;
        int n = drawable3.getIntrinsicWidth();
        int n2 = drawable3.getIntrinsicHeight();
        RectF rectF2 = rectF;
        float f = n;
        float f2 = n2;
        rectF = new RectF(0.0f, 0.0f, f, f2);
        multiTouchImageView.baseMatrix.reset();
        multiTouchImageView.baseMatrix.setRectToRect(rectF2, this.viewRect, Matrix.ScaleToFit.CENTER);
    }

    public boolean onTouchEvent(MotionEvent motionEvent) {
        if (!this.isInitializationComplete()) {
            return false;
        }
        MultiTouchImageView multiTouchImageView = this;
        multiTouchImageView.requestDisallowInterceptTouchEvent(true);
        boolean bl = multiTouchImageView.scaleGestureDetector.onTouchEvent(motionEvent);
        boolean bl2 = multiTouchImageView.gestureDetector.onTouchEvent(motionEvent) || bl;
        return bl2 || super.onTouchEvent(motionEvent);
    }

    void requestDisallowInterceptTouchEvent(boolean bl) {
        if ((this = this.getParent()) != null) {
            this.requestDisallowInterceptTouchEvent(bl);
        }
    }

    void setScale(float f, float f2, float f3) {
        float f4 = f;
        this.updateMatrix.postScale(f4, f4, f2, f3);
    }

    float getScale() {
        MultiTouchImageView multiTouchImageView = this;
        multiTouchImageView.updateMatrix.getValues(this.matrixValues);
        return multiTouchImageView.matrixValues[0];
    }

    void setTranslate(float f, float f2) {
        this.updateMatrix.postTranslate(f, f2);
    }

    void reset() {
        this.updateMatrix.reset();
    }

    void updateMatrixBounds() {
        float f;
        RectF rectF;
        MultiTouchImageView multiTouchImageView = this;
        RectF rectF2 = multiTouchImageView.getDrawRect(multiTouchImageView.getDrawMatrix());
        float f2 = 0.0f;
        float f3 = 0.0f;
        if (rectF.height() <= this.viewRect.height()) {
            f2 = (this.viewRect.height() - rectF2.height()) / 2.0f - rectF2.top;
        } else {
            float f4;
            f = rectF2.top;
            if (f4 > 0.0f) {
                f2 = -f;
            } else if (rectF2.bottom < this.viewRect.height()) {
                f2 = this.viewRect.height() - rectF2.bottom;
            }
        }
        if (rectF2.width() <= this.viewRect.width()) {
            this.allowIntercept = true;
            f3 = (this.viewRect.width() - rectF2.width()) / 2.0f - rectF2.left;
        } else {
            float f5;
            f = rectF2.left;
            if (f5 > 0.0f) {
                this.allowIntercept = true;
                f3 = -f;
            } else if (rectF2.right < this.viewRect.width()) {
                this.allowIntercept = true;
                f3 = this.viewRect.width() - rectF2.right;
            } else {
                this.allowIntercept = false;
            }
        }
        this.setTranslate(f3, f2);
    }

    RectF getDrawRect(Matrix matrix) {
        Drawable drawable2 = this.getDrawable();
        if (drawable2 != null) {
            MultiTouchImageView multiTouchImageView = this;
            Drawable drawable3 = drawable2;
            float f = drawable3.getIntrinsicWidth();
            float f2 = drawable3.getIntrinsicHeight();
            multiTouchImageView.drawRect.set(0.0f, 0.0f, f, f2);
            matrix.mapRect(multiTouchImageView.drawRect);
        }
        return this.drawRect;
    }

    Matrix getDrawMatrix() {
        MultiTouchImageView multiTouchImageView = this;
        multiTouchImageView.drawMatrix.set(this.baseMatrix);
        multiTouchImageView.drawMatrix.postConcat(this.updateMatrix);
        return multiTouchImageView.drawMatrix;
    }

    void setImageMatrix() {
        MultiTouchImageView multiTouchImageView = this;
        multiTouchImageView.updateMatrixBounds();
        multiTouchImageView.setScaleType(ImageView.ScaleType.MATRIX);
        multiTouchImageView.setImageMatrix(multiTouchImageView.getDrawMatrix());
    }

    void animateScale(float f, float f2, float f3, float f4) {
        ValueAnimator valueAnimator2;
        ValueAnimator valueAnimator3 = valueAnimator2 = ValueAnimator.ofFloat((float[])new float[]{f, f2});
        valueAnimator3.setDuration(300L);
        valueAnimator3.setInterpolator((TimeInterpolator)new AccelerateDecelerateInterpolator());
        valueAnimator2.addUpdateListener(valueAnimator -> {
            MultiTouchImageView multiTouchImageView = this;
            multiTouchImageView.setScale(((Float)valueAnimator.getAnimatedValue()).floatValue() / this.getScale(), f3, f4);
            multiTouchImageView.setImageMatrix();
        });
        valueAnimator2.start();
    }
}

