/*
 * Decompiled with CFR 0.152.
 */
package org.apache.distributedlog.fs;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.InputStream;
import org.apache.distributedlog.LogRecordWithDLSN;
import org.apache.distributedlog.api.DistributedLogManager;
import org.apache.distributedlog.api.LogReader;
import org.apache.hadoop.fs.FSInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DLInputStream
extends FSInputStream {
    private static final Logger log = LoggerFactory.getLogger(DLInputStream.class);
    private static final long REOPEN_READER_SKIP_BYTES = 0x400000L;
    private final DistributedLogManager dlm;
    private LogReader reader;
    private long pos;
    private long lastPos;
    private RecordStream currentRecord = null;

    private static RecordStream nextRecordStream(LogReader reader) throws IOException {
        LogRecordWithDLSN record = reader.readNext(false);
        if (null != record) {
            return new RecordStream(record);
        }
        return null;
    }

    DLInputStream(DistributedLogManager dlm, LogReader reader, long startPos) throws IOException {
        this.dlm = dlm;
        this.reader = reader;
        this.pos = startPos;
        this.lastPos = this.readEndPos();
        this.seek(startPos);
    }

    public void close() throws IOException {
        this.reader.close();
        this.dlm.close();
    }

    private long readEndPos() throws IOException {
        return this.dlm.getLastTxId();
    }

    public void seek(long pos) throws IOException {
        if (this.pos == pos) {
            return;
        }
        if (this.pos > pos || pos - this.pos >= 0x400000L) {
            this.reader.close();
            this.reader = this.dlm.openLogReader(pos);
            this.currentRecord = null;
        }
        this.skipTo(pos);
    }

    private boolean skipTo(long position) throws IOException {
        long endPos;
        while (true) {
            if (null == this.currentRecord) {
                this.currentRecord = DLInputStream.nextRecordStream(this.reader);
            }
            if (null == this.currentRecord) {
                return false;
            }
            endPos = this.currentRecord.record.getTransactionId();
            if (endPos >= position) break;
            this.currentRecord = DLInputStream.nextRecordStream(this.reader);
            this.pos = endPos;
        }
        if (endPos == position) {
            this.pos = position;
            this.currentRecord = null;
            return true;
        }
        this.currentRecord.payloadStream.skip((long)this.currentRecord.payloadStream.available() - (endPos - position));
        this.pos = position;
        return true;
    }

    public long getPos() throws IOException {
        return this.pos;
    }

    public boolean seekToNewSource(long targetPos) throws IOException {
        return false;
    }

    public int read(byte[] b, int off, int len) throws IOException {
        int remaining = len;
        int numBytesRead = 0;
        while (remaining > 0) {
            if (null == this.currentRecord) {
                this.currentRecord = DLInputStream.nextRecordStream(this.reader);
            }
            if (null == this.currentRecord) {
                if (numBytesRead != 0) break;
                return -1;
            }
            int bytesLeft = this.currentRecord.payloadStream.available();
            if (bytesLeft <= 0) {
                this.currentRecord.payloadStream.close();
                this.currentRecord = null;
                continue;
            }
            int numBytesToRead = Math.min(bytesLeft, remaining);
            int numBytes = this.currentRecord.payloadStream.read(b, off + numBytesRead, numBytesToRead);
            if (numBytes < 0) continue;
            numBytesRead += numBytes;
            remaining -= numBytes;
        }
        return numBytesRead;
    }

    public long skip(long n) throws IOException {
        long endPos;
        int bytesLeft;
        if (n <= 0L) {
            return 0L;
        }
        long remaining = n;
        while (true) {
            if (null == this.currentRecord) {
                this.currentRecord = DLInputStream.nextRecordStream(this.reader);
            }
            if (null == this.currentRecord) {
                return n - remaining;
            }
            bytesLeft = this.currentRecord.payloadStream.available();
            endPos = this.currentRecord.record.getTransactionId();
            if (remaining <= (long)bytesLeft) break;
            remaining -= (long)bytesLeft;
            this.pos = endPos;
            this.currentRecord = DLInputStream.nextRecordStream(this.reader);
        }
        if (remaining == (long)bytesLeft) {
            this.pos = endPos;
            this.currentRecord = null;
            return n;
        }
        this.currentRecord.payloadStream.skip(remaining);
        this.pos = endPos - (long)this.currentRecord.payloadStream.available();
        return n;
    }

    public int available() throws IOException {
        if (this.lastPos - this.pos == 0L) {
            this.lastPos = this.readEndPos();
        }
        return (int)(this.lastPos - this.pos);
    }

    public boolean markSupported() {
        return false;
    }

    public int read() throws IOException {
        byte[] data = new byte[1];
        int numBytes = this.read(data);
        if (numBytes <= 0) {
            return -1;
        }
        return data[0];
    }

    private static class RecordStream {
        private final InputStream payloadStream;
        private final LogRecordWithDLSN record;

        RecordStream(LogRecordWithDLSN record) {
            Preconditions.checkNotNull((Object)record);
            this.record = record;
            this.payloadStream = record.getPayLoadInputStream();
        }
    }
}

