/*
 * Decompiled with CFR 0.152.
 */
package org.apache.distributedlog.fs;

import com.google.common.collect.Lists;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.distributedlog.DLSN;
import org.apache.distributedlog.DistributedLogConfiguration;
import org.apache.distributedlog.api.AsyncLogWriter;
import org.apache.distributedlog.api.DistributedLogManager;
import org.apache.distributedlog.api.LogReader;
import org.apache.distributedlog.api.namespace.Namespace;
import org.apache.distributedlog.api.namespace.NamespaceBuilder;
import org.apache.distributedlog.exceptions.DLInterruptedException;
import org.apache.distributedlog.exceptions.LogEmptyException;
import org.apache.distributedlog.exceptions.LogNotFoundException;
import org.apache.distributedlog.fs.DLInputStream;
import org.apache.distributedlog.fs.DLOutputStream;
import org.apache.distributedlog.util.Utils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.BufferedFSInputStream;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FSInputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.util.Progressable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DLFileSystem
extends FileSystem {
    private static final Logger log = LoggerFactory.getLogger(DLFileSystem.class);
    public static final String DLFS_CONF_FILE = "dlog.configuration.file";
    private URI rootUri;
    private Namespace namespace;
    private final DistributedLogConfiguration dlConf = new DistributedLogConfiguration();
    private Path workingDir;

    public DLFileSystem() {
        this.setWorkingDirectory(new Path(System.getProperty("user.dir", "")));
    }

    public URI getUri() {
        return this.rootUri;
    }

    public void initialize(URI name, Configuration conf) throws IOException {
        super.initialize(name, conf);
        this.setConf(conf);
        this.rootUri = name;
        String dlConfLocation = conf.get(DLFS_CONF_FILE);
        if (null != dlConfLocation) {
            try {
                this.dlConf.loadConf(new File(dlConfLocation).toURI().toURL());
                log.info("Loaded the distributedlog configuration from {}", (Object)dlConfLocation);
            }
            catch (ConfigurationException e) {
                log.error("Failed to load the distributedlog configuration from " + dlConfLocation, (Throwable)e);
                throw new IOException("Failed to load distributedlog configuration from " + dlConfLocation);
            }
        }
        log.info("Initializing the filesystem at {}", (Object)name);
        this.namespace = NamespaceBuilder.newBuilder().clientId("dlfs-client-" + InetAddress.getLocalHost().getHostName()).conf(this.dlConf).regionId(0).uri(name).build();
        log.info("Initialized the filesystem at {}", (Object)name);
    }

    public void close() throws IOException {
        this.namespace.close();
        super.close();
    }

    private Path makeAbsolute(Path f) {
        if (f.isAbsolute()) {
            return f;
        }
        return new Path(this.workingDir, f);
    }

    private String getStreamName(Path relativePath) {
        return this.makeAbsolute(relativePath).toUri().getPath().substring(1);
    }

    public Path getHomeDirectory() {
        return this.makeQualified(new Path(System.getProperty("user.home", "")));
    }

    protected Path getInitialWorkingDirectory() {
        return this.makeQualified(new Path(System.getProperty("user.dir", "")));
    }

    public void setWorkingDirectory(Path path) {
        this.workingDir = this.makeAbsolute(path);
        this.checkPath(this.workingDir);
    }

    public Path getWorkingDirectory() {
        return this.workingDir;
    }

    public FSDataInputStream open(Path path, int bufferSize) throws IOException {
        try {
            LogReader reader;
            DistributedLogManager dlm = this.namespace.openLog(this.getStreamName(path));
            try {
                reader = dlm.openLogReader(DLSN.InitialDLSN);
            }
            catch (LogNotFoundException lnfe) {
                throw new FileNotFoundException(path.toString());
            }
            catch (LogEmptyException lee) {
                throw new FileNotFoundException(path.toString());
            }
            return new FSDataInputStream((InputStream)new BufferedFSInputStream((FSInputStream)new DLInputStream(dlm, reader, 0L), bufferSize));
        }
        catch (LogNotFoundException e) {
            throw new FileNotFoundException(path.toString());
        }
    }

    public FSDataOutputStream create(Path path, FsPermission fsPermission, boolean overwrite, int bufferSize, short replication, long blockSize, Progressable progressable) throws IOException {
        if (overwrite) {
            this.delete(path, false);
        }
        DistributedLogConfiguration confLocal = new DistributedLogConfiguration();
        confLocal.addConfiguration((org.apache.commons.configuration.Configuration)this.dlConf);
        confLocal.setEnsembleSize((int)replication);
        confLocal.setWriteQuorumSize((int)replication);
        confLocal.setAckQuorumSize((int)replication);
        confLocal.setMaxLogSegmentBytes(blockSize);
        return this.append(path, bufferSize, Optional.of(confLocal));
    }

    public FSDataOutputStream append(Path path, int bufferSize, Progressable progressable) throws IOException {
        return this.append(path, bufferSize, Optional.empty());
    }

    private FSDataOutputStream append(Path path, int bufferSize, Optional<DistributedLogConfiguration> confLocal) throws IOException {
        try {
            DistributedLogManager dlm = this.namespace.openLog(this.getStreamName(path), confLocal, Optional.empty(), Optional.empty());
            AsyncLogWriter writer = (AsyncLogWriter)Utils.ioResult((CompletableFuture)dlm.openAsyncLogWriter());
            return new FSDataOutputStream((OutputStream)new BufferedOutputStream(new DLOutputStream(dlm, writer), bufferSize), this.statistics, writer.getLastTxId() < 0L ? 0L : writer.getLastTxId());
        }
        catch (LogNotFoundException le) {
            throw new FileNotFoundException(path.toString());
        }
    }

    public boolean delete(Path path, boolean recursive) throws IOException {
        try {
            String logName = this.getStreamName(path);
            if (recursive) {
                Iterator logs = this.namespace.getLogs(logName);
                while (logs.hasNext()) {
                    String child = (String)logs.next();
                    Path childPath = new Path(path, child);
                    this.delete(childPath, recursive);
                }
            }
            this.namespace.deleteLog(logName);
            return true;
        }
        catch (LogNotFoundException e) {
            return true;
        }
    }

    public FileStatus[] listStatus(Path path) throws FileNotFoundException, IOException {
        String logName = this.getStreamName(path);
        try {
            Iterator logs = this.namespace.getLogs(logName);
            ArrayList statusList = Lists.newArrayList();
            while (logs.hasNext()) {
                String child = (String)logs.next();
                Path childPath = new Path(path, child);
                statusList.add(this.getFileStatus(childPath));
            }
            Collections.sort(statusList, Comparator.comparing(fileStatus -> fileStatus.getPath().getName()));
            return statusList.toArray(new FileStatus[statusList.size()]);
        }
        catch (LogNotFoundException e) {
            throw new FileNotFoundException(path.toString());
        }
    }

    public boolean mkdirs(Path path, FsPermission fsPermission) throws IOException {
        String streamName = this.getStreamName(path);
        this.namespace.createLog(streamName);
        return true;
    }

    public FileStatus getFileStatus(Path path) throws IOException {
        long endPos;
        String logName = this.getStreamName(path);
        boolean exists = this.namespace.logExists(logName);
        if (!exists) {
            throw new FileNotFoundException(path.toString());
        }
        try {
            DistributedLogManager dlm = this.namespace.openLog(logName);
            endPos = dlm.getLastTxId();
        }
        catch (LogNotFoundException e) {
            throw new FileNotFoundException(path.toString());
        }
        catch (LogEmptyException e) {
            endPos = 0L;
        }
        return new FileStatus(endPos, false, 3, this.dlConf.getMaxLogSegmentBytes(), 0L, this.makeAbsolute(path));
    }

    public boolean rename(Path src, Path dst) throws IOException {
        String srcLog = this.getStreamName(src);
        String dstLog = this.getStreamName(dst);
        try {
            this.namespace.renameLog(srcLog, dstLog).get();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new DLInterruptedException("Interrupted at renaming " + srcLog + " to " + dstLog, (Throwable)e);
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof IOException) {
                throw (IOException)e.getCause();
            }
            throw new IOException("Failed to rename " + srcLog + " to " + dstLog, e.getCause());
        }
        return true;
    }

    public boolean truncate(Path f, long newLength) throws IOException {
        throw new UnsupportedOperationException("Truncate is not supported yet");
    }
}

