/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.mledger.impl;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CountDownLatch;
import org.apache.bookkeeper.client.BKException;
import org.apache.bookkeeper.client.api.LedgerEntries;
import org.apache.bookkeeper.client.api.ReadHandle;
import org.apache.bookkeeper.client.impl.LedgerEntryImpl;
import org.apache.bookkeeper.mledger.AsyncCallbacks;
import org.apache.bookkeeper.mledger.Entry;
import org.apache.bookkeeper.mledger.ManagedLedgerConfig;
import org.apache.bookkeeper.mledger.ManagedLedgerException;
import org.apache.bookkeeper.mledger.impl.EntryImpl;
import org.apache.bookkeeper.mledger.impl.ManagedLedgerImpl;
import org.apache.bookkeeper.mledger.impl.ManagedLedgerMBeanImpl;
import org.apache.bookkeeper.mledger.impl.cache.EntryCache;
import org.apache.bookkeeper.mledger.impl.cache.EntryCacheManager;
import org.apache.bookkeeper.test.MockedBookKeeperTestCase;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.testng.Assert;
import org.testng.annotations.Test;

public class EntryCacheTest
extends MockedBookKeeperTestCase {
    private ManagedLedgerImpl ml;

    @Override
    protected void setUpTestCase() throws Exception {
        this.ml = (ManagedLedgerImpl)Mockito.mock(ManagedLedgerImpl.class);
        Mockito.when((Object)this.ml.getName()).thenReturn((Object)"name");
        Mockito.when((Object)this.ml.getExecutor()).thenReturn((Object)this.executor);
        Mockito.when((Object)this.ml.getMbean()).thenReturn((Object)new ManagedLedgerMBeanImpl(this.ml));
        Mockito.when((Object)this.ml.getConfig()).thenReturn((Object)new ManagedLedgerConfig());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeOut=5000L)
    public void testRead() throws Exception {
        ReadHandle lh = EntryCacheTest.getLedgerHandle();
        Mockito.when((Object)lh.getId()).thenReturn((Object)0L);
        EntryCacheManager cacheManager = this.factory.getEntryCacheManager();
        EntryCache entryCache = cacheManager.getEntryCache(this.ml);
        try {
            byte[] data = new byte[10];
            for (int i = 0; i < 10; ++i) {
                entryCache.insert(EntryImpl.create((long)0L, (long)i, (byte[])data));
            }
            final CountDownLatch counter = new CountDownLatch(1);
            entryCache.asyncReadEntry(lh, 0L, 9L, false, new AsyncCallbacks.ReadEntriesCallback(){

                public void readEntriesComplete(List<Entry> entries, Object ctx) {
                    Assert.assertEquals((int)entries.size(), (int)10);
                    entries.forEach(Entry::release);
                    counter.countDown();
                }

                public void readEntriesFailed(ManagedLedgerException exception, Object ctx) {
                    Assert.fail((String)"should not have failed");
                }
            }, null);
            counter.await();
            ((ReadHandle)Mockito.verify((Object)lh, (VerificationMode)Mockito.never())).readAsync(ArgumentMatchers.anyLong(), ArgumentMatchers.anyLong());
        }
        finally {
            if (Collections.singletonList(entryCache).get(0) != null) {
                entryCache.clear();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeOut=5000L)
    public void testReadMissingBefore() throws Exception {
        ReadHandle lh = EntryCacheTest.getLedgerHandle();
        Mockito.when((Object)lh.getId()).thenReturn((Object)0L);
        EntryCacheManager cacheManager = this.factory.getEntryCacheManager();
        EntryCache entryCache = cacheManager.getEntryCache(this.ml);
        try {
            byte[] data = new byte[10];
            for (int i = 3; i < 10; ++i) {
                entryCache.insert(EntryImpl.create((long)0L, (long)i, (byte[])data));
            }
            final CountDownLatch counter = new CountDownLatch(1);
            entryCache.asyncReadEntry(lh, 0L, 9L, false, new AsyncCallbacks.ReadEntriesCallback(){

                public void readEntriesComplete(List<Entry> entries, Object ctx) {
                    Assert.assertEquals((int)entries.size(), (int)10);
                    counter.countDown();
                }

                public void readEntriesFailed(ManagedLedgerException exception, Object ctx) {
                    Assert.fail((String)"should not have failed");
                }
            }, null);
            counter.await();
        }
        finally {
            if (Collections.singletonList(entryCache).get(0) != null) {
                entryCache.clear();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeOut=5000L)
    public void testReadMissingAfter() throws Exception {
        ReadHandle lh = EntryCacheTest.getLedgerHandle();
        Mockito.when((Object)lh.getId()).thenReturn((Object)0L);
        EntryCacheManager cacheManager = this.factory.getEntryCacheManager();
        EntryCache entryCache = cacheManager.getEntryCache(this.ml);
        try {
            byte[] data = new byte[10];
            for (int i = 0; i < 8; ++i) {
                entryCache.insert(EntryImpl.create((long)0L, (long)i, (byte[])data));
            }
            final CountDownLatch counter = new CountDownLatch(1);
            entryCache.asyncReadEntry(lh, 0L, 9L, false, new AsyncCallbacks.ReadEntriesCallback(){

                public void readEntriesComplete(List<Entry> entries, Object ctx) {
                    Assert.assertEquals((int)entries.size(), (int)10);
                    counter.countDown();
                }

                public void readEntriesFailed(ManagedLedgerException exception, Object ctx) {
                    Assert.fail((String)"should not have failed");
                }
            }, null);
            counter.await();
        }
        finally {
            if (Collections.singletonList(entryCache).get(0) != null) {
                entryCache.clear();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeOut=5000L)
    public void testReadMissingMiddle() throws Exception {
        ReadHandle lh = EntryCacheTest.getLedgerHandle();
        Mockito.when((Object)lh.getId()).thenReturn((Object)0L);
        EntryCacheManager cacheManager = this.factory.getEntryCacheManager();
        EntryCache entryCache = cacheManager.getEntryCache(this.ml);
        try {
            byte[] data = new byte[10];
            entryCache.insert(EntryImpl.create((long)0L, (long)0L, (byte[])data));
            entryCache.insert(EntryImpl.create((long)0L, (long)1L, (byte[])data));
            entryCache.insert(EntryImpl.create((long)0L, (long)8L, (byte[])data));
            entryCache.insert(EntryImpl.create((long)0L, (long)9L, (byte[])data));
            final CountDownLatch counter = new CountDownLatch(1);
            entryCache.asyncReadEntry(lh, 0L, 9L, false, new AsyncCallbacks.ReadEntriesCallback(){

                public void readEntriesComplete(List<Entry> entries, Object ctx) {
                    Assert.assertEquals((int)entries.size(), (int)10);
                    counter.countDown();
                }

                public void readEntriesFailed(ManagedLedgerException exception, Object ctx) {
                    Assert.fail((String)"should not have failed");
                }
            }, null);
            counter.await();
        }
        finally {
            if (Collections.singletonList(entryCache).get(0) != null) {
                entryCache.clear();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeOut=5000L)
    public void testReadMissingMultiple() throws Exception {
        ReadHandle lh = EntryCacheTest.getLedgerHandle();
        Mockito.when((Object)lh.getId()).thenReturn((Object)0L);
        EntryCacheManager cacheManager = this.factory.getEntryCacheManager();
        EntryCache entryCache = cacheManager.getEntryCache(this.ml);
        try {
            byte[] data = new byte[10];
            entryCache.insert(EntryImpl.create((long)0L, (long)0L, (byte[])data));
            entryCache.insert(EntryImpl.create((long)0L, (long)2L, (byte[])data));
            entryCache.insert(EntryImpl.create((long)0L, (long)5L, (byte[])data));
            entryCache.insert(EntryImpl.create((long)0L, (long)8L, (byte[])data));
            final CountDownLatch counter = new CountDownLatch(1);
            entryCache.asyncReadEntry(lh, 0L, 9L, false, new AsyncCallbacks.ReadEntriesCallback(){

                public void readEntriesComplete(List<Entry> entries, Object ctx) {
                    Assert.assertEquals((int)entries.size(), (int)10);
                    counter.countDown();
                }

                public void readEntriesFailed(ManagedLedgerException exception, Object ctx) {
                    Assert.fail((String)"should not have failed");
                }
            }, null);
            counter.await();
        }
        finally {
            if (Collections.singletonList(entryCache).get(0) != null) {
                entryCache.clear();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCachedReadReturnsDifferentByteBuffer() throws Exception {
        ReadHandle lh = EntryCacheTest.getLedgerHandle();
        Mockito.when((Object)lh.getId()).thenReturn((Object)0L);
        EntryCacheManager cacheManager = this.factory.getEntryCacheManager();
        EntryCache entryCache = cacheManager.getEntryCache(this.ml);
        try {
            final CompletableFuture cacheMissFutureEntries = new CompletableFuture();
            entryCache.asyncReadEntry(lh, 0L, 1L, true, new AsyncCallbacks.ReadEntriesCallback(){

                public void readEntriesComplete(List<Entry> entries, Object ctx) {
                    cacheMissFutureEntries.complete(entries);
                }

                public void readEntriesFailed(ManagedLedgerException exception, Object ctx) {
                    cacheMissFutureEntries.completeExceptionally((Throwable)exception);
                }
            }, null);
            List cacheMissEntries = (List)cacheMissFutureEntries.get();
            Assert.assertEquals((int)cacheMissEntries.size(), (int)2);
            Assert.assertEquals((long)((Entry)cacheMissEntries.get(0)).getEntryId(), (long)0L);
            Assert.assertEquals((int)((Entry)cacheMissEntries.get(0)).getDataBuffer().readerIndex(), (int)0);
            ((Entry)cacheMissEntries.get(0)).getDataBuffer().readerIndex(10);
            final CompletableFuture cacheHitFutureEntries = new CompletableFuture();
            entryCache.asyncReadEntry(lh, 0L, 1L, true, new AsyncCallbacks.ReadEntriesCallback(){

                public void readEntriesComplete(List<Entry> entries, Object ctx) {
                    cacheHitFutureEntries.complete(entries);
                }

                public void readEntriesFailed(ManagedLedgerException exception, Object ctx) {
                    cacheHitFutureEntries.completeExceptionally((Throwable)exception);
                }
            }, null);
            List cacheHitEntries = (List)cacheHitFutureEntries.get();
            Assert.assertEquals((long)((Entry)cacheHitEntries.get(0)).getEntryId(), (long)0L);
            Assert.assertEquals((int)((Entry)cacheHitEntries.get(0)).getDataBuffer().readerIndex(), (int)0);
        }
        finally {
            if (Collections.singletonList(entryCache).get(0) != null) {
                entryCache.clear();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeOut=5000L)
    public void testReadWithError() throws Exception {
        ReadHandle lh = EntryCacheTest.getLedgerHandle();
        Mockito.when((Object)lh.getId()).thenReturn((Object)0L);
        ((ReadHandle)Mockito.doAnswer(invocation -> {
            CompletableFuture future = new CompletableFuture();
            future.completeExceptionally((Throwable)new BKException.BKNoSuchLedgerExistsException());
            return future;
        }).when((Object)lh)).readAsync(ArgumentMatchers.anyLong(), ArgumentMatchers.anyLong());
        EntryCacheManager cacheManager = this.factory.getEntryCacheManager();
        EntryCache entryCache = cacheManager.getEntryCache(this.ml);
        try {
            byte[] data = new byte[10];
            entryCache.insert(EntryImpl.create((long)0L, (long)2L, (byte[])data));
            final CountDownLatch counter = new CountDownLatch(1);
            entryCache.asyncReadEntry(lh, 0L, 9L, false, new AsyncCallbacks.ReadEntriesCallback(){

                public void readEntriesComplete(List<Entry> entries, Object ctx) {
                    Assert.fail((String)"should not complete");
                }

                public void readEntriesFailed(ManagedLedgerException exception, Object ctx) {
                    counter.countDown();
                }
            }, null);
            counter.await();
        }
        finally {
            if (Collections.singletonList(entryCache).get(0) != null) {
                entryCache.clear();
            }
        }
    }

    static ReadHandle getLedgerHandle() {
        ReadHandle lh = (ReadHandle)Mockito.mock(ReadHandle.class);
        ((ReadHandle)Mockito.doAnswer(invocation -> {
            Object[] args = invocation.getArguments();
            long firstEntry = (Long)args[0];
            long lastEntry = (Long)args[1];
            ArrayList<LedgerEntryImpl> entries = new ArrayList<LedgerEntryImpl>();
            int i = 0;
            while ((long)i <= lastEntry - firstEntry) {
                entries.add(LedgerEntryImpl.create((long)0L, (long)i, (long)10L, (ByteBuf)Unpooled.wrappedBuffer((byte[])new byte[10])));
                ++i;
            }
            LedgerEntries ledgerEntries = (LedgerEntries)Mockito.mock(LedgerEntries.class);
            ((LedgerEntries)Mockito.doAnswer(invocation2 -> entries.iterator()).when((Object)ledgerEntries)).iterator();
            return CompletableFuture.completedFuture(ledgerEntries);
        }).when((Object)lh)).readAsync(ArgumentMatchers.anyLong(), ArgumentMatchers.anyLong());
        return lh;
    }
}

