/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.mledger.impl;

import com.google.common.collect.Range;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ConcurrentSkipListMap;
import org.apache.bookkeeper.client.BookKeeper;
import org.apache.bookkeeper.mledger.ManagedLedgerConfig;
import org.apache.bookkeeper.mledger.impl.ManagedCursorImpl;
import org.apache.bookkeeper.mledger.impl.ManagedLedgerImpl;
import org.apache.bookkeeper.mledger.impl.PositionImpl;
import org.apache.bookkeeper.mledger.proto.MLDataFormats;
import org.apache.pulsar.common.util.collections.LongPairRangeSet;
import org.mockito.Mockito;
import org.testng.Assert;
import org.testng.annotations.Test;

public class ManagedCursorIndividualDeletedMessagesTest {
    @Test(timeOut=10000L)
    void testRecoverIndividualDeletedMessages() throws Exception {
        BookKeeper bookkeeper = (BookKeeper)Mockito.mock(BookKeeper.class);
        ManagedLedgerConfig config = new ManagedLedgerConfig();
        config.setUnackedRangesOpenCacheSetEnabled(true);
        ConcurrentSkipListMap<Long, MLDataFormats.ManagedLedgerInfo.LedgerInfo> ledgersInfo = new ConcurrentSkipListMap<Long, MLDataFormats.ManagedLedgerInfo.LedgerInfo>();
        ledgersInfo.put(1L, ManagedCursorIndividualDeletedMessagesTest.createLedgerInfo(1L, 100L, 1024L));
        ledgersInfo.put(3L, ManagedCursorIndividualDeletedMessagesTest.createLedgerInfo(3L, 50L, 512L));
        ledgersInfo.put(5L, ManagedCursorIndividualDeletedMessagesTest.createLedgerInfo(5L, 200L, 2048L));
        ledgersInfo.put(10L, ManagedCursorIndividualDeletedMessagesTest.createLedgerInfo(10L, 2L, 32L));
        ledgersInfo.put(20L, ManagedCursorIndividualDeletedMessagesTest.createLedgerInfo(20L, 10L, 256L));
        ManagedLedgerImpl ledger = (ManagedLedgerImpl)Mockito.mock(ManagedLedgerImpl.class);
        ((ManagedLedgerImpl)Mockito.doReturn(ledgersInfo).when((Object)ledger)).getLedgersInfo();
        ManagedCursorImpl cursor = (ManagedCursorImpl)Mockito.spy((Object)new ManagedCursorImpl(bookkeeper, config, ledger, "test-cursor"));
        LongPairRangeSet deletedMessages = cursor.getIndividuallyDeletedMessagesSet();
        Method recoverMethod = ManagedCursorImpl.class.getDeclaredMethod("recoverIndividualDeletedMessages", List.class);
        recoverMethod.setAccessible(true);
        ArrayList<MLDataFormats.MessageRange> messageRangeList = new ArrayList<MLDataFormats.MessageRange>();
        messageRangeList.add(ManagedCursorIndividualDeletedMessagesTest.createMessageRange(1L, 5L, 1L, 10L));
        ArrayList<Range<PositionImpl>> expectedRangeList = new ArrayList<Range<PositionImpl>>();
        expectedRangeList.add(ManagedCursorIndividualDeletedMessagesTest.createPositionRange(1L, 5L, 1L, 10L));
        recoverMethod.invoke((Object)cursor, messageRangeList);
        Assert.assertEquals((int)deletedMessages.size(), (int)1);
        Assert.assertEquals((Collection)deletedMessages.asRanges(), expectedRangeList);
        messageRangeList.clear();
        messageRangeList.add(ManagedCursorIndividualDeletedMessagesTest.createMessageRange(1L, 10L, 3L, 0L));
        expectedRangeList.clear();
        expectedRangeList.add(ManagedCursorIndividualDeletedMessagesTest.createPositionRange(1L, 10L, 1L, 99L));
        expectedRangeList.add(ManagedCursorIndividualDeletedMessagesTest.createPositionRange(3L, -1L, 3L, 0L));
        recoverMethod.invoke((Object)cursor, messageRangeList);
        Assert.assertEquals((int)deletedMessages.size(), (int)2);
        Assert.assertEquals((Collection)deletedMessages.asRanges(), expectedRangeList);
        messageRangeList.clear();
        messageRangeList.add(ManagedCursorIndividualDeletedMessagesTest.createMessageRange(1L, 20L, 10L, 1L));
        messageRangeList.add(ManagedCursorIndividualDeletedMessagesTest.createMessageRange(20L, 2L, 20L, 9L));
        expectedRangeList.clear();
        expectedRangeList.add(ManagedCursorIndividualDeletedMessagesTest.createPositionRange(1L, 20L, 1L, 99L));
        expectedRangeList.add(ManagedCursorIndividualDeletedMessagesTest.createPositionRange(3L, -1L, 3L, 49L));
        expectedRangeList.add(ManagedCursorIndividualDeletedMessagesTest.createPositionRange(5L, -1L, 5L, 199L));
        expectedRangeList.add(ManagedCursorIndividualDeletedMessagesTest.createPositionRange(10L, -1L, 10L, 1L));
        expectedRangeList.add(ManagedCursorIndividualDeletedMessagesTest.createPositionRange(20L, 2L, 20L, 9L));
        recoverMethod.invoke((Object)cursor, messageRangeList);
        Assert.assertEquals((int)deletedMessages.size(), (int)5);
        Assert.assertEquals((Collection)deletedMessages.asRanges(), expectedRangeList);
    }

    private static MLDataFormats.ManagedLedgerInfo.LedgerInfo createLedgerInfo(long ledgerId, long entries, long size) {
        return MLDataFormats.ManagedLedgerInfo.LedgerInfo.newBuilder().setLedgerId(ledgerId).setEntries(entries).setSize(size).setTimestamp(System.currentTimeMillis()).build();
    }

    private static MLDataFormats.MessageRange createMessageRange(long lowerLedgerId, long lowerEntryId, long upperLedgerId, long upperEntryId) {
        MLDataFormats.NestedPositionInfo.Builder nestedPositionBuilder = MLDataFormats.NestedPositionInfo.newBuilder();
        MLDataFormats.MessageRange.Builder messageRangeBuilder = MLDataFormats.MessageRange.newBuilder();
        nestedPositionBuilder.setLedgerId(lowerLedgerId);
        nestedPositionBuilder.setEntryId(lowerEntryId);
        messageRangeBuilder.setLowerEndpoint(nestedPositionBuilder.build());
        nestedPositionBuilder.setLedgerId(upperLedgerId);
        nestedPositionBuilder.setEntryId(upperEntryId);
        messageRangeBuilder.setUpperEndpoint(nestedPositionBuilder.build());
        return messageRangeBuilder.build();
    }

    private static Range<PositionImpl> createPositionRange(long lowerLedgerId, long lowerEntryId, long upperLedgerId, long upperEntryId) {
        return Range.openClosed((Comparable)new PositionImpl(lowerLedgerId, lowerEntryId), (Comparable)new PositionImpl(upperLedgerId, upperEntryId));
    }
}

