/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.mledger.impl;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.bookkeeper.mledger.MetadataCompressionConfig;
import org.apache.bookkeeper.mledger.impl.MetaStoreImpl;
import org.apache.bookkeeper.mledger.proto.MLDataFormats;
import org.apache.pulsar.common.api.proto.CompressionType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.Assert;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class ManagedCursorInfoMetadataTest {
    private static final Logger log = LoggerFactory.getLogger(ManagedCursorInfoMetadataTest.class);
    private final String INVALID_TYPE = "INVALID_TYPE";

    @DataProvider(name="compressionTypeProvider")
    private Object[][] compressionTypeProvider() {
        return new Object[][]{{null}, {"INVALID_TYPE"}, {CompressionType.NONE.name()}, {CompressionType.LZ4.name()}, {CompressionType.ZLIB.name()}, {CompressionType.ZSTD.name()}, {CompressionType.SNAPPY.name()}};
    }

    private MLDataFormats.ManagedCursorInfo.Builder generateManagedCursorInfo(long ledgerId, int positionNumber) {
        MLDataFormats.ManagedCursorInfo.Builder builder = MLDataFormats.ManagedCursorInfo.newBuilder();
        builder.setCursorsLedgerId(ledgerId);
        builder.setMarkDeleteLedgerId(ledgerId);
        ArrayList<MLDataFormats.BatchedEntryDeletionIndexInfo> batchedEntryDeletionIndexInfos = new ArrayList<MLDataFormats.BatchedEntryDeletionIndexInfo>();
        for (int i = 0; i < positionNumber; ++i) {
            MLDataFormats.NestedPositionInfo nestedPositionInfo = MLDataFormats.NestedPositionInfo.newBuilder().setEntryId((long)i).setLedgerId((long)i).build();
            MLDataFormats.BatchedEntryDeletionIndexInfo batchedEntryDeletionIndexInfo = MLDataFormats.BatchedEntryDeletionIndexInfo.newBuilder().setPosition(nestedPositionInfo).build();
            batchedEntryDeletionIndexInfos.add(batchedEntryDeletionIndexInfo);
        }
        builder.addAllBatchedEntryDeletionIndexInfo(batchedEntryDeletionIndexInfos);
        return builder;
    }

    @Test(dataProvider="compressionTypeProvider")
    public void testEncodeAndDecode(String compressionType) throws IOException {
        long ledgerId = 10000L;
        MLDataFormats.ManagedCursorInfo.Builder builder = this.generateManagedCursorInfo(ledgerId, 1000);
        if ("INVALID_TYPE".equals(compressionType)) {
            IllegalArgumentException compressionTypeEx = (IllegalArgumentException)Assert.expectThrows(IllegalArgumentException.class, () -> new MetaStoreImpl(null, null, null, new MetadataCompressionConfig(compressionType)));
            Assert.assertEquals((String)compressionTypeEx.getMessage(), (String)("No enum constant org.apache.bookkeeper.mledger.proto.MLDataFormats.CompressionType." + compressionType));
            return;
        }
        MetaStoreImpl metaStore = new MetaStoreImpl(null, null, null, new MetadataCompressionConfig(compressionType));
        MLDataFormats.ManagedCursorInfo managedCursorInfo = builder.build();
        byte[] compressionBytes = metaStore.compressCursorInfo(managedCursorInfo);
        log.info("[{}] Uncompressed data size: {}, compressed data size: {}", new Object[]{compressionType, managedCursorInfo.getSerializedSize(), compressionBytes.length});
        if (compressionType == null || compressionType.equals(CompressionType.NONE.name())) {
            Assert.assertEquals((int)compressionBytes.length, (int)managedCursorInfo.getSerializedSize());
        }
        MLDataFormats.ManagedCursorInfo info1 = metaStore.parseManagedCursorInfo(compressionBytes);
        MLDataFormats.ManagedCursorInfo info2 = metaStore.parseManagedCursorInfo(managedCursorInfo.toByteArray());
        Assert.assertEquals((Object)info1, (Object)info2);
    }

    @Test(dataProvider="compressionTypeProvider")
    public void testCompressionThreshold(String compressionType) throws IOException {
        int compressThreshold = 512;
        long ledgerId = 10000L;
        MLDataFormats.ManagedCursorInfo smallInfo = this.generateManagedCursorInfo(ledgerId, 1).build();
        Assert.assertTrue((smallInfo.getSerializedSize() < compressThreshold ? 1 : 0) != 0);
        MLDataFormats.ManagedCursorInfo bigInfo = this.generateManagedCursorInfo(ledgerId, 1000).build();
        Assert.assertTrue((bigInfo.getSerializedSize() > compressThreshold ? 1 : 0) != 0);
        if ("INVALID_TYPE".equals(compressionType)) {
            IllegalArgumentException compressionTypeEx = (IllegalArgumentException)Assert.expectThrows(IllegalArgumentException.class, () -> new MetaStoreImpl(null, null, null, new MetadataCompressionConfig(compressionType, (long)compressThreshold)));
            Assert.assertEquals((String)compressionTypeEx.getMessage(), (String)("No enum constant org.apache.bookkeeper.mledger.proto.MLDataFormats.CompressionType." + compressionType));
            return;
        }
        MetaStoreImpl metaStore = new MetaStoreImpl(null, null, null, new MetadataCompressionConfig(compressionType, (long)compressThreshold));
        byte[] compressionBytes = metaStore.compressCursorInfo(smallInfo);
        Assert.assertEquals((int)compressionBytes.length, (int)smallInfo.getSerializedSize());
        byte[] compressionBigBytes = metaStore.compressCursorInfo(bigInfo);
        Assert.assertTrue((compressionBigBytes.length != smallInfo.getSerializedSize() ? 1 : 0) != 0);
    }
}

