/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.mledger.impl;

import com.google.common.collect.Lists;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.bookkeeper.mledger.ManagedCursor;
import org.apache.bookkeeper.mledger.ManagedLedger;
import org.apache.bookkeeper.mledger.ManagedLedgerConfig;
import org.apache.bookkeeper.mledger.Position;
import org.apache.bookkeeper.test.MockedBookKeeperTestCase;
import org.testng.Assert;
import org.testng.annotations.Test;

public class ManagedCursorListAckTest
extends MockedBookKeeperTestCase {
    private static final Charset Encoding = StandardCharsets.UTF_8;

    @Test(timeOut=20000L)
    void testMultiPositionDelete() throws Exception {
        ManagedLedger ledger = this.factory.open("my_test_ledger", new ManagedLedgerConfig().setMaxEntriesPerLedger(2));
        ManagedCursor c1 = ledger.openCursor("c1");
        Position p0 = c1.getMarkDeletedPosition();
        Position p1 = ledger.addEntry("dummy-entry-1".getBytes(Encoding));
        Position p2 = ledger.addEntry("dummy-entry-2".getBytes(Encoding));
        Position p3 = ledger.addEntry("dummy-entry-3".getBytes(Encoding));
        Position p4 = ledger.addEntry("dummy-entry-4".getBytes(Encoding));
        Position p5 = ledger.addEntry("dummy-entry-5".getBytes(Encoding));
        Position p6 = ledger.addEntry("dummy-entry-6".getBytes(Encoding));
        Position p7 = ledger.addEntry("dummy-entry-7".getBytes(Encoding));
        Assert.assertEquals((long)c1.getNumberOfEntries(), (long)7L);
        Assert.assertEquals((long)c1.getNumberOfEntriesInBacklog(false), (long)7L);
        c1.delete((Iterable)Lists.newArrayList((Object[])new Position[]{p2, p3, p5, p7}));
        Assert.assertEquals((long)c1.getNumberOfEntries(), (long)3L);
        Assert.assertEquals((long)c1.getNumberOfEntriesInBacklog(false), (long)3L);
        Assert.assertEquals((Object)c1.getMarkDeletedPosition(), (Object)p0);
        c1.delete((Iterable)Lists.newArrayList((Object[])new Position[]{p1}));
        Assert.assertEquals((long)c1.getNumberOfEntries(), (long)2L);
        Assert.assertEquals((long)c1.getNumberOfEntriesInBacklog(false), (long)2L);
        Assert.assertEquals((Object)c1.getMarkDeletedPosition(), (Object)p3);
        c1.delete((Iterable)Lists.newArrayList((Object[])new Position[]{p4, p6, p7}));
        Assert.assertEquals((long)c1.getNumberOfEntries(), (long)0L);
        Assert.assertEquals((long)c1.getNumberOfEntriesInBacklog(false), (long)0L);
        Assert.assertEquals((Object)c1.getMarkDeletedPosition(), (Object)p7);
    }
}

