/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.mledger.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import org.apache.bookkeeper.client.BookKeeper;
import org.apache.bookkeeper.mledger.ManagedCursor;
import org.apache.bookkeeper.mledger.ManagedLedger;
import org.apache.bookkeeper.mledger.ManagedLedgerConfig;
import org.apache.bookkeeper.mledger.ManagedLedgerException;
import org.apache.bookkeeper.mledger.Position;
import org.apache.bookkeeper.mledger.impl.ManagedLedgerFactoryImpl;
import org.apache.bookkeeper.mledger.util.Futures;
import org.apache.bookkeeper.test.MockedBookKeeperTestCase;
import org.apache.pulsar.common.api.proto.CommandSubscribe;
import org.apache.pulsar.common.util.FutureUtil;
import org.apache.pulsar.metadata.api.extended.MetadataStoreExtended;
import org.testng.Assert;
import org.testng.annotations.Test;

public class ManagedCursorPropertiesTest
extends MockedBookKeeperTestCase {
    @Test(timeOut=20000L)
    void testPropertiesClose() throws Exception {
        ManagedLedger ledger = this.factory.open("my_test_ledger", new ManagedLedgerConfig());
        ManagedCursor c1 = ledger.openCursor("c1");
        Assert.assertEquals((Map)c1.getProperties(), Collections.emptyMap());
        ledger.addEntry("entry-1".getBytes());
        ledger.addEntry("entry-2".getBytes());
        Position p3 = ledger.addEntry("entry-3".getBytes());
        ledger.addEntry("entry-4".getBytes());
        TreeMap<String, Long> properties = new TreeMap<String, Long>();
        properties.put("a", 1L);
        properties.put("b", 2L);
        properties.put("c", 3L);
        c1.markDelete(p3, properties);
        Assert.assertEquals((Map)c1.getProperties(), properties);
        TreeMap<String, Long> properties2 = new TreeMap<String, Long>();
        properties2.put("a", 4L);
        properties2.put("b", 5L);
        properties2.put("c", 6L);
        c1.markDelete(p3, properties2);
        Assert.assertEquals((Map)c1.getProperties(), properties2);
        ledger.close();
        ledger = this.factory.open("my_test_ledger", new ManagedLedgerConfig());
        c1 = ledger.openCursor("c1");
        Assert.assertEquals((Object)c1.getMarkDeletedPosition(), (Object)p3);
        Assert.assertEquals((Map)c1.getProperties(), properties2);
    }

    @Test(timeOut=20000L)
    void testPropertiesRecoveryAfterCrash() throws Exception {
        ManagedLedger ledger = this.factory.open("my_test_ledger", new ManagedLedgerConfig());
        TreeMap<String, String> cursorProperties = new TreeMap<String, String>();
        cursorProperties.put("custom1", "one");
        cursorProperties.put("custom2", "two");
        ManagedCursor c1 = ledger.openCursor("c1", CommandSubscribe.InitialPosition.Latest, Collections.emptyMap(), cursorProperties);
        Assert.assertEquals((Map)c1.getProperties(), Collections.emptyMap());
        Assert.assertEquals((Map)c1.getCursorProperties(), cursorProperties);
        ledger.addEntry("entry-1".getBytes());
        ledger.addEntry("entry-2".getBytes());
        Position p3 = ledger.addEntry("entry-3".getBytes());
        ledger.addEntry("entry-4".getBytes());
        TreeMap<String, Long> properties = new TreeMap<String, Long>();
        properties.put("a", 1L);
        properties.put("b", 2L);
        properties.put("c", 3L);
        c1.markDelete(p3, properties);
        ManagedLedgerFactoryImpl factory2 = new ManagedLedgerFactoryImpl((MetadataStoreExtended)this.metadataStore, (BookKeeper)this.bkc);
        ledger = factory2.open("my_test_ledger", new ManagedLedgerConfig());
        c1 = ledger.openCursor("c1");
        Assert.assertEquals((Object)c1.getMarkDeletedPosition(), (Object)p3);
        Assert.assertEquals((Map)c1.getProperties(), properties);
        Assert.assertEquals((Map)c1.getCursorProperties(), cursorProperties);
        factory2.shutdown();
    }

    @Test(timeOut=20000L)
    void testPropertiesOnDelete() throws Exception {
        ManagedLedger ledger = this.factory.open("my_test_ledger", new ManagedLedgerConfig());
        ManagedCursor c1 = ledger.openCursor("c1");
        Assert.assertEquals((Map)c1.getProperties(), Collections.emptyMap());
        ledger.addEntry("entry-1".getBytes());
        Position p2 = ledger.addEntry("entry-2".getBytes());
        Position p3 = ledger.addEntry("entry-3".getBytes());
        ledger.addEntry("entry-4".getBytes());
        TreeMap<String, Long> properties = new TreeMap<String, Long>();
        properties.put("a", 1L);
        properties.put("b", 2L);
        properties.put("c", 3L);
        c1.markDelete(p2, properties);
        Assert.assertEquals((Map)c1.getProperties(), properties);
        c1.markDelete(p3, properties);
        Assert.assertEquals((Map)c1.getProperties(), properties);
        ledger.close();
        ledger = this.factory.open("my_test_ledger", new ManagedLedgerConfig());
        c1 = ledger.openCursor("c1");
        Assert.assertEquals((Object)c1.getMarkDeletedPosition(), (Object)p3);
        Assert.assertEquals((Map)c1.getProperties(), properties);
    }

    @Test
    void testPropertiesAtCreation() throws Exception {
        ManagedLedger ledger = this.factory.open("my_test_ledger_at_creation", new ManagedLedgerConfig());
        TreeMap<String, Long> properties = new TreeMap<String, Long>();
        properties.put("a", 1L);
        properties.put("b", 2L);
        properties.put("c", 3L);
        TreeMap<String, String> cursorProperties = new TreeMap<String, String>();
        cursorProperties.put("custom1", "one");
        cursorProperties.put("custom2", "two");
        ManagedCursor c1 = ledger.openCursor("c1", CommandSubscribe.InitialPosition.Latest, properties, cursorProperties);
        Assert.assertEquals((Map)c1.getProperties(), properties);
        Assert.assertEquals((Map)c1.getCursorProperties(), cursorProperties);
        ledger.addEntry("entry-1".getBytes());
        ledger.close();
        ledger = this.factory.open("my_test_ledger_at_creation", new ManagedLedgerConfig());
        c1 = ledger.openCursor("c1");
        Assert.assertEquals((Map)c1.getProperties(), properties);
        Assert.assertEquals((Map)c1.getCursorProperties(), cursorProperties);
    }

    @Test
    void testUpdateCursorProperties() throws Exception {
        ManagedLedger ledger = this.factory.open("testUpdateCursorProperties", new ManagedLedgerConfig());
        TreeMap<String, Long> properties = new TreeMap<String, Long>();
        properties.put("a", 1L);
        TreeMap<String, String> cursorProperties = new TreeMap<String, String>();
        cursorProperties.put("custom1", "one");
        cursorProperties.put("custom2", "two");
        ManagedCursor c1 = ledger.openCursor("c1", CommandSubscribe.InitialPosition.Latest, properties, cursorProperties);
        Assert.assertEquals((Map)c1.getProperties(), properties);
        Assert.assertEquals((Map)c1.getCursorProperties(), cursorProperties);
        ledger.addEntry("entry-1".getBytes());
        TreeMap<String, String> cursorPropertiesUpdated = new TreeMap<String, String>();
        cursorPropertiesUpdated.put("custom1", "three");
        cursorPropertiesUpdated.put("custom2", "four");
        c1.setCursorProperties(cursorPropertiesUpdated).get(10L, TimeUnit.SECONDS);
        ledger.close();
        ledger = this.factory.open("testUpdateCursorProperties", new ManagedLedgerConfig());
        c1 = ledger.openCursor("c1");
        Assert.assertEquals((Map)c1.getProperties(), properties);
        Assert.assertEquals((Map)c1.getCursorProperties(), cursorPropertiesUpdated);
        c1.putCursorProperty("custom3", "Five").get();
        cursorPropertiesUpdated.put("custom3", "Five");
        c1.removeCursorProperty("custom1").get();
        cursorPropertiesUpdated.remove("custom1");
        Assert.assertEquals((Map)c1.getCursorProperties(), cursorPropertiesUpdated);
        ManagedLedgerFactoryImpl factory2 = new ManagedLedgerFactoryImpl((MetadataStoreExtended)this.metadataStore, (BookKeeper)this.bkc);
        ledger = factory2.open("testUpdateCursorProperties", new ManagedLedgerConfig());
        c1 = ledger.openCursor("c1");
        Assert.assertEquals((Map)c1.getProperties(), properties);
        Assert.assertEquals((Map)c1.getCursorProperties(), cursorPropertiesUpdated);
        ledger.close();
        factory2.shutdown();
        ManagedLedgerFactoryImpl factory3 = new ManagedLedgerFactoryImpl((MetadataStoreExtended)this.metadataStore, (BookKeeper)this.bkc);
        ledger = factory3.open("testUpdateCursorProperties", new ManagedLedgerConfig());
        c1 = ledger.openCursor("c1");
        c1.putCursorProperty("#pulsar.internal.test", "test").get(10L, TimeUnit.SECONDS);
        c1.putCursorProperty("custom4", "custom4").get(10L, TimeUnit.SECONDS);
        c1.setCursorProperties(cursorPropertiesUpdated).get(10L, TimeUnit.SECONDS);
        cursorPropertiesUpdated.put("#pulsar.internal.test", "test");
        try {
            c1.setCursorProperties(cursorPropertiesUpdated).get(10L, TimeUnit.SECONDS);
            Assert.fail((String)"Should fail");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)FutureUtil.unwrapCompletionException((Throwable)e).getMessage().contains("The property key can't start with"));
        }
        Assert.assertEquals((Map)c1.getCursorProperties(), cursorPropertiesUpdated);
        ledger.close();
        factory3.shutdown();
    }

    @Test
    public void testUpdateCursorPropertiesConcurrent() throws Exception {
        ManagedLedger ledger = this.factory.open("my_test_ledger", new ManagedLedgerConfig());
        ManagedCursor c1 = ledger.openCursor("c1");
        ArrayList<CompletableFuture> futures = new ArrayList<CompletableFuture>();
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("a", "1");
        map.put("b", "2");
        map.put("c", "3");
        futures.add(Futures.executeWithRetry(() -> c1.setCursorProperties(map), ManagedLedgerException.BadVersionException.class, (int)3));
        futures.add(Futures.executeWithRetry(() -> c1.putCursorProperty("a", "2"), ManagedLedgerException.BadVersionException.class, (int)3));
        futures.add(Futures.executeWithRetry(() -> c1.removeCursorProperty("c"), ManagedLedgerException.BadVersionException.class, (int)3));
        for (CompletableFuture future : futures) {
            future.get(10L, TimeUnit.SECONDS);
        }
        Assert.assertEquals((String)((String)c1.getCursorProperties().get("a")), (String)"2");
        Assert.assertEquals((String)((String)c1.getCursorProperties().get("b")), (String)"2");
        Assert.assertNull(c1.getCursorProperties().get("c"));
    }
}

