/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.mledger.impl;

import io.netty.buffer.ByteBuf;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.bookkeeper.client.BKException;
import org.apache.bookkeeper.client.BookKeeper;
import org.apache.bookkeeper.client.LedgerHandle;
import org.apache.bookkeeper.client.api.DigestType;
import org.apache.bookkeeper.mledger.AsyncCallbacks;
import org.apache.bookkeeper.mledger.Entry;
import org.apache.bookkeeper.mledger.ManagedCursor;
import org.apache.bookkeeper.mledger.ManagedLedger;
import org.apache.bookkeeper.mledger.ManagedLedgerConfig;
import org.apache.bookkeeper.mledger.ManagedLedgerException;
import org.apache.bookkeeper.mledger.Position;
import org.apache.bookkeeper.mledger.impl.ManagedLedgerFactoryImpl;
import org.apache.bookkeeper.mledger.impl.ManagedLedgerImpl;
import org.apache.bookkeeper.test.MockedBookKeeperTestCase;
import org.apache.pulsar.metadata.api.MetadataStoreException;
import org.apache.pulsar.metadata.api.extended.MetadataStoreExtended;
import org.apache.pulsar.metadata.impl.FaultInjectionMetadataStore;
import org.awaitility.Awaitility;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.Assert;
import org.testng.annotations.Test;

public class ManagedLedgerErrorsTest
extends MockedBookKeeperTestCase {
    private static final Logger log = LoggerFactory.getLogger(ManagedLedgerErrorsTest.class);

    @Test
    public void removingCursor() throws Exception {
        ManagedLedger ledger = this.factory.open("my_test_ledger");
        ManagedCursor c1 = ledger.openCursor("c1");
        Assert.assertTrue((boolean)((Boolean)this.metadataStore.exists("/managed-ledgers/my_test_ledger/c1").join()));
        this.metadataStore.failConditional((MetadataStoreException)new MetadataStoreException.BadVersionException("err"), (op, path) -> op == FaultInjectionMetadataStore.OperationType.PUT && path.equals("/managed-ledgers/my_test_ledger/c1"));
        try {
            c1.close();
            Assert.fail((String)"should fail");
        }
        catch (ManagedLedgerException managedLedgerException) {
            // empty catch block
        }
        this.bkc.failNow(-7);
        ledger.deleteCursor("c1");
        Assert.assertFalse((boolean)((Boolean)this.metadataStore.exists("/managed-ledgers/my_test_ledger/c1").join()));
        Assert.assertEquals((int)this.bkc.getLedgers().size(), (int)1);
    }

    @Test
    public void removingCursor2() throws Exception {
        ManagedLedger ledger = this.factory.open("my_test_ledger");
        ledger.openCursor("c1");
        this.metadataStore.failConditional(new MetadataStoreException("error"), (op, path) -> op == FaultInjectionMetadataStore.OperationType.DELETE && path.equals("/managed-ledgers/my_test_ledger/c1"));
        try {
            ledger.deleteCursor("c1");
            Assert.fail((String)"should fail");
        }
        catch (ManagedLedgerException managedLedgerException) {
            // empty catch block
        }
    }

    @Test
    public void closingManagedLedger() throws Exception {
        ManagedLedger ledger = this.factory.open("my_test_ledger");
        ledger.openCursor("c1");
        ledger.addEntry("entry".getBytes());
        this.bkc.failNow(-7);
        try {
            ledger.close();
            Assert.fail((String)"should fail");
        }
        catch (ManagedLedgerException managedLedgerException) {
            // empty catch block
        }
        try {
            ledger.addEntry("entry".getBytes());
            Assert.fail((String)"managed ledger was closed");
        }
        catch (ManagedLedgerException managedLedgerException) {
            // empty catch block
        }
    }

    @Test
    public void asyncClosingManagedLedger() throws Exception {
        ManagedLedger ledger = this.factory.open("my_test_ledger");
        ledger.openCursor("c1");
        this.bkc.failNow(-7);
        final CountDownLatch latch = new CountDownLatch(1);
        ledger.asyncClose(new AsyncCallbacks.CloseCallback(){

            public void closeFailed(ManagedLedgerException exception, Object ctx) {
                latch.countDown();
            }

            public void closeComplete(Object ctx) {
                Assert.fail((String)"should have failed");
            }
        }, null);
        latch.await();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void errorInRecovering() throws Exception {
        ManagedLedger ledger = this.factory.open("my_test_ledger");
        ledger.addEntry("entry".getBytes());
        ledger.close();
        ManagedLedgerFactoryImpl factory2 = new ManagedLedgerFactoryImpl((MetadataStoreExtended)this.metadataStore, (BookKeeper)this.bkc);
        try {
            this.bkc.failNow(-101);
            try {
                ledger = factory2.open("my_test_ledger");
                Assert.fail((String)"should fail");
            }
            catch (ManagedLedgerException managedLedgerException) {
                // empty catch block
            }
            ledger = factory2.open("my_test_ledger");
        }
        finally {
            if (Collections.singletonList(factory2).get(0) != null) {
                factory2.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void errorInRecovering2() throws Exception {
        ManagedLedger ledger = this.factory.open("my_test_ledger");
        ledger.addEntry("entry".getBytes());
        ledger.close();
        ManagedLedgerFactoryImpl factory2 = new ManagedLedgerFactoryImpl((MetadataStoreExtended)this.metadataStore, (BookKeeper)this.bkc);
        try {
            this.bkc.failAfter(1, -101);
            try {
                ledger = factory2.open("my_test_ledger");
                Assert.fail((String)"should fail");
            }
            catch (ManagedLedgerException managedLedgerException) {
                // empty catch block
            }
            ledger = factory2.open("my_test_ledger");
        }
        finally {
            if (Collections.singletonList(factory2).get(0) != null) {
                factory2.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void errorInRecovering3() throws Exception {
        ManagedLedger ledger = this.factory.open("my_test_ledger");
        ledger.addEntry("entry".getBytes());
        ledger.close();
        ManagedLedgerFactoryImpl factory2 = new ManagedLedgerFactoryImpl((MetadataStoreExtended)this.metadataStore, (BookKeeper)this.bkc);
        try {
            this.bkc.failAfter(1, -101);
            try {
                ledger = factory2.open("my_test_ledger");
                Assert.fail((String)"should fail");
            }
            catch (ManagedLedgerException managedLedgerException) {
                // empty catch block
            }
            ledger = factory2.open("my_test_ledger");
        }
        finally {
            if (Collections.singletonList(factory2).get(0) != null) {
                factory2.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void errorInRecovering4() throws Exception {
        ManagedLedger ledger = this.factory.open("my_test_ledger");
        ledger.addEntry("entry".getBytes());
        ledger.close();
        ManagedLedgerFactoryImpl factory2 = new ManagedLedgerFactoryImpl((MetadataStoreExtended)this.metadataStore, (BookKeeper)this.bkc);
        try {
            this.metadataStore.failConditional(new MetadataStoreException("error"), (op, path) -> path.equals("/managed-ledgers/my_test_ledger") && op == FaultInjectionMetadataStore.OperationType.PUT);
            try {
                ledger = factory2.open("my_test_ledger");
                Assert.fail((String)"should fail");
            }
            catch (ManagedLedgerException managedLedgerException) {
                // empty catch block
            }
            ledger = factory2.open("my_test_ledger");
        }
        finally {
            if (Collections.singletonList(factory2).get(0) != null) {
                factory2.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void errorInRecovering5() throws Exception {
        ManagedLedger ledger = this.factory.open("my_test_ledger");
        ledger.addEntry("entry".getBytes());
        ledger.close();
        ManagedLedgerFactoryImpl factory2 = new ManagedLedgerFactoryImpl((MetadataStoreExtended)this.metadataStore, (BookKeeper)this.bkc);
        try {
            this.metadataStore.failConditional(new MetadataStoreException("error"), (op, path) -> path.equals("/managed-ledgers/my_test_ledger") && op == FaultInjectionMetadataStore.OperationType.GET_CHILDREN);
            try {
                ledger = factory2.open("my_test_ledger");
                Assert.fail((String)"should fail");
            }
            catch (ManagedLedgerException managedLedgerException) {
                // empty catch block
            }
            ledger = factory2.open("my_test_ledger");
        }
        finally {
            if (Collections.singletonList(factory2).get(0) != null) {
                factory2.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void errorInRecovering6() throws Exception {
        ManagedLedger ledger = this.factory.open("my_test_ledger");
        ledger.openCursor("c1");
        ledger.addEntry("entry".getBytes());
        ledger.close();
        ManagedLedgerFactoryImpl factory2 = new ManagedLedgerFactoryImpl((MetadataStoreExtended)this.metadataStore, (BookKeeper)this.bkc);
        try {
            this.metadataStore.failConditional(new MetadataStoreException("error"), (op, path) -> path.equals("/managed-ledgers/my_test_ledger/c1") && op == FaultInjectionMetadataStore.OperationType.GET);
            try {
                ledger = factory2.open("my_test_ledger");
                Assert.fail((String)"should fail");
            }
            catch (ManagedLedgerException managedLedgerException) {
                // empty catch block
            }
            ledger = factory2.open("my_test_ledger");
        }
        finally {
            if (Collections.singletonList(factory2).get(0) != null) {
                factory2.shutdown();
            }
        }
    }

    @Test
    public void passwordError() throws Exception {
        ManagedLedger ledger = this.factory.open("my_test_ledger", new ManagedLedgerConfig().setPassword("password"));
        ledger.openCursor("c1");
        ledger.addEntry("entry".getBytes());
        ledger.close();
        try {
            ledger = this.factory.open("my_test_ledger", new ManagedLedgerConfig().setPassword("wrong-password"));
            Assert.fail((String)"should fail for password error");
        }
        catch (ManagedLedgerException managedLedgerException) {
            // empty catch block
        }
    }

    @Test
    public void digestError() throws Exception {
        ManagedLedger ledger = this.factory.open("my_test_ledger", new ManagedLedgerConfig().setDigestType(DigestType.CRC32));
        ledger.openCursor("c1");
        ledger.addEntry("entry".getBytes());
        ledger.close();
        try {
            ledger = this.factory.open("my_test_ledger", new ManagedLedgerConfig().setDigestType(DigestType.MAC));
            Assert.fail((String)"should fail for digest error");
        }
        catch (ManagedLedgerException managedLedgerException) {
            // empty catch block
        }
    }

    @Test(timeOut=20000L, invocationCount=1, skipFailedInvocations=true, enabled=false)
    public void errorInUpdatingLedgersList() throws Exception {
        ManagedLedger ledger = this.factory.open("my_test_ledger", new ManagedLedgerConfig().setMaxEntriesPerLedger(1));
        final CompletableFuture promise = new CompletableFuture();
        this.metadataStore.failConditional(new MetadataStoreException("error"), (op, path) -> path.equals("/managed-ledgers/my_test_ledger") && op == FaultInjectionMetadataStore.OperationType.PUT);
        ledger.asyncAddEntry("entry".getBytes(), new AsyncCallbacks.AddEntryCallback(){

            public void addFailed(ManagedLedgerException exception, Object ctx) {
            }

            public void addComplete(Position position, ByteBuf entryData, Object ctx) {
            }
        }, null);
        ledger.asyncAddEntry("entry".getBytes(), new AsyncCallbacks.AddEntryCallback(){

            public void addFailed(ManagedLedgerException exception, Object ctx) {
                promise.complete(null);
            }

            public void addComplete(Position position, ByteBuf entryData, Object ctx) {
                promise.completeExceptionally(new Exception("should have failed"));
            }
        }, null);
        promise.get();
    }

    @Test
    public void recoverAfterZnodeVersionError() throws Exception {
        ManagedLedger ledger = this.factory.open("my_test_ledger", new ManagedLedgerConfig().setMaxEntriesPerLedger(1));
        this.metadataStore.failConditional((MetadataStoreException)new MetadataStoreException.BadVersionException("err"), (op, path) -> path.equals("/managed-ledgers/my_test_ledger") && op == FaultInjectionMetadataStore.OperationType.PUT);
        ledger.addEntry("test".getBytes());
        try {
            ledger.addEntry("entry".getBytes());
            Assert.fail((String)"should fail");
        }
        catch (ManagedLedgerException.ManagedLedgerFencedException e) {
            Assert.assertEquals(e.getCause().getClass(), ManagedLedgerException.BadVersionException.class);
        }
        try {
            ledger.addEntry("entry".getBytes());
            Assert.fail((String)"should fail");
        }
        catch (ManagedLedgerException.ManagedLedgerFencedException managedLedgerFencedException) {
            // empty catch block
        }
    }

    @Test
    public void recoverAfterZnodeVersionErrorWhileTrimming() throws Exception {
        ManagedLedger ledger = this.factory.open("my_test_ledger_trim", new ManagedLedgerConfig().setMaxEntriesPerLedger(2));
        ledger.addEntry("test".getBytes());
        ledger.addEntry("test".getBytes());
        ledger.addEntry("test".getBytes());
        this.metadataStore.failConditional((MetadataStoreException)new MetadataStoreException.BadVersionException("err"), (op, path) -> path.equals("/managed-ledgers/my_test_ledger_trim") && op == FaultInjectionMetadataStore.OperationType.PUT);
        CompletableFuture handle = new CompletableFuture();
        ledger.trimConsumedLedgersInBackground(handle);
        MatcherAssert.assertThat((Object)((ExecutionException)Assert.expectThrows(ExecutionException.class, () -> handle.get())).getCause(), (Matcher)CoreMatchers.instanceOf(ManagedLedgerException.BadVersionException.class));
        Assert.assertEquals((Object)ManagedLedgerImpl.State.Fenced, (Object)((ManagedLedgerImpl)ledger).getState());
        CompletableFuture handleAlreadyFenced = new CompletableFuture();
        ledger.trimConsumedLedgersInBackground(handleAlreadyFenced);
        MatcherAssert.assertThat((Object)((ExecutionException)Assert.expectThrows(ExecutionException.class, () -> handleAlreadyFenced.get())).getCause(), (Matcher)CoreMatchers.instanceOf(ManagedLedgerException.ManagedLedgerFencedException.class));
        try {
            ledger.addEntry("entry".getBytes());
            Assert.fail((String)"should fail");
        }
        catch (ManagedLedgerException.ManagedLedgerFencedException e) {
            Assert.assertEquals((String)"Attempted to use a fenced managed ledger", (String)e.getCause().getMessage());
        }
        Assert.assertFalse((boolean)this.factory.ledgers.isEmpty());
        try {
            ledger.close();
        }
        catch (ManagedLedgerException.ManagedLedgerFencedException e) {
            Assert.assertEquals((String)"Attempted to use a fenced managed ledger", (String)e.getCause().getMessage());
        }
        Assert.assertTrue((boolean)this.factory.ledgers.isEmpty());
    }

    @Test
    public void badVersionErrorDuringTruncateLedger() throws Exception {
        ManagedLedger ledger = this.factory.open("my_test_ledger_trim", new ManagedLedgerConfig().setMaxEntriesPerLedger(2));
        ledger.addEntry("test".getBytes());
        ledger.addEntry("test".getBytes());
        ledger.addEntry("test".getBytes());
        this.metadataStore.failConditional((MetadataStoreException)new MetadataStoreException.BadVersionException("err"), (op, path) -> path.equals("/managed-ledgers/my_test_ledger_trim") && op == FaultInjectionMetadataStore.OperationType.PUT);
        CompletableFuture handle = ledger.asyncTruncate();
        MatcherAssert.assertThat((Object)((ExecutionException)Assert.expectThrows(ExecutionException.class, () -> handle.get())).getCause(), (Matcher)CoreMatchers.instanceOf(ManagedLedgerException.BadVersionException.class));
        Assert.assertEquals((Object)ManagedLedgerImpl.State.Fenced, (Object)((ManagedLedgerImpl)ledger).getState());
    }

    @Test
    public void recoverAfterWriteError() throws Exception {
        ManagedLedger ledger = this.factory.open("my_test_ledger");
        ManagedCursor cursor = ledger.openCursor("c1");
        this.bkc.failNow(-8);
        ledger.addEntry("entry-1".getBytes());
        Assert.assertEquals((long)cursor.getNumberOfEntriesInBacklog(false), (long)1L);
        this.bkc.failNow(-8);
        this.metadataStore.failConditional(new MetadataStoreException("err"), (op, path) -> path.equals("/managed-ledgers/my_test_ledger") && op == FaultInjectionMetadataStore.OperationType.PUT);
        try {
            ledger.addEntry("entry-2".getBytes());
            Assert.fail((String)"should fail");
        }
        catch (ManagedLedgerException managedLedgerException) {
            // empty catch block
        }
        this.bkc.failNow(-6);
        try {
            ledger.addEntry("entry-3".getBytes());
            Assert.fail((String)"should fail");
        }
        catch (ManagedLedgerException managedLedgerException) {
            // empty catch block
        }
        Assert.assertEquals((long)cursor.getNumberOfEntriesInBacklog(false), (long)1L);
        ledger.readyToCreateNewLedger();
        ledger.addEntry("entry-4".getBytes());
        Assert.assertEquals((long)cursor.getNumberOfEntriesInBacklog(false), (long)2L);
        List entries = cursor.readEntries(10);
        Assert.assertEquals((int)entries.size(), (int)2);
        Assert.assertEquals((String)new String(((Entry)entries.get(0)).getData()), (String)"entry-1");
        Assert.assertEquals((String)new String(((Entry)entries.get(1)).getData()), (String)"entry-4");
        entries.forEach(Entry::release);
    }

    @Test
    public void recoverLongTimeAfterMultipleWriteErrors() throws Exception {
        ManagedLedgerImpl ledger = (ManagedLedgerImpl)this.factory.open("recoverLongTimeAfterMultipleWriteErrors");
        ManagedCursor cursor = ledger.openCursor("c1");
        LedgerHandle firstLedger = ledger.currentLedger;
        this.bkc.addEntryFailAfter(0, -8);
        this.bkc.addEntryFailAfter(1, -8);
        final CountDownLatch counter = new CountDownLatch(2);
        final AtomicReference ex = new AtomicReference();
        AsyncCallbacks.AddEntryCallback cb = new AsyncCallbacks.AddEntryCallback(){

            public void addComplete(Position position, ByteBuf entryData, Object ctx) {
                counter.countDown();
            }

            public void addFailed(ManagedLedgerException exception, Object ctx) {
                log.warn("Error in write", (Throwable)exception);
                ex.set(exception);
                counter.countDown();
            }
        };
        ledger.asyncAddEntry("entry-1".getBytes(), cb, null);
        ledger.asyncAddEntry("entry-2".getBytes(), cb, null);
        counter.await();
        Assert.assertNull(ex.get());
        Awaitility.await().untilAsserted(() -> {
            try {
                this.bkc.openLedger(firstLedger.getId(), BookKeeper.DigestType.fromApiDigestType((DigestType)ledger.getConfig().getDigestType()), ledger.getConfig().getPassword());
                Assert.fail((String)"The expected behavior is that the first ledger will be deleted, but it still exists.");
            }
            catch (Exception ledgerDeletedEx) {
                Assert.assertTrue((boolean)(ledgerDeletedEx instanceof BKException.BKNoSuchLedgerExistsException));
            }
        });
        Assert.assertEquals((long)cursor.getNumberOfEntriesInBacklog(false), (long)2L);
        Assert.assertEquals((int)ledger.getLedgersInfoAsList().size(), (int)1);
        ledger.addEntry("entry-3".getBytes());
        List entries = cursor.readEntries(10);
        Assert.assertEquals((int)entries.size(), (int)3);
        Assert.assertEquals((String)new String(((Entry)entries.get(0)).getData()), (String)"entry-1");
        Assert.assertEquals((String)new String(((Entry)entries.get(1)).getData()), (String)"entry-2");
        Assert.assertEquals((String)new String(((Entry)entries.get(2)).getData()), (String)"entry-3");
        entries.forEach(Entry::release);
    }

    @Test
    public void recoverAfterMarkDeleteError() throws Exception {
        ManagedLedger ledger = this.factory.open("my_test_ledger");
        ManagedCursor cursor = ledger.openCursor("my-cursor");
        Position position = ledger.addEntry("entry".getBytes());
        Position position1 = ledger.addEntry("entry".getBytes());
        cursor.markDelete(position);
        this.bkc.failNow(-8);
        this.metadataStore.failConditional(new MetadataStoreException("error"), (op, path) -> path.equals("/managed-ledgers/my_test_ledger/my-cursor") && op == FaultInjectionMetadataStore.OperationType.PUT);
        try {
            cursor.markDelete(position1);
            Assert.fail((String)"should fail");
        }
        catch (ManagedLedgerException managedLedgerException) {
            // empty catch block
        }
        Thread.sleep(100L);
        cursor.markDelete(position1);
    }

    @Test
    public void handleCursorRecoveryFailure() throws Exception {
        ManagedLedger ledger = this.factory.open("my_test_ledger");
        ManagedCursor cursor = ledger.openCursor("my-cursor");
        Position p0 = cursor.getMarkDeletedPosition();
        Position p1 = ledger.addEntry("entry-1".getBytes());
        cursor.markDelete(p1);
        ManagedLedgerFactoryImpl factory2 = new ManagedLedgerFactoryImpl((MetadataStoreExtended)this.metadataStore, (BookKeeper)this.bkc);
        this.bkc.failAfter(3, -10);
        ledger = factory2.open("my_test_ledger");
        cursor = ledger.openCursor("my-cursor");
        Assert.assertEquals((Object)cursor.getMarkDeletedPosition(), (Object)p0);
        factory2.shutdown();
    }
}

