/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.mledger.impl;

import com.google.protobuf.InvalidProtocolBufferException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.UUID;
import org.apache.bookkeeper.mledger.MetadataCompressionConfig;
import org.apache.bookkeeper.mledger.impl.MetaStoreImpl;
import org.apache.bookkeeper.mledger.offload.OffloadUtils;
import org.apache.bookkeeper.mledger.proto.MLDataFormats;
import org.apache.commons.lang3.RandomUtils;
import org.apache.pulsar.common.api.proto.CompressionType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.Assert;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class ManagedLedgerInfoMetadataTest {
    private static final Logger log = LoggerFactory.getLogger(ManagedLedgerInfoMetadataTest.class);

    @DataProvider(name="compressionTypeProvider")
    private Object[][] compressionTypeProvider() {
        return new Object[][]{{null}, {"INVALID_TYPE"}, {CompressionType.NONE.name()}, {CompressionType.LZ4.name()}, {CompressionType.ZLIB.name()}, {CompressionType.ZSTD.name()}, {CompressionType.SNAPPY.name()}};
    }

    private MLDataFormats.ManagedLedgerInfo.Builder generateManagedLedgerInfo(long ledgerId, int ledgerInfoNumber) {
        ArrayList<MLDataFormats.ManagedLedgerInfo.LedgerInfo> ledgerInfoList = new ArrayList<MLDataFormats.ManagedLedgerInfo.LedgerInfo>();
        for (int i = 0; i < ledgerInfoNumber; ++i) {
            MLDataFormats.ManagedLedgerInfo.LedgerInfo.Builder builder = MLDataFormats.ManagedLedgerInfo.LedgerInfo.newBuilder();
            builder.setLedgerId(ledgerId);
            builder.setEntries((long)RandomUtils.nextInt());
            builder.setSize(RandomUtils.nextLong());
            builder.setTimestamp(System.currentTimeMillis());
            UUID uuid = UUID.randomUUID();
            builder.getOffloadContextBuilder().setUidMsb(uuid.getMostSignificantBits()).setUidLsb(uuid.getLeastSignificantBits());
            HashMap<String, String> offloadDriverMetadata = new HashMap<String, String>();
            offloadDriverMetadata.put("bucket", "test-bucket");
            offloadDriverMetadata.put("managedLedgerOffloadDriver", "pulsar-offload-dev");
            offloadDriverMetadata.put("serviceEndpoint", "https://s3.eu-west-1.amazonaws.com");
            offloadDriverMetadata.put("region", "eu-west-1");
            OffloadUtils.setOffloadDriverMetadata((MLDataFormats.ManagedLedgerInfo.LedgerInfo.Builder)builder, (String)"aws-s3", offloadDriverMetadata);
            MLDataFormats.ManagedLedgerInfo.LedgerInfo ledgerInfo = builder.build();
            ledgerInfoList.add(ledgerInfo);
            ++ledgerId;
        }
        return MLDataFormats.ManagedLedgerInfo.newBuilder().addAllLedgerInfo(ledgerInfoList);
    }

    @Test(dataProvider="compressionTypeProvider")
    public void testEncodeAndDecode(String compressionType) throws IOException {
        MetaStoreImpl metaStore;
        long ledgerId = 10000L;
        MLDataFormats.ManagedLedgerInfo managedLedgerInfo = this.generateManagedLedgerInfo(ledgerId, 100).build();
        try {
            metaStore = new MetaStoreImpl(null, null, new MetadataCompressionConfig(compressionType), null);
            if ("INVALID_TYPE".equals(compressionType)) {
                Assert.fail((String)"The managedLedgerInfo compression type is invalid, should fail.");
            }
        }
        catch (Exception e) {
            if ("INVALID_TYPE".equals(compressionType)) {
                Assert.assertEquals(e.getClass(), IllegalArgumentException.class);
                Assert.assertEquals((String)("No enum constant org.apache.bookkeeper.mledger.proto.MLDataFormats.CompressionType." + compressionType), (String)e.getMessage());
                return;
            }
            throw e;
        }
        byte[] compressionBytes = metaStore.compressLedgerInfo(managedLedgerInfo);
        log.info("[{}] Uncompressed data size: {}, compressed data size: {}", new Object[]{compressionType, managedLedgerInfo.getSerializedSize(), compressionBytes.length});
        if (compressionType == null || compressionType.equals(CompressionType.NONE.name())) {
            Assert.assertEquals((int)compressionBytes.length, (int)managedLedgerInfo.getSerializedSize());
        }
        MLDataFormats.ManagedLedgerInfo info1 = metaStore.parseManagedLedgerInfo(compressionBytes);
        MLDataFormats.ManagedLedgerInfo info2 = metaStore.parseManagedLedgerInfo(managedLedgerInfo.toByteArray());
        Assert.assertEquals((Object)info1, (Object)info2);
    }

    @Test
    public void testParseEmptyData() throws InvalidProtocolBufferException {
        MetaStoreImpl metaStore = new MetaStoreImpl(null, null);
        MLDataFormats.ManagedLedgerInfo managedLedgerInfo = metaStore.parseManagedLedgerInfo(new byte[0]);
        Assert.assertEquals((String)managedLedgerInfo.toString(), (String)"");
    }

    @Test(dataProvider="compressionTypeProvider")
    public void testCompressionThreshold(String compressionType) {
        MetaStoreImpl metaStore;
        long ledgerId = 10000L;
        int compressThreshold = 512;
        MLDataFormats.ManagedLedgerInfo smallInfo = this.generateManagedLedgerInfo(ledgerId, 0).build();
        Assert.assertTrue((smallInfo.getSerializedSize() < compressThreshold ? 1 : 0) != 0);
        MLDataFormats.ManagedLedgerInfo bigInfo = this.generateManagedLedgerInfo(ledgerId, 1000).build();
        Assert.assertTrue((bigInfo.getSerializedSize() > compressThreshold ? 1 : 0) != 0);
        MLDataFormats.ManagedLedgerInfo managedLedgerInfo = this.generateManagedLedgerInfo(ledgerId, 100).build();
        try {
            MetadataCompressionConfig metadataCompressionConfig = new MetadataCompressionConfig(compressionType, (long)compressThreshold);
            metaStore = new MetaStoreImpl(null, null, metadataCompressionConfig, null);
            if ("INVALID_TYPE".equals(compressionType)) {
                Assert.fail((String)"The managedLedgerInfo compression type is invalid, should fail.");
            }
        }
        catch (Exception e) {
            if ("INVALID_TYPE".equals(compressionType)) {
                Assert.assertEquals(e.getClass(), IllegalArgumentException.class);
                Assert.assertEquals((String)("No enum constant org.apache.bookkeeper.mledger.proto.MLDataFormats.CompressionType." + compressionType), (String)e.getMessage());
                return;
            }
            throw e;
        }
        byte[] compressionBytes = metaStore.compressLedgerInfo(smallInfo);
        Assert.assertEquals((int)compressionBytes.length, (int)smallInfo.getSerializedSize());
        byte[] compressionBytesBig = metaStore.compressLedgerInfo(bigInfo);
        Assert.assertTrue((compressionBytesBig.length != smallInfo.getSerializedSize() ? 1 : 0) != 0);
    }
}

