/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.mledger.impl;

import org.apache.bookkeeper.mledger.impl.PositionImpl;
import org.apache.bookkeeper.mledger.proto.MLDataFormats;
import org.testng.Assert;
import org.testng.annotations.Test;

public class PositionTest {
    @Test(expectedExceptions={NullPointerException.class})
    public void nullParam() {
        new PositionImpl((MLDataFormats.PositionInfo)null);
    }

    @Test
    public void simpleTest() {
        PositionImpl pos = new PositionImpl(1L, 2L);
        Assert.assertEquals((long)pos.getLedgerId(), (long)1L);
        Assert.assertEquals((long)pos.getEntryId(), (long)2L);
        Assert.assertEquals((Object)pos, (Object)new PositionImpl(1L, 2L));
        Assert.assertNotEquals((Object)new PositionImpl(1L, 3L), (Object)pos);
        Assert.assertNotEquals((Object)new PositionImpl(3L, 2L), (Object)pos);
        Assert.assertNotEquals((Object)pos, (Object)"1:2");
    }

    @Test
    public void comparisons() {
        PositionImpl pos1_1 = new PositionImpl(1L, 1L);
        PositionImpl pos2_5 = new PositionImpl(2L, 5L);
        PositionImpl pos10_0 = new PositionImpl(10L, 0L);
        PositionImpl pos10_1 = new PositionImpl(10L, 1L);
        Assert.assertEquals((int)0, (int)pos1_1.compareTo(pos1_1));
        Assert.assertEquals((int)-1, (int)pos1_1.compareTo(pos2_5));
        Assert.assertEquals((int)-1, (int)pos1_1.compareTo(pos10_0));
        Assert.assertEquals((int)-1, (int)pos1_1.compareTo(pos10_1));
        Assert.assertEquals((int)1, (int)pos2_5.compareTo(pos1_1));
        Assert.assertEquals((int)0, (int)pos2_5.compareTo(pos2_5));
        Assert.assertEquals((int)-1, (int)pos2_5.compareTo(pos10_0));
        Assert.assertEquals((int)-1, (int)pos2_5.compareTo(pos10_1));
        Assert.assertEquals((int)1, (int)pos10_0.compareTo(pos1_1));
        Assert.assertEquals((int)1, (int)pos10_0.compareTo(pos2_5));
        Assert.assertEquals((int)0, (int)pos10_0.compareTo(pos10_0));
        Assert.assertEquals((int)-1, (int)pos10_0.compareTo(pos10_1));
        Assert.assertEquals((int)1, (int)pos10_1.compareTo(pos1_1));
        Assert.assertEquals((int)1, (int)pos10_1.compareTo(pos2_5));
        Assert.assertEquals((int)1, (int)pos10_1.compareTo(pos10_0));
        Assert.assertEquals((int)0, (int)pos10_1.compareTo(pos10_1));
    }

    @Test
    public void hashes() throws Exception {
        PositionImpl p1 = new PositionImpl(5L, 15L);
        PositionImpl p2 = new PositionImpl(MLDataFormats.PositionInfo.parseFrom((byte[])p1.getPositionInfo().toByteArray()));
        Assert.assertEquals((long)p2.getLedgerId(), (long)5L);
        Assert.assertEquals((long)p2.getEntryId(), (long)15L);
        Assert.assertEquals((int)new PositionImpl(5L, 15L).hashCode(), (int)p2.hashCode());
    }
}

