/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.mledger.impl;

import com.google.common.collect.BoundType;
import com.google.common.collect.Range;
import com.google.common.collect.TreeRangeSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.bookkeeper.mledger.ManagedLedgerConfig;
import org.apache.bookkeeper.mledger.impl.ManagedCursorImpl;
import org.apache.bookkeeper.mledger.impl.ManagedLedgerImpl;
import org.apache.bookkeeper.mledger.impl.RangeSetWrapper;
import org.apache.pulsar.common.util.collections.LongPairRangeSet;
import org.mockito.Mockito;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class RangeSetWrapperTest {
    static final LongPairRangeSet.LongPairConsumer<LongPairRangeSet.LongPair> consumer = (key, value) -> new LongPairRangeSet.LongPair(key, value);
    static final LongPairRangeSet.RangeBoundConsumer<LongPairRangeSet.LongPair> reverseConvert = pair -> pair;
    ManagedLedgerImpl managedLedger;
    RangeSetWrapper<LongPairRangeSet.LongPair> set;
    ManagedLedgerConfig managedLedgerConfig;
    ManagedCursorImpl managedCursor;

    @BeforeMethod
    public void setUp() {
        this.initManagedLedgerConfig();
        this.managedLedger = (ManagedLedgerImpl)Mockito.mock(ManagedLedgerImpl.class);
        this.managedCursor = (ManagedCursorImpl)Mockito.mock(ManagedCursorImpl.class);
        ((ManagedLedgerImpl)Mockito.doReturn((Object)this.managedLedgerConfig).when((Object)this.managedLedger)).getConfig();
        ((ManagedCursorImpl)Mockito.doReturn((Object)this.managedLedgerConfig).when((Object)this.managedCursor)).getConfig();
        ((ManagedCursorImpl)Mockito.doReturn((Object)this.managedLedger).when((Object)this.managedCursor)).getManagedLedger();
    }

    private void initManagedLedgerConfig() {
        this.managedLedgerConfig = new ManagedLedgerConfig();
        this.managedLedgerConfig.setUnackedRangesOpenCacheSetEnabled(true);
        this.managedLedgerConfig.setPersistentUnackedRangesWithMultipleEntriesEnabled(true);
    }

    @AfterMethod
    public void clean() throws Exception {
    }

    @Test
    public void testDirtyLedger() {
        long i;
        RangeSetWrapper rangeSetWrapper = new RangeSetWrapper(consumer, reverseConvert, this.managedCursor);
        rangeSetWrapper.addOpenClosed(10L, 0L, 20L, 0L);
        Assert.assertEquals((int)rangeSetWrapper.size(), (int)1);
        Assert.assertFalse((boolean)rangeSetWrapper.isDirtyLedgers(10L));
        for (i = 11L; i < 20L; ++i) {
            Assert.assertTrue((boolean)rangeSetWrapper.isDirtyLedgers(i));
        }
        rangeSetWrapper.removeAtMost(11L, 0L);
        Assert.assertEquals((int)rangeSetWrapper.size(), (int)1);
        Assert.assertFalse((boolean)rangeSetWrapper.isDirtyLedgers(11L));
        for (i = 12L; i < 20L; ++i) {
            Assert.assertTrue((boolean)rangeSetWrapper.isDirtyLedgers(i));
        }
    }

    @Test
    public void testAddForSameKey() {
        this.doTestAddForSameKey();
        this.managedLedgerConfig.setUnackedRangesOpenCacheSetEnabled(false);
        this.doTestAddForSameKey();
    }

    private void doTestAddForSameKey() {
        this.set = new RangeSetWrapper(consumer, reverseConvert, this.managedCursor);
        this.set.addOpenClosed(0L, 0L, 0L, 5L);
        this.set.addOpenClosed(0L, 8L, 0L, 8L);
        this.set.addOpenClosed(0L, 9L, 0L, 9L);
        this.set.addOpenClosed(0L, 10L, 0L, 10L);
        this.set.addOpenClosed(0L, 98L, 0L, 99L);
        this.set.addOpenClosed(0L, 102L, 0L, 106L);
        ArrayList ranges = new ArrayList(this.set.asRanges());
        int count = 0;
        Assert.assertEquals(ranges.get(count++), (Object)Range.openClosed((Comparable)new LongPairRangeSet.LongPair(0L, 0L), (Comparable)new LongPairRangeSet.LongPair(0L, 5L)));
        Assert.assertEquals(ranges.get(count++), (Object)Range.openClosed((Comparable)new LongPairRangeSet.LongPair(0L, 98L), (Comparable)new LongPairRangeSet.LongPair(0L, 99L)));
        Assert.assertEquals(ranges.get(count), (Object)Range.openClosed((Comparable)new LongPairRangeSet.LongPair(0L, 102L), (Comparable)new LongPairRangeSet.LongPair(0L, 106L)));
    }

    @Test
    public void testAddForDifferentKey() {
        this.set = new RangeSetWrapper(consumer, reverseConvert, this.managedCursor);
        this.set.addOpenClosed(0L, 98L, 0L, 99L);
        this.set.addOpenClosed(0L, 100L, 1L, 5L);
        this.set.addOpenClosed(1L, 10L, 1L, 15L);
        this.set.addOpenClosed(1L, 20L, 2L, 10L);
        ArrayList ranges = new ArrayList(this.set.asRanges());
        int count = 0;
        Assert.assertEquals(ranges.get(count++), (Object)Range.openClosed((Comparable)new LongPairRangeSet.LongPair(0L, 98L), (Comparable)new LongPairRangeSet.LongPair(0L, 99L)));
        Assert.assertEquals(ranges.get(count++), (Object)Range.openClosed((Comparable)new LongPairRangeSet.LongPair(1L, -1L), (Comparable)new LongPairRangeSet.LongPair(1L, 5L)));
        Assert.assertEquals(ranges.get(count++), (Object)Range.openClosed((Comparable)new LongPairRangeSet.LongPair(1L, 10L), (Comparable)new LongPairRangeSet.LongPair(1L, 15L)));
        Assert.assertEquals(ranges.get(count), (Object)Range.openClosed((Comparable)new LongPairRangeSet.LongPair(2L, -1L), (Comparable)new LongPairRangeSet.LongPair(2L, 10L)));
    }

    @Test
    public void testAddForDifferentKey2() {
        this.managedLedgerConfig.setUnackedRangesOpenCacheSetEnabled(false);
        this.set = new RangeSetWrapper(consumer, reverseConvert, this.managedCursor);
        this.set.addOpenClosed(0L, 98L, 0L, 99L);
        this.set.addOpenClosed(0L, 100L, 1L, 5L);
        this.set.addOpenClosed(1L, 10L, 1L, 15L);
        this.set.addOpenClosed(1L, 20L, 2L, 10L);
        ArrayList ranges = new ArrayList(this.set.asRanges());
        int count = 0;
        Assert.assertEquals(ranges.get(count++), (Object)Range.openClosed((Comparable)new LongPairRangeSet.LongPair(0L, 98L), (Comparable)new LongPairRangeSet.LongPair(0L, 99L)));
        Assert.assertEquals(ranges.get(count++), (Object)Range.openClosed((Comparable)new LongPairRangeSet.LongPair(0L, 100L), (Comparable)new LongPairRangeSet.LongPair(1L, 5L)));
        Assert.assertEquals(ranges.get(count++), (Object)Range.openClosed((Comparable)new LongPairRangeSet.LongPair(1L, 10L), (Comparable)new LongPairRangeSet.LongPair(1L, 15L)));
        Assert.assertEquals(ranges.get(count++), (Object)Range.openClosed((Comparable)new LongPairRangeSet.LongPair(1L, 20L), (Comparable)new LongPairRangeSet.LongPair(2L, 10L)));
    }

    @Test
    public void testAddCompareCompareWithGuava() {
        LongPairRangeSet.LongPair upper;
        LongPairRangeSet.LongPair lower;
        int i;
        this.set = new RangeSetWrapper(consumer, reverseConvert, this.managedCursor);
        TreeRangeSet gSet = TreeRangeSet.create();
        int totalInsert = 10000;
        for (i = 0; i < totalInsert; ++i) {
            if (i % 3 != 0 && i % 6 != 0 && i % 8 != 0) continue;
            lower = new LongPairRangeSet.LongPair(0L, (long)(i - 1));
            upper = new LongPairRangeSet.LongPair(0L, (long)i);
            this.set.addOpenClosed(lower.getKey(), lower.getValue(), upper.getKey(), upper.getValue());
            gSet.add(Range.openClosed((Comparable)lower, (Comparable)upper));
        }
        for (i = totalInsert; i < totalInsert * 2; ++i) {
            if (i % 5 != 0) continue;
            lower = new LongPairRangeSet.LongPair(0L, (long)(i - 3 - 1));
            upper = new LongPairRangeSet.LongPair(0L, (long)(i + 3));
            this.set.addOpenClosed(lower.getKey(), lower.getValue(), upper.getKey(), upper.getValue());
            gSet.add(Range.openClosed((Comparable)lower, (Comparable)upper));
        }
        ArrayList ranges = new ArrayList(this.set.asRanges());
        Set gRanges = gSet.asRanges();
        List<Range<LongPairRangeSet.LongPair>> gRangeConnected = this.getConnectedRange(gRanges);
        Assert.assertEquals((int)gRangeConnected.size(), (int)ranges.size());
        int i2 = 0;
        for (Range<LongPairRangeSet.LongPair> range : gRangeConnected) {
            Assert.assertEquals(range, ranges.get(i2));
            ++i2;
        }
    }

    @Test
    public void testDeleteCompareWithGuava() throws Exception {
        Range range;
        LongPairRangeSet.LongPair upper;
        LongPairRangeSet.LongPair lower;
        int i;
        RangeSetWrapper set = new RangeSetWrapper(consumer, reverseConvert, this.managedCursor);
        TreeRangeSet gSet = TreeRangeSet.create();
        int totalInsert = 10000;
        ArrayList<Range> removedRanges = new ArrayList<Range>();
        for (i = 0; i < totalInsert; ++i) {
            if (i % 3 == 0 || i % 7 == 0 || i % 11 == 0) continue;
            lower = new LongPairRangeSet.LongPair(0L, (long)(i - 1));
            upper = new LongPairRangeSet.LongPair(0L, (long)i);
            range = Range.openClosed((Comparable)lower, (Comparable)upper);
            set.addOpenClosed(lower.getKey(), lower.getValue(), upper.getKey(), upper.getValue());
            gSet.add(range);
            if (i % 4 != 0) continue;
            removedRanges.add(range);
        }
        for (i = totalInsert; i < totalInsert * 2; ++i) {
            lower = new LongPairRangeSet.LongPair(0L, (long)(i - 3 - 1));
            upper = new LongPairRangeSet.LongPair(0L, (long)(i + 3));
            range = Range.openClosed((Comparable)lower, (Comparable)upper);
            if (i % 5 != 0) {
                set.addOpenClosed(lower.getKey(), lower.getValue(), upper.getKey(), upper.getValue());
                gSet.add(range);
            }
            if (i % 4 != 0) continue;
            removedRanges.add(range);
        }
        for (Range range2 : removedRanges) {
            set.remove(range2);
            gSet.remove(range2);
        }
        ArrayList ranges = new ArrayList(set.asRanges());
        Set gRanges = gSet.asRanges();
        List<Range<LongPairRangeSet.LongPair>> gRangeConnected = this.getConnectedRange(gRanges);
        Assert.assertEquals((int)gRangeConnected.size(), (int)ranges.size());
        int i2 = 0;
        for (Range<LongPairRangeSet.LongPair> range3 : gRangeConnected) {
            Assert.assertEquals(range3, ranges.get(i2));
            ++i2;
        }
    }

    @Test
    public void testSpanWithGuava() {
        this.set = new RangeSetWrapper(consumer, reverseConvert, this.managedCursor);
        TreeRangeSet gSet = TreeRangeSet.create();
        this.set.addOpenClosed(0L, 97L, 0L, 99L);
        gSet.add(Range.openClosed((Comparable)new LongPairRangeSet.LongPair(0L, 97L), (Comparable)new LongPairRangeSet.LongPair(0L, 99L)));
        this.set.addOpenClosed(0L, 99L, 1L, 5L);
        gSet.add(Range.openClosed((Comparable)new LongPairRangeSet.LongPair(0L, 99L), (Comparable)new LongPairRangeSet.LongPair(1L, 5L)));
        Assert.assertEquals((Object)this.set.span(), (Object)gSet.span());
        Assert.assertEquals((Object)this.set.span(), (Object)Range.openClosed((Comparable)new LongPairRangeSet.LongPair(0L, 97L), (Comparable)new LongPairRangeSet.LongPair(1L, 5L)));
        this.set.addOpenClosed(1L, 9L, 1L, 15L);
        this.set.addOpenClosed(1L, 19L, 2L, 10L);
        this.set.addOpenClosed(2L, 24L, 2L, 28L);
        this.set.addOpenClosed(3L, 11L, 3L, 20L);
        this.set.addOpenClosed(4L, 11L, 4L, 20L);
        gSet.add(Range.openClosed((Comparable)new LongPairRangeSet.LongPair(1L, 9L), (Comparable)new LongPairRangeSet.LongPair(1L, 15L)));
        gSet.add(Range.openClosed((Comparable)new LongPairRangeSet.LongPair(1L, 19L), (Comparable)new LongPairRangeSet.LongPair(2L, 10L)));
        gSet.add(Range.openClosed((Comparable)new LongPairRangeSet.LongPair(2L, 24L), (Comparable)new LongPairRangeSet.LongPair(2L, 28L)));
        gSet.add(Range.openClosed((Comparable)new LongPairRangeSet.LongPair(3L, 11L), (Comparable)new LongPairRangeSet.LongPair(3L, 20L)));
        gSet.add(Range.openClosed((Comparable)new LongPairRangeSet.LongPair(4L, 11L), (Comparable)new LongPairRangeSet.LongPair(4L, 20L)));
        Assert.assertEquals((Object)this.set.span(), (Object)gSet.span());
        Assert.assertEquals((Object)this.set.span(), (Object)Range.openClosed((Comparable)new LongPairRangeSet.LongPair(0L, 97L), (Comparable)new LongPairRangeSet.LongPair(4L, 20L)));
    }

    @Test
    public void testFirstRange() {
        this.set = new RangeSetWrapper(consumer, reverseConvert, this.managedCursor);
        Assert.assertNull((Object)this.set.firstRange());
        this.set.addOpenClosed(0L, 97L, 0L, 99L);
        Assert.assertEquals((Object)this.set.firstRange(), (Object)Range.openClosed((Comparable)new LongPairRangeSet.LongPair(0L, 97L), (Comparable)new LongPairRangeSet.LongPair(0L, 99L)));
        Assert.assertEquals((int)this.set.size(), (int)1);
        this.set.addOpenClosed(0L, 98L, 0L, 105L);
        Assert.assertEquals((Object)this.set.firstRange(), (Object)Range.openClosed((Comparable)new LongPairRangeSet.LongPair(0L, 97L), (Comparable)new LongPairRangeSet.LongPair(0L, 105L)));
        Assert.assertEquals((int)this.set.size(), (int)1);
        this.set.addOpenClosed(0L, 5L, 0L, 75L);
        Assert.assertEquals((Object)this.set.firstRange(), (Object)Range.openClosed((Comparable)new LongPairRangeSet.LongPair(0L, 5L), (Comparable)new LongPairRangeSet.LongPair(0L, 75L)));
        Assert.assertEquals((int)this.set.size(), (int)2);
    }

    @Test
    public void testLastRange() {
        this.set = new RangeSetWrapper(consumer, reverseConvert, this.managedCursor);
        Assert.assertNull((Object)this.set.lastRange());
        Range range = Range.openClosed((Comparable)new LongPairRangeSet.LongPair(0L, 97L), (Comparable)new LongPairRangeSet.LongPair(0L, 99L));
        this.set.addOpenClosed(0L, 97L, 0L, 99L);
        Assert.assertEquals((Object)this.set.lastRange(), (Object)range);
        Assert.assertEquals((int)this.set.size(), (int)1);
        this.set.addOpenClosed(0L, 98L, 0L, 105L);
        Assert.assertEquals((Object)this.set.lastRange(), (Object)Range.openClosed((Comparable)new LongPairRangeSet.LongPair(0L, 97L), (Comparable)new LongPairRangeSet.LongPair(0L, 105L)));
        Assert.assertEquals((int)this.set.size(), (int)1);
        range = Range.openClosed((Comparable)new LongPairRangeSet.LongPair(1L, 5L), (Comparable)new LongPairRangeSet.LongPair(1L, 75L));
        this.set.addOpenClosed(1L, 5L, 1L, 75L);
        Assert.assertEquals((Object)this.set.lastRange(), (Object)range);
        Assert.assertEquals((int)this.set.size(), (int)2);
        range = Range.openClosed((Comparable)new LongPairRangeSet.LongPair(1L, 80L), (Comparable)new LongPairRangeSet.LongPair(1L, 120L));
        this.set.addOpenClosed(1L, 80L, 1L, 120L);
        Assert.assertEquals((Object)this.set.lastRange(), (Object)range);
        Assert.assertEquals((int)this.set.size(), (int)3);
    }

    @Test
    public void testToString() {
        this.set = new RangeSetWrapper(consumer, reverseConvert, this.managedCursor);
        this.set.addOpenClosed(0L, 97L, 0L, 99L);
        Assert.assertEquals((String)this.set.toString(), (String)"[(0:97..0:99]]");
        this.set.addOpenClosed(0L, 98L, 0L, 105L);
        Assert.assertEquals((String)this.set.toString(), (String)"[(0:97..0:105]]");
        this.set.addOpenClosed(0L, 5L, 0L, 75L);
        Assert.assertEquals((String)this.set.toString(), (String)"[(0:5..0:75],(0:97..0:105]]");
    }

    @Test
    public void testDeleteForDifferentKey() {
        this.set = new RangeSetWrapper(consumer, reverseConvert, this.managedCursor);
        this.set.addOpenClosed(0L, 97L, 0L, 99L);
        this.set.addOpenClosed(0L, 99L, 1L, 5L);
        this.set.addOpenClosed(1L, 9L, 1L, 15L);
        this.set.addOpenClosed(1L, 19L, 2L, 10L);
        this.set.addOpenClosed(2L, 24L, 2L, 28L);
        this.set.addOpenClosed(3L, 11L, 3L, 20L);
        this.set.addOpenClosed(4L, 11L, 4L, 20L);
        this.set.remove(Range.open((Comparable)new LongPairRangeSet.LongPair(0L, 99L), (Comparable)new LongPairRangeSet.LongPair(0L, 105L)));
        this.set.remove(Range.closed((Comparable)new LongPairRangeSet.LongPair(2L, 27L), (Comparable)new LongPairRangeSet.LongPair(4L, 15L)));
        ArrayList ranges = new ArrayList(this.set.asRanges());
        int count = 0;
        Assert.assertEquals(ranges.get(count++), (Object)Range.openClosed((Comparable)new LongPairRangeSet.LongPair(0L, 97L), (Comparable)new LongPairRangeSet.LongPair(0L, 99L)));
        Assert.assertEquals(ranges.get(count++), (Object)Range.openClosed((Comparable)new LongPairRangeSet.LongPair(1L, -1L), (Comparable)new LongPairRangeSet.LongPair(1L, 5L)));
        Assert.assertEquals(ranges.get(count++), (Object)Range.openClosed((Comparable)new LongPairRangeSet.LongPair(1L, 9L), (Comparable)new LongPairRangeSet.LongPair(1L, 15L)));
        Assert.assertEquals(ranges.get(count++), (Object)Range.openClosed((Comparable)new LongPairRangeSet.LongPair(2L, -1L), (Comparable)new LongPairRangeSet.LongPair(2L, 10L)));
        Assert.assertEquals(ranges.get(count++), (Object)Range.openClosed((Comparable)new LongPairRangeSet.LongPair(2L, 24L), (Comparable)new LongPairRangeSet.LongPair(2L, 26L)));
        Assert.assertEquals(ranges.get(count++), (Object)Range.openClosed((Comparable)new LongPairRangeSet.LongPair(2L, 27L), (Comparable)new LongPairRangeSet.LongPair(2L, 28L)));
        Assert.assertEquals(ranges.get(count++), (Object)Range.openClosed((Comparable)new LongPairRangeSet.LongPair(4L, 15L), (Comparable)new LongPairRangeSet.LongPair(4L, 20L)));
    }

    @Test
    public void testDeleteWithAtMost() {
        this.set = new RangeSetWrapper(consumer, reverseConvert, this.managedCursor);
        this.set.addOpenClosed(0L, 98L, 0L, 99L);
        this.set.addOpenClosed(0L, 100L, 1L, 5L);
        this.set.addOpenClosed(1L, 10L, 1L, 15L);
        this.set.addOpenClosed(1L, 20L, 2L, 10L);
        this.set.addOpenClosed(2L, 25L, 2L, 28L);
        this.set.addOpenClosed(3L, 12L, 3L, 20L);
        this.set.addOpenClosed(4L, 12L, 4L, 20L);
        this.set.remove(Range.open((Comparable)new LongPairRangeSet.LongPair(0L, 99L), (Comparable)new LongPairRangeSet.LongPair(0L, 105L)));
        this.set.remove(Range.atMost((Comparable)new LongPairRangeSet.LongPair(2L, 27L)));
        ArrayList ranges = new ArrayList(this.set.asRanges());
        int count = 0;
        Assert.assertEquals(ranges.get(count++), (Object)Range.openClosed((Comparable)new LongPairRangeSet.LongPair(2L, 27L), (Comparable)new LongPairRangeSet.LongPair(2L, 28L)));
        Assert.assertEquals(ranges.get(count++), (Object)Range.openClosed((Comparable)new LongPairRangeSet.LongPair(3L, 12L), (Comparable)new LongPairRangeSet.LongPair(3L, 20L)));
        Assert.assertEquals(ranges.get(count++), (Object)Range.openClosed((Comparable)new LongPairRangeSet.LongPair(4L, 12L), (Comparable)new LongPairRangeSet.LongPair(4L, 20L)));
    }

    @Test
    public void testDeleteWithAtMost2() {
        this.set = new RangeSetWrapper(consumer, reverseConvert, this.managedCursor);
        this.set.addOpenClosed(0L, 98L, 0L, 99L);
        this.set.addOpenClosed(0L, 100L, 1L, 5L);
        this.set.addOpenClosed(1L, 10L, 1L, 15L);
        this.set.addOpenClosed(1L, 20L, 2L, 10L);
        this.set.addOpenClosed(2L, 25L, 2L, 28L);
        this.set.addOpenClosed(3L, 12L, 3L, 20L);
        this.set.addOpenClosed(4L, 12L, 4L, 20L);
        this.set.remove(Range.closed((Comparable)new LongPairRangeSet.LongPair(0L, 0L), (Comparable)new LongPairRangeSet.LongPair(0L, 0x7FFFFFFEL)));
        ArrayList ranges = new ArrayList(this.set.asRanges());
        int count = 0;
        Assert.assertEquals(ranges.get(count++), (Object)Range.openClosed((Comparable)new LongPairRangeSet.LongPair(1L, -1L), (Comparable)new LongPairRangeSet.LongPair(1L, 5L)));
        Assert.assertEquals(ranges.get(count++), (Object)Range.openClosed((Comparable)new LongPairRangeSet.LongPair(1L, 10L), (Comparable)new LongPairRangeSet.LongPair(1L, 15L)));
        Assert.assertEquals(ranges.get(count++), (Object)Range.openClosed((Comparable)new LongPairRangeSet.LongPair(2L, -1L), (Comparable)new LongPairRangeSet.LongPair(2L, 10L)));
        Assert.assertEquals(ranges.get(count), (Object)Range.openClosed((Comparable)new LongPairRangeSet.LongPair(2L, 25L), (Comparable)new LongPairRangeSet.LongPair(2L, 28L)));
        this.managedLedgerConfig.setUnackedRangesOpenCacheSetEnabled(false);
        this.set = new RangeSetWrapper(consumer, reverseConvert, this.managedCursor);
        this.set.addOpenClosed(0L, 98L, 0L, 99L);
        this.set.addOpenClosed(0L, 100L, 1L, 5L);
        this.set.addOpenClosed(1L, 10L, 1L, 15L);
        this.set.addOpenClosed(1L, 20L, 2L, 10L);
        this.set.addOpenClosed(2L, 25L, 2L, 28L);
        this.set.addOpenClosed(3L, 12L, 3L, 20L);
        this.set.addOpenClosed(4L, 12L, 4L, 20L);
        this.set.remove(Range.openClosed((Comparable)new LongPairRangeSet.LongPair(0L, 0L), (Comparable)new LongPairRangeSet.LongPair(0L, 0x7FFFFFFEL)));
        ranges = new ArrayList(this.set.asRanges());
        count = 0;
        Assert.assertEquals(ranges.get(count++), (Object)Range.openClosed((Comparable)new LongPairRangeSet.LongPair(0L, 0x7FFFFFFEL), (Comparable)new LongPairRangeSet.LongPair(1L, 5L)));
        Assert.assertEquals(ranges.get(count++), (Object)Range.openClosed((Comparable)new LongPairRangeSet.LongPair(1L, 10L), (Comparable)new LongPairRangeSet.LongPair(1L, 15L)));
        Assert.assertEquals(ranges.get(count++), (Object)Range.openClosed((Comparable)new LongPairRangeSet.LongPair(1L, 20L), (Comparable)new LongPairRangeSet.LongPair(2L, 10L)));
        Assert.assertEquals(ranges.get(count), (Object)Range.openClosed((Comparable)new LongPairRangeSet.LongPair(2L, 25L), (Comparable)new LongPairRangeSet.LongPair(2L, 28L)));
    }

    @Test
    public void testDeleteWithLeastMost() {
        this.set = new RangeSetWrapper(consumer, reverseConvert, this.managedCursor);
        this.set.addOpenClosed(0L, 98L, 0L, 99L);
        this.set.addOpenClosed(0L, 100L, 1L, 5L);
        this.set.addOpenClosed(1L, 10L, 1L, 15L);
        this.set.addOpenClosed(1L, 20L, 2L, 10L);
        this.set.addOpenClosed(2L, 25L, 2L, 28L);
        this.set.addOpenClosed(2L, 12L, 3L, 20L);
        this.set.addOpenClosed(4L, 12L, 4L, 20L);
        this.set.remove(Range.open((Comparable)new LongPairRangeSet.LongPair(0L, 99L), (Comparable)new LongPairRangeSet.LongPair(0L, 105L)));
        this.set.remove(Range.atLeast((Comparable)new LongPairRangeSet.LongPair(2L, 27L)));
        ArrayList ranges = new ArrayList(this.set.asRanges());
        int count = 0;
        Assert.assertEquals(ranges.get(count++), (Object)Range.openClosed((Comparable)new LongPairRangeSet.LongPair(0L, 98L), (Comparable)new LongPairRangeSet.LongPair(0L, 99L)));
        Assert.assertEquals(ranges.get(count++), (Object)Range.openClosed((Comparable)new LongPairRangeSet.LongPair(1L, -1L), (Comparable)new LongPairRangeSet.LongPair(1L, 5L)));
        Assert.assertEquals(ranges.get(count++), (Object)Range.openClosed((Comparable)new LongPairRangeSet.LongPair(1L, 10L), (Comparable)new LongPairRangeSet.LongPair(1L, 15L)));
        Assert.assertEquals(ranges.get(count++), (Object)Range.openClosed((Comparable)new LongPairRangeSet.LongPair(2L, -1L), (Comparable)new LongPairRangeSet.LongPair(2L, 10L)));
        Assert.assertEquals(ranges.get(count), (Object)Range.openClosed((Comparable)new LongPairRangeSet.LongPair(2L, 12L), (Comparable)new LongPairRangeSet.LongPair(2L, 26L)));
    }

    @Test
    public void testRangeContaining() {
        this.set = new RangeSetWrapper(consumer, reverseConvert, this.managedCursor);
        this.set.add(Range.closed((Comparable)new LongPairRangeSet.LongPair(0L, 98L), (Comparable)new LongPairRangeSet.LongPair(0L, 99L)));
        this.set.add(Range.closed((Comparable)new LongPairRangeSet.LongPair(0L, 100L), (Comparable)new LongPairRangeSet.LongPair(1L, 5L)));
        TreeRangeSet gSet = TreeRangeSet.create();
        gSet.add(Range.closed((Comparable)new LongPairRangeSet.LongPair(0L, 98L), (Comparable)new LongPairRangeSet.LongPair(0L, 100L)));
        gSet.add(Range.closed((Comparable)new LongPairRangeSet.LongPair(0L, 101L), (Comparable)new LongPairRangeSet.LongPair(1L, 5L)));
        this.set.add(Range.closed((Comparable)new LongPairRangeSet.LongPair(1L, 10L), (Comparable)new LongPairRangeSet.LongPair(1L, 15L)));
        this.set.add(Range.closed((Comparable)new LongPairRangeSet.LongPair(1L, 20L), (Comparable)new LongPairRangeSet.LongPair(2L, 10L)));
        this.set.add(Range.closed((Comparable)new LongPairRangeSet.LongPair(2L, 25L), (Comparable)new LongPairRangeSet.LongPair(2L, 28L)));
        this.set.add(Range.closed((Comparable)new LongPairRangeSet.LongPair(3L, 12L), (Comparable)new LongPairRangeSet.LongPair(3L, 20L)));
        this.set.add(Range.closed((Comparable)new LongPairRangeSet.LongPair(4L, 12L), (Comparable)new LongPairRangeSet.LongPair(4L, 20L)));
        gSet.add(Range.closed((Comparable)new LongPairRangeSet.LongPair(1L, 10L), (Comparable)new LongPairRangeSet.LongPair(1L, 15L)));
        gSet.add(Range.closed((Comparable)new LongPairRangeSet.LongPair(1L, 20L), (Comparable)new LongPairRangeSet.LongPair(2L, 10L)));
        gSet.add(Range.closed((Comparable)new LongPairRangeSet.LongPair(2L, 25L), (Comparable)new LongPairRangeSet.LongPair(2L, 28L)));
        gSet.add(Range.closed((Comparable)new LongPairRangeSet.LongPair(3L, 12L), (Comparable)new LongPairRangeSet.LongPair(3L, 20L)));
        gSet.add(Range.closed((Comparable)new LongPairRangeSet.LongPair(4L, 12L), (Comparable)new LongPairRangeSet.LongPair(4L, 20L)));
        LongPairRangeSet.LongPair position = new LongPairRangeSet.LongPair(0L, 99L);
        Assert.assertEquals((Object)this.set.rangeContaining(position.getKey(), position.getValue()), (Object)Range.closed((Comparable)new LongPairRangeSet.LongPair(0L, 98L), (Comparable)new LongPairRangeSet.LongPair(0L, 100L)));
        Assert.assertEquals((Object)this.set.rangeContaining(position.getKey(), position.getValue()), (Object)gSet.rangeContaining((Comparable)position));
        position = new LongPairRangeSet.LongPair(2L, 30L);
        Assert.assertNull((Object)this.set.rangeContaining(position.getKey(), position.getValue()));
        Assert.assertEquals((Object)this.set.rangeContaining(position.getKey(), position.getValue()), (Object)gSet.rangeContaining((Comparable)position));
        position = new LongPairRangeSet.LongPair(3L, 13L);
        Assert.assertEquals((Object)this.set.rangeContaining(position.getKey(), position.getValue()), (Object)Range.closed((Comparable)new LongPairRangeSet.LongPair(3L, 12L), (Comparable)new LongPairRangeSet.LongPair(3L, 20L)));
        Assert.assertEquals((Object)this.set.rangeContaining(position.getKey(), position.getValue()), (Object)gSet.rangeContaining((Comparable)position));
        position = new LongPairRangeSet.LongPair(3L, 22L);
        Assert.assertNull((Object)this.set.rangeContaining(position.getKey(), position.getValue()));
        Assert.assertEquals((Object)this.set.rangeContaining(position.getKey(), position.getValue()), (Object)gSet.rangeContaining((Comparable)position));
    }

    private List<Range<LongPairRangeSet.LongPair>> getConnectedRange(Set<Range<LongPairRangeSet.LongPair>> gRanges) {
        ArrayList<Range<LongPairRangeSet.LongPair>> gRangeConnected = new ArrayList<Range<LongPairRangeSet.LongPair>>();
        Range lastRange = null;
        for (Range range : gRanges) {
            boolean connected;
            if (lastRange == null) {
                lastRange = range;
                continue;
            }
            LongPairRangeSet.LongPair previousUpper = (LongPairRangeSet.LongPair)lastRange.upperEndpoint();
            LongPairRangeSet.LongPair currentLower = (LongPairRangeSet.LongPair)range.lowerEndpoint();
            int previousUpperValue = (int)(lastRange.upperBoundType().equals((Object)BoundType.CLOSED) ? previousUpper.getValue() : previousUpper.getValue() - 1L);
            int currentLowerValue = (int)(range.lowerBoundType().equals((Object)BoundType.CLOSED) ? currentLower.getValue() : currentLower.getValue() + 1L);
            boolean bl = connected = previousUpper.getKey() == currentLower.getKey() && previousUpperValue >= currentLowerValue;
            if (connected) {
                lastRange = Range.closed((Comparable)((LongPairRangeSet.LongPair)lastRange.lowerEndpoint()), (Comparable)((LongPairRangeSet.LongPair)range.upperEndpoint()));
                continue;
            }
            gRangeConnected.add((Range<LongPairRangeSet.LongPair>)lastRange);
            lastRange = range;
        }
        int lowerOpenValue = (int)(lastRange.lowerBoundType().equals((Object)BoundType.CLOSED) ? ((LongPairRangeSet.LongPair)lastRange.lowerEndpoint()).getValue() - 1L : ((LongPairRangeSet.LongPair)lastRange.lowerEndpoint()).getValue());
        lastRange = Range.openClosed((Comparable)new LongPairRangeSet.LongPair(((LongPairRangeSet.LongPair)lastRange.lowerEndpoint()).getKey(), (long)lowerOpenValue), (Comparable)((LongPairRangeSet.LongPair)lastRange.upperEndpoint()));
        gRangeConnected.add(lastRange);
        return gRangeConnected;
    }
}

