/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.mledger.impl.cache;

import org.apache.bookkeeper.mledger.impl.cache.InflightReadsLimiter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.Assert;
import org.testng.annotations.Test;

public class InflightReadsLimiterTest {
    private static final Logger log = LoggerFactory.getLogger(InflightReadsLimiterTest.class);

    @Test
    public void testDisabled() throws Exception {
        InflightReadsLimiter limiter = new InflightReadsLimiter(0L);
        Assert.assertTrue((boolean)limiter.isDisabled());
        limiter = new InflightReadsLimiter(-1L);
        Assert.assertTrue((boolean)limiter.isDisabled());
        limiter = new InflightReadsLimiter(1L);
        Assert.assertFalse((boolean)limiter.isDisabled());
    }

    @Test
    public void testBasicAcquireRelease() throws Exception {
        InflightReadsLimiter limiter = new InflightReadsLimiter(100L);
        Assert.assertEquals((long)100L, (long)limiter.getRemainingBytes());
        InflightReadsLimiter.Handle handle = limiter.acquire(100L, null);
        Assert.assertEquals((long)0L, (long)limiter.getRemainingBytes());
        Assert.assertTrue((boolean)handle.success);
        Assert.assertEquals((long)handle.acquiredPermits, (long)100L);
        Assert.assertEquals((int)1, (int)handle.trials);
        limiter.release(handle);
        Assert.assertEquals((long)100L, (long)limiter.getRemainingBytes());
    }

    @Test
    public void testNotEnoughPermits() throws Exception {
        InflightReadsLimiter limiter = new InflightReadsLimiter(100L);
        Assert.assertEquals((long)100L, (long)limiter.getRemainingBytes());
        InflightReadsLimiter.Handle handle = limiter.acquire(100L, null);
        Assert.assertEquals((long)0L, (long)limiter.getRemainingBytes());
        Assert.assertTrue((boolean)handle.success);
        Assert.assertEquals((long)handle.acquiredPermits, (long)100L);
        Assert.assertEquals((int)1, (int)handle.trials);
        InflightReadsLimiter.Handle handle2 = limiter.acquire(100L, null);
        Assert.assertEquals((long)0L, (long)limiter.getRemainingBytes());
        Assert.assertFalse((boolean)handle2.success);
        Assert.assertEquals((long)handle2.acquiredPermits, (long)0L);
        Assert.assertEquals((int)1, (int)handle2.trials);
        limiter.release(handle);
        Assert.assertEquals((long)100L, (long)limiter.getRemainingBytes());
        handle2 = limiter.acquire(100L, handle2);
        Assert.assertEquals((long)0L, (long)limiter.getRemainingBytes());
        Assert.assertTrue((boolean)handle2.success);
        Assert.assertEquals((long)handle2.acquiredPermits, (long)100L);
        Assert.assertEquals((int)2, (int)handle2.trials);
        limiter.release(handle2);
        Assert.assertEquals((long)100L, (long)limiter.getRemainingBytes());
    }

    @Test
    public void testPartialAcquire() throws Exception {
        InflightReadsLimiter limiter = new InflightReadsLimiter(100L);
        Assert.assertEquals((long)100L, (long)limiter.getRemainingBytes());
        InflightReadsLimiter.Handle handle = limiter.acquire(30L, null);
        Assert.assertEquals((long)70L, (long)limiter.getRemainingBytes());
        Assert.assertTrue((boolean)handle.success);
        Assert.assertEquals((long)handle.acquiredPermits, (long)30L);
        Assert.assertEquals((int)1, (int)handle.trials);
        InflightReadsLimiter.Handle handle2 = limiter.acquire(100L, null);
        Assert.assertEquals((long)0L, (long)limiter.getRemainingBytes());
        Assert.assertFalse((boolean)handle2.success);
        Assert.assertEquals((long)handle2.acquiredPermits, (long)70L);
        Assert.assertEquals((int)1, (int)handle2.trials);
        limiter.release(handle);
        handle2 = limiter.acquire(100L, handle2);
        Assert.assertEquals((long)0L, (long)limiter.getRemainingBytes());
        Assert.assertTrue((boolean)handle2.success);
        Assert.assertEquals((long)handle2.acquiredPermits, (long)100L);
        Assert.assertEquals((int)2, (int)handle2.trials);
        limiter.release(handle2);
        Assert.assertEquals((long)100L, (long)limiter.getRemainingBytes());
    }

    @Test
    public void testTooManyTrials() throws Exception {
        InflightReadsLimiter limiter = new InflightReadsLimiter(100L);
        Assert.assertEquals((long)100L, (long)limiter.getRemainingBytes());
        InflightReadsLimiter.Handle handle = limiter.acquire(30L, null);
        Assert.assertEquals((long)70L, (long)limiter.getRemainingBytes());
        Assert.assertTrue((boolean)handle.success);
        Assert.assertEquals((long)handle.acquiredPermits, (long)30L);
        Assert.assertEquals((int)1, (int)handle.trials);
        InflightReadsLimiter.Handle handle2 = limiter.acquire(100L, null);
        Assert.assertEquals((long)0L, (long)limiter.getRemainingBytes());
        Assert.assertFalse((boolean)handle2.success);
        Assert.assertEquals((long)handle2.acquiredPermits, (long)70L);
        Assert.assertEquals((int)1, (int)handle2.trials);
        handle2 = limiter.acquire(100L, handle2);
        Assert.assertEquals((long)0L, (long)limiter.getRemainingBytes());
        Assert.assertFalse((boolean)handle2.success);
        Assert.assertEquals((long)handle2.acquiredPermits, (long)70L);
        Assert.assertEquals((int)2, (int)handle2.trials);
        handle2 = limiter.acquire(100L, handle2);
        Assert.assertEquals((long)0L, (long)limiter.getRemainingBytes());
        Assert.assertFalse((boolean)handle2.success);
        Assert.assertEquals((long)handle2.acquiredPermits, (long)70L);
        Assert.assertEquals((int)3, (int)handle2.trials);
        handle2 = limiter.acquire(100L, handle2);
        Assert.assertEquals((long)0L, (long)limiter.getRemainingBytes());
        Assert.assertFalse((boolean)handle2.success);
        Assert.assertEquals((long)handle2.acquiredPermits, (long)70L);
        Assert.assertEquals((int)4, (int)handle2.trials);
        handle2 = limiter.acquire(100L, handle2);
        Assert.assertEquals((long)70L, (long)limiter.getRemainingBytes());
        Assert.assertFalse((boolean)handle2.success);
        Assert.assertEquals((long)handle2.acquiredPermits, (long)0L);
        Assert.assertEquals((int)1, (int)handle2.trials);
        limiter.release(handle);
        handle2 = limiter.acquire(100L, handle2);
        Assert.assertEquals((long)0L, (long)limiter.getRemainingBytes());
        Assert.assertTrue((boolean)handle2.success);
        Assert.assertEquals((long)handle2.acquiredPermits, (long)100L);
        Assert.assertEquals((int)2, (int)handle2.trials);
        limiter.release(handle2);
        Assert.assertEquals((long)100L, (long)limiter.getRemainingBytes());
    }
}

