/*
 * Decompiled with CFR 0.152.
 */
package io.streamnative.oxia.client;

import com.google.common.base.Strings;
import io.opentelemetry.api.GlobalOpenTelemetry;
import io.opentelemetry.api.OpenTelemetry;
import io.streamnative.oxia.client.AsyncOxiaClientImpl;
import io.streamnative.oxia.client.ClientConfig;
import io.streamnative.oxia.client.SyncOxiaClientImpl;
import io.streamnative.oxia.client.api.AsyncOxiaClient;
import io.streamnative.oxia.client.api.Authentication;
import io.streamnative.oxia.client.api.OxiaClientBuilder;
import io.streamnative.oxia.client.api.SyncOxiaClient;
import io.streamnative.oxia.client.api.exceptions.OxiaException;
import io.streamnative.oxia.client.api.exceptions.UnsupportedAuthenticationException;
import io.streamnative.oxia.client.auth.AuthenticationFactory;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.lang.reflect.Field;
import java.time.Duration;
import java.util.Properties;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import lombok.NonNull;

public class OxiaClientBuilderImpl
implements OxiaClientBuilder {
    public static final Duration DefaultBatchLinger = Duration.ofMillis(5L);
    public static final int DefaultMaxRequestsPerBatch = 1000;
    public static final int DefaultMaxBatchSize = 131072;
    public static final Duration DefaultRequestTimeout = Duration.ofSeconds(30L);
    public static final Duration DefaultSessionTimeout = Duration.ofSeconds(15L);
    public static final String DefaultNamespace = "default";
    public static final boolean DefaultEnableTls = false;
    @NonNull
    protected final String serviceAddress;
    @NonNull
    protected Duration requestTimeout = DefaultRequestTimeout;
    @NonNull
    protected Duration batchLinger = DefaultBatchLinger;
    protected int maxRequestsPerBatch = 1000;
    @NonNull
    protected Duration sessionTimeout = DefaultSessionTimeout;
    protected String clientIdentifier = OxiaClientBuilderImpl.randomClientIdentifier();
    @NonNull
    protected Supplier<String> clientIdentifierSupplier = () -> this.clientIdentifier;
    @NonNull
    protected String namespace = "default";
    @NonNull
    protected OpenTelemetry openTelemetry = GlobalOpenTelemetry.get();
    @Nullable
    protected String authPluginClassName;
    @Nullable
    protected String authParams;
    @Nullable
    protected Authentication authentication;
    protected boolean enableTls = false;

    @NonNull
    public OxiaClientBuilder requestTimeout(@NonNull Duration requestTimeout) {
        if (requestTimeout == null) {
            throw new NullPointerException("requestTimeout is marked non-null but is null");
        }
        if (requestTimeout.isNegative() || requestTimeout.equals(Duration.ZERO)) {
            throw new IllegalArgumentException("requestTimeout must be greater than zero: " + requestTimeout);
        }
        this.requestTimeout = requestTimeout;
        return this;
    }

    @NonNull
    public OxiaClientBuilder batchLinger(@NonNull Duration batchLinger) {
        if (batchLinger == null) {
            throw new NullPointerException("batchLinger is marked non-null but is null");
        }
        if (batchLinger.isNegative() || batchLinger.equals(Duration.ZERO)) {
            throw new IllegalArgumentException("batchLinger must be greater than zero: " + batchLinger);
        }
        this.batchLinger = batchLinger;
        return this;
    }

    @NonNull
    public OxiaClientBuilder maxRequestsPerBatch(int maxRequestsPerBatch) {
        if (maxRequestsPerBatch <= 0) {
            throw new IllegalArgumentException("MaxRequestsPerBatch must be greater than zero: " + maxRequestsPerBatch);
        }
        this.maxRequestsPerBatch = maxRequestsPerBatch;
        return this;
    }

    @NonNull
    public OxiaClientBuilder namespace(@NonNull String namespace) {
        if (namespace == null) {
            throw new NullPointerException("namespace is marked non-null but is null");
        }
        if (Strings.isNullOrEmpty((String)namespace)) {
            throw new IllegalArgumentException("namespace must not be null or empty.");
        }
        this.namespace = namespace;
        return this;
    }

    @NonNull
    public OxiaClientBuilder sessionTimeout(@NonNull Duration sessionTimeout) {
        if (sessionTimeout == null) {
            throw new NullPointerException("sessionTimeout is marked non-null but is null");
        }
        if (sessionTimeout.isNegative() || sessionTimeout.equals(Duration.ZERO)) {
            throw new IllegalArgumentException("SessionTimeout must be greater than zero: " + sessionTimeout);
        }
        this.sessionTimeout = sessionTimeout;
        return this;
    }

    @NonNull
    public OxiaClientBuilder clientIdentifier(@NonNull String clientIdentifier) {
        if (clientIdentifier == null) {
            throw new NullPointerException("clientIdentifier is marked non-null but is null");
        }
        this.clientIdentifier = clientIdentifier;
        this.clientIdentifierSupplier = () -> clientIdentifier;
        return this;
    }

    @NonNull
    public OxiaClientBuilder clientIdentifier(@NonNull Supplier<String> clientIdentifierSupplier) {
        if (clientIdentifierSupplier == null) {
            throw new NullPointerException("clientIdentifierSupplier is marked non-null but is null");
        }
        this.clientIdentifierSupplier = clientIdentifierSupplier;
        return this;
    }

    @NonNull
    public OxiaClientBuilder openTelemetry(@NonNull OpenTelemetry openTelemetry) {
        if (openTelemetry == null) {
            throw new NullPointerException("openTelemetry is marked non-null but is null");
        }
        this.openTelemetry = openTelemetry;
        return this;
    }

    public OxiaClientBuilder authentication(Authentication authentication) {
        this.authentication = authentication;
        return this;
    }

    public OxiaClientBuilder authentication(String authPluginClassName, String authParamsString) throws UnsupportedAuthenticationException {
        this.authPluginClassName = authPluginClassName;
        this.authParams = authParamsString;
        this.authentication = AuthenticationFactory.create(authPluginClassName, authParamsString);
        return this;
    }

    public OxiaClientBuilder enableTls(boolean enableTls) {
        this.enableTls = enableTls;
        return this;
    }

    public OxiaClientBuilder loadConfig(String configPath) {
        try {
            File configFile = new File(configPath);
            return this.loadConfig(configFile);
        }
        catch (Throwable e) {
            throw new IllegalArgumentException("Failed to load configuration from file: " + configPath, e);
        }
    }

    public OxiaClientBuilder loadConfig(File configFile) {
        Properties properties = new Properties();
        try (FileInputStream input = new FileInputStream(configFile);){
            properties.load(input);
        }
        catch (IOException ex) {
            throw new IllegalArgumentException("Failed to load configuration from file: " + configFile, ex);
        }
        return this.loadConfig(properties);
    }

    public OxiaClientBuilder loadConfig(Properties properties) {
        if (properties == null) {
            throw new IllegalArgumentException("Properties must not be null.");
        }
        for (String name : properties.stringPropertyNames()) {
            try {
                Field field = this.getClass().getDeclaredField(name);
                field.setAccessible(true);
                if (field.getType().equals(Duration.class)) {
                    field.set(this, Duration.ofMillis(Long.parseLong(properties.getProperty(name))));
                    continue;
                }
                if (field.getType().equals(Integer.TYPE)) {
                    field.set(this, Integer.parseInt(properties.getProperty(name)));
                    continue;
                }
                if (field.getType().equals(Boolean.TYPE)) {
                    field.set(this, Boolean.parseBoolean(properties.getProperty(name)));
                    continue;
                }
                field.set(this, properties.getProperty(name));
            }
            catch (IllegalAccessException | NoSuchFieldException e) {
                throw new IllegalArgumentException("Invalid configuration property: " + name);
            }
        }
        try {
            this.authentication = AuthenticationFactory.create(this.authPluginClassName, this.authParams);
        }
        catch (UnsupportedAuthenticationException e) {
            throw new IllegalArgumentException("Failed to create authentication from configuration.", e);
        }
        return this;
    }

    @NonNull
    public CompletableFuture<AsyncOxiaClient> asyncClient() {
        ClientConfig config = new ClientConfig(this.serviceAddress, this.requestTimeout, this.batchLinger, this.maxRequestsPerBatch, 131072, this.sessionTimeout, this.clientIdentifierSupplier.get(), this.openTelemetry, this.namespace, this.authentication, this.enableTls);
        return AsyncOxiaClientImpl.newInstance(config);
    }

    public SyncOxiaClient syncClient() throws OxiaException {
        return new SyncOxiaClientImpl(this.asyncClient().join());
    }

    @NonNull
    private static String randomClientIdentifier() {
        return "oxia-client-java:" + UUID.randomUUID();
    }

    public OxiaClientBuilderImpl(@NonNull String serviceAddress) {
        if (serviceAddress == null) {
            throw new NullPointerException("serviceAddress is marked non-null but is null");
        }
        this.serviceAddress = serviceAddress;
    }
}

