/*
 * Decompiled with CFR 0.152.
 */
package io.streamnative.oxia.client.batch;

import io.streamnative.oxia.client.grpc.OxiaStub;
import io.streamnative.oxia.client.grpc.OxiaStubProvider;
import lombok.NonNull;

abstract class BatchBase {
    @NonNull
    private final OxiaStubProvider stubProvider;
    private final long shardId;
    private final long startTimeNanos = System.nanoTime();

    BatchBase(OxiaStubProvider stubProvider, long shardId) {
        this.stubProvider = stubProvider;
        this.shardId = shardId;
    }

    protected OxiaStub getStub() {
        return this.stubProvider.getStubForShard(this.shardId);
    }

    public long getShardId() {
        return this.shardId;
    }

    public long getStartTimeNanos() {
        return this.startTimeNanos;
    }
}

