/*
 * Decompiled with CFR 0.152.
 */
package io.streamnative.oxia.client.batch;

import com.google.protobuf.ByteString;
import io.streamnative.oxia.client.ProtoUtil;
import io.streamnative.oxia.client.api.GetResult;
import io.streamnative.oxia.client.api.PutResult;
import io.streamnative.oxia.client.api.exceptions.KeyAlreadyExistsException;
import io.streamnative.oxia.client.api.exceptions.SessionDoesNotExistException;
import io.streamnative.oxia.client.api.exceptions.UnexpectedVersionIdException;
import io.streamnative.oxia.proto.DeleteRangeRequest;
import io.streamnative.oxia.proto.DeleteRangeResponse;
import io.streamnative.oxia.proto.DeleteRequest;
import io.streamnative.oxia.proto.DeleteResponse;
import io.streamnative.oxia.proto.GetRequest;
import io.streamnative.oxia.proto.GetResponse;
import io.streamnative.oxia.proto.KeyComparisonType;
import io.streamnative.oxia.proto.PutRequest;
import io.streamnative.oxia.proto.PutResponse;
import io.streamnative.oxia.proto.Status;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.concurrent.CompletableFuture;
import lombok.NonNull;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface Operation<R> {
    public CompletableFuture<R> callback();

    default public void fail(Throwable t) {
        this.callback().completeExceptionally(t);
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static interface WriteOperation<R>
    extends Operation<R> {

        public record DeleteRangeOperation(@NonNull CompletableFuture<Void> callback, @NonNull String startKeyInclusive, @NonNull String endKeyExclusive) implements WriteOperation<Void>
        {
            public DeleteRangeOperation(@NonNull CompletableFuture<Void> callback, @NonNull String startKeyInclusive, @NonNull String endKeyExclusive) {
                if (callback == null) {
                    throw new NullPointerException("callback is marked non-null but is null");
                }
                if (startKeyInclusive == null) {
                    throw new NullPointerException("startKeyInclusive is marked non-null but is null");
                }
                if (endKeyExclusive == null) {
                    throw new NullPointerException("endKeyExclusive is marked non-null but is null");
                }
            }

            DeleteRangeRequest toProto() {
                return DeleteRangeRequest.newBuilder().setStartInclusive(this.startKeyInclusive).setEndExclusive(this.endKeyExclusive).build();
            }

            void complete(@NonNull DeleteRangeResponse response) {
                if (response == null) {
                    throw new NullPointerException("response is marked non-null but is null");
                }
                if (response.getStatus() == Status.OK) {
                    this.callback.complete(null);
                } else {
                    this.fail(new IllegalStateException("GRPC.Status: " + response.getStatus().name()));
                }
            }
        }

        public record DeleteOperation(@NonNull CompletableFuture<Boolean> callback, @NonNull String key, @NonNull OptionalLong expectedVersionId) implements WriteOperation<Boolean>
        {
            public DeleteOperation(@NonNull CompletableFuture<Boolean> callback, @NonNull String key, @NonNull OptionalLong expectedVersionId) {
                if (callback == null) {
                    throw new NullPointerException("callback is marked non-null but is null");
                }
                if (key == null) {
                    throw new NullPointerException("key is marked non-null but is null");
                }
                if (expectedVersionId == null) {
                    throw new NullPointerException("expectedVersionId is marked non-null but is null");
                }
                if (expectedVersionId.isPresent() && expectedVersionId.getAsLong() < 0L) {
                    throw new IllegalArgumentException("expectedVersionId must be >= 0, was: " + expectedVersionId.getAsLong());
                }
            }

            public DeleteOperation(@NonNull CompletableFuture<Boolean> callback, @NonNull String key) {
                this(callback, key, OptionalLong.empty());
                if (callback == null) {
                    throw new NullPointerException("callback is marked non-null but is null");
                }
                if (key == null) {
                    throw new NullPointerException("key is marked non-null but is null");
                }
            }

            DeleteRequest toProto() {
                DeleteRequest.Builder builder = DeleteRequest.newBuilder().setKey(this.key);
                this.expectedVersionId.ifPresent(builder::setExpectedVersionId);
                return builder.build();
            }

            void complete(@NonNull DeleteResponse response) {
                if (response == null) {
                    throw new NullPointerException("response is marked non-null but is null");
                }
                switch (response.getStatus()) {
                    case UNEXPECTED_VERSION_ID: {
                        this.fail((Throwable)new UnexpectedVersionIdException(this.key, this.expectedVersionId.getAsLong()));
                        break;
                    }
                    case KEY_NOT_FOUND: {
                        this.callback.complete(false);
                        break;
                    }
                    case OK: {
                        this.callback.complete(true);
                        break;
                    }
                    default: {
                        this.fail(new IllegalStateException("GRPC.Status: " + response.getStatus().name()));
                    }
                }
            }
        }

        public record PutOperation(@NonNull CompletableFuture<PutResult> callback, @NonNull String key, @NonNull Optional<String> partitionKey, @NonNull Optional<List<Long>> sequenceKeysDeltas, byte @NonNull [] value, @NonNull OptionalLong expectedVersionId, OptionalLong sessionId, Optional<String> clientIdentifier) implements WriteOperation<PutResult>
        {
            public PutOperation(@NonNull CompletableFuture<PutResult> callback, @NonNull String key, @NonNull Optional<String> partitionKey, @NonNull Optional<List<Long>> sequenceKeysDeltas, byte[] value, @NonNull OptionalLong expectedVersionId, OptionalLong sessionId, Optional<String> clientIdentifier) {
                if (callback == null) {
                    throw new NullPointerException("callback is marked non-null but is null");
                }
                if (key == null) {
                    throw new NullPointerException("key is marked non-null but is null");
                }
                if (partitionKey == null) {
                    throw new NullPointerException("partitionKey is marked non-null but is null");
                }
                if (sequenceKeysDeltas == null) {
                    throw new NullPointerException("sequenceKeysDeltas is marked non-null but is null");
                }
                if (value == null) {
                    throw new NullPointerException("value is marked non-null but is null");
                }
                if (expectedVersionId == null) {
                    throw new NullPointerException("expectedVersionId is marked non-null but is null");
                }
                if (expectedVersionId.isPresent() && expectedVersionId.getAsLong() < -1L) {
                    throw new IllegalArgumentException("expectedVersionId must be >= -1 (KeyNotExists), was: " + expectedVersionId.getAsLong());
                }
                if (sequenceKeysDeltas.isPresent()) {
                    if (expectedVersionId.isPresent()) {
                        throw new IllegalArgumentException("Usage of sequential keys does not allow to specify an ExpectedVersionId");
                    }
                    if (partitionKey.isEmpty()) {
                        throw new IllegalArgumentException("usage of sequential keys requires PartitionKey() to be set");
                    }
                }
            }

            PutRequest toProto() {
                PutRequest.Builder builder = PutRequest.newBuilder().setKey(this.key).setValue(ByteString.copyFrom((byte[])this.value));
                this.partitionKey.ifPresent(builder::setPartitionKey);
                this.expectedVersionId.ifPresent(builder::setExpectedVersionId);
                this.sessionId.ifPresent(builder::setSessionId);
                this.clientIdentifier.ifPresent(builder::setClientIdentity);
                this.sequenceKeysDeltas.ifPresent(builder::addAllSequenceKeyDelta);
                return builder.build();
            }

            void complete(@NonNull PutResponse response) {
                if (response == null) {
                    throw new NullPointerException("response is marked non-null but is null");
                }
                switch (response.getStatus()) {
                    case SESSION_DOES_NOT_EXIST: {
                        this.fail((Throwable)new SessionDoesNotExistException());
                        break;
                    }
                    case UNEXPECTED_VERSION_ID: {
                        if (this.expectedVersionId.getAsLong() == -1L) {
                            this.fail((Throwable)new KeyAlreadyExistsException(this.key));
                            break;
                        }
                        this.fail((Throwable)new UnexpectedVersionIdException(this.key, this.expectedVersionId.getAsLong()));
                        break;
                    }
                    case OK: {
                        this.callback.complete(ProtoUtil.getPutResultFromProto(this.key, response));
                        break;
                    }
                    default: {
                        this.fail(new IllegalStateException("GRPC.Status: " + response.getStatus().name()));
                    }
                }
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                PutOperation that = (PutOperation)o;
                return this.key.equals(that.key) && Arrays.equals(this.value, that.value) && Objects.equals(this.expectedVersionId, that.expectedVersionId);
            }

            @Override
            public int hashCode() {
                int result = Objects.hash(this.key, this.expectedVersionId);
                result = 31 * result + Arrays.hashCode(this.value);
                return result;
            }
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static interface ReadOperation<R>
    extends Operation<R> {

        public record GetOperation(@NonNull CompletableFuture<GetResult> callback, @NonNull String key, KeyComparisonType comparisonType) implements ReadOperation<GetResult>
        {
            public GetOperation(@NonNull CompletableFuture<GetResult> callback, @NonNull String key, KeyComparisonType comparisonType) {
                if (callback == null) {
                    throw new NullPointerException("callback is marked non-null but is null");
                }
                if (key == null) {
                    throw new NullPointerException("key is marked non-null but is null");
                }
            }

            GetRequest toProto() {
                return GetRequest.newBuilder().setKey(this.key).setComparisonType(this.comparisonType).setIncludeValue(true).build();
            }

            void complete(@NonNull GetResponse response) {
                if (response == null) {
                    throw new NullPointerException("response is marked non-null but is null");
                }
                switch (response.getStatus()) {
                    case KEY_NOT_FOUND: {
                        this.callback.complete(null);
                        break;
                    }
                    case OK: {
                        this.callback.complete(ProtoUtil.getResultFromProto(this.key, response));
                        break;
                    }
                    default: {
                        this.fail(new IllegalStateException("GRPC.Status: " + response.getStatus().name()));
                    }
                }
            }
        }
    }
}

