/*
 * Decompiled with CFR 0.152.
 */
package io.streamnative.oxia.client.grpc;

import io.streamnative.oxia.client.api.Authentication;
import io.streamnative.oxia.client.grpc.OxiaStub;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;

public class OxiaStubManager
implements AutoCloseable {
    private final Map<String, OxiaStub> stubs = new ConcurrentHashMap<String, OxiaStub>();
    @Nullable
    private final Authentication authentication;
    private final boolean enableTls;

    public OxiaStubManager(@Nullable Authentication authentication, boolean enableTls) {
        this.authentication = authentication;
        this.enableTls = enableTls;
    }

    public OxiaStub getStub(String address) {
        return this.stubs.computeIfAbsent(address, addr -> new OxiaStub((String)addr, this.authentication, this.enableTls));
    }

    @Override
    public void close() throws Exception {
        for (OxiaStub stub : this.stubs.values()) {
            stub.close();
        }
    }
}

