/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.bookie.rackawareness;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import org.apache.pulsar.bookie.rackawareness.BookieRackAffinityMapping;
import org.apache.pulsar.metadata.api.MetadataCache;
import org.apache.pulsar.metadata.api.MetadataStore;
import org.apache.pulsar.shade.io.netty.util.HashedWheelTimer;
import org.apache.pulsar.shade.org.apache.bookkeeper.client.BKException;
import org.apache.pulsar.shade.org.apache.bookkeeper.client.EnsemblePlacementPolicy;
import org.apache.pulsar.shade.org.apache.bookkeeper.client.RackawareEnsemblePlacementPolicy;
import org.apache.pulsar.shade.org.apache.bookkeeper.client.RackawareEnsemblePlacementPolicyImpl;
import org.apache.pulsar.shade.org.apache.bookkeeper.conf.ClientConfiguration;
import org.apache.pulsar.shade.org.apache.bookkeeper.feature.FeatureProvider;
import org.apache.pulsar.shade.org.apache.bookkeeper.meta.exceptions.MetadataException;
import org.apache.pulsar.shade.org.apache.bookkeeper.net.BookieId;
import org.apache.pulsar.shade.org.apache.bookkeeper.net.DNSToSwitchMapping;
import org.apache.pulsar.shade.org.apache.bookkeeper.proto.BookieAddressResolver;
import org.apache.pulsar.shade.org.apache.bookkeeper.stats.StatsLogger;
import org.apache.pulsar.shade.org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.pulsar.shade.org.apache.commons.lang3.tuple.MutablePair;
import org.apache.pulsar.shade.org.apache.commons.lang3.tuple.Pair;
import org.apache.pulsar.shade.org.apache.pulsar.common.policies.data.BookiesRackConfiguration;
import org.apache.pulsar.shade.org.apache.pulsar.common.policies.data.EnsemblePlacementPolicyConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IsolatedBookieEnsemblePlacementPolicy
extends RackawareEnsemblePlacementPolicy {
    private static final Logger log = LoggerFactory.getLogger(IsolatedBookieEnsemblePlacementPolicy.class);
    public static final String ISOLATION_BOOKIE_GROUPS = "isolationBookieGroups";
    public static final String SECONDARY_ISOLATION_BOOKIE_GROUPS = "secondaryIsolationBookieGroups";
    private ImmutablePair<Set<String>, Set<String>> defaultIsolationGroups;
    private MetadataCache<BookiesRackConfiguration> bookieMappingCache;

    @Override
    public RackawareEnsemblePlacementPolicyImpl initialize(ClientConfiguration conf, Optional<DNSToSwitchMapping> optionalDnsResolver, HashedWheelTimer timer, FeatureProvider featureProvider, StatsLogger statsLogger, BookieAddressResolver bookieAddressResolver) {
        String secondaryIsolationGroupsString;
        String isolationGroupsString;
        MetadataStore store;
        try {
            store = BookieRackAffinityMapping.createMetadataStore(conf);
        }
        catch (MetadataException e) {
            throw new RuntimeException("METADATA_STORE_INSTANCE failed initialized");
        }
        HashSet<String> primaryIsolationGroups = new HashSet<String>();
        HashSet<String> secondaryIsolationGroups = new HashSet<String>();
        if (conf.getProperty(ISOLATION_BOOKIE_GROUPS) != null && !(isolationGroupsString = IsolatedBookieEnsemblePlacementPolicy.castToString(conf.getProperty(ISOLATION_BOOKIE_GROUPS))).isEmpty()) {
            for (String isolationGroup : isolationGroupsString.split(",")) {
                primaryIsolationGroups.add(isolationGroup);
            }
            this.bookieMappingCache = store.getMetadataCache(BookiesRackConfiguration.class);
            this.bookieMappingCache.get("/bookies").join();
        }
        if (conf.getProperty(SECONDARY_ISOLATION_BOOKIE_GROUPS) != null && !(secondaryIsolationGroupsString = IsolatedBookieEnsemblePlacementPolicy.castToString(conf.getProperty(SECONDARY_ISOLATION_BOOKIE_GROUPS))).isEmpty()) {
            for (String isolationGroup : secondaryIsolationGroupsString.split(",")) {
                secondaryIsolationGroups.add(isolationGroup);
            }
        }
        this.defaultIsolationGroups = ImmutablePair.of(primaryIsolationGroups, secondaryIsolationGroups);
        return super.initialize(conf, (Optional)optionalDnsResolver, timer, featureProvider, statsLogger, bookieAddressResolver);
    }

    private static String castToString(Object obj) {
        if (null == obj) {
            return "";
        }
        if (obj instanceof List) {
            ArrayList<String> result = new ArrayList<String>();
            for (Object o : (List)obj) {
                result.add((String)o);
            }
            return String.join((CharSequence)",", result);
        }
        return obj.toString();
    }

    @Override
    public EnsemblePlacementPolicy.PlacementResult<List<BookieId>> newEnsemble(int ensembleSize, int writeQuorumSize, int ackQuorumSize, Map<String, byte[]> customMetadata, Set<BookieId> excludeBookies) throws BKException.BKNotEnoughBookiesException {
        HashMap isolationGroup = new HashMap();
        Set<BookieId> blacklistedBookies = this.getBlacklistedBookiesWithIsolationGroups(ensembleSize, this.defaultIsolationGroups);
        if (excludeBookies == null) {
            excludeBookies = new HashSet<BookieId>();
        }
        excludeBookies.addAll(blacklistedBookies);
        return super.newEnsemble(ensembleSize, writeQuorumSize, ackQuorumSize, customMetadata, excludeBookies);
    }

    @Override
    public EnsemblePlacementPolicy.PlacementResult<BookieId> replaceBookie(int ensembleSize, int writeQuorumSize, int ackQuorumSize, Map<String, byte[]> customMetadata, List<BookieId> currentEnsemble, BookieId bookieToReplace, Set<BookieId> excludeBookies) throws BKException.BKNotEnoughBookiesException {
        Set<BookieId> blacklistedBookies;
        Optional<EnsemblePlacementPolicyConfig> ensemblePlacementPolicyConfig = IsolatedBookieEnsemblePlacementPolicy.getEnsemblePlacementPolicyConfig(customMetadata);
        if (ensemblePlacementPolicyConfig.isPresent()) {
            EnsemblePlacementPolicyConfig config = ensemblePlacementPolicyConfig.get();
            Pair<Set<String>, Set<String>> groups = IsolatedBookieEnsemblePlacementPolicy.getIsolationGroup(config);
            blacklistedBookies = this.getBlacklistedBookiesWithIsolationGroups(ensembleSize, groups);
        } else {
            blacklistedBookies = this.getBlacklistedBookiesWithIsolationGroups(ensembleSize, this.defaultIsolationGroups);
        }
        if (excludeBookies == null) {
            excludeBookies = new HashSet<BookieId>();
        }
        excludeBookies.addAll(blacklistedBookies);
        return super.replaceBookie(ensembleSize, writeQuorumSize, ackQuorumSize, customMetadata, currentEnsemble, bookieToReplace, excludeBookies);
    }

    private static Optional<EnsemblePlacementPolicyConfig> getEnsemblePlacementPolicyConfig(Map<String, byte[]> customMetadata) {
        byte[] ensemblePlacementPolicyConfigData = customMetadata.get("EnsemblePlacementPolicyConfig");
        if (ensemblePlacementPolicyConfigData != null) {
            try {
                return Optional.ofNullable(EnsemblePlacementPolicyConfig.decode(ensemblePlacementPolicyConfigData));
            }
            catch (EnsemblePlacementPolicyConfig.ParseEnsemblePlacementPolicyConfigException e) {
                log.error("Failed to parse the ensemble placement policy config from the custom metadata", (Throwable)e);
                return Optional.empty();
            }
        }
        return Optional.empty();
    }

    private static Pair<Set<String>, Set<String>> getIsolationGroup(EnsemblePlacementPolicyConfig ensemblePlacementPolicyConfig) {
        MutablePair<Set<String>, Set<String>> pair = new MutablePair<Set<String>, Set<String>>();
        String className = IsolatedBookieEnsemblePlacementPolicy.class.getName();
        if (ensemblePlacementPolicyConfig.getPolicyClass().getName().equals(className)) {
            Map<String, Object> properties = ensemblePlacementPolicyConfig.getProperties();
            String primaryIsolationGroupString = IsolatedBookieEnsemblePlacementPolicy.castToString(properties.getOrDefault(ISOLATION_BOOKIE_GROUPS, ""));
            String secondaryIsolationGroupString = IsolatedBookieEnsemblePlacementPolicy.castToString(properties.getOrDefault(SECONDARY_ISOLATION_BOOKIE_GROUPS, ""));
            if (!primaryIsolationGroupString.isEmpty()) {
                pair.setLeft(new HashSet<String>(Arrays.asList(primaryIsolationGroupString.split(","))));
            }
            if (!secondaryIsolationGroupString.isEmpty()) {
                pair.setRight(new HashSet<String>(Arrays.asList(secondaryIsolationGroupString.split(","))));
            }
        }
        return pair;
    }

    private Set<BookieId> getBlacklistedBookiesWithIsolationGroups(int ensembleSize, Pair<Set<String>, Set<String>> isolationGroups) {
        HashSet<BookieId> blacklistedBookies;
        block13: {
            blacklistedBookies = new HashSet<BookieId>();
            try {
                Map bookieGroup;
                Optional optRes;
                if (this.bookieMappingCache == null) break block13;
                CompletableFuture<Optional<BookiesRackConfiguration>> future = this.bookieMappingCache.get("/bookies");
                Optional<Object> optional = optRes = future.isDone() && !future.isCompletedExceptionally() ? future.join() : Optional.empty();
                if (!optRes.isPresent()) {
                    return blacklistedBookies;
                }
                BookiesRackConfiguration allGroupsBookieMapping = (BookiesRackConfiguration)optRes.get();
                Set allBookies = allGroupsBookieMapping.keySet();
                int totalAvailableBookiesInPrimaryGroup = 0;
                Set<Object> primaryIsolationGroup = Collections.emptySet();
                Set<Object> secondaryIsolationGroup = Collections.emptySet();
                if (isolationGroups != null) {
                    primaryIsolationGroup = isolationGroups.getLeft();
                    secondaryIsolationGroup = isolationGroups.getRight();
                }
                for (String string : allBookies) {
                    Set bookiesInGroup = ((Map)allGroupsBookieMapping.get(string)).keySet();
                    if (!primaryIsolationGroup.contains(string)) {
                        for (String bookieAddress : bookiesInGroup) {
                            blacklistedBookies.add(BookieId.parse(bookieAddress));
                        }
                        continue;
                    }
                    for (String groupBookie : bookiesInGroup) {
                        totalAvailableBookiesInPrimaryGroup += this.knownBookies.containsKey(BookieId.parse(groupBookie)) ? 1 : 0;
                    }
                }
                for (String string : primaryIsolationGroup) {
                    bookieGroup = (Map)allGroupsBookieMapping.get(string);
                    if (bookieGroup == null || bookieGroup.isEmpty()) continue;
                    for (String bookieAddress : bookieGroup.keySet()) {
                        blacklistedBookies.remove(BookieId.parse(bookieAddress));
                    }
                }
                if (totalAvailableBookiesInPrimaryGroup < ensembleSize) {
                    log.info("Not found enough available-bookies from primary isolation group [{}], checking secondary group [{}]", primaryIsolationGroup, secondaryIsolationGroup);
                    for (String string : secondaryIsolationGroup) {
                        bookieGroup = (Map)allGroupsBookieMapping.get(string);
                        if (bookieGroup == null || bookieGroup.isEmpty()) continue;
                        for (String bookieAddress : bookieGroup.keySet()) {
                            blacklistedBookies.remove(BookieId.parse(bookieAddress));
                        }
                    }
                }
            }
            catch (Exception e) {
                log.warn("Error getting bookie isolation info from metadata store: {}", (Object)e.getMessage());
            }
        }
        return blacklistedBookies;
    }
}

