/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.lookup.v1;

import org.apache.pulsar.broker.lookup.TopicLookupBase;
import org.apache.pulsar.broker.web.NoSwaggerDocumentation;
import org.apache.pulsar.shade.io.swagger.annotations.ApiResponse;
import org.apache.pulsar.shade.io.swagger.annotations.ApiResponses;
import org.apache.pulsar.shade.javax.ws.rs.DefaultValue;
import org.apache.pulsar.shade.javax.ws.rs.Encoded;
import org.apache.pulsar.shade.javax.ws.rs.GET;
import org.apache.pulsar.shade.javax.ws.rs.HeaderParam;
import org.apache.pulsar.shade.javax.ws.rs.Path;
import org.apache.pulsar.shade.javax.ws.rs.PathParam;
import org.apache.pulsar.shade.javax.ws.rs.Produces;
import org.apache.pulsar.shade.javax.ws.rs.QueryParam;
import org.apache.pulsar.shade.javax.ws.rs.container.AsyncResponse;
import org.apache.pulsar.shade.javax.ws.rs.container.Suspended;
import org.apache.pulsar.shade.org.apache.commons.lang3.StringUtils;
import org.apache.pulsar.shade.org.apache.pulsar.common.naming.TopicName;

@Path(value="/v2/destination/")
@NoSwaggerDocumentation
public class TopicLookup
extends TopicLookupBase {
    static final String LISTENERNAME_HEADER = "X-Pulsar-ListenerName";

    @GET
    @Path(value="{topic-domain}/{property}/{cluster}/{namespace}/{topic}")
    @Produces(value={"application/json"})
    @ApiResponses(value={@ApiResponse(code=307, message="Current broker doesn't serve the namespace of this topic")})
    public void lookupTopicAsync(@PathParam(value="topic-domain") String topicDomain, @PathParam(value="property") String property, @PathParam(value="cluster") String cluster, @PathParam(value="namespace") String namespace, @PathParam(value="topic") @Encoded String encodedTopic, @QueryParam(value="authoritative") @DefaultValue(value="false") boolean authoritative, @Suspended AsyncResponse asyncResponse, @QueryParam(value="listenerName") String listenerName, @HeaderParam(value="X-Pulsar-ListenerName") String listenerNameHeader) {
        TopicName topicName = this.getTopicName(topicDomain, property, cluster, namespace, encodedTopic);
        if (StringUtils.isEmpty(listenerName) && StringUtils.isNotEmpty(listenerNameHeader)) {
            listenerName = listenerNameHeader;
        }
        this.internalLookupTopicAsync(topicName, authoritative, asyncResponse, listenerName);
    }

    @GET
    @Path(value="{topic-domain}/{property}/{cluster}/{namespace}/{topic}/bundle")
    @Produces(value={"application/json"})
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=405, message="Invalid topic domain type")})
    public String getNamespaceBundle(@PathParam(value="topic-domain") String topicDomain, @PathParam(value="property") String property, @PathParam(value="cluster") String cluster, @PathParam(value="namespace") String namespace, @PathParam(value="topic") @Encoded String encodedTopic) {
        TopicName topicName = this.getTopicName(topicDomain, property, cluster, namespace, encodedTopic);
        return this.internalGetNamespaceBundle(topicName);
    }
}

