/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.service;

import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import java.util.concurrent.atomic.LongAdder;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.pulsar.broker.ServiceConfiguration;
import org.apache.pulsar.broker.resourcegroup.ResourceGroup;
import org.apache.pulsar.broker.resourcegroup.ResourceGroupPublishLimiter;
import org.apache.pulsar.broker.service.AbstractDispatcherSingleActiveConsumer;
import org.apache.pulsar.broker.service.BrokerService;
import org.apache.pulsar.broker.service.BrokerServiceException;
import org.apache.pulsar.broker.service.Consumer;
import org.apache.pulsar.broker.service.Dispatcher;
import org.apache.pulsar.broker.service.PrecisPublishLimiter;
import org.apache.pulsar.broker.service.Producer;
import org.apache.pulsar.broker.service.PublishRateLimiter;
import org.apache.pulsar.broker.service.PublishRateLimiterImpl;
import org.apache.pulsar.broker.service.Subscription;
import org.apache.pulsar.broker.service.Topic;
import org.apache.pulsar.broker.service.TopicPolicyListener;
import org.apache.pulsar.broker.service.schema.BookkeeperSchemaStorage;
import org.apache.pulsar.broker.service.schema.SchemaRegistry;
import org.apache.pulsar.broker.service.schema.SchemaRegistryService;
import org.apache.pulsar.broker.service.schema.exceptions.IncompatibleSchemaException;
import org.apache.pulsar.broker.stats.prometheus.metrics.Summary;
import org.apache.pulsar.shade.com.google.common.base.MoreObjects;
import org.apache.pulsar.shade.com.google.common.base.Preconditions;
import org.apache.pulsar.shade.com.google.common.collect.Lists;
import org.apache.pulsar.shade.org.apache.bookkeeper.mledger.impl.ManagedLedgerMBeanImpl;
import org.apache.pulsar.shade.org.apache.bookkeeper.mledger.util.StatsBuckets;
import org.apache.pulsar.shade.org.apache.commons.collections4.CollectionUtils;
import org.apache.pulsar.shade.org.apache.commons.collections4.MapUtils;
import org.apache.pulsar.shade.org.apache.commons.lang3.tuple.Pair;
import org.apache.pulsar.shade.org.apache.pulsar.common.api.proto.CommandSubscribe;
import org.apache.pulsar.shade.org.apache.pulsar.common.naming.TopicName;
import org.apache.pulsar.shade.org.apache.pulsar.common.policies.data.BacklogQuota;
import org.apache.pulsar.shade.org.apache.pulsar.common.policies.data.DelayedDeliveryPolicies;
import org.apache.pulsar.shade.org.apache.pulsar.common.policies.data.HierarchyTopicPolicies;
import org.apache.pulsar.shade.org.apache.pulsar.common.policies.data.InactiveTopicPolicies;
import org.apache.pulsar.shade.org.apache.pulsar.common.policies.data.Policies;
import org.apache.pulsar.shade.org.apache.pulsar.common.policies.data.PublishRate;
import org.apache.pulsar.shade.org.apache.pulsar.common.policies.data.RetentionPolicies;
import org.apache.pulsar.shade.org.apache.pulsar.common.policies.data.SchemaCompatibilityStrategy;
import org.apache.pulsar.shade.org.apache.pulsar.common.policies.data.TopicPolicies;
import org.apache.pulsar.shade.org.apache.pulsar.common.policies.data.impl.DispatchRateImpl;
import org.apache.pulsar.shade.org.apache.pulsar.common.protocol.schema.SchemaData;
import org.apache.pulsar.shade.org.apache.pulsar.common.protocol.schema.SchemaVersion;
import org.apache.pulsar.shade.org.apache.pulsar.common.util.FutureUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractTopic
implements Topic,
TopicPolicyListener<TopicPolicies> {
    protected static final long POLICY_UPDATE_FAILURE_RETRY_TIME_SECONDS = 60L;
    protected final String topic;
    protected final ConcurrentHashMap<String, Producer> producers;
    protected final BrokerService brokerService;
    protected final String replicatorPrefix;
    protected final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    protected volatile boolean isFenced;
    protected final HierarchyTopicPolicies topicPolicies;
    protected volatile long lastActive;
    protected volatile boolean hasBatchMessagePublished = false;
    protected StatsBuckets addEntryLatencyStatsUsec = new StatsBuckets(ManagedLedgerMBeanImpl.ENTRY_LATENCY_BUCKETS_USEC);
    protected volatile boolean isEncryptionRequired = false;
    protected volatile Boolean isAllowAutoUpdateSchema;
    protected volatile boolean schemaValidationEnforced = false;
    protected volatile PublishRateLimiter topicPublishRateLimiter;
    protected volatile ResourceGroupPublishLimiter resourceGroupPublishLimiter;
    protected boolean preciseTopicPublishRateLimitingEnable;
    protected boolean resourceGroupRateLimitingEnabled;
    private LongAdder bytesInCounter = new LongAdder();
    private LongAdder msgInCounter = new LongAdder();
    private static final AtomicLongFieldUpdater<AbstractTopic> RATE_LIMITED_UPDATER = AtomicLongFieldUpdater.newUpdater(AbstractTopic.class, "publishRateLimitedTimes");
    protected volatile long publishRateLimitedTimes = 0L;
    protected volatile Optional<Long> topicEpoch = Optional.empty();
    private volatile boolean hasExclusiveProducer;
    private volatile String exclusiveProducerName;
    private final Queue<Pair<Producer, CompletableFuture<Optional<Long>>>> waitingExclusiveProducers = new ConcurrentLinkedQueue<Pair<Producer, CompletableFuture<Optional<Long>>>>();
    private static final AtomicLongFieldUpdater<AbstractTopic> USAGE_COUNT_UPDATER = AtomicLongFieldUpdater.newUpdater(AbstractTopic.class, "usageCount");
    private volatile long usageCount = 0L;
    private static final Summary PUBLISH_LATENCY = (Summary)Summary.build("pulsar_broker_publish_latency", "-").quantile(0.0).quantile(0.5).quantile(0.95).quantile(0.99).quantile(0.999).quantile(0.9999).quantile(1.0).register();
    private static final Logger log = LoggerFactory.getLogger(AbstractTopic.class);

    public AbstractTopic(String topic, BrokerService brokerService) {
        this.topic = topic;
        this.brokerService = brokerService;
        this.producers = new ConcurrentHashMap();
        this.isFenced = false;
        ServiceConfiguration config = brokerService.pulsar().getConfiguration();
        this.replicatorPrefix = config.getReplicatorPrefix();
        this.topicPolicies = new HierarchyTopicPolicies();
        this.updateTopicPolicyByBrokerConfig();
        this.lastActive = System.nanoTime();
        this.preciseTopicPublishRateLimitingEnable = config.isPreciseTopicPublishRateLimiterEnable();
    }

    public DispatchRateImpl getSubscriptionDispatchRate() {
        return this.topicPolicies.getSubscriptionDispatchRate().get();
    }

    public SchemaCompatibilityStrategy getSchemaCompatibilityStrategy() {
        return this.topicPolicies.getSchemaCompatibilityStrategy().get();
    }

    private SchemaCompatibilityStrategy formatSchemaCompatibilityStrategy(SchemaCompatibilityStrategy strategy) {
        return strategy == SchemaCompatibilityStrategy.UNDEFINED ? null : strategy;
    }

    protected void updateTopicPolicy(TopicPolicies data) {
        if (!this.isSystemTopic()) {
            this.topicPolicies.getReplicationClusters().updateTopicValue(data.getReplicationClusters());
            this.topicPolicies.getSchemaCompatibilityStrategy().updateTopicValue(this.formatSchemaCompatibilityStrategy(data.getSchemaCompatibilityStrategy()));
        }
        this.topicPolicies.getRetentionPolicies().updateTopicValue(data.getRetentionPolicies());
        this.topicPolicies.getMaxSubscriptionsPerTopic().updateTopicValue(data.getMaxSubscriptionsPerTopic());
        this.topicPolicies.getMaxUnackedMessagesOnConsumer().updateTopicValue(data.getMaxUnackedMessagesOnConsumer());
        this.topicPolicies.getMaxUnackedMessagesOnSubscription().updateTopicValue(data.getMaxUnackedMessagesOnSubscription());
        this.topicPolicies.getMaxProducersPerTopic().updateTopicValue(data.getMaxProducerPerTopic());
        this.topicPolicies.getMaxConsumerPerTopic().updateTopicValue(data.getMaxConsumerPerTopic());
        this.topicPolicies.getMaxConsumersPerSubscription().updateTopicValue(data.getMaxConsumersPerSubscription());
        this.topicPolicies.getInactiveTopicPolicies().updateTopicValue(data.getInactiveTopicPolicies());
        this.topicPolicies.getDeduplicationEnabled().updateTopicValue(data.getDeduplicationEnabled());
        this.topicPolicies.getDeduplicationSnapshotIntervalSeconds().updateTopicValue(data.getDeduplicationSnapshotIntervalSeconds());
        this.topicPolicies.getSubscriptionTypesEnabled().updateTopicValue(CollectionUtils.isEmpty(data.getSubscriptionTypesEnabled()) ? null : EnumSet.copyOf(data.getSubscriptionTypesEnabled()));
        Arrays.stream(BacklogQuota.BacklogQuotaType.values()).forEach(type -> this.topicPolicies.getBackLogQuotaMap().get(type).updateTopicValue(data.getBackLogQuotaMap() == null ? null : (BacklogQuota)data.getBackLogQuotaMap().get(type.toString())));
        this.topicPolicies.getTopicMaxMessageSize().updateTopicValue(data.getMaxMessageSize());
        this.topicPolicies.getMessageTTLInSeconds().updateTopicValue(data.getMessageTTLInSeconds());
        this.topicPolicies.getPublishRate().updateTopicValue(PublishRate.normalize(data.getPublishRate()));
        this.topicPolicies.getDelayedDeliveryEnabled().updateTopicValue(data.getDelayedDeliveryEnabled());
        this.topicPolicies.getDelayedDeliveryTickTimeMillis().updateTopicValue(data.getDelayedDeliveryTickTimeMillis());
        this.topicPolicies.getSubscriptionDispatchRate().updateTopicValue(this.normalize(data.getSubscriptionDispatchRate()));
        this.topicPolicies.getCompactionThreshold().updateTopicValue(data.getCompactionThreshold());
    }

    protected void updateTopicPolicyByNamespacePolicy(Policies namespacePolicies) {
        if (log.isDebugEnabled()) {
            log.debug("[{}]updateTopicPolicyByNamespacePolicy,data={}", (Object)this.topic, (Object)namespacePolicies);
        }
        if (namespacePolicies.deleted) {
            return;
        }
        this.topicPolicies.getRetentionPolicies().updateNamespaceValue(namespacePolicies.retention_policies);
        this.topicPolicies.getCompactionThreshold().updateNamespaceValue(namespacePolicies.compaction_threshold);
        this.topicPolicies.getReplicationClusters().updateNamespaceValue(Lists.newArrayList(CollectionUtils.emptyIfNull(namespacePolicies.replication_clusters)));
        this.topicPolicies.getMaxUnackedMessagesOnConsumer().updateNamespaceValue(namespacePolicies.max_unacked_messages_per_consumer);
        this.topicPolicies.getMaxUnackedMessagesOnSubscription().updateNamespaceValue(namespacePolicies.max_unacked_messages_per_subscription);
        this.topicPolicies.getMessageTTLInSeconds().updateNamespaceValue(namespacePolicies.message_ttl_in_seconds);
        this.topicPolicies.getMaxSubscriptionsPerTopic().updateNamespaceValue(namespacePolicies.max_subscriptions_per_topic);
        this.topicPolicies.getMaxProducersPerTopic().updateNamespaceValue(namespacePolicies.max_producers_per_topic);
        this.topicPolicies.getMaxConsumerPerTopic().updateNamespaceValue(namespacePolicies.max_consumers_per_topic);
        this.topicPolicies.getMaxConsumersPerSubscription().updateNamespaceValue(namespacePolicies.max_consumers_per_subscription);
        this.topicPolicies.getInactiveTopicPolicies().updateNamespaceValue(namespacePolicies.inactive_topic_policies);
        this.topicPolicies.getDeduplicationEnabled().updateNamespaceValue(namespacePolicies.deduplicationEnabled);
        this.topicPolicies.getDeduplicationSnapshotIntervalSeconds().updateNamespaceValue(namespacePolicies.deduplicationSnapshotIntervalSeconds);
        this.updateNamespacePublishRate(namespacePolicies, this.brokerService.getPulsar().getConfig().getClusterName());
        this.topicPolicies.getDelayedDeliveryEnabled().updateNamespaceValue(Optional.ofNullable(namespacePolicies.delayed_delivery_policies).map(DelayedDeliveryPolicies::isActive).orElse(null));
        this.topicPolicies.getDelayedDeliveryTickTimeMillis().updateNamespaceValue(Optional.ofNullable(namespacePolicies.delayed_delivery_policies).map(DelayedDeliveryPolicies::getTickTime).orElse(null));
        this.topicPolicies.getSubscriptionTypesEnabled().updateNamespaceValue(this.subTypeStringsToEnumSet(namespacePolicies.subscription_types_enabled));
        Arrays.stream(BacklogQuota.BacklogQuotaType.values()).forEach(type -> this.topicPolicies.getBackLogQuotaMap().get(type).updateNamespaceValue(MapUtils.getObject(namespacePolicies.backlog_quota_map, type)));
        this.updateNamespaceSubscriptionDispatchRate(namespacePolicies, this.brokerService.getPulsar().getConfig().getClusterName());
        this.updateSchemaCompatibilityStrategyNamespaceValue(namespacePolicies);
    }

    private void updateNamespaceSubscriptionDispatchRate(Policies namespacePolicies, String cluster) {
        this.topicPolicies.getSubscriptionDispatchRate().updateNamespaceValue(this.normalize(namespacePolicies.subscriptionDispatchRate.get(cluster)));
    }

    private DispatchRateImpl normalize(DispatchRateImpl dispatchRate) {
        if (dispatchRate != null && (dispatchRate.getDispatchThrottlingRateInMsg() > 0 || dispatchRate.getDispatchThrottlingRateInByte() > 0L)) {
            return dispatchRate;
        }
        return null;
    }

    private void updateSchemaCompatibilityStrategyNamespaceValue(Policies namespacePolicies) {
        if (this.isSystemTopic()) {
            return;
        }
        SchemaCompatibilityStrategy strategy = namespacePolicies.schema_compatibility_strategy;
        if (SchemaCompatibilityStrategy.isUndefined(namespacePolicies.schema_compatibility_strategy)) {
            strategy = SchemaCompatibilityStrategy.fromAutoUpdatePolicy(namespacePolicies.schema_auto_update_compatibility_strategy);
        }
        this.topicPolicies.getSchemaCompatibilityStrategy().updateNamespaceValue(this.formatSchemaCompatibilityStrategy(strategy));
    }

    private void updateNamespacePublishRate(Policies namespacePolicies, String cluster) {
        this.topicPolicies.getPublishRate().updateNamespaceValue(PublishRate.normalize(namespacePolicies.publishMaxMessageRate != null ? namespacePolicies.publishMaxMessageRate.get(cluster) : null));
    }

    private void updateTopicPolicyByBrokerConfig() {
        ServiceConfiguration config = this.brokerService.pulsar().getConfiguration();
        this.topicPolicies.getInactiveTopicPolicies().updateBrokerValue(new InactiveTopicPolicies(config.getBrokerDeleteInactiveTopicsMode(), config.getBrokerDeleteInactiveTopicsMaxInactiveDurationSeconds(), config.isBrokerDeleteInactiveTopicsEnabled()));
        this.updateBrokerSubscriptionTypesEnabled();
        this.topicPolicies.getMaxSubscriptionsPerTopic().updateBrokerValue(config.getMaxSubscriptionsPerTopic());
        this.topicPolicies.getMaxProducersPerTopic().updateBrokerValue(config.getMaxProducersPerTopic());
        this.topicPolicies.getMaxConsumerPerTopic().updateBrokerValue(config.getMaxConsumersPerTopic());
        this.topicPolicies.getMaxConsumersPerSubscription().updateBrokerValue(config.getMaxConsumersPerSubscription());
        this.topicPolicies.getDeduplicationEnabled().updateBrokerValue(config.isBrokerDeduplicationEnabled());
        this.topicPolicies.getRetentionPolicies().updateBrokerValue(new RetentionPolicies(config.getDefaultRetentionTimeInMinutes(), config.getDefaultRetentionSizeInMB()));
        this.topicPolicies.getDeduplicationSnapshotIntervalSeconds().updateBrokerValue(config.getBrokerDeduplicationSnapshotIntervalSeconds());
        this.topicPolicies.getMaxUnackedMessagesOnConsumer().updateBrokerValue(config.getMaxUnackedMessagesPerConsumer());
        this.topicPolicies.getMaxUnackedMessagesOnSubscription().updateBrokerValue(config.getMaxUnackedMessagesPerSubscription());
        this.topicPolicies.getBackLogQuotaMap().get((Object)BacklogQuota.BacklogQuotaType.destination_storage).updateBrokerValue(this.brokerService.getBacklogQuotaManager().getDefaultQuota());
        this.topicPolicies.getBackLogQuotaMap().get((Object)BacklogQuota.BacklogQuotaType.message_age).updateBrokerValue(this.brokerService.getBacklogQuotaManager().getDefaultQuota());
        this.topicPolicies.getTopicMaxMessageSize().updateBrokerValue(config.getMaxMessageSize());
        this.topicPolicies.getMessageTTLInSeconds().updateBrokerValue(config.getTtlDurationDefaultInSeconds());
        this.topicPolicies.getPublishRate().updateBrokerValue(this.publishRateInBroker(config));
        this.topicPolicies.getDelayedDeliveryEnabled().updateBrokerValue(config.isDelayedDeliveryEnabled());
        this.topicPolicies.getDelayedDeliveryTickTimeMillis().updateBrokerValue(config.getDelayedDeliveryTickTimeMillis());
        this.topicPolicies.getCompactionThreshold().updateBrokerValue(config.getBrokerServiceCompactionThresholdInBytes());
        this.topicPolicies.getReplicationClusters().updateBrokerValue(Collections.emptyList());
        SchemaCompatibilityStrategy schemaCompatibilityStrategy = config.getSchemaCompatibilityStrategy();
        if (this.isSystemTopic()) {
            schemaCompatibilityStrategy = config.getSystemTopicSchemaCompatibilityStrategy();
        }
        this.topicPolicies.getSubscriptionDispatchRate().updateBrokerValue(this.subscriptionDispatchRateInBroker(config));
        this.topicPolicies.getSchemaCompatibilityStrategy().updateBrokerValue(this.formatSchemaCompatibilityStrategy(schemaCompatibilityStrategy));
    }

    private DispatchRateImpl subscriptionDispatchRateInBroker(ServiceConfiguration config) {
        return DispatchRateImpl.builder().dispatchThrottlingRateInMsg(config.getDispatchThrottlingRatePerSubscriptionInMsg()).dispatchThrottlingRateInByte(config.getDispatchThrottlingRatePerSubscriptionInByte()).ratePeriodInSecond(1).build();
    }

    private EnumSet<CommandSubscribe.SubType> subTypeStringsToEnumSet(Set<String> getSubscriptionTypesEnabled) {
        EnumSet<CommandSubscribe.SubType> subTypes = EnumSet.noneOf(CommandSubscribe.SubType.class);
        for (String subTypeStr : CollectionUtils.emptyIfNull(getSubscriptionTypesEnabled)) {
            try {
                CommandSubscribe.SubType subType = CommandSubscribe.SubType.valueOf(subTypeStr);
                subTypes.add(subType);
            }
            catch (Throwable throwable) {}
        }
        if (subTypes.isEmpty()) {
            return null;
        }
        return subTypes;
    }

    private PublishRate publishRateInBroker(ServiceConfiguration config) {
        return new PublishRate(config.getMaxPublishRatePerTopicInMessages(), config.getMaxPublishRatePerTopicInBytes());
    }

    protected boolean isProducersExceeded() {
        Integer maxProducers = this.topicPolicies.getMaxProducersPerTopic().get();
        return maxProducers > 0 && maxProducers <= this.producers.size();
    }

    protected void registerTopicPolicyListener() {
        if (this.brokerService.pulsar().getConfig().isSystemTopicEnabled() && this.brokerService.pulsar().getConfig().isTopicLevelPoliciesEnabled()) {
            this.brokerService.getPulsar().getTopicPoliciesService().registerListener(TopicName.getPartitionedTopicName(this.topic), this);
        }
    }

    protected void unregisterTopicPolicyListener() {
        if (this.brokerService.pulsar().getConfig().isSystemTopicEnabled() && this.brokerService.pulsar().getConfig().isTopicLevelPoliciesEnabled()) {
            this.brokerService.getPulsar().getTopicPoliciesService().unregisterListener(TopicName.getPartitionedTopicName(this.topic), this);
        }
    }

    protected boolean isSameAddressProducersExceeded(Producer producer) {
        int maxSameAddressProducers = this.brokerService.pulsar().getConfiguration().getMaxSameAddressProducersPerTopic();
        return maxSameAddressProducers > 0 && this.getNumberOfSameAddressProducers(producer.getClientAddress()) >= maxSameAddressProducers;
    }

    public int getNumberOfSameAddressProducers(String clientAddress) {
        int count = 0;
        if (clientAddress != null) {
            for (Producer producer : this.producers.values()) {
                if (!clientAddress.equals(producer.getClientAddress())) continue;
                ++count;
            }
        }
        return count;
    }

    protected boolean isConsumersExceededOnTopic() {
        int maxConsumersPerTopic = this.topicPolicies.getMaxConsumerPerTopic().get();
        return maxConsumersPerTopic > 0 && maxConsumersPerTopic <= this.getNumberOfConsumers();
    }

    protected boolean isSameAddressConsumersExceededOnTopic(Consumer consumer) {
        int maxSameAddressConsumers = this.brokerService.pulsar().getConfiguration().getMaxSameAddressConsumersPerTopic();
        return maxSameAddressConsumers > 0 && this.getNumberOfSameAddressConsumers(consumer.getClientAddress()) >= maxSameAddressConsumers;
    }

    public abstract int getNumberOfConsumers();

    public abstract int getNumberOfSameAddressConsumers(String var1);

    protected int getNumberOfSameAddressConsumers(String clientAddress, List<? extends Subscription> subscriptions) {
        int count = 0;
        if (clientAddress != null) {
            for (Subscription subscription : subscriptions) {
                count += subscription.getNumberOfSameAddressConsumers(clientAddress);
            }
        }
        return count;
    }

    protected CompletableFuture<Void> addConsumerToSubscription(Subscription subscription, Consumer consumer) {
        if (this.isConsumersExceededOnTopic()) {
            log.warn("[{}] Attempting to add consumer to topic which reached max consumers limit", (Object)this.topic);
            return FutureUtil.failedFuture(new BrokerServiceException.ConsumerBusyException("Topic reached max consumers limit"));
        }
        if (this.isSameAddressConsumersExceededOnTopic(consumer)) {
            log.warn("[{}] Attempting to add consumer to topic which reached max same address consumers limit", (Object)this.topic);
            return FutureUtil.failedFuture(new BrokerServiceException.ConsumerBusyException("Topic reached max same address consumers limit"));
        }
        return subscription.addConsumer(consumer);
    }

    protected Consumer getActiveConsumer(Subscription subscription) {
        Dispatcher dispatcher = subscription.getDispatcher();
        if (dispatcher instanceof AbstractDispatcherSingleActiveConsumer) {
            return ((AbstractDispatcherSingleActiveConsumer)dispatcher).getActiveConsumer();
        }
        return null;
    }

    @Override
    public void disableCnxAutoRead() {
        this.producers.values().forEach(producer -> producer.getCnx().disableCnxAutoRead());
    }

    @Override
    public void enableCnxAutoRead() {
        this.producers.values().forEach(producer -> producer.getCnx().enableCnxAutoRead());
    }

    protected boolean hasLocalProducers() {
        if (this.producers.isEmpty()) {
            return false;
        }
        for (Producer producer : this.producers.values()) {
            if (producer.isRemote()) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("topic", this.topic).toString();
    }

    @Override
    public Map<String, Producer> getProducers() {
        return this.producers;
    }

    @Override
    public BrokerService getBrokerService() {
        return this.brokerService;
    }

    @Override
    public String getName() {
        return this.topic;
    }

    @Override
    public boolean isEncryptionRequired() {
        return this.isEncryptionRequired;
    }

    @Override
    public boolean getSchemaValidationEnforced() {
        return this.schemaValidationEnforced;
    }

    public void markBatchMessagePublished() {
        this.hasBatchMessagePublished = true;
    }

    public String getReplicatorPrefix() {
        return this.replicatorPrefix;
    }

    @Override
    public CompletableFuture<Boolean> hasSchema() {
        String base = TopicName.get(this.getName()).getPartitionedTopicName();
        String id = TopicName.get(base).getSchemaName();
        return this.brokerService.pulsar().getSchemaRegistryService().getSchema(id).thenApply(Objects::nonNull);
    }

    @Override
    public CompletableFuture<SchemaVersion> addSchema(SchemaData schema) {
        if (schema == null) {
            return CompletableFuture.completedFuture(SchemaVersion.Empty);
        }
        String base = TopicName.get(this.getName()).getPartitionedTopicName();
        String id = TopicName.get(base).getSchemaName();
        SchemaRegistryService schemaRegistryService = this.brokerService.pulsar().getSchemaRegistryService();
        if (this.allowAutoUpdateSchema()) {
            return schemaRegistryService.putSchemaIfAbsent(id, schema, this.getSchemaCompatibilityStrategy());
        }
        return schemaRegistryService.trimDeletedSchemaAndGetList(id).thenCompose(schemaAndMetadataList -> schemaRegistryService.getSchemaVersionBySchemaData((List<SchemaRegistry.SchemaAndMetadata>)schemaAndMetadataList, schema).thenCompose(schemaVersion -> {
            if (schemaVersion == null) {
                return FutureUtil.failedFuture(new IncompatibleSchemaException("Schema not found and schema auto updating is disabled."));
            }
            return CompletableFuture.completedFuture(schemaVersion);
        }));
    }

    private boolean allowAutoUpdateSchema() {
        if (this.brokerService.isSystemTopic(this.topic)) {
            return true;
        }
        if (this.isAllowAutoUpdateSchema == null) {
            return this.brokerService.pulsar().getConfig().isAllowAutoUpdateSchemaEnabled();
        }
        return this.isAllowAutoUpdateSchema;
    }

    @Override
    public CompletableFuture<SchemaVersion> deleteSchema() {
        String base = TopicName.get(this.getName()).getPartitionedTopicName();
        String id = TopicName.get(base).getSchemaName();
        SchemaRegistryService schemaRegistryService = this.brokerService.pulsar().getSchemaRegistryService();
        return BookkeeperSchemaStorage.ignoreUnrecoverableBKException(schemaRegistryService.getSchema(id)).thenCompose(schema -> {
            if (schema != null) {
                log.info("Delete schema storage of id: {}", (Object)id);
                return schemaRegistryService.deleteSchemaStorage(id);
            }
            return CompletableFuture.completedFuture(null);
        });
    }

    @Override
    public CompletableFuture<Void> checkSchemaCompatibleForConsumer(SchemaData schema) {
        String base = TopicName.get(this.getName()).getPartitionedTopicName();
        String id = TopicName.get(base).getSchemaName();
        return this.brokerService.pulsar().getSchemaRegistryService().checkConsumerCompatibility(id, schema, this.getSchemaCompatibilityStrategy());
    }

    @Override
    public CompletableFuture<Optional<Long>> addProducer(Producer producer, CompletableFuture<Void> producerQueuedFuture) {
        Preconditions.checkArgument(producer.getTopic() == this);
        return ((CompletableFuture)this.brokerService.checkTopicNsOwnership(this.getName()).thenCompose(__ -> this.incrementTopicEpochIfNeeded(producer, producerQueuedFuture))).thenCompose(producerEpoch -> {
            this.lock.writeLock().lock();
            try {
                this.checkTopicFenced();
                if (this.isTerminated()) {
                    log.warn("[{}] Attempting to add producer to a terminated topic", (Object)this.topic);
                    throw new BrokerServiceException.TopicTerminatedException("Topic was already terminated");
                }
                this.internalAddProducer(producer);
                USAGE_COUNT_UPDATER.incrementAndGet(this);
                if (log.isDebugEnabled()) {
                    log.debug("[{}] [{}] Added producer -- count: {}", new Object[]{this.topic, producer.getProducerName(), USAGE_COUNT_UPDATER.get(this)});
                }
                CompletableFuture<Optional> completableFuture = CompletableFuture.completedFuture(producerEpoch);
                return completableFuture;
            }
            catch (BrokerServiceException e) {
                CompletableFuture completableFuture = FutureUtil.failedFuture(e);
                return completableFuture;
            }
            finally {
                this.lock.writeLock().unlock();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected CompletableFuture<Optional<Long>> incrementTopicEpochIfNeeded(Producer producer, CompletableFuture<Void> producerQueuedFuture) {
        this.lock.writeLock().lock();
        try {
            switch (producer.getAccessMode()) {
                case Shared: {
                    if (this.hasExclusiveProducer || !this.waitingExclusiveProducers.isEmpty()) {
                        CompletableFuture<Optional<Long>> completableFuture = FutureUtil.failedFuture(new BrokerServiceException.ProducerBusyException("Topic has an existing exclusive producer: " + this.exclusiveProducerName));
                        return completableFuture;
                    }
                    CompletableFuture<Optional<Long>> completableFuture = CompletableFuture.completedFuture(this.topicEpoch);
                    return completableFuture;
                }
                case Exclusive: {
                    if (this.hasExclusiveProducer || !this.waitingExclusiveProducers.isEmpty()) {
                        CompletableFuture<Optional<Long>> completableFuture = FutureUtil.failedFuture(new BrokerServiceException.ProducerFencedException("Topic has an existing exclusive producer: " + this.exclusiveProducerName));
                        return completableFuture;
                    }
                    if (!this.producers.isEmpty()) {
                        CompletableFuture<Optional<Long>> completableFuture = FutureUtil.failedFuture(new BrokerServiceException.ProducerFencedException("Topic has existing shared producers"));
                        return completableFuture;
                    }
                    if (producer.getTopicEpoch().isPresent() && producer.getTopicEpoch().get() < this.topicEpoch.orElse(-1L)) {
                        CompletableFuture<Optional<Long>> completableFuture = FutureUtil.failedFuture(new BrokerServiceException.ProducerFencedException(String.format("Topic epoch has already moved. Current epoch: %d, Producer epoch: %d", this.topicEpoch.get(), producer.getTopicEpoch().get())));
                        return completableFuture;
                    }
                    this.hasExclusiveProducer = true;
                    this.exclusiveProducerName = producer.getProducerName();
                    CompletableFuture<Long> future = producer.getTopicEpoch().isPresent() ? this.setTopicEpoch(producer.getTopicEpoch().get()) : this.incrementTopicEpoch(this.topicEpoch);
                    future.exceptionally(ex -> {
                        this.hasExclusiveProducer = false;
                        this.exclusiveProducerName = null;
                        return null;
                    });
                    CompletionStage completionStage = future.thenApply(epoch -> {
                        this.topicEpoch = Optional.of(epoch);
                        return this.topicEpoch;
                    });
                    return completionStage;
                }
                case WaitForExclusive: {
                    if (this.hasExclusiveProducer || !this.producers.isEmpty()) {
                        CompletableFuture<Optional<Long>> future = new CompletableFuture<Optional<Long>>();
                        log.info("[{}] Queuing producer {} since there's already a producer", (Object)this.topic, (Object)producer);
                        this.waitingExclusiveProducers.add(Pair.of(producer, future));
                        producerQueuedFuture.complete(null);
                        CompletableFuture<Optional<Long>> completableFuture = future;
                        return completableFuture;
                    }
                    if (producer.getTopicEpoch().isPresent() && producer.getTopicEpoch().get() < this.topicEpoch.orElse(-1L)) {
                        CompletableFuture<Optional<Long>> future = FutureUtil.failedFuture(new BrokerServiceException.ProducerFencedException(String.format("Topic epoch has already moved. Current epoch: %d, Producer epoch: %d", this.topicEpoch.get(), producer.getTopicEpoch().get())));
                        return future;
                    }
                    this.hasExclusiveProducer = true;
                    this.exclusiveProducerName = producer.getProducerName();
                    CompletableFuture<Long> future = producer.getTopicEpoch().isPresent() ? this.setTopicEpoch(producer.getTopicEpoch().get()) : this.incrementTopicEpoch(this.topicEpoch);
                    future.exceptionally(ex -> {
                        this.hasExclusiveProducer = false;
                        this.exclusiveProducerName = null;
                        return null;
                    });
                    CompletionStage completionStage = future.thenApply(epoch -> {
                        this.topicEpoch = Optional.of(epoch);
                        return this.topicEpoch;
                    });
                    return completionStage;
                }
            }
            CompletableFuture<Optional<Long>> future = FutureUtil.failedFuture(new BrokerServiceException("Invalid producer access mode: " + (Object)((Object)producer.getAccessMode())));
            return future;
        }
        catch (Exception e) {
            log.error("Encountered unexpected error during exclusive producer creation", (Throwable)e);
            CompletableFuture<Optional<Long>> completableFuture = FutureUtil.failedFuture(new BrokerServiceException(e));
            return completableFuture;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    protected abstract CompletableFuture<Long> setTopicEpoch(long var1);

    protected abstract CompletableFuture<Long> incrementTopicEpoch(Optional<Long> var1);

    @Override
    public void recordAddLatency(long latency, TimeUnit unit) {
        this.addEntryLatencyStatsUsec.addValue(unit.toMicros(latency));
        PUBLISH_LATENCY.observe(latency, unit);
    }

    @Override
    public long increasePublishLimitedTimes() {
        return RATE_LIMITED_UPDATER.incrementAndGet(this);
    }

    @Override
    public void checkTopicPublishThrottlingRate() {
        this.topicPublishRateLimiter.checkPublishRate();
    }

    @Override
    public void incrementPublishCount(int numOfMessages, long msgSizeInBytes) {
        this.topicPublishRateLimiter.incrementPublishCount(numOfMessages, msgSizeInBytes);
        this.getBrokerPublishRateLimiter().incrementPublishCount(numOfMessages, msgSizeInBytes);
        this.bytesInCounter.add(msgSizeInBytes);
        this.msgInCounter.add(numOfMessages);
    }

    @Override
    public void resetTopicPublishCountAndEnableReadIfRequired() {
        if (!this.getBrokerPublishRateLimiter().isPublishRateExceeded() && this.topicPublishRateLimiter.resetPublishCount()) {
            this.enableProducerReadForPublishRateLimiting();
        }
    }

    @Override
    public void resetBrokerPublishCountAndEnableReadIfRequired(boolean doneBrokerReset) {
        if (!this.topicPublishRateLimiter.isPublishRateExceeded() && doneBrokerReset) {
            this.enableProducerReadForPublishRateLimiting();
        }
    }

    protected void enableProducerReadForPublishRateLimiting() {
        if (this.producers != null) {
            this.producers.values().forEach(producer -> {
                producer.getCnx().cancelPublishRateLimiting();
                producer.getCnx().enableCnxAutoRead();
            });
        }
    }

    protected void enableProducerReadForPublishBufferLimiting() {
        if (this.producers != null) {
            this.producers.values().forEach(producer -> {
                producer.getCnx().cancelPublishBufferLimiting();
                producer.getCnx().enableCnxAutoRead();
            });
        }
    }

    protected void disableProducerRead() {
        if (this.producers != null) {
            this.producers.values().forEach(producer -> producer.getCnx().disableCnxAutoRead());
        }
    }

    protected void checkTopicFenced() throws BrokerServiceException {
        if (this.isFenced) {
            log.warn("[{}] Attempting to add producer to a fenced topic", (Object)this.topic);
            throw new BrokerServiceException.TopicFencedException("Topic is temporarily unavailable");
        }
    }

    protected void internalAddProducer(Producer producer) throws BrokerServiceException {
        Producer existProducer;
        if (this.isProducersExceeded()) {
            log.warn("[{}] Attempting to add producer to topic which reached max producers limit", (Object)this.topic);
            throw new BrokerServiceException.ProducerBusyException("Topic reached max producers limit");
        }
        if (this.isSameAddressProducersExceeded(producer)) {
            log.warn("[{}] Attempting to add producer to topic which reached max same address producers limit", (Object)this.topic);
            throw new BrokerServiceException.ProducerBusyException("Topic reached max same address producers limit");
        }
        if (log.isDebugEnabled()) {
            log.debug("[{}] {} Got request to create producer ", (Object)this.topic, (Object)producer.getProducerName());
        }
        if ((existProducer = this.producers.putIfAbsent(producer.getProducerName(), producer)) != null) {
            this.tryOverwriteOldProducer(existProducer, producer);
        }
    }

    private void tryOverwriteOldProducer(Producer oldProducer, Producer newProducer) throws BrokerServiceException {
        if (newProducer.isSuccessorTo(oldProducer) && !this.isUserProvidedProducerName(oldProducer) && !this.isUserProvidedProducerName(newProducer)) {
            oldProducer.close(false);
            if (!this.producers.replace(newProducer.getProducerName(), oldProducer, newProducer)) {
                throw new BrokerServiceException.NamingException("Producer with name '" + newProducer.getProducerName() + "' replace concurrency error");
            }
        } else {
            throw new BrokerServiceException.NamingException("Producer with name '" + newProducer.getProducerName() + "' is already connected to topic");
        }
        this.handleProducerRemoved(oldProducer);
    }

    private boolean isUserProvidedProducerName(Producer producer) {
        return producer.isUserProvidedProducerName() && !producer.getProducerName().startsWith(this.replicatorPrefix);
    }

    @Override
    public void removeProducer(Producer producer) {
        Preconditions.checkArgument(producer.getTopic() == this);
        if (this.producers.remove(producer.getProducerName(), producer)) {
            this.handleProducerRemoved(producer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleProducerRemoved(Producer producer) {
        USAGE_COUNT_UPDATER.decrementAndGet(this);
        if (this.hasExclusiveProducer) {
            this.lock.writeLock().lock();
            try {
                this.hasExclusiveProducer = false;
                this.exclusiveProducerName = null;
                Pair<Producer, CompletableFuture<Optional<Long>>> nextWaitingProducer = this.waitingExclusiveProducers.poll();
                if (nextWaitingProducer != null) {
                    Producer nextProducer = nextWaitingProducer.getKey();
                    CompletableFuture<Optional<Long>> producerFuture = nextWaitingProducer.getValue();
                    this.hasExclusiveProducer = true;
                    this.exclusiveProducerName = nextProducer.getProducerName();
                    CompletableFuture<Long> future = nextProducer.getTopicEpoch().isPresent() ? this.setTopicEpoch(nextProducer.getTopicEpoch().get()) : this.incrementTopicEpoch(this.topicEpoch);
                    ((CompletableFuture)future.thenAccept(epoch -> {
                        this.topicEpoch = Optional.of(epoch);
                        producerFuture.complete(this.topicEpoch);
                    })).exceptionally(ex -> {
                        this.hasExclusiveProducer = false;
                        this.exclusiveProducerName = null;
                        producerFuture.completeExceptionally((Throwable)ex);
                        return null;
                    });
                }
            }
            finally {
                this.lock.writeLock().unlock();
            }
        }
        if (log.isDebugEnabled()) {
            log.debug("[{}] [{}] Removed producer -- count: {}", new Object[]{this.topic, producer.getProducerName(), USAGE_COUNT_UPDATER.get(this)});
        }
        this.lastActive = System.nanoTime();
    }

    public void handleConsumerAdded(String subscriptionName, String consumerName) {
        USAGE_COUNT_UPDATER.incrementAndGet(this);
        if (log.isDebugEnabled()) {
            log.debug("[{}] [{}] [{}] Added consumer -- count: {}", new Object[]{this.topic, subscriptionName, consumerName, USAGE_COUNT_UPDATER.get(this)});
        }
    }

    public void decrementUsageCount() {
        USAGE_COUNT_UPDATER.decrementAndGet(this);
    }

    public long currentUsageCount() {
        return this.usageCount;
    }

    @Override
    public boolean isPublishRateExceeded() {
        return this.topicPublishRateLimiter.isPublishRateExceeded() || this.getBrokerPublishRateLimiter().isPublishRateExceeded();
    }

    @Override
    public boolean isResourceGroupPublishRateExceeded(int numMessages, int bytes) {
        return this.resourceGroupRateLimitingEnabled && !this.resourceGroupPublishLimiter.tryAcquire(numMessages, bytes);
    }

    @Override
    public boolean isResourceGroupRateLimitingEnabled() {
        return this.resourceGroupRateLimitingEnabled;
    }

    @Override
    public boolean isTopicPublishRateExceeded(int numberMessages, int bytes) {
        return this.preciseTopicPublishRateLimitingEnable && !this.topicPublishRateLimiter.tryAcquire(numberMessages, bytes);
    }

    @Override
    public boolean isBrokerPublishRateExceeded() {
        return this.getBrokerPublishRateLimiter().isPublishRateExceeded();
    }

    public PublishRateLimiter getTopicPublishRateLimiter() {
        return this.topicPublishRateLimiter;
    }

    public PublishRateLimiter getBrokerPublishRateLimiter() {
        return this.brokerService.getBrokerPublishRateLimiter();
    }

    public void updateResourceGroupLimiter(Optional<Policies> optPolicies) {
        String rgName;
        Policies policies;
        try {
            policies = optPolicies.orElseGet(() -> this.brokerService.pulsar().getPulsarResources().getNamespaceResources().getPoliciesIfCached(TopicName.get(this.topic).getNamespaceObject()).orElseGet(Policies::new));
        }
        catch (Exception e) {
            log.warn("[{}] Error getting policies {} and publish throttling will be disabled", (Object)this.topic, (Object)e.getMessage());
            policies = new Policies();
        }
        String string = rgName = policies.resource_group_name != null ? policies.resource_group_name : null;
        if (rgName != null) {
            ResourceGroup resourceGroup = this.brokerService.getPulsar().getResourceGroupServiceManager().resourceGroupGet(rgName);
            if (resourceGroup != null) {
                this.resourceGroupRateLimitingEnabled = true;
                this.resourceGroupPublishLimiter = resourceGroup.getResourceGroupPublishLimiter();
                this.resourceGroupPublishLimiter.registerRateLimitFunction(this.getName(), () -> this.enableCnxAutoRead());
                log.info("Using resource group {} rate limiter for topic {}", (Object)rgName, (Object)this.topic);
                return;
            }
        } else {
            if (this.resourceGroupRateLimitingEnabled) {
                this.resourceGroupPublishLimiter.unregisterRateLimitFunction(this.getName());
                this.resourceGroupPublishLimiter = null;
                this.resourceGroupRateLimitingEnabled = false;
            }
            this.enableProducerReadForPublishRateLimiting();
        }
    }

    public long getMsgInCounter() {
        return this.msgInCounter.longValue();
    }

    public long getBytesInCounter() {
        return this.bytesInCounter.longValue();
    }

    public long getMsgOutCounter() {
        return this.getStats((boolean)false, (boolean)false, (boolean)false).msgOutCounter;
    }

    public long getBytesOutCounter() {
        return this.getStats((boolean)false, (boolean)false, (boolean)false).bytesOutCounter;
    }

    public boolean isDeleteWhileInactive() {
        return this.topicPolicies.getInactiveTopicPolicies().get().isDeleteWhileInactive();
    }

    public boolean deletePartitionedTopicMetadataWhileInactive() {
        return this.brokerService.pulsar().getConfiguration().isBrokerDeleteInactivePartitionedTopicMetadataEnabled();
    }

    protected abstract boolean isTerminated();

    public InactiveTopicPolicies getInactiveTopicPolicies() {
        return this.topicPolicies.getInactiveTopicPolicies().get();
    }

    public Optional<TopicPolicies> getTopicPolicies() {
        return this.brokerService.getTopicPolicies(TopicName.get(this.topic));
    }

    public CompletableFuture<Void> deleteTopicPolicies() {
        return this.brokerService.deleteTopicPolicies(TopicName.get(this.topic));
    }

    protected int getWaitingProducersCount() {
        return this.waitingExclusiveProducers.size();
    }

    protected boolean isExceedMaximumMessageSize(int size, Topic.PublishContext publishContext) {
        if (publishContext.isChunked()) {
            return false;
        }
        int topicMaxMessageSize = this.topicPolicies.getTopicMaxMessageSize().get();
        if (topicMaxMessageSize <= 0) {
            return false;
        }
        if (topicMaxMessageSize >= this.brokerService.pulsar().getConfiguration().getMaxMessageSize()) {
            return false;
        }
        return size > topicMaxMessageSize;
    }

    public void updatePublishDispatcher() {
        PublishRate publishRate = this.topicPolicies.getPublishRate().get();
        if (publishRate.publishThrottlingRateInByte > 0L || publishRate.publishThrottlingRateInMsg > 0) {
            log.info("Enabling publish rate limiting {} ", (Object)publishRate);
            if (!this.preciseTopicPublishRateLimitingEnable) {
                this.brokerService.setupTopicPublishRateLimiterMonitor();
            }
            if (this.topicPublishRateLimiter == null || this.topicPublishRateLimiter == PublishRateLimiter.DISABLED_RATE_LIMITER) {
                this.topicPublishRateLimiter = this.preciseTopicPublishRateLimitingEnable ? new PrecisPublishLimiter(publishRate, () -> this.enableCnxAutoRead(), this.brokerService.pulsar().getExecutor()) : new PublishRateLimiterImpl(publishRate);
            } else {
                this.topicPublishRateLimiter.update(publishRate);
            }
        } else {
            log.info("Disabling publish throttling for {}", (Object)this.topic);
            this.topicPublishRateLimiter = PublishRateLimiter.DISABLED_RATE_LIMITER;
            this.enableProducerReadForPublishRateLimiting();
        }
    }

    public void updateBrokerSubscriptionTypesEnabled() {
        this.topicPolicies.getSubscriptionTypesEnabled().updateBrokerValue(this.subTypeStringsToEnumSet(this.brokerService.pulsar().getConfiguration().getSubscriptionTypesEnabled()));
    }

    @Override
    public HierarchyTopicPolicies getHierarchyTopicPolicies() {
        return this.topicPolicies;
    }

    public void updateBrokerSubscriptionDispatchRate() {
        this.topicPolicies.getSubscriptionDispatchRate().updateBrokerValue(this.subscriptionDispatchRateInBroker(this.brokerService.pulsar().getConfiguration()));
    }
}

