/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.functions.utils;

import org.apache.pulsar.functions.proto.Function;

public class FunctionMetaDataUtils {
    public static boolean canChangeState(Function.FunctionMetaData functionMetaData, int instanceId, Function.FunctionState newState) {
        if (instanceId >= functionMetaData.getFunctionDetails().getParallelism()) {
            return false;
        }
        if (functionMetaData.getInstanceStatesMap() == null || functionMetaData.getInstanceStatesMap().isEmpty()) {
            return newState == Function.FunctionState.STOPPED;
        }
        if (instanceId >= 0) {
            if (functionMetaData.getInstanceStatesMap().containsKey(instanceId)) {
                return functionMetaData.getInstanceStatesMap().get(instanceId) != newState;
            }
            return false;
        }
        for (Function.FunctionState state : functionMetaData.getInstanceStatesMap().values()) {
            if (state == newState) continue;
            return true;
        }
        return false;
    }

    public static Function.FunctionMetaData changeFunctionInstanceStatus(Function.FunctionMetaData functionMetaData, Integer instanceId, boolean start) {
        Function.FunctionState state;
        Function.FunctionMetaData.Builder builder = functionMetaData.toBuilder().setVersion(functionMetaData.getVersion() + 1L);
        if (builder.getInstanceStatesMap() == null || builder.getInstanceStatesMap().isEmpty()) {
            for (int i = 0; i < functionMetaData.getFunctionDetails().getParallelism(); ++i) {
                builder.putInstanceStates(i, Function.FunctionState.RUNNING);
            }
        }
        Function.FunctionState functionState = state = start ? Function.FunctionState.RUNNING : Function.FunctionState.STOPPED;
        if (instanceId < 0) {
            for (int i = 0; i < functionMetaData.getFunctionDetails().getParallelism(); ++i) {
                builder.putInstanceStates(i, state);
            }
        } else if (instanceId < builder.getFunctionDetails().getParallelism()) {
            builder.putInstanceStates(instanceId, state);
        }
        return builder.build();
    }

    public static Function.FunctionMetaData incrMetadataVersion(Function.FunctionMetaData existingMetaData, Function.FunctionMetaData updatedMetaData) {
        long version = 0L;
        if (existingMetaData != null) {
            version = existingMetaData.getVersion() + 1L;
        }
        return updatedMetaData.toBuilder().setVersion(version).build();
    }
}

