/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.metadata.bookkeeper;

import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import org.apache.pulsar.metadata.api.GetResult;
import org.apache.pulsar.metadata.api.MetadataStoreException;
import org.apache.pulsar.metadata.api.coordination.CoordinationService;
import org.apache.pulsar.metadata.api.coordination.LockManager;
import org.apache.pulsar.metadata.api.coordination.ResourceLock;
import org.apache.pulsar.metadata.api.extended.MetadataStoreExtended;
import org.apache.pulsar.metadata.bookkeeper.BookieServiceInfoSerde;
import org.apache.pulsar.metadata.bookkeeper.PulsarLayoutManager;
import org.apache.pulsar.metadata.bookkeeper.PulsarLedgerManagerFactory;
import org.apache.pulsar.metadata.bookkeeper.PulsarLedgerUnderreplicationManager;
import org.apache.pulsar.metadata.bookkeeper.PulsarRegistrationClient;
import org.apache.pulsar.metadata.coordination.impl.CoordinationServiceImpl;
import org.apache.pulsar.shade.org.apache.bookkeeper.bookie.BookieException;
import org.apache.pulsar.shade.org.apache.bookkeeper.conf.AbstractConfiguration;
import org.apache.pulsar.shade.org.apache.bookkeeper.discover.BookieServiceInfo;
import org.apache.pulsar.shade.org.apache.bookkeeper.discover.RegistrationManager;
import org.apache.pulsar.shade.org.apache.bookkeeper.net.BookieId;
import org.apache.pulsar.shade.org.apache.bookkeeper.versioning.LongVersion;
import org.apache.pulsar.shade.org.apache.bookkeeper.versioning.Version;
import org.apache.pulsar.shade.org.apache.bookkeeper.versioning.Versioned;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PulsarRegistrationManager
implements RegistrationManager {
    private static final Logger log = LoggerFactory.getLogger(PulsarRegistrationManager.class);
    private final MetadataStoreExtended store;
    private final CoordinationService coordinationService;
    private final LockManager<BookieServiceInfo> lockManager;
    private final AbstractConfiguration<?> conf;
    private final String ledgersRootPath;
    private final String cookiePath;
    private final String bookieRegistrationPath;
    private final String bookieReadonlyRegistrationPath;
    private final Map<BookieId, ResourceLock<BookieServiceInfo>> bookieRegistration = new ConcurrentHashMap<BookieId, ResourceLock<BookieServiceInfo>>();
    private final Map<BookieId, ResourceLock<BookieServiceInfo>> bookieRegistrationReadOnly = new ConcurrentHashMap<BookieId, ResourceLock<BookieServiceInfo>>();

    PulsarRegistrationManager(MetadataStoreExtended store, String ledgersRootPath, AbstractConfiguration<?> conf) {
        this.store = store;
        this.conf = conf;
        this.coordinationService = new CoordinationServiceImpl(store);
        this.lockManager = this.coordinationService.getLockManager(BookieServiceInfoSerde.INSTANCE);
        this.ledgersRootPath = ledgersRootPath;
        this.cookiePath = ledgersRootPath + "/" + "cookies";
        this.bookieRegistrationPath = ledgersRootPath + "/" + "available";
        this.bookieReadonlyRegistrationPath = this.bookieRegistrationPath + "/" + "readonly";
    }

    @Override
    public void close() {
        for (ResourceLock<BookieServiceInfo> rwBookie : this.bookieRegistration.values()) {
            rwBookie.release().get();
        }
        for (ResourceLock<BookieServiceInfo> roBookie : this.bookieRegistrationReadOnly.values()) {
            roBookie.release().get();
        }
        this.coordinationService.close();
    }

    @Override
    public String getClusterInstanceId() throws BookieException {
        try {
            return this.store.get(this.ledgersRootPath + "/" + "INSTANCEID").get().map(res -> new String(res.getValue(), StandardCharsets.UTF_8)).orElseThrow(() -> new BookieException.MetadataStoreException("BookKeeper cluster not initialized"));
        }
        catch (InterruptedException | ExecutionException e) {
            throw new BookieException.MetadataStoreException("Failed to get cluster instance id", (Throwable)e);
        }
    }

    @Override
    public void registerBookie(BookieId bookieId, boolean readOnly, BookieServiceInfo bookieServiceInfo) throws BookieException {
        String regPath = this.bookieRegistrationPath + "/" + bookieId;
        String regPathReadOnly = this.bookieReadonlyRegistrationPath + "/" + bookieId;
        try {
            if (readOnly) {
                ResourceLock<BookieServiceInfo> rwRegistration = this.bookieRegistration.remove(bookieId);
                if (rwRegistration != null) {
                    rwRegistration.release().get();
                }
                this.bookieRegistrationReadOnly.put(bookieId, this.lockManager.acquireLock(regPathReadOnly, bookieServiceInfo).get());
            } else {
                ResourceLock<BookieServiceInfo> roRegistration = this.bookieRegistrationReadOnly.remove(bookieId);
                if (roRegistration != null) {
                    roRegistration.release().get();
                }
                this.bookieRegistration.put(bookieId, this.lockManager.acquireLock(regPath, bookieServiceInfo).get());
            }
        }
        catch (ExecutionException ee) {
            log.error("Exception registering ephemeral node for Bookie!", (Throwable)ee);
            throw new BookieException.MetadataStoreException(ee);
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
            log.error("Interrupted exception while registering Bookie!", (Throwable)ie);
            throw new BookieException.MetadataStoreException(ie);
        }
    }

    @Override
    public void unregisterBookie(BookieId bookieId, boolean readOnly) throws BookieException {
        try {
            if (readOnly) {
                ResourceLock<BookieServiceInfo> roRegistration = this.bookieRegistrationReadOnly.get(bookieId);
                if (roRegistration != null) {
                    roRegistration.release().get();
                }
            } else {
                ResourceLock<BookieServiceInfo> rwRegistration = this.bookieRegistration.get(bookieId);
                if (rwRegistration != null) {
                    rwRegistration.release().get();
                }
            }
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
            throw new BookieException.MetadataStoreException(ie);
        }
        catch (ExecutionException e) {
            throw new BookieException.MetadataStoreException(e);
        }
    }

    @Override
    public boolean isBookieRegistered(BookieId bookieId) throws BookieException {
        String regPath = this.bookieRegistrationPath + "/" + bookieId;
        String readonlyRegPath = this.bookieReadonlyRegistrationPath + "/" + bookieId;
        try {
            return this.store.exists(regPath).get() != false || this.store.exists(readonlyRegPath).get() != false;
        }
        catch (ExecutionException e) {
            log.error("Exception while checking registration ephemeral nodes for BookieId: {}", (Object)bookieId, (Object)e);
            throw new BookieException.MetadataStoreException(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            log.error("InterruptedException while checking registration ephemeral nodes for BookieId: {}", (Object)bookieId, (Object)e);
            throw new BookieException.MetadataStoreException(e);
        }
    }

    @Override
    public void writeCookie(BookieId bookieId, Versioned<byte[]> cookieData) throws BookieException {
        String path = this.cookiePath + "/" + bookieId;
        try {
            long version;
            if (Version.NEW == cookieData.getVersion()) {
                version = -1L;
            } else {
                if (!(cookieData.getVersion() instanceof LongVersion)) {
                    throw new BookieException.BookieIllegalOpException("Invalid version type, expected it to be LongVersion");
                }
                version = ((LongVersion)cookieData.getVersion()).getLongVersion();
            }
            this.store.put(path, cookieData.getValue(), Optional.of(version)).get();
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
            throw new BookieException.MetadataStoreException("Interrupted writing cookie for bookie " + bookieId, (Throwable)ie);
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof MetadataStoreException.BadVersionException) {
                throw new BookieException.CookieExistException(bookieId.toString());
            }
            throw new BookieException.MetadataStoreException("Failed to write cookie for bookie " + bookieId);
        }
    }

    @Override
    public Versioned<byte[]> readCookie(BookieId bookieId) throws BookieException {
        String path = this.cookiePath + "/" + bookieId;
        try {
            Optional<GetResult> res = this.store.get(path).get();
            if (!res.isPresent()) {
                throw new BookieException.CookieNotFoundException(bookieId.toString());
            }
            LongVersion version = new LongVersion(res.get().getStat().getVersion());
            return new Versioned<byte[]>(res.get().getValue(), version);
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
            throw new BookieException.MetadataStoreException(ie);
        }
        catch (ExecutionException e) {
            throw new BookieException.MetadataStoreException(e);
        }
    }

    @Override
    public void removeCookie(BookieId bookieId, Version version) throws BookieException {
        String path = this.cookiePath + "/" + bookieId;
        try {
            this.store.delete(path, Optional.of(((LongVersion)version).getLongVersion())).get();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new BookieException.MetadataStoreException("Interrupted deleting cookie for bookie " + bookieId, (Throwable)e);
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof MetadataStoreException.NotFoundException) {
                throw new BookieException.CookieNotFoundException(bookieId.toString());
            }
            throw new BookieException.MetadataStoreException("Failed to delete cookie for bookie " + bookieId);
        }
        log.info("Removed cookie from {} for bookie {}.", (Object)this.cookiePath, (Object)bookieId);
    }

    @Override
    public boolean prepareFormat() throws Exception {
        boolean ledgerRootExists = this.store.exists(this.ledgersRootPath).get();
        boolean availableNodeExists = this.store.exists(this.bookieRegistrationPath).get();
        if (!ledgerRootExists) {
            this.store.put(this.ledgersRootPath, new byte[0], Optional.empty()).get();
        }
        if (!availableNodeExists) {
            this.store.put(this.bookieRegistrationPath, new byte[0], Optional.empty()).get();
        }
        if (!this.store.exists(this.bookieReadonlyRegistrationPath).get().booleanValue()) {
            this.store.put(this.bookieReadonlyRegistrationPath, new byte[0], Optional.empty()).get();
        }
        return ledgerRootExists;
    }

    @Override
    public boolean initNewCluster() throws Exception {
        String instanceIdPath = this.ledgersRootPath + "/" + "INSTANCEID";
        log.info("Initializing metadata for new cluster, ledger root path: {}", (Object)this.ledgersRootPath);
        if (this.store.exists(instanceIdPath).get().booleanValue()) {
            log.error("Ledger root path: {} already exists", (Object)this.ledgersRootPath);
            return false;
        }
        this.store.put(this.ledgersRootPath, new byte[0], Optional.empty()).get();
        String instanceId = UUID.randomUUID().toString();
        this.store.put(instanceIdPath, instanceId.getBytes(StandardCharsets.UTF_8), Optional.of(-1L)).join();
        log.info("Successfully initiated cluster. ledger root path: {} instanceId: {}", (Object)this.ledgersRootPath, (Object)instanceId);
        return true;
    }

    @Override
    public boolean format() throws Exception {
        this.store.deleteRecursive(PulsarLedgerUnderreplicationManager.getBasePath(this.ledgersRootPath) + "/ledgers").get();
        this.store.deleteRecursive(PulsarLedgerUnderreplicationManager.getUrLockPath(this.ledgersRootPath)).get();
        this.store.deleteRecursive(this.cookiePath).get();
        if (this.store.exists(this.ledgersRootPath + "/" + "INSTANCEID").get().booleanValue()) {
            this.store.delete(this.ledgersRootPath + "/" + "INSTANCEID", Optional.empty()).get();
        }
        String instanceId = UUID.randomUUID().toString();
        this.store.put(this.ledgersRootPath + "/" + "INSTANCEID", instanceId.getBytes(StandardCharsets.UTF_8), Optional.of(-1L)).get();
        log.info("Successfully formatted BookKeeper metadata");
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean nukeExistingCluster() throws Exception {
        log.info("Nuking metadata of existing cluster, ledger root path: {}", (Object)this.ledgersRootPath);
        if (!this.store.exists(this.ledgersRootPath + "/" + "INSTANCEID").join().booleanValue()) {
            log.info("There is no existing cluster with ledgersRootPath: {}, so exiting nuke operation", (Object)this.ledgersRootPath);
            return true;
        }
        PulsarRegistrationClient registrationClient = new PulsarRegistrationClient(this.store, this.ledgersRootPath);
        try {
            Collection rwBookies = registrationClient.getWritableBookies().join().getValue();
            if (rwBookies != null && !rwBookies.isEmpty()) {
                log.error("Bookies are still up and connected to this cluster, stop all bookies before nuking the cluster");
                boolean bl = false;
                return bl;
            }
            Collection roBookies = registrationClient.getReadOnlyBookies().join().getValue();
            if (roBookies != null && !roBookies.isEmpty()) {
                log.error("Readonly Bookies are still up and connected to this cluster, stop all bookies before nuking the cluster");
                boolean bl = false;
                return bl;
            }
            PulsarLayoutManager layoutManager = new PulsarLayoutManager(this.store, this.ledgersRootPath);
            PulsarLedgerManagerFactory ledgerManagerFactory = new PulsarLedgerManagerFactory();
            ledgerManagerFactory.initialize(this.conf, layoutManager, 1);
            boolean bl = ledgerManagerFactory.validateAndNukeExistingCluster(this.conf, layoutManager);
            return bl;
        }
        finally {
            if (Collections.singletonList(registrationClient).get(0) != null) {
                registrationClient.close();
            }
        }
    }
}

