/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.shade.org.apache.bookkeeper.common.grpc.stats;

import io.grpc.ClientCall;
import io.grpc.ForwardingClientCallListener;
import io.grpc.Metadata;
import io.grpc.Status;
import org.apache.pulsar.shade.org.apache.bookkeeper.common.grpc.stats.ClientStats;
import org.apache.pulsar.shade.org.apache.bookkeeper.common.util.MathUtils;

class MonitoringClientCallListener<RespT>
extends ForwardingClientCallListener<RespT> {
    private final ClientCall.Listener<RespT> delegate;
    private final ClientStats stats;
    private final long startNanos;

    MonitoringClientCallListener(ClientCall.Listener<RespT> delegate, ClientStats stats) {
        this.delegate = delegate;
        this.stats = stats;
        this.startNanos = MathUtils.nowInNano();
    }

    protected ClientCall.Listener<RespT> delegate() {
        return this.delegate;
    }

    public void onMessage(RespT message) {
        this.stats.recordStreamMessageReceived();
        super.onMessage(message);
    }

    public void onClose(Status status, Metadata trailers) {
        this.stats.recordClientHandled(status.getCode());
        if (this.stats.shouldRecordLatency()) {
            long latencyMicros = MathUtils.elapsedMicroSec(this.startNanos);
            this.stats.recordLatency(Status.OK == status, latencyMicros);
        }
        super.onClose(status, trailers);
    }

    public String toString() {
        return this.delegate.toString();
    }
}

