/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.shade.org.apache.bookkeeper.mledger.offload;

import java.io.File;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.concurrent.CompletableFuture;
import org.apache.pulsar.shade.org.apache.bookkeeper.mledger.LedgerOffloaderFactory;
import org.apache.pulsar.shade.org.apache.bookkeeper.mledger.offload.OffloaderDefinition;
import org.apache.pulsar.shade.org.apache.bookkeeper.mledger.offload.Offloaders;
import org.apache.pulsar.shade.org.apache.commons.lang3.StringUtils;
import org.apache.pulsar.shade.org.apache.commons.lang3.tuple.Pair;
import org.apache.pulsar.shade.org.apache.pulsar.common.nar.NarClassLoader;
import org.apache.pulsar.shade.org.apache.pulsar.common.nar.NarClassLoaderBuilder;
import org.apache.pulsar.shade.org.apache.pulsar.common.util.ObjectMapperFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OffloaderUtils {
    private static final Logger log = LoggerFactory.getLogger(OffloaderUtils.class);
    private static final String PULSAR_OFFLOADER_SERVICE_NAME = "pulsar-offloader.yaml";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Pair<NarClassLoader, LedgerOffloaderFactory> getOffloaderFactory(String narPath, String narExtractionDirectory) throws IOException {
        Pair<NarClassLoader, LedgerOffloaderFactory> pair;
        NarClassLoader ncl = NarClassLoaderBuilder.builder().narFile(new File(narPath)).parentClassLoader(LedgerOffloaderFactory.class.getClassLoader()).extractionDirectory(narExtractionDirectory).build();
        String configStr = ncl.getServiceDefinition(PULSAR_OFFLOADER_SERVICE_NAME);
        OffloaderDefinition conf = ObjectMapperFactory.getThreadLocalYaml().readValue(configStr, OffloaderDefinition.class);
        if (StringUtils.isEmpty(conf.getOffloaderFactoryClass())) {
            throw new IOException(String.format("The '%s' offloader does not provide an offloader factory implementation", conf.getName()));
        }
        Class<?> factoryClass = ncl.loadClass(conf.getOffloaderFactoryClass());
        CompletableFuture loadFuture = new CompletableFuture();
        Thread loadingThread = new Thread(() -> {
            Thread.currentThread().setContextClassLoader(ncl);
            try {
                Object offloader = factoryClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                if (!(offloader instanceof LedgerOffloaderFactory)) {
                    throw new IOException("Class " + conf.getOffloaderFactoryClass() + " does not implement interface " + LedgerOffloaderFactory.class.getName());
                }
                loadFuture.complete((LedgerOffloaderFactory)offloader);
            }
            catch (Throwable t) {
                loadFuture.completeExceptionally(t);
            }
        }, "load-factory-" + factoryClass);
        try {
            loadingThread.start();
            pair = Pair.of(ncl, loadFuture.get());
        }
        catch (Throwable throwable) {
            try {
                loadingThread.join();
                throw throwable;
            }
            catch (Throwable t) {
                OffloaderUtils.rethrowIOException(t);
                return null;
            }
        }
        loadingThread.join();
        return pair;
    }

    private static void rethrowIOException(Throwable cause) throws IOException {
        if (cause instanceof IOException) {
            throw (IOException)cause;
        }
        if (cause instanceof RuntimeException) {
            throw (RuntimeException)cause;
        }
        if (cause instanceof Error) {
            throw (Error)cause;
        }
        throw new IOException(cause.getMessage(), cause);
    }

    public static OffloaderDefinition getOffloaderDefinition(String narPath, String narExtractionDirectory) throws IOException {
        try (NarClassLoader ncl = NarClassLoaderBuilder.builder().narFile(new File(narPath)).parentClassLoader(LedgerOffloaderFactory.class.getClassLoader()).extractionDirectory(narExtractionDirectory).build();){
            String configStr = ncl.getServiceDefinition(PULSAR_OFFLOADER_SERVICE_NAME);
            OffloaderDefinition offloaderDefinition = ObjectMapperFactory.getThreadLocalYaml().readValue(configStr, OffloaderDefinition.class);
            return offloaderDefinition;
        }
    }

    public static Offloaders searchForOffloaders(String offloadersPath, String narExtractionDirectory) throws IOException {
        Path path = Paths.get(offloadersPath, new String[0]).toAbsolutePath();
        log.info("Searching for offloaders in {}", (Object)path);
        Offloaders offloaders = new Offloaders();
        if (!path.toFile().exists()) {
            log.warn("Offloaders archive directory not found");
            return offloaders;
        }
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(path, "*.nar");){
            stream.forEach(archive -> {
                try {
                    Pair<NarClassLoader, LedgerOffloaderFactory> offloaderFactoryPair;
                    OffloaderDefinition definition = OffloaderUtils.getOffloaderDefinition(archive.toString(), narExtractionDirectory);
                    log.info("Found offloader {} from {}", (Object)definition, archive);
                    if (!StringUtils.isEmpty(definition.getOffloaderFactoryClass()) && null != (offloaderFactoryPair = OffloaderUtils.getOffloaderFactory(archive.toString(), narExtractionDirectory))) {
                        offloaders.getOffloaders().add(offloaderFactoryPair);
                    }
                }
                catch (Throwable t) {
                    log.warn("Failed to load offloader from {}", archive, (Object)t);
                }
            });
        }
        log.info("Found and loaded {} offloaders", (Object)offloaders.getOffloaders().size());
        return offloaders;
    }
}

