/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.shade.org.apache.bookkeeper.mledger.util;

import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.pulsar.shade.org.apache.bookkeeper.mledger.AsyncCallbacks;
import org.apache.pulsar.shade.org.apache.bookkeeper.mledger.ManagedLedgerException;

public class Futures {
    public static final CompletableFuture<Void> NULL_PROMISE = CompletableFuture.completedFuture(null);

    public static CompletableFuture<Void> waitForAll(List<CompletableFuture<Void>> futures) {
        CompletableFuture<Void> compositeFuture = new CompletableFuture<Void>();
        AtomicInteger count = new AtomicInteger(futures.size());
        for (CompletableFuture<Void> future : futures) {
            future.whenComplete((r, ex) -> {
                if (ex != null) {
                    compositeFuture.completeExceptionally((Throwable)ex);
                } else if (count.decrementAndGet() == 0) {
                    compositeFuture.complete(null);
                }
            });
        }
        if (futures.isEmpty()) {
            compositeFuture.complete(null);
        }
        return compositeFuture;
    }

    public static class CloseFuture
    extends CompletableFuture<Void>
    implements AsyncCallbacks.CloseCallback {
        @Override
        public void closeComplete(Object ctx) {
            this.complete(null);
        }

        @Override
        public void closeFailed(ManagedLedgerException exception, Object ctx) {
            this.completeExceptionally(exception);
        }
    }
}

