/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.shade.org.apache.bookkeeper.mledger.util;

import org.apache.pulsar.shade.com.google.common.collect.ComparisonChain;
import org.apache.pulsar.shade.org.apache.bookkeeper.mledger.impl.PositionImpl;
import org.apache.pulsar.shade.org.apache.pulsar.common.util.collections.BitSetRecyclable;

public class PositionAckSetUtil {
    public static boolean isAckSetOverlap(long[] currentAckSet, long[] otherAckSet) {
        if (currentAckSet == null || otherAckSet == null) {
            return false;
        }
        BitSetRecyclable currentBitSet = BitSetRecyclable.valueOf(currentAckSet);
        BitSetRecyclable otherBitSet = BitSetRecyclable.valueOf(otherAckSet);
        currentBitSet.flip(0, currentBitSet.size());
        otherBitSet.flip(0, otherBitSet.size());
        currentBitSet.and(otherBitSet);
        boolean isAckSetRepeated = !currentBitSet.isEmpty();
        currentBitSet.recycle();
        otherBitSet.recycle();
        return isAckSetRepeated;
    }

    public static void andAckSet(PositionImpl currentPosition, PositionImpl otherPosition) {
        if (currentPosition == null || otherPosition == null) {
            return;
        }
        BitSetRecyclable thisAckSet = BitSetRecyclable.valueOf(currentPosition.getAckSet());
        BitSetRecyclable otherAckSet = BitSetRecyclable.valueOf(otherPosition.getAckSet());
        thisAckSet.and(otherAckSet);
        currentPosition.setAckSet(thisAckSet.toLongArray());
        thisAckSet.recycle();
        otherAckSet.recycle();
    }

    public static int compareToWithAckSet(PositionImpl currentPosition, PositionImpl otherPosition) {
        if (currentPosition == null || otherPosition == null) {
            throw new IllegalArgumentException("Two positions can't be null! current position : [" + currentPosition + "] other position : [" + otherPosition + "]");
        }
        int result = ComparisonChain.start().compare(currentPosition.getLedgerId(), otherPosition.getLedgerId()).compare(currentPosition.getEntryId(), otherPosition.getEntryId()).result();
        if (result == 0) {
            BitSetRecyclable otherAckSet = otherPosition.getAckSet() == null ? BitSetRecyclable.create() : BitSetRecyclable.valueOf(otherPosition.getAckSet());
            BitSetRecyclable currentAckSet = currentPosition.getAckSet() == null ? BitSetRecyclable.create() : BitSetRecyclable.valueOf(currentPosition.getAckSet());
            result = currentAckSet.isEmpty() || otherAckSet.isEmpty() ? -(currentAckSet.nextSetBit(0) - otherAckSet.nextSetBit(0)) : currentAckSet.nextSetBit(0) - otherAckSet.nextSetBit(0);
            currentAckSet.recycle();
            otherAckSet.recycle();
        }
        return result;
    }
}

