/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.shade.org.apache.pulsar.common.nar;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Enumeration;
import java.util.concurrent.ConcurrentHashMap;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.apache.pulsar.shade.com.google.common.annotations.VisibleForTesting;
import org.apache.pulsar.shade.org.apache.pulsar.common.nar.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NarUnpacker {
    private static final Logger log = LoggerFactory.getLogger(NarUnpacker.class);
    private static final ConcurrentHashMap<String, Object> CURRENT_JVM_FILE_LOCKS = new ConcurrentHashMap();

    public static File unpackNar(File nar, File baseWorkingDirectory) throws IOException {
        return NarUnpacker.doUnpackNar(nar, baseWorkingDirectory, null);
    }

    /*
     * Exception decompiling
     */
    @VisibleForTesting
    static File doUnpackNar(File nar, File baseWorkingDirectory, Runnable extractCallback) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static void unpack(File nar, File workingDirectory) throws IOException {
        try (JarFile jarFile = new JarFile(nar);){
            Enumeration<JarEntry> jarEntries = jarFile.entries();
            while (jarEntries.hasMoreElements()) {
                JarEntry jarEntry = jarEntries.nextElement();
                String name = jarEntry.getName();
                File f = new File(workingDirectory, name);
                if (jarEntry.isDirectory()) {
                    FileUtils.ensureDirectoryExistAndCanReadAndWrite(f);
                    continue;
                }
                NarUnpacker.makeFile(jarFile.getInputStream(jarEntry), f);
            }
        }
    }

    private static void makeFile(InputStream inputStream, File file) throws IOException {
        try (InputStream in = inputStream;
             FileOutputStream fos = new FileOutputStream(file);){
            int numRead;
            byte[] bytes = new byte[65536];
            while ((numRead = in.read(bytes)) != -1) {
                fos.write(bytes, 0, numRead);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static byte[] calculateMd5sum(File file) throws IOException {
        try (FileInputStream inputStream = new FileInputStream(file);){
            MessageDigest md5 = MessageDigest.getInstance("md5");
            byte[] buffer = new byte[1024];
            int read = inputStream.read(buffer);
            while (read > -1) {
                md5.update(buffer, 0, read);
                read = inputStream.read(buffer);
            }
            byte[] byArray = md5.digest();
            return byArray;
        }
        catch (NoSuchAlgorithmException nsae) {
            throw new IllegalArgumentException(nsae);
        }
    }

    private static /* synthetic */ Object lambda$doUnpackNar$0(String key) {
        return new Object();
    }
}

