/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.shade.org.apache.pulsar.common.policies.data;

import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;

public class PolicyHierarchyValue<T> {
    private static final AtomicReferenceFieldUpdater<PolicyHierarchyValue, Object> VALUE_UPDATER = AtomicReferenceFieldUpdater.newUpdater(PolicyHierarchyValue.class, Object.class, "value");
    private volatile T brokerValue;
    private volatile T namespaceValue;
    private volatile T topicValue;
    private volatile T value;

    public void updateBrokerValue(T brokerValue) {
        this.brokerValue = brokerValue;
        this.updateValue();
    }

    public void updateNamespaceValue(T namespaceValue) {
        this.namespaceValue = namespaceValue;
        this.updateValue();
    }

    public void updateTopicValue(T topicValue) {
        this.topicValue = topicValue;
        this.updateValue();
    }

    private void updateValue() {
        VALUE_UPDATER.updateAndGet(this, preValue -> {
            if (this.topicValue != null) {
                return this.topicValue;
            }
            if (this.namespaceValue != null) {
                return this.namespaceValue;
            }
            return this.brokerValue;
        });
    }

    public T get() {
        return this.value;
    }

    public T getBrokerValue() {
        return this.brokerValue;
    }

    public T getNamespaceValue() {
        return this.namespaceValue;
    }

    public T getTopicValue() {
        return this.topicValue;
    }
}

