/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.shade.org.apache.pulsar.common.schema;

import org.apache.pulsar.shade.org.apache.pulsar.common.classification.InterfaceAudience;
import org.apache.pulsar.shade.org.apache.pulsar.common.classification.InterfaceStability;

@InterfaceAudience.Public
@InterfaceStability.Stable
public enum SchemaType {
    NONE(0),
    STRING(1),
    JSON(2),
    PROTOBUF(3),
    AVRO(4),
    BOOLEAN(5),
    INT8(6),
    INT16(7),
    INT32(8),
    INT64(9),
    FLOAT(10),
    DOUBLE(11),
    DATE(12),
    TIME(13),
    TIMESTAMP(14),
    KEY_VALUE(15),
    INSTANT(16),
    LOCAL_DATE(17),
    LOCAL_TIME(18),
    LOCAL_DATE_TIME(19),
    PROTOBUF_NATIVE(20),
    BYTES(-1),
    AUTO(-2),
    AUTO_CONSUME(-3),
    AUTO_PUBLISH(-4);

    final int value;

    private SchemaType(int value) {
        this.value = value;
    }

    public int getValue() {
        return this.value;
    }

    public static SchemaType valueOf(int value) {
        switch (value) {
            case 0: {
                return NONE;
            }
            case 1: {
                return STRING;
            }
            case 2: {
                return JSON;
            }
            case 3: {
                return PROTOBUF;
            }
            case 4: {
                return AVRO;
            }
            case 5: {
                return BOOLEAN;
            }
            case 6: {
                return INT8;
            }
            case 7: {
                return INT16;
            }
            case 8: {
                return INT32;
            }
            case 9: {
                return INT64;
            }
            case 10: {
                return FLOAT;
            }
            case 11: {
                return DOUBLE;
            }
            case 12: {
                return DATE;
            }
            case 13: {
                return TIME;
            }
            case 14: {
                return TIMESTAMP;
            }
            case 15: {
                return KEY_VALUE;
            }
            case 16: {
                return INSTANT;
            }
            case 17: {
                return LOCAL_DATE;
            }
            case 18: {
                return LOCAL_TIME;
            }
            case 19: {
                return LOCAL_DATE_TIME;
            }
            case 20: {
                return PROTOBUF_NATIVE;
            }
            case -1: {
                return BYTES;
            }
            case -2: {
                return AUTO;
            }
            case -3: {
                return AUTO_CONSUME;
            }
            case -4: {
                return AUTO_PUBLISH;
            }
        }
        return NONE;
    }

    public boolean isPrimitive() {
        return SchemaType.isPrimitiveType(this);
    }

    public boolean isStruct() {
        return SchemaType.isStructType(this);
    }

    public static boolean isPrimitiveType(SchemaType type) {
        switch (type) {
            case STRING: 
            case BOOLEAN: 
            case INT8: 
            case INT16: 
            case INT32: 
            case INT64: 
            case FLOAT: 
            case DOUBLE: 
            case DATE: 
            case TIME: 
            case TIMESTAMP: 
            case BYTES: 
            case INSTANT: 
            case LOCAL_DATE: 
            case LOCAL_TIME: 
            case LOCAL_DATE_TIME: 
            case NONE: {
                return true;
            }
        }
        return false;
    }

    public static boolean isStructType(SchemaType type) {
        switch (type) {
            case AVRO: 
            case JSON: 
            case PROTOBUF: 
            case PROTOBUF_NATIVE: {
                return true;
            }
        }
        return false;
    }
}

