/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.shade.org.apache.pulsar.common.util;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Set;
import javax.net.ssl.SSLException;
import org.apache.pulsar.client.api.AuthenticationDataProvider;
import org.apache.pulsar.shade.io.netty.handler.ssl.SslContext;
import org.apache.pulsar.shade.io.netty.handler.ssl.SslProvider;
import org.apache.pulsar.shade.org.apache.pulsar.common.util.FileModifiedTimeUpdater;
import org.apache.pulsar.shade.org.apache.pulsar.common.util.SecurityUtility;
import org.apache.pulsar.shade.org.apache.pulsar.common.util.SslContextAutoRefreshBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NettyClientSslContextRefresher
extends SslContextAutoRefreshBuilder<SslContext> {
    private static final Logger log = LoggerFactory.getLogger(NettyClientSslContextRefresher.class);
    private volatile SslContext sslNettyContext;
    private final boolean tlsAllowInsecureConnection;
    protected final FileModifiedTimeUpdater tlsTrustCertsFilePath;
    protected final FileModifiedTimeUpdater tlsCertsFilePath;
    protected final FileModifiedTimeUpdater tlsPrivateKeyFilePath;
    private final AuthenticationDataProvider authData;
    private final SslProvider sslProvider;
    private final Set<String> ciphers;
    private final Set<String> protocols;

    public NettyClientSslContextRefresher(SslProvider sslProvider, boolean allowInsecure, String trustCertsFilePath, AuthenticationDataProvider authData, Set<String> ciphers, Set<String> protocols, long delayInSeconds) throws IOException, GeneralSecurityException {
        super(delayInSeconds);
        this.tlsAllowInsecureConnection = allowInsecure;
        this.tlsTrustCertsFilePath = new FileModifiedTimeUpdater(trustCertsFilePath);
        this.authData = authData;
        this.tlsCertsFilePath = new FileModifiedTimeUpdater(authData != null ? authData.getTlsCerificateFilePath() : null);
        this.tlsPrivateKeyFilePath = new FileModifiedTimeUpdater(authData != null ? authData.getTlsPrivateKeyFilePath() : null);
        this.sslProvider = sslProvider;
        this.ciphers = ciphers;
        this.protocols = protocols;
    }

    @Override
    public synchronized SslContext update() throws SSLException, FileNotFoundException, GeneralSecurityException, IOException {
        this.sslNettyContext = this.authData != null && this.authData.hasDataForTls() ? (this.authData.getTlsTrustStoreStream() == null ? SecurityUtility.createNettySslContextForClient(this.sslProvider, this.tlsAllowInsecureConnection, this.tlsTrustCertsFilePath.getFileName(), (Certificate[])((X509Certificate[])this.authData.getTlsCertificates()), this.authData.getTlsPrivateKey(), this.ciphers, this.protocols) : SecurityUtility.createNettySslContextForClient(this.sslProvider, this.tlsAllowInsecureConnection, this.authData.getTlsTrustStoreStream(), (Certificate[])((X509Certificate[])this.authData.getTlsCertificates()), this.authData.getTlsPrivateKey(), this.ciphers, this.protocols)) : SecurityUtility.createNettySslContextForClient(this.sslProvider, this.tlsAllowInsecureConnection, this.tlsTrustCertsFilePath.getFileName(), this.ciphers, this.protocols);
        return this.sslNettyContext;
    }

    @Override
    public SslContext getSslContext() {
        return this.sslNettyContext;
    }

    @Override
    public boolean needUpdate() {
        return this.tlsTrustCertsFilePath.checkAndRefresh() || this.tlsCertsFilePath.checkAndRefresh() || this.tlsPrivateKeyFilePath.checkAndRefresh();
    }
}

