/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.shade.org.apache.pulsar.common.util.collections;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.locks.StampedLock;
import java.util.function.LongFunction;
import org.apache.pulsar.shade.com.google.common.base.Preconditions;
import org.apache.pulsar.shade.com.google.common.collect.Lists;

public class ConcurrentLongHashMap<V> {
    private static final Object EmptyValue = null;
    private static final Object DeletedValue = new Object();
    private static final float MapFillFactor = 0.66f;
    private static final int DefaultExpectedItems = 256;
    private static final int DefaultConcurrencyLevel = 16;
    private final Section<V>[] sections;
    private static final long HashMixer = -4132994306676758123L;
    private static final int R = 47;

    public ConcurrentLongHashMap() {
        this(256);
    }

    public ConcurrentLongHashMap(int expectedItems) {
        this(expectedItems, 16);
    }

    public ConcurrentLongHashMap(int expectedItems, int concurrencyLevel) {
        Preconditions.checkArgument(expectedItems > 0);
        Preconditions.checkArgument(concurrencyLevel > 0);
        Preconditions.checkArgument(expectedItems >= concurrencyLevel);
        int numSections = concurrencyLevel;
        int perSectionExpectedItems = expectedItems / numSections;
        int perSectionCapacity = (int)((float)perSectionExpectedItems / 0.66f);
        this.sections = new Section[numSections];
        for (int i = 0; i < numSections; ++i) {
            this.sections[i] = new Section(perSectionCapacity);
        }
    }

    public long size() {
        long size = 0L;
        for (Section<V> s : this.sections) {
            size += (long)((Section)s).size;
        }
        return size;
    }

    long getUsedBucketCount() {
        long usedBucketCount = 0L;
        for (Section<V> s : this.sections) {
            usedBucketCount += (long)((Section)s).usedBuckets;
        }
        return usedBucketCount;
    }

    public long capacity() {
        long capacity = 0L;
        for (Section<V> s : this.sections) {
            capacity += (long)((Section)s).capacity;
        }
        return capacity;
    }

    public boolean isEmpty() {
        for (Section<V> s : this.sections) {
            if (((Section)s).size == 0) continue;
            return false;
        }
        return true;
    }

    public V get(long key) {
        long h = ConcurrentLongHashMap.hash(key);
        return this.getSection(h).get(key, (int)h);
    }

    public boolean containsKey(long key) {
        return this.get(key) != null;
    }

    public V put(long key, V value) {
        Objects.requireNonNull(value);
        long h = ConcurrentLongHashMap.hash(key);
        return this.getSection(h).put(key, value, (int)h, false, null);
    }

    public V putIfAbsent(long key, V value) {
        Objects.requireNonNull(value);
        long h = ConcurrentLongHashMap.hash(key);
        return this.getSection(h).put(key, value, (int)h, true, null);
    }

    public V computeIfAbsent(long key, LongFunction<V> provider) {
        Objects.requireNonNull(provider);
        long h = ConcurrentLongHashMap.hash(key);
        return this.getSection(h).put(key, null, (int)h, true, provider);
    }

    public V remove(long key) {
        long h = ConcurrentLongHashMap.hash(key);
        return (V)((Section)this.getSection(h)).remove(key, null, (int)h);
    }

    public boolean remove(long key, Object value) {
        Objects.requireNonNull(value);
        long h = ConcurrentLongHashMap.hash(key);
        return ((Section)this.getSection(h)).remove(key, value, (int)h) != null;
    }

    private Section<V> getSection(long hash) {
        int sectionIdx = (int)(hash >>> 32) & this.sections.length - 1;
        return this.sections[sectionIdx];
    }

    public void clear() {
        for (int i = 0; i < this.sections.length; ++i) {
            this.sections[i].clear();
        }
    }

    public void forEach(EntryProcessor<V> processor) {
        for (int i = 0; i < this.sections.length; ++i) {
            this.sections[i].forEach(processor);
        }
    }

    public List<Long> keys() {
        ArrayList<Long> keys = Lists.newArrayListWithExpectedSize((int)this.size());
        this.forEach((key, value) -> keys.add(key));
        return keys;
    }

    public List<V> values() {
        ArrayList values = Lists.newArrayListWithExpectedSize((int)this.size());
        this.forEach((key, value) -> values.add(value));
        return values;
    }

    static final long hash(long key) {
        long hash = key * -4132994306676758123L;
        hash ^= hash >>> 47;
        return hash *= -4132994306676758123L;
    }

    static final int signSafeMod(long n, int max) {
        return (int)n & max - 1;
    }

    private static int alignToPowerOfTwo(int n) {
        return (int)Math.pow(2.0, 32 - Integer.numberOfLeadingZeros(n - 1));
    }

    private static final class Section<V>
    extends StampedLock {
        private volatile long[] keys;
        private volatile V[] values;
        private volatile int capacity;
        private static final AtomicIntegerFieldUpdater<Section> SIZE_UPDATER = AtomicIntegerFieldUpdater.newUpdater(Section.class, "size");
        private volatile int size;
        private int usedBuckets;
        private int resizeThreshold;

        Section(int capacity) {
            this.capacity = ConcurrentLongHashMap.alignToPowerOfTwo(capacity);
            this.keys = new long[this.capacity];
            this.values = new Object[this.capacity];
            this.size = 0;
            this.usedBuckets = 0;
            this.resizeThreshold = (int)((float)this.capacity * 0.66f);
        }

        V get(long key, int keyHash) {
            int bucket = keyHash;
            long stamp = this.tryOptimisticRead();
            boolean acquiredLock = false;
            try {
                while (true) {
                    int capacity = this.capacity;
                    bucket = ConcurrentLongHashMap.signSafeMod(bucket, capacity);
                    long storedKey = this.keys[bucket];
                    V storedValue = this.values[bucket];
                    if (!acquiredLock && this.validate(stamp)) {
                        if (storedKey == key) {
                            V v = storedValue != DeletedValue ? storedValue : null;
                            return v;
                        }
                        if (storedValue == EmptyValue) {
                            V v = null;
                            return v;
                        }
                    } else {
                        if (!acquiredLock) {
                            stamp = this.readLock();
                            acquiredLock = true;
                            storedKey = this.keys[bucket];
                            storedValue = this.values[bucket];
                        }
                        if (capacity != this.capacity) {
                            bucket = keyHash;
                            continue;
                        }
                        if (storedKey == key) {
                            V v = storedValue != DeletedValue ? storedValue : null;
                            return v;
                        }
                        if (storedValue == EmptyValue) {
                            V v = null;
                            return v;
                        }
                    }
                    ++bucket;
                }
            }
            finally {
                if (acquiredLock) {
                    this.unlockRead(stamp);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        V put(long key, V value, int keyHash, boolean onlyIfAbsent, LongFunction<V> valueProvider) {
            int bucket = keyHash;
            long stamp = this.writeLock();
            int capacity = this.capacity;
            int firstDeletedKey = -1;
            try {
                while (true) {
                    bucket = ConcurrentLongHashMap.signSafeMod(bucket, capacity);
                    long storedKey = this.keys[bucket];
                    V storedValue = this.values[bucket];
                    if (storedKey == key) {
                        if (storedValue == EmptyValue) {
                            this.values[bucket] = value != null ? value : valueProvider.apply(key);
                            SIZE_UPDATER.incrementAndGet(this);
                            ++this.usedBuckets;
                            V v = valueProvider != null ? (V)this.values[bucket] : null;
                            return v;
                        }
                        if (storedValue == DeletedValue) {
                            this.values[bucket] = value != null ? value : valueProvider.apply(key);
                            SIZE_UPDATER.incrementAndGet(this);
                            V v = valueProvider != null ? (V)this.values[bucket] : null;
                            return v;
                        }
                        if (!onlyIfAbsent) {
                            this.values[bucket] = value;
                            V v = storedValue;
                            return v;
                        }
                        V v = storedValue;
                        return v;
                    }
                    if (storedValue == EmptyValue) {
                        if (firstDeletedKey != -1) {
                            bucket = firstDeletedKey;
                        } else {
                            ++this.usedBuckets;
                        }
                        this.keys[bucket] = key;
                        this.values[bucket] = value != null ? value : valueProvider.apply(key);
                        SIZE_UPDATER.incrementAndGet(this);
                        V v = valueProvider != null ? (V)this.values[bucket] : null;
                        return v;
                    }
                    if (storedValue == DeletedValue && firstDeletedKey == -1) {
                        firstDeletedKey = bucket;
                    }
                    ++bucket;
                }
            }
            finally {
                if (this.usedBuckets >= this.resizeThreshold) {
                    try {
                        this.rehash();
                    }
                    finally {
                        this.unlockWrite(stamp);
                    }
                } else {
                    this.unlockWrite(stamp);
                }
            }
        }

        private V remove(long key, Object value, int keyHash) {
            int bucket = keyHash;
            long stamp = this.writeLock();
            try {
                while (true) {
                    int capacity = this.capacity;
                    bucket = ConcurrentLongHashMap.signSafeMod(bucket, capacity);
                    long storedKey = this.keys[bucket];
                    V storedValue = this.values[bucket];
                    if (storedKey == key) {
                        if (value == null || value.equals(storedValue)) {
                            if (storedValue == EmptyValue || storedValue == DeletedValue) {
                                V v = null;
                                return v;
                            }
                            SIZE_UPDATER.decrementAndGet(this);
                            V nextValueInArray = this.values[ConcurrentLongHashMap.signSafeMod(bucket + 1, capacity)];
                            if (nextValueInArray == EmptyValue) {
                                this.values[bucket] = EmptyValue;
                                --this.usedBuckets;
                            } else {
                                this.values[bucket] = DeletedValue;
                            }
                            V v = storedValue;
                            return v;
                        }
                        V v = null;
                        return v;
                    }
                    if (storedValue == EmptyValue) {
                        V v = null;
                        return v;
                    }
                    ++bucket;
                }
            }
            finally {
                this.unlockWrite(stamp);
            }
        }

        void clear() {
            long stamp = this.writeLock();
            try {
                Arrays.fill(this.keys, 0L);
                Arrays.fill(this.values, EmptyValue);
                this.size = 0;
                this.usedBuckets = 0;
            }
            finally {
                this.unlockWrite(stamp);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void forEach(EntryProcessor<V> processor) {
            long stamp = this.tryOptimisticRead();
            int capacity = this.capacity;
            long[] keys = this.keys;
            V[] values = this.values;
            if (!this.validate(stamp)) {
                stamp = this.readLock();
                capacity = this.capacity;
                keys = this.keys;
                values = this.values;
                this.unlockRead(stamp);
            }
            for (int bucket = 0; bucket < capacity; ++bucket) {
                if (stamp == 0L) {
                    stamp = this.tryOptimisticRead();
                }
                long storedKey = keys[bucket];
                V storedValue = values[bucket];
                if (!this.validate(stamp)) {
                    stamp = this.readLock();
                    try {
                        storedKey = keys[bucket];
                        storedValue = values[bucket];
                    }
                    finally {
                        this.unlockRead(stamp);
                    }
                    stamp = 0L;
                }
                if (storedValue == DeletedValue || storedValue == EmptyValue) continue;
                processor.accept(storedKey, storedValue);
            }
        }

        private void rehash() {
            int newCapacity = this.capacity * 2;
            long[] newKeys = new long[newCapacity];
            Object[] newValues = new Object[newCapacity];
            for (int i = 0; i < this.keys.length; ++i) {
                long storedKey = this.keys[i];
                V storedValue = this.values[i];
                if (storedValue == EmptyValue || storedValue == DeletedValue) continue;
                Section.insertKeyValueNoLock(newKeys, newValues, storedKey, storedValue);
            }
            this.keys = newKeys;
            this.values = newValues;
            this.capacity = newCapacity;
            this.usedBuckets = this.size;
            this.resizeThreshold = (int)((float)this.capacity * 0.66f);
        }

        private static <V> void insertKeyValueNoLock(long[] keys, V[] values, long key, V value) {
            int bucket = (int)ConcurrentLongHashMap.hash(key);
            while (true) {
                V storedValue;
                if ((storedValue = values[bucket = ConcurrentLongHashMap.signSafeMod(bucket, keys.length)]) == EmptyValue) {
                    keys[bucket] = key;
                    values[bucket] = value;
                    return;
                }
                ++bucket;
            }
        }
    }

    public static interface EntryProcessor<V> {
        public void accept(long var1, V var3);
    }
}

