/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar;

import java.io.FileInputStream;
import java.util.Arrays;
import org.apache.logging.log4j.LogManager;
import org.apache.pulsar.PulsarStandalone;
import org.apache.pulsar.broker.ServiceConfiguration;
import org.apache.pulsar.shade.com.beust.jcommander.JCommander;
import org.apache.pulsar.shade.com.beust.jcommander.Parameter;
import org.apache.pulsar.shade.com.google.common.base.Strings;
import org.apache.pulsar.shade.org.apache.commons.lang3.StringUtils;
import org.apache.pulsar.shade.org.apache.pulsar.common.configuration.PulsarConfigurationLoader;
import org.apache.pulsar.shade.org.apache.pulsar.common.util.CmdGenerateDocs;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PulsarStandaloneStarter
extends PulsarStandalone {
    private static final Logger log = LoggerFactory.getLogger(PulsarStandaloneStarter.class);
    private static final String PULSAR_CONFIG_FILE = "pulsar.config.file";
    @Parameter(names={"-g", "--generate-docs"}, description="Generate docs")
    private boolean generateDocs = false;

    public PulsarStandaloneStarter(String[] args) throws Exception {
        JCommander jcommander = new JCommander();
        try {
            jcommander.addObject(this);
            jcommander.parse(args);
            if (this.isHelp()) {
                jcommander.usage();
                System.exit(0);
            }
            if (Strings.isNullOrEmpty(this.getConfigFile())) {
                String configFile = System.getProperty(PULSAR_CONFIG_FILE);
                if (Strings.isNullOrEmpty(configFile)) {
                    throw new IllegalArgumentException("Config file not specified. Please use -c, --config-file or -Dpulsar.config.file to specify the config file.");
                }
                this.setConfigFile(configFile);
            }
            if (this.generateDocs) {
                CmdGenerateDocs cmd = new CmdGenerateDocs("pulsar");
                cmd.addCommand("standalone", this);
                cmd.run(null);
                System.exit(0);
            }
            if (this.isNoBroker() && this.isOnlyBroker()) {
                log.error("Only one option is allowed between '--no-broker' and '--only-broker'");
                jcommander.usage();
                return;
            }
        }
        catch (Exception e) {
            jcommander.usage();
            log.error(e.getMessage());
            System.exit(1);
        }
        try (FileInputStream inputStream = new FileInputStream(this.getConfigFile());){
            this.config = (ServiceConfiguration)PulsarConfigurationLoader.create(inputStream, ServiceConfiguration.class);
        }
        if (this.getAdvertisedAddress() != null) {
            this.config.setAdvertisedAddress(this.getAdvertisedAddress());
        } else if (StringUtils.isBlank(this.config.getAdvertisedAddress()) && StringUtils.isBlank(this.config.getAdvertisedListeners())) {
            this.config.setAdvertisedAddress("localhost");
        }
        if (!PulsarStandaloneStarter.argsContains(args, "--zookeeper-port") && StringUtils.isNotBlank(this.config.getMetadataStoreUrl())) {
            String[] metadataStoreUrl = this.config.getMetadataStoreUrl().split(",")[0].split(":");
            if (metadataStoreUrl.length == 2) {
                this.setZkPort(Integer.parseInt(metadataStoreUrl[1]));
            } else if (metadataStoreUrl.length == 3) {
                String zkPort = metadataStoreUrl[2];
                if (zkPort.contains("/")) {
                    this.setZkPort(Integer.parseInt(zkPort.substring(0, zkPort.lastIndexOf("/"))));
                } else {
                    this.setZkPort(Integer.parseInt(zkPort));
                }
            }
        }
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            try {
                if (this.fnWorkerService != null) {
                    this.fnWorkerService.stop();
                }
                if (this.broker != null) {
                    this.broker.close();
                }
                if (this.bkEnsemble != null) {
                    this.bkEnsemble.stop();
                }
            }
            catch (Exception e) {
                log.error("Shutdown failed: {}", (Object)e.getMessage(), (Object)e);
            }
            finally {
                LogManager.shutdown();
            }
        }));
    }

    private static boolean argsContains(String[] args, String arg) {
        return Arrays.asList(args).contains(arg);
    }

    public static void main(String[] args) throws Exception {
        PulsarStandaloneStarter standalone = new PulsarStandaloneStarter(args);
        try {
            standalone.start();
        }
        catch (Throwable th) {
            log.error("Failed to start pulsar service.", th);
            LogManager.shutdown();
            Runtime.getRuntime().exit(1);
        }
    }
}

