/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker;

import java.net.InetAddress;
import java.net.URI;
import java.net.UnknownHostException;
import java.util.Map;
import java.util.Optional;
import org.apache.pulsar.broker.ServiceConfiguration;
import org.apache.pulsar.broker.validator.MultipleListenerValidator;
import org.apache.pulsar.shade.org.apache.commons.lang3.StringUtils;
import org.apache.pulsar.shade.org.apache.pulsar.policies.data.loadbalancer.AdvertisedListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceConfigurationUtils {
    private static final Logger LOG = LoggerFactory.getLogger(ServiceConfigurationUtils.class);

    public static String getDefaultOrConfiguredAddress(String configuredAddress) {
        if (StringUtils.isBlank(configuredAddress)) {
            return ServiceConfigurationUtils.unsafeLocalhostResolve();
        }
        return configuredAddress;
    }

    public static String unsafeLocalhostResolve() {
        try {
            return InetAddress.getLocalHost().getCanonicalHostName();
        }
        catch (UnknownHostException ex) {
            LOG.error(ex.getMessage(), (Throwable)ex);
            throw new IllegalStateException("Failed to resolve localhost name.", ex);
        }
    }

    @Deprecated
    public static String getAppliedAdvertisedAddress(ServiceConfiguration configuration, boolean ignoreAdvertisedListener) {
        String address;
        Map<String, AdvertisedListener> result = MultipleListenerValidator.validateAndAnalysisAdvertisedListener(configuration);
        String advertisedAddress = configuration.getAdvertisedAddress();
        if (advertisedAddress != null) {
            return advertisedAddress;
        }
        AdvertisedListener advertisedListener = result.get(configuration.getInternalListenerName());
        if (advertisedListener != null && !ignoreAdvertisedListener && (address = advertisedListener.getBrokerServiceUrl().getHost()) != null) {
            return address;
        }
        return ServiceConfigurationUtils.getDefaultOrConfiguredAddress(advertisedAddress);
    }

    public static AdvertisedListener getInternalListener(ServiceConfiguration config, String protocol) {
        Map<String, AdvertisedListener> result = MultipleListenerValidator.validateAndAnalysisAdvertisedListener(config);
        AdvertisedListener internal = result.get(config.getInternalListenerName());
        if (internal == null || !internal.hasUriForProtocol(protocol)) {
            for (AdvertisedListener l : result.values()) {
                if (!l.hasUriForProtocol(protocol)) continue;
                internal = l;
                break;
            }
        }
        if (internal == null) {
            String host = ServiceConfigurationUtils.getDefaultOrConfiguredAddress(config.getAdvertisedAddress());
            internal = AdvertisedListener.builder().brokerServiceUrl(ServiceConfigurationUtils.createUriOrNull("pulsar", host, config.getBrokerServicePort())).brokerServiceUrlTls(ServiceConfigurationUtils.createUriOrNull("pulsar+ssl", host, config.getBrokerServicePortTls())).build();
        }
        return internal;
    }

    private static URI createUriOrNull(String scheme, String hostname, Optional<Integer> port) {
        return port.map(p -> URI.create(String.format("%s://%s:%d", scheme, hostname, p))).orElse(null);
    }

    public static String getWebServiceAddress(ServiceConfiguration config) {
        return ServiceConfigurationUtils.getDefaultOrConfiguredAddress(config.getAdvertisedAddress());
    }

    public static String brokerUrl(String host, int port) {
        return String.format("pulsar://%s:%d", host, port);
    }

    public static String brokerUrlTls(String host, int port) {
        return String.format("pulsar+ssl://%s:%d", host, port);
    }

    public static String webServiceUrl(String host, int port) {
        return String.format("http://%s:%d", host, port);
    }

    public static String webServiceUrlTls(String host, int port) {
        return String.format("https://%s:%d", host, port);
    }
}

