/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.admin;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.pulsar.broker.PulsarService;
import org.apache.pulsar.broker.ServiceConfiguration;
import org.apache.pulsar.broker.web.PulsarWebResource;
import org.apache.pulsar.broker.web.RestException;
import org.apache.pulsar.client.admin.internal.TopicsImpl;
import org.apache.pulsar.functions.worker.WorkerService;
import org.apache.pulsar.metadata.api.MetadataStoreException;
import org.apache.pulsar.shade.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.pulsar.shade.com.google.common.base.Preconditions;
import org.apache.pulsar.shade.com.google.errorprone.annotations.CanIgnoreReturnValue;
import org.apache.pulsar.shade.javax.servlet.ServletContext;
import org.apache.pulsar.shade.javax.ws.rs.WebApplicationException;
import org.apache.pulsar.shade.javax.ws.rs.container.AsyncResponse;
import org.apache.pulsar.shade.javax.ws.rs.core.Response;
import org.apache.pulsar.shade.org.apache.bookkeeper.client.BookKeeper;
import org.apache.pulsar.shade.org.apache.bookkeeper.mledger.ManagedLedgerException;
import org.apache.pulsar.shade.org.apache.pulsar.common.api.proto.CommandGetTopicsOfNamespace;
import org.apache.pulsar.shade.org.apache.pulsar.common.naming.NamespaceBundle;
import org.apache.pulsar.shade.org.apache.pulsar.common.naming.NamespaceName;
import org.apache.pulsar.shade.org.apache.pulsar.common.naming.TopicDomain;
import org.apache.pulsar.shade.org.apache.pulsar.common.naming.TopicName;
import org.apache.pulsar.shade.org.apache.pulsar.common.partition.PartitionedTopicMetadata;
import org.apache.pulsar.shade.org.apache.pulsar.common.policies.data.BacklogQuota;
import org.apache.pulsar.shade.org.apache.pulsar.common.policies.data.BundlesData;
import org.apache.pulsar.shade.org.apache.pulsar.common.policies.data.ClusterData;
import org.apache.pulsar.shade.org.apache.pulsar.common.policies.data.NamespaceOperation;
import org.apache.pulsar.shade.org.apache.pulsar.common.policies.data.PersistencePolicies;
import org.apache.pulsar.shade.org.apache.pulsar.common.policies.data.Policies;
import org.apache.pulsar.shade.org.apache.pulsar.common.policies.data.PolicyName;
import org.apache.pulsar.shade.org.apache.pulsar.common.policies.data.PolicyOperation;
import org.apache.pulsar.shade.org.apache.pulsar.common.policies.data.RetentionPolicies;
import org.apache.pulsar.shade.org.apache.pulsar.common.policies.data.SchemaCompatibilityStrategy;
import org.apache.pulsar.shade.org.apache.pulsar.common.policies.data.SubscribeRate;
import org.apache.pulsar.shade.org.apache.pulsar.common.policies.data.TopicOperation;
import org.apache.pulsar.shade.org.apache.pulsar.common.policies.data.TopicPolicies;
import org.apache.pulsar.shade.org.apache.pulsar.common.policies.data.impl.DispatchRateImpl;
import org.apache.pulsar.shade.org.apache.pulsar.common.util.Codec;
import org.apache.pulsar.shade.org.apache.pulsar.common.util.FutureUtil;
import org.apache.pulsar.shade.org.apache.pulsar.common.util.ObjectMapperFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AdminResource
extends PulsarWebResource {
    private static final Logger log = LoggerFactory.getLogger(AdminResource.class);
    protected NamespaceName namespaceName;
    protected TopicName topicName;

    protected BookKeeper bookKeeper() {
        return this.pulsar().getBookKeeperClient();
    }

    protected String domain() {
        if (this.uri.getPath().startsWith("persistent/")) {
            return "persistent";
        }
        if (this.uri.getPath().startsWith("non-persistent/")) {
            return "non-persistent";
        }
        throw new RestException(Response.Status.INTERNAL_SERVER_ERROR, "domain() invoked from wrong resource");
    }

    @Override
    public void validateSuperUserAccess() {
        super.validateSuperUserAccess();
    }

    @Override
    protected void validateAdminAccessForTenant(String property) {
        super.validateAdminAccessForTenant(property);
    }

    @Override
    protected void validateBundleOwnership(String property, String cluster, String namespace, boolean authoritative, boolean readOnly, NamespaceBundle bundle) {
        super.validateBundleOwnership(property, cluster, namespace, authoritative, readOnly, bundle);
    }

    @Override
    protected boolean isLeaderBroker() {
        return super.isLeaderBroker();
    }

    @Override
    public void validatePoliciesReadOnlyAccess() {
        try {
            this.validatePoliciesReadOnlyAccessAsync().join();
        }
        catch (CompletionException ce) {
            throw new RestException(ce.getCause());
        }
    }

    @Override
    public CompletableFuture<Void> validatePoliciesReadOnlyAccessAsync() {
        return this.pulsar().getPulsarResources().getNamespaceResources().getPoliciesReadOnlyAsync().thenAccept(arePoliciesReadOnly -> {
            if (arePoliciesReadOnly.booleanValue()) {
                if (log.isDebugEnabled()) {
                    log.debug("Policies are read-only. Broker cannot do read-write operations");
                }
                throw new RestException(Response.Status.FORBIDDEN, "Broker is forbidden to do read-write operations");
            }
            if (log.isDebugEnabled()) {
                log.debug("Broker is allowed to make read-write operations");
            }
        });
    }

    protected CompletableFuture<Void> tryCreatePartitionsAsync(int numPartitions) {
        if (!this.topicName.isPersistent()) {
            return CompletableFuture.completedFuture(null);
        }
        ArrayList<CompletableFuture<Void>> futures = new ArrayList<CompletableFuture<Void>>(numPartitions);
        for (int i = 0; i < numPartitions; ++i) {
            futures.add(this.tryCreatePartitionAsync(i));
        }
        return FutureUtil.waitForAll(futures);
    }

    protected CompletableFuture<Void> tryCreateExtendedPartitionsAsync(int oldNumPartitions, int numPartitions) {
        if (!this.topicName.isPersistent()) {
            return CompletableFuture.completedFuture(null);
        }
        if (numPartitions <= oldNumPartitions) {
            return CompletableFuture.failedFuture(new RestException(Response.Status.NOT_ACCEPTABLE, "Number of new partitions must be greater than existing number of partitions"));
        }
        ArrayList<CompletableFuture<Void>> futures = new ArrayList<CompletableFuture<Void>>(numPartitions - oldNumPartitions);
        for (int i = oldNumPartitions; i < numPartitions; ++i) {
            futures.add(this.tryCreatePartitionAsync(i));
        }
        return FutureUtil.waitForAll(futures);
    }

    private CompletableFuture<Void> tryCreatePartitionAsync(int partition) {
        CompletableFuture<Void> result = new CompletableFuture<Void>();
        ((CompletableFuture)this.getPulsarResources().getTopicResources().createPersistentTopicAsync(this.topicName.getPartition(partition)).thenAccept(r -> {
            if (log.isDebugEnabled()) {
                log.debug("[{}] Topic partition {} created.", (Object)this.clientAppId(), (Object)this.topicName.getPartition(partition));
            }
            result.complete(null);
        })).exceptionally(ex -> {
            if (ex.getCause() instanceof MetadataStoreException.AlreadyExistsException) {
                log.info("[{}] Topic partition {} is exists, doing nothing.", (Object)this.clientAppId(), (Object)this.topicName.getPartition(partition));
                result.complete(null);
            } else if (ex.getCause() instanceof MetadataStoreException.BadVersionException) {
                log.warn("[{}] Partitioned topic {} is already created.", (Object)this.clientAppId(), (Object)this.topicName.getPartition(partition));
                result.complete(null);
            } else {
                log.error("[{}] Fail to create topic partition {}", new Object[]{this.clientAppId(), this.topicName.getPartition(partition), ex.getCause()});
                result.completeExceptionally(ex.getCause());
            }
            return null;
        });
        return result;
    }

    protected void validateNamespaceName(String property, String namespace) {
        try {
            this.namespaceName = NamespaceName.get(property, namespace);
        }
        catch (IllegalArgumentException e) {
            log.warn("[{}] Invalid namespace name [{}/{}]", new Object[]{this.clientAppId(), property, namespace});
            throw new RestException(Response.Status.PRECONDITION_FAILED, "Namespace name is not valid");
        }
    }

    protected void validateGlobalNamespaceOwnership() {
        try {
            this.validateGlobalNamespaceOwnership(this.namespaceName);
        }
        catch (IllegalArgumentException e) {
            throw new RestException(Response.Status.PRECONDITION_FAILED, "Tenant name or namespace is not valid");
        }
        catch (RestException re) {
            throw re;
        }
        catch (Exception e) {
            log.warn("Failed to validate global cluster configuration : ns={}  emsg={}", (Object)this.namespaceName, (Object)e.getMessage());
            throw new RestException(Response.Status.SERVICE_UNAVAILABLE, "Failed to validate global cluster configuration");
        }
    }

    @Deprecated
    protected void validateNamespaceName(String property, String cluster, String namespace) {
        try {
            this.namespaceName = NamespaceName.get(property, cluster, namespace);
        }
        catch (IllegalArgumentException e) {
            log.warn("[{}] Invalid namespace name [{}/{}/{}]", new Object[]{this.clientAppId(), property, cluster, namespace});
            throw new RestException(Response.Status.PRECONDITION_FAILED, "Namespace name is not valid");
        }
    }

    protected void validateTopicName(String property, String namespace, String encodedTopic) {
        String topic = Codec.decode(encodedTopic);
        try {
            this.namespaceName = NamespaceName.get(property, namespace);
            this.topicName = TopicName.get(this.domain(), this.namespaceName, topic);
        }
        catch (IllegalArgumentException e) {
            log.warn("[{}] Invalid topic name [{}://{}/{}/{}]", new Object[]{this.clientAppId(), this.domain(), property, namespace, topic});
            throw new RestException(Response.Status.PRECONDITION_FAILED, "Topic name is not valid");
        }
    }

    protected void validatePersistentTopicName(String property, String namespace, String encodedTopic) {
        this.validateTopicName(property, namespace, encodedTopic);
        if (this.topicName.getDomain() != TopicDomain.persistent) {
            throw new RestException(Response.Status.NOT_ACCEPTABLE, "Need to provide a persistent topic name");
        }
    }

    protected void validatePartitionedTopicName(String tenant, String namespace, String encodedTopic) {
        this.validateTopicName(tenant, namespace, encodedTopic);
        if (encodedTopic.contains("-partition-")) {
            throw new RestException(Response.Status.PRECONDITION_FAILED, "Partitioned Topic Name should not contain '-partition-'");
        }
    }

    protected CompletableFuture<Void> validatePartitionedTopicMetadataAsync() {
        return this.pulsar().getBrokerService().fetchPartitionedTopicMetadataAsync(this.topicName).thenAccept(metadata -> {
            if (metadata.partitions < 1) {
                throw new RestException(Response.Status.CONFLICT, "Topic is not partitioned topic");
            }
        });
    }

    @Deprecated
    protected void validateTopicName(String property, String cluster, String namespace, String encodedTopic) {
        String topic = Codec.decode(encodedTopic);
        try {
            this.namespaceName = NamespaceName.get(property, cluster, namespace);
            this.topicName = TopicName.get(this.domain(), this.namespaceName, topic);
        }
        catch (IllegalArgumentException e) {
            log.warn("[{}] Invalid topic name {}://{}/{}/{}/{}", new Object[]{this.clientAppId(), this.domain(), property, cluster, namespace, topic});
            throw new RestException(Response.Status.PRECONDITION_FAILED, "Topic name is not valid");
        }
    }

    @Deprecated
    protected void validatePersistentTopicName(String property, String cluster, String namespace, String encodedTopic) {
        this.validateTopicName(property, cluster, namespace, encodedTopic);
        if (this.topicName.getDomain() != TopicDomain.persistent) {
            throw new RestException(Response.Status.NOT_ACCEPTABLE, "Need to provide a persistent topic name");
        }
    }

    protected WorkerService validateAndGetWorkerService() {
        try {
            return this.pulsar().getWorkerService();
        }
        catch (UnsupportedOperationException e) {
            throw new RestException(Response.Status.CONFLICT, e.getMessage());
        }
    }

    protected Policies getNamespacePolicies(NamespaceName namespaceName) {
        try {
            Policies policies = this.namespaceResources().getPolicies(namespaceName).orElseThrow(() -> new RestException(Response.Status.NOT_FOUND, "Namespace does not exist"));
            BundlesData bundleData = this.pulsar().getNamespaceService().getNamespaceBundleFactory().getBundles(namespaceName).getBundlesData();
            BundlesData bundlesData = policies.bundles = bundleData != null ? bundleData : policies.bundles;
            if (policies.is_allow_auto_update_schema == null) {
                policies.is_allow_auto_update_schema = this.pulsar().getConfig().isAllowAutoUpdateSchemaEnabled();
            }
            return policies;
        }
        catch (RestException re) {
            throw re;
        }
        catch (Exception e) {
            log.error("[{}] Failed to get namespace policies {}", new Object[]{this.clientAppId(), namespaceName, e});
            throw new RestException(e);
        }
    }

    protected CompletableFuture<Policies> getNamespacePoliciesAsync(NamespaceName namespaceName) {
        return this.namespaceResources().getPoliciesAsync(namespaceName).thenCompose(policies -> {
            if (policies.isPresent()) {
                return this.pulsar().getNamespaceService().getNamespaceBundleFactory().getBundlesAsync(namespaceName).thenCompose(bundles -> {
                    BundlesData bundleData = null;
                    try {
                        bundleData = bundles.getBundlesData();
                    }
                    catch (Exception e) {
                        log.error("[{}] Failed to get namespace policies {}", new Object[]{this.clientAppId(), namespaceName, e});
                        return FutureUtil.failedFuture(new RestException(e));
                    }
                    BundlesData bundlesData = ((Policies)policies.get()).bundles = bundleData != null ? bundleData : ((Policies)policies.get()).bundles;
                    if (((Policies)policies.get()).is_allow_auto_update_schema == null) {
                        ((Policies)policies.get()).is_allow_auto_update_schema = this.pulsar().getConfig().isAllowAutoUpdateSchemaEnabled();
                    }
                    return CompletableFuture.completedFuture((Policies)policies.get());
                });
            }
            return FutureUtil.failedFuture(new RestException(Response.Status.NOT_FOUND, "Namespace does not exist"));
        });
    }

    protected BacklogQuota namespaceBacklogQuota(NamespaceName namespace, BacklogQuota.BacklogQuotaType backlogQuotaType) {
        return this.pulsar().getBrokerService().getBacklogQuotaManager().getBacklogQuota(namespace, backlogQuotaType);
    }

    protected CompletableFuture<Optional<TopicPolicies>> getTopicPoliciesAsyncWithRetry(TopicName topicName) {
        return this.getTopicPoliciesAsyncWithRetry(topicName, false);
    }

    protected CompletableFuture<Optional<TopicPolicies>> getTopicPoliciesAsyncWithRetry(TopicName topicName, boolean isGlobal) {
        try {
            this.checkTopicLevelPolicyEnable();
            return this.pulsar().getTopicPoliciesService().getTopicPoliciesAsyncWithRetry(topicName, null, this.pulsar().getExecutor(), isGlobal);
        }
        catch (Exception e) {
            log.error("[{}] Failed to get topic policies {}", new Object[]{this.clientAppId(), topicName, e});
            return FutureUtil.failedFuture(e);
        }
    }

    protected boolean checkBacklogQuota(BacklogQuota quota, RetentionPolicies retention) {
        if (retention == null || retention.getRetentionSizeInMB() <= 0L && retention.getRetentionTimeInMinutes() <= 0) {
            return true;
        }
        if (quota == null) {
            quota = this.pulsar().getBrokerService().getBacklogQuotaManager().getDefaultQuota();
        }
        if (retention.getRetentionSizeInMB() > 0L && quota.getLimitSize() >= retention.getRetentionSizeInMB() * 1024L * 1024L) {
            return false;
        }
        return retention.getRetentionTimeInMinutes() <= 0 || quota.getLimitTime() < retention.getRetentionTimeInMinutes() * 60;
    }

    protected void checkTopicLevelPolicyEnable() {
        if (!this.config().isTopicLevelPoliciesEnabled()) {
            throw new RestException(Response.Status.METHOD_NOT_ALLOWED, "Topic level policies is disabled, to enable the topic level policy and retry.");
        }
    }

    protected DispatchRateImpl dispatchRate() {
        return DispatchRateImpl.builder().dispatchThrottlingRateInMsg(this.config().getDispatchThrottlingRatePerTopicInMsg()).dispatchThrottlingRateInByte(this.config().getDispatchThrottlingRatePerTopicInByte()).ratePeriodInSecond(1).build();
    }

    protected DispatchRateImpl subscriptionDispatchRate() {
        return DispatchRateImpl.builder().dispatchThrottlingRateInMsg(this.config().getDispatchThrottlingRatePerSubscriptionInMsg()).dispatchThrottlingRateInByte(this.config().getDispatchThrottlingRatePerSubscriptionInByte()).ratePeriodInSecond(1).build();
    }

    protected DispatchRateImpl replicatorDispatchRate() {
        return DispatchRateImpl.builder().dispatchThrottlingRateInMsg(this.config().getDispatchThrottlingRatePerReplicatorInMsg()).dispatchThrottlingRateInByte(this.config().getDispatchThrottlingRatePerReplicatorInByte()).ratePeriodInSecond(1).build();
    }

    protected SubscribeRate subscribeRate() {
        return new SubscribeRate(this.pulsar().getConfiguration().getSubscribeThrottlingRatePerConsumer(), this.pulsar().getConfiguration().getSubscribeRatePeriodPerConsumerInSecond());
    }

    public static ObjectMapper jsonMapper() {
        return ObjectMapperFactory.getThreadLocal();
    }

    protected Set<String> clusters() {
        try {
            Set<String> clusters = this.clusterResources().list().stream().filter(cluster -> !"global".equals(cluster)).collect(Collectors.toSet());
            return clusters;
        }
        catch (Exception e) {
            throw new RestException(e);
        }
    }

    protected CompletableFuture<Set<String>> clustersAsync() {
        return this.clusterResources().listAsync().thenApply(list -> list.stream().filter(cluster -> !"global".equals(cluster)).collect(Collectors.toSet()));
    }

    protected void setServletContext(ServletContext servletContext) {
        this.servletContext = servletContext;
    }

    protected PartitionedTopicMetadata getPartitionedTopicMetadata(TopicName topicName, boolean authoritative, boolean checkAllowAutoCreation) {
        return (PartitionedTopicMetadata)this.sync(() -> this.getPartitionedTopicMetadataAsync(topicName, authoritative, checkAllowAutoCreation));
    }

    protected CompletableFuture<PartitionedTopicMetadata> getPartitionedTopicMetadataAsync(TopicName topicName, boolean authoritative, boolean checkAllowAutoCreation) {
        return ((CompletableFuture)((CompletableFuture)this.validateClusterOwnershipAsync(topicName.getCluster()).thenCompose(__ -> this.validateGlobalNamespaceOwnershipAsync(topicName.getNamespaceObject()))).thenCompose(__ -> this.validateTopicOperationAsync(topicName, TopicOperation.LOOKUP))).thenCompose(__ -> {
            if (checkAllowAutoCreation) {
                return this.pulsar().getBrokerService().fetchPartitionedTopicMetadataCheckAllowAutoCreationAsync(topicName);
            }
            return this.pulsar().getBrokerService().fetchPartitionedTopicMetadataAsync(topicName);
        });
    }

    protected static PartitionedTopicMetadata fetchPartitionedTopicMetadata(PulsarService pulsar, TopicName topicName) {
        try {
            return pulsar.getBrokerService().fetchPartitionedTopicMetadataAsync(topicName).get();
        }
        catch (Exception e) {
            if (e.getCause() instanceof RestException) {
                throw (RestException)e.getCause();
            }
            throw new RestException(e);
        }
    }

    protected static PartitionedTopicMetadata fetchPartitionedTopicMetadataCheckAllowAutoCreation(PulsarService pulsar, TopicName topicName) {
        try {
            return pulsar.getBrokerService().fetchPartitionedTopicMetadataCheckAllowAutoCreationAsync(topicName).get();
        }
        catch (Exception e) {
            if (e.getCause() instanceof RestException) {
                throw (RestException)e.getCause();
            }
            throw new RestException(e);
        }
    }

    @Override
    protected void validateClusterExists(String cluster) {
        try {
            if (!this.clusterResources().getCluster(cluster).isPresent()) {
                throw new RestException(Response.Status.PRECONDITION_FAILED, "Cluster " + cluster + " does not exist.");
            }
        }
        catch (Exception e) {
            throw new RestException(e);
        }
    }

    protected Policies getNamespacePolicies(String tenant, String cluster, String namespace) {
        NamespaceName ns = NamespaceName.get(tenant, cluster, namespace);
        return this.getNamespacePolicies(ns);
    }

    protected boolean isNamespaceReplicated(NamespaceName namespaceName) {
        return this.getNamespaceReplicatedClusters(namespaceName).size() > 1;
    }

    protected Set<String> getNamespaceReplicatedClusters(NamespaceName namespaceName) {
        try {
            Policies policies = this.namespaceResources().getPolicies(namespaceName).orElseThrow(() -> new RestException(Response.Status.NOT_FOUND, "Namespace does not exist"));
            return policies.replication_clusters;
        }
        catch (RestException re) {
            throw re;
        }
        catch (Exception e) {
            log.error("[{}] Failed to get namespace policies {}", new Object[]{this.clientAppId(), namespaceName, e});
            throw new RestException(e);
        }
    }

    protected CompletableFuture<Set<String>> getNamespaceReplicatedClustersAsync(NamespaceName namespaceName) {
        return this.namespaceResources().getPoliciesAsync(namespaceName).thenApply(policies -> {
            if (policies.isPresent()) {
                return ((Policies)policies.get()).replication_clusters;
            }
            throw new RestException(Response.Status.NOT_FOUND, "Namespace does not exist");
        });
    }

    protected List<String> getPartitionedTopicList(TopicDomain topicDomain) {
        try {
            return this.namespaceResources().getPartitionedTopicResources().listPartitionedTopicsAsync(this.namespaceName, topicDomain).join();
        }
        catch (Exception e) {
            log.error("[{}] Failed to get partitioned topic list for namespace {}", new Object[]{this.clientAppId(), this.namespaceName.toString(), e});
            throw new RestException(e);
        }
    }

    protected CompletableFuture<List<String>> getPartitionedTopicListAsync(TopicDomain topicDomain) {
        return this.namespaceResources().getPartitionedTopicResources().listPartitionedTopicsAsync(this.namespaceName, topicDomain);
    }

    protected List<String> getTopicPartitionList(TopicDomain topicDomain) {
        try {
            return this.getPulsarResources().getTopicResources().getExistingPartitions(this.topicName).get(this.config().getMetadataStoreOperationTimeoutSeconds(), TimeUnit.SECONDS);
        }
        catch (Exception e) {
            log.error("[{}] Failed to get topic partition list for namespace {}", new Object[]{this.clientAppId(), this.namespaceName.toString(), e});
            throw new RestException(e);
        }
    }

    protected void internalCreatePartitionedTopic(AsyncResponse asyncResponse, int numPartitions, boolean createLocalTopicOnly) {
        this.internalCreatePartitionedTopic(asyncResponse, numPartitions, createLocalTopicOnly, null);
    }

    protected void internalCreatePartitionedTopic(AsyncResponse asyncResponse, int numPartitions, boolean createLocalTopicOnly, Map<String, String> properties) {
        Integer maxTopicsPerNamespace;
        block11: {
            maxTopicsPerNamespace = null;
            try {
                Policies policies = this.getNamespacePolicies(this.namespaceName);
                maxTopicsPerNamespace = policies.max_topics_per_namespace;
            }
            catch (RestException e) {
                if (e.getResponse().getStatus() == Response.Status.NOT_FOUND.getStatusCode()) break block11;
                log.error("[{}] Failed to create partitioned topic {}", new Object[]{this.clientAppId(), this.namespaceName, e});
                AdminResource.resumeAsyncResponseExceptionally(asyncResponse, e);
                return;
            }
        }
        try {
            List<String> partitionedTopics;
            long topicsCount;
            if (maxTopicsPerNamespace == null) {
                maxTopicsPerNamespace = this.pulsar().getConfig().getMaxTopicsPerNamespace();
            }
            if (maxTopicsPerNamespace > 0 && !this.pulsar().getBrokerService().isSystemTopic(this.topicName) && (topicsCount = (partitionedTopics = this.getTopicPartitionList(TopicDomain.persistent)).stream().filter(t -> !this.pulsar().getBrokerService().isSystemTopic(TopicName.get(t))).count()) + (long)numPartitions > (long)maxTopicsPerNamespace.intValue()) {
                log.error("[{}] Failed to create partitioned topic {}, exceed maximum number of topics in namespace", (Object)this.clientAppId(), (Object)this.topicName);
                AdminResource.resumeAsyncResponseExceptionally(asyncResponse, new RestException(Response.Status.PRECONDITION_FAILED, "Exceed maximum number of topics in namespace."));
                return;
            }
        }
        catch (Exception e) {
            log.error("[{}] Failed to create partitioned topic {}", new Object[]{this.clientAppId(), this.namespaceName, e});
            AdminResource.resumeAsyncResponseExceptionally(asyncResponse, e);
            return;
        }
        int maxPartitions = this.pulsar().getConfig().getMaxNumPartitionsPerPartitionedTopic();
        try {
            this.validateNamespaceOperation(this.topicName.getNamespaceObject(), NamespaceOperation.CREATE_TOPIC);
        }
        catch (Exception e) {
            log.error("[{}] Failed to create partitioned topic {}", new Object[]{this.clientAppId(), this.topicName, e});
            AdminResource.resumeAsyncResponseExceptionally(asyncResponse, e);
            return;
        }
        if (numPartitions <= 0) {
            asyncResponse.resume(new RestException(Response.Status.NOT_ACCEPTABLE, "Number of partitions should be more than 0"));
            return;
        }
        if (maxPartitions > 0 && numPartitions > maxPartitions) {
            asyncResponse.resume(new RestException(Response.Status.NOT_ACCEPTABLE, "Number of partitions should be less than or equal to " + maxPartitions));
            return;
        }
        CompletableFuture createLocalFuture = new CompletableFuture();
        ((CompletableFuture)this.checkTopicExistsAsync(this.topicName).thenAccept(exists -> {
            if (exists.booleanValue()) {
                log.warn("[{}] Failed to create already existing topic {}", (Object)this.clientAppId(), (Object)this.topicName);
                asyncResponse.resume(new RestException(Response.Status.CONFLICT, "This topic already exists"));
                return;
            }
            ((CompletableFuture)this.provisionPartitionedTopicPath(asyncResponse, numPartitions, createLocalTopicOnly, properties).thenCompose(ignored -> this.tryCreatePartitionsAsync(numPartitions))).whenComplete((ignored, ex) -> {
                if (ex != null) {
                    createLocalFuture.completeExceptionally((Throwable)ex);
                    return;
                }
                createLocalFuture.complete(null);
            });
        })).exceptionally(ex -> {
            log.error("[{}] Failed to create partitioned topic {}", new Object[]{this.clientAppId(), this.topicName, ex});
            AdminResource.resumeAsyncResponseExceptionally(asyncResponse, ex);
            return null;
        });
        ArrayList replicatedClusters = new ArrayList();
        if (!createLocalTopicOnly && this.topicName.isGlobal() && this.isNamespaceReplicated(this.namespaceName)) {
            this.getNamespaceReplicatedClusters(this.namespaceName).stream().filter(cluster -> !cluster.equals(this.pulsar().getConfiguration().getClusterName())).forEach(replicatedClusters::add);
        }
        createLocalFuture.whenComplete((ignored, ex) -> {
            if (ex != null) {
                log.error("[{}] Failed to create partitions for topic {}", new Object[]{this.clientAppId(), this.topicName, ex.getCause()});
                if (ex.getCause() instanceof RestException) {
                    asyncResponse.resume(ex.getCause());
                } else {
                    AdminResource.resumeAsyncResponseExceptionally(asyncResponse, ex.getCause());
                }
                return;
            }
            if (!replicatedClusters.isEmpty()) {
                replicatedClusters.forEach(cluster -> ((CompletableFuture)this.pulsar().getPulsarResources().getClusterResources().getClusterAsync((String)cluster).thenAccept(clusterDataOp -> ((TopicsImpl)this.pulsar().getBrokerService().getClusterPulsarAdmin((String)cluster, (Optional<ClusterData>)clusterDataOp).topics()).createPartitionedTopicAsync(this.topicName.getPartitionedTopicName(), numPartitions, true, null))).exceptionally(throwable -> {
                    log.error("Failed to create partition topic in cluster {}.", cluster, throwable);
                    return null;
                }));
            }
            log.info("[{}] Successfully created partitions for topic {} in cluster {}", new Object[]{this.clientAppId(), this.topicName, this.pulsar().getConfiguration().getClusterName()});
            asyncResponse.resume(Response.noContent().build());
        });
    }

    protected CompletableFuture<Boolean> checkTopicExistsAsync(TopicName topicName) {
        return this.pulsar().getNamespaceService().getListOfTopics(topicName.getNamespaceObject(), CommandGetTopicsOfNamespace.Mode.ALL).thenCompose(topics -> {
            boolean exists = false;
            for (String topic : topics) {
                if (!topicName.getPartitionedTopicName().equals(TopicName.get(topic).getPartitionedTopicName())) continue;
                exists = true;
                break;
            }
            return CompletableFuture.completedFuture(exists);
        });
    }

    private CompletableFuture<Void> provisionPartitionedTopicPath(AsyncResponse asyncResponse, int numPartitions, boolean createLocalTopicOnly, Map<String, String> properties) {
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        this.namespaceResources().getPartitionedTopicResources().createPartitionedTopicAsync(this.topicName, new PartitionedTopicMetadata(numPartitions, properties)).whenComplete((ignored, ex) -> {
            if (ex != null) {
                if (ex instanceof MetadataStoreException.AlreadyExistsException) {
                    if (createLocalTopicOnly) {
                        future.complete(null);
                        return;
                    }
                    log.warn("[{}] Failed to create already existing partitioned topic {}", (Object)this.clientAppId(), (Object)this.topicName);
                    future.completeExceptionally(new RestException(Response.Status.CONFLICT, "Partitioned topic already exists"));
                } else if (ex instanceof MetadataStoreException.BadVersionException) {
                    log.warn("[{}] Failed to create partitioned topic {}: concurrent modification", (Object)this.clientAppId(), (Object)this.topicName);
                    future.completeExceptionally(new RestException(Response.Status.CONFLICT, "Concurrent modification"));
                } else {
                    log.error("[{}] Failed to create partitioned topic {}", new Object[]{this.clientAppId(), this.topicName, ex});
                    future.completeExceptionally(new RestException(ex.getCause()));
                }
                return;
            }
            log.info("[{}] Successfully created partitioned topic {}", (Object)this.clientAppId(), (Object)this.topicName);
            future.complete(null);
        });
        return future;
    }

    protected CompletableFuture<SchemaCompatibilityStrategy> getSchemaCompatibilityStrategyAsync() {
        return ((CompletableFuture)this.validateTopicPolicyOperationAsync(this.topicName, PolicyName.SCHEMA_COMPATIBILITY_STRATEGY, PolicyOperation.READ).thenCompose(__ -> this.getSchemaCompatibilityStrategyAsyncWithoutAuth())).whenComplete((__, ex) -> {
            if (ex != null) {
                log.error("[{}] Failed to get schema compatibility strategy of topic {} {}", new Object[]{this.clientAppId(), this.topicName, ex});
            }
        });
    }

    protected CompletableFuture<SchemaCompatibilityStrategy> getSchemaCompatibilityStrategyAsyncWithoutAuth() {
        CompletionStage<Object> future = CompletableFuture.completedFuture(null);
        if (this.config().isTopicLevelPoliciesEnabled()) {
            future = this.getTopicPoliciesAsyncWithRetry(this.topicName).thenApply(op -> op.map(TopicPolicies::getSchemaCompatibilityStrategy).orElse(null));
        }
        return future.thenCompose(topicSchemaCompatibilityStrategy -> {
            if (!SchemaCompatibilityStrategy.isUndefined(topicSchemaCompatibilityStrategy)) {
                return CompletableFuture.completedFuture(topicSchemaCompatibilityStrategy);
            }
            return this.getNamespacePoliciesAsync(this.namespaceName).thenApply(policies -> {
                SchemaCompatibilityStrategy schemaCompatibilityStrategy = policies.schema_compatibility_strategy;
                if (SchemaCompatibilityStrategy.isUndefined(schemaCompatibilityStrategy) && SchemaCompatibilityStrategy.isUndefined(schemaCompatibilityStrategy = SchemaCompatibilityStrategy.fromAutoUpdatePolicy(policies.schema_auto_update_compatibility_strategy))) {
                    schemaCompatibilityStrategy = this.pulsar().getConfig().getSchemaCompatibilityStrategy();
                }
                return schemaCompatibilityStrategy;
            });
        });
    }

    @CanIgnoreReturnValue
    public static <T> T checkNotNull(T reference) {
        return Preconditions.checkNotNull(reference);
    }

    protected void checkNotNull(Object o, String errorMessage) {
        if (o == null) {
            throw new RestException(Response.Status.BAD_REQUEST, errorMessage);
        }
    }

    protected boolean isManagedLedgerNotFoundException(Throwable cause) {
        return cause instanceof ManagedLedgerException.MetadataNotFoundException || cause instanceof MetadataStoreException.NotFoundException;
    }

    protected void checkArgument(boolean b, String errorMessage) {
        if (!b) {
            throw new RestException(Response.Status.BAD_REQUEST, errorMessage);
        }
    }

    protected void validatePersistencePolicies(PersistencePolicies persistence) {
        this.checkNotNull(persistence, "persistence policies should not be null");
        ServiceConfiguration config = this.pulsar().getConfiguration();
        this.checkArgument(persistence.getBookkeeperEnsemble() <= config.getManagedLedgerMaxEnsembleSize(), "Bookkeeper-Ensemble must be <= " + config.getManagedLedgerMaxEnsembleSize());
        this.checkArgument(persistence.getBookkeeperWriteQuorum() <= config.getManagedLedgerMaxWriteQuorum(), "Bookkeeper-WriteQuorum must be <= " + config.getManagedLedgerMaxWriteQuorum());
        this.checkArgument(persistence.getBookkeeperAckQuorum() <= config.getManagedLedgerMaxAckQuorum(), "Bookkeeper-AckQuorum must be <= " + config.getManagedLedgerMaxAckQuorum());
        this.checkArgument(persistence.getBookkeeperEnsemble() >= persistence.getBookkeeperWriteQuorum() && persistence.getBookkeeperWriteQuorum() >= persistence.getBookkeeperAckQuorum(), String.format("Bookkeeper Ensemble (%s) >= WriteQuorum (%s) >= AckQuorum (%s)", persistence.getBookkeeperEnsemble(), persistence.getBookkeeperWriteQuorum(), persistence.getBookkeeperAckQuorum()));
    }

    protected static boolean isRedirectException(Throwable ex) {
        Throwable realCause = FutureUtil.unwrapCompletionException(ex);
        return realCause instanceof WebApplicationException && ((WebApplicationException)realCause).getResponse().getStatus() == Response.Status.TEMPORARY_REDIRECT.getStatusCode();
    }

    protected static boolean isNotFoundException(Throwable ex) {
        Throwable realCause = FutureUtil.unwrapCompletionException(ex);
        return realCause instanceof WebApplicationException && ((WebApplicationException)realCause).getResponse().getStatus() == Response.Status.NOT_FOUND.getStatusCode();
    }

    protected static String getTopicNotFoundErrorMessage(String topic) {
        return String.format("Topic %s not found", topic);
    }

    protected static String getPartitionedTopicNotFoundErrorMessage(String topic) {
        return String.format("Partitioned Topic %s not found", topic);
    }

    protected static String getSubNotFoundErrorMessage(String topic, String subscription) {
        return String.format("Subscription %s not found for topic %s", subscription, topic);
    }

    protected List<String> filterSystemTopic(List<String> topics, boolean includeSystemTopic) {
        return topics.stream().filter(topic -> includeSystemTopic ? true : !this.pulsar().getBrokerService().isSystemTopic((String)topic)).collect(Collectors.toList());
    }
}

