/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.intercept;

import java.io.IOException;
import java.util.Map;
import org.apache.pulsar.broker.PulsarService;
import org.apache.pulsar.broker.service.Consumer;
import org.apache.pulsar.broker.service.Producer;
import org.apache.pulsar.broker.service.ServerCnx;
import org.apache.pulsar.broker.service.Subscription;
import org.apache.pulsar.broker.service.Topic;
import org.apache.pulsar.shade.io.netty.buffer.ByteBuf;
import org.apache.pulsar.shade.javax.servlet.FilterChain;
import org.apache.pulsar.shade.javax.servlet.ServletException;
import org.apache.pulsar.shade.javax.servlet.ServletRequest;
import org.apache.pulsar.shade.javax.servlet.ServletResponse;
import org.apache.pulsar.shade.org.apache.bookkeeper.mledger.Entry;
import org.apache.pulsar.shade.org.apache.pulsar.common.api.proto.BaseCommand;
import org.apache.pulsar.shade.org.apache.pulsar.common.api.proto.CommandAck;
import org.apache.pulsar.shade.org.apache.pulsar.common.api.proto.MessageMetadata;
import org.apache.pulsar.shade.org.apache.pulsar.common.classification.InterfaceAudience;
import org.apache.pulsar.shade.org.apache.pulsar.common.classification.InterfaceStability;
import org.apache.pulsar.shade.org.apache.pulsar.common.intercept.InterceptException;

@InterfaceAudience.LimitedPrivate
@InterfaceStability.Evolving
public interface BrokerInterceptor
extends AutoCloseable {
    default public void beforeSendMessage(Subscription subscription, Entry entry, long[] ackSet, MessageMetadata msgMetadata) {
    }

    default public void onConnectionCreated(ServerCnx cnx) {
    }

    default public void producerCreated(ServerCnx cnx, Producer producer, Map<String, String> metadata) {
    }

    default public void consumerCreated(ServerCnx cnx, Consumer consumer, Map<String, String> metadata) {
    }

    default public void messageProduced(ServerCnx cnx, Producer producer, long startTimeNs, long ledgerId, long entryId, Topic.PublishContext publishContext) {
    }

    default public void messageDispatched(ServerCnx cnx, Consumer consumer, long ledgerId, long entryId, ByteBuf headersAndPayload) {
    }

    default public void messageAcked(ServerCnx cnx, Consumer consumer, CommandAck ackCmd) {
    }

    default public void txnOpened(long tcId, String txnID) {
    }

    default public void txnEnded(String txnID, long txnAction) {
    }

    public void onPulsarCommand(BaseCommand var1, ServerCnx var2) throws InterceptException;

    public void onConnectionClosed(ServerCnx var1);

    public void onWebserviceRequest(ServletRequest var1) throws IOException, ServletException, InterceptException;

    public void onWebserviceResponse(ServletRequest var1, ServletResponse var2) throws IOException, ServletException;

    default public void onFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        chain.doFilter(request, response);
    }

    public void initialize(PulsarService var1) throws Exception;

    @Override
    public void close();
}

