/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.loadbalance.impl;

import java.lang.management.ManagementFactory;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.pulsar.broker.BitRateUnit;
import org.apache.pulsar.broker.PulsarService;
import org.apache.pulsar.broker.loadbalance.BrokerHostUsage;
import org.apache.pulsar.broker.loadbalance.LinuxInfoUtils;
import org.apache.pulsar.shade.com.google.common.annotations.VisibleForTesting;
import org.apache.pulsar.shade.com.sun.management.OperatingSystemMXBean;
import org.apache.pulsar.shade.org.apache.pulsar.common.util.Runnables;
import org.apache.pulsar.shade.org.apache.pulsar.policies.data.loadbalancer.ResourceUsage;
import org.apache.pulsar.shade.org.apache.pulsar.policies.data.loadbalancer.SystemResourceUsage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LinuxBrokerHostUsageImpl
implements BrokerHostUsage {
    private static final Logger log = LoggerFactory.getLogger(LinuxBrokerHostUsageImpl.class);
    private long lastCollection = 0L;
    private double lastTotalNicUsageTx;
    private double lastTotalNicUsageRx;
    private double lastCpuUsage;
    private double lastCpuTotalTime;
    private OperatingSystemMXBean systemBean = (OperatingSystemMXBean)ManagementFactory.getOperatingSystemMXBean();
    private SystemResourceUsage usage = new SystemResourceUsage();
    private final Optional<Double> overrideBrokerNicSpeedGbps;
    private final boolean isCGroupsEnabled;

    public LinuxBrokerHostUsageImpl(PulsarService pulsar) {
        this(pulsar.getConfiguration().getLoadBalancerHostUsageCheckIntervalMinutes(), pulsar.getConfiguration().getLoadBalancerOverrideBrokerNicSpeedGbps(), pulsar.getLoadManagerExecutor());
    }

    public LinuxBrokerHostUsageImpl(int hostUsageCheckIntervalMin, Optional<Double> overrideBrokerNicSpeedGbps, ScheduledExecutorService executorService) {
        this.overrideBrokerNicSpeedGbps = overrideBrokerNicSpeedGbps;
        this.isCGroupsEnabled = LinuxInfoUtils.isCGroupEnabled();
        this.calculateBrokerHostUsage();
        executorService.scheduleWithFixedDelay(Runnables.catchingAndLoggingThrowables(this::calculateBrokerHostUsage), hostUsageCheckIntervalMin, hostUsageCheckIntervalMin, TimeUnit.MINUTES);
    }

    @Override
    public SystemResourceUsage getBrokerHostUsage() {
        return this.usage;
    }

    @Override
    public void calculateBrokerHostUsage() {
        List<String> nics = LinuxInfoUtils.getUsablePhysicalNICs();
        double totalNicLimit = this.getTotalNicLimitWithConfiguration(nics);
        double totalNicUsageTx = LinuxInfoUtils.getTotalNicUsage(nics, LinuxInfoUtils.NICUsageType.TX, BitRateUnit.Kilobit);
        double totalNicUsageRx = LinuxInfoUtils.getTotalNicUsage(nics, LinuxInfoUtils.NICUsageType.RX, BitRateUnit.Kilobit);
        double totalCpuLimit = LinuxInfoUtils.getTotalCpuLimit(this.isCGroupsEnabled);
        long now = System.currentTimeMillis();
        double elapsedSeconds = (double)(now - this.lastCollection) / 1000.0;
        if (elapsedSeconds <= 0.0) {
            log.warn("elapsedSeconds {} is not expected, skip this round of calculateBrokerHostUsage", (Object)elapsedSeconds);
            return;
        }
        SystemResourceUsage usage = new SystemResourceUsage();
        double cpuUsage = this.getTotalCpuUsage(elapsedSeconds);
        if (this.lastCollection == 0L) {
            usage.setMemory(this.getMemUsage());
            usage.setBandwidthIn(new ResourceUsage(0.0, totalNicLimit));
            usage.setBandwidthOut(new ResourceUsage(0.0, totalNicLimit));
        } else {
            double nicUsageTx = (totalNicUsageTx - this.lastTotalNicUsageTx) / elapsedSeconds;
            double nicUsageRx = (totalNicUsageRx - this.lastTotalNicUsageRx) / elapsedSeconds;
            usage.setMemory(this.getMemUsage());
            usage.setBandwidthIn(new ResourceUsage(nicUsageRx, totalNicLimit));
            usage.setBandwidthOut(new ResourceUsage(nicUsageTx, totalNicLimit));
        }
        usage.setCpu(new ResourceUsage(cpuUsage, totalCpuLimit));
        this.lastTotalNicUsageTx = totalNicUsageTx;
        this.lastTotalNicUsageRx = totalNicUsageRx;
        this.lastCollection = System.currentTimeMillis();
        this.usage = usage;
    }

    @VisibleForTesting
    double getTotalNicLimitWithConfiguration(List<String> nics) {
        return this.overrideBrokerNicSpeedGbps.map(BitRateUnit.Gigabit::toKilobit).map(speed -> speed * (double)nics.size()).orElseGet(() -> LinuxInfoUtils.getTotalNicLimit(nics, BitRateUnit.Kilobit));
    }

    private double getTotalCpuUsage(double elapsedTimeSeconds) {
        if (this.isCGroupsEnabled) {
            return this.getTotalCpuUsageForCGroup(elapsedTimeSeconds);
        }
        return this.getTotalCpuUsageForEntireHost();
    }

    private double getTotalCpuUsageForCGroup(double elapsedTimeSeconds) {
        double usage = LinuxInfoUtils.getCpuUsageForCGroup();
        double currentUsage = usage - this.lastCpuUsage;
        this.lastCpuUsage = usage;
        return 100.0 * currentUsage / elapsedTimeSeconds / (double)TimeUnit.SECONDS.toNanos(1L);
    }

    private double getTotalCpuUsageForEntireHost() {
        LinuxInfoUtils.ResourceUsage cpuUsageForEntireHost = LinuxInfoUtils.getCpuUsageForEntireHost();
        if (cpuUsageForEntireHost.isEmpty()) {
            return -1.0;
        }
        double currentUsage = ((double)cpuUsageForEntireHost.getUsage() - this.lastCpuUsage) / ((double)cpuUsageForEntireHost.getTotal() - this.lastCpuTotalTime) * LinuxInfoUtils.getTotalCpuLimit(this.isCGroupsEnabled);
        this.lastCpuUsage = cpuUsageForEntireHost.getUsage();
        this.lastCpuTotalTime = cpuUsageForEntireHost.getTotal();
        return currentUsage;
    }

    private ResourceUsage getMemUsage() {
        double total = (double)this.systemBean.getTotalPhysicalMemorySize() / 1048576.0;
        double free = (double)this.systemBean.getFreePhysicalMemorySize() / 1048576.0;
        return new ResourceUsage(total - free, total);
    }
}

