/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.resourcegroup;

import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import org.apache.pulsar.broker.PulsarService;
import org.apache.pulsar.broker.resourcegroup.ResourceGroupNamespaceConfigListener;
import org.apache.pulsar.broker.resourcegroup.ResourceGroupService;
import org.apache.pulsar.broker.resources.ResourceGroupResources;
import org.apache.pulsar.client.admin.PulsarAdminException;
import org.apache.pulsar.metadata.api.Notification;
import org.apache.pulsar.metadata.api.NotificationType;
import org.apache.pulsar.shade.com.google.common.collect.Sets;
import org.apache.pulsar.shade.org.apache.pulsar.common.policies.data.ResourceGroup;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceGroupConfigListener
implements Consumer<Notification> {
    private static final Logger LOG = LoggerFactory.getLogger(ResourceGroupConfigListener.class);
    private final ResourceGroupService rgService;
    private final PulsarService pulsarService;
    private final ResourceGroupResources rgResources;
    private final ResourceGroupNamespaceConfigListener rgNamespaceConfigListener;

    public ResourceGroupConfigListener(ResourceGroupService rgService, PulsarService pulsarService) {
        this.rgService = rgService;
        this.pulsarService = pulsarService;
        this.rgResources = pulsarService.getPulsarResources().getResourcegroupResources();
        this.loadAllResourceGroups();
        this.rgResources.getStore().registerListener(this);
        this.rgNamespaceConfigListener = new ResourceGroupNamespaceConfigListener(rgService, pulsarService, this);
    }

    private void loadAllResourceGroups() {
        this.rgResources.listResourceGroupsAsync().whenCompleteAsync((rgList, ex) -> {
            if (ex != null) {
                LOG.error("Exception when fetching resource groups", ex);
                return;
            }
            Set<String> existingSet = this.rgService.resourceGroupGetAll();
            HashSet<String> newSet = new HashSet<String>();
            for (Object rgName : rgList) {
                newSet.add((String)rgName);
            }
            Sets.SetView<String> deleteList = Sets.difference(existingSet, newSet);
            for (String rgName : deleteList) {
                this.deleteResourceGroup(rgName);
            }
            Sets.SetView<String> addList = Sets.difference(newSet, existingSet);
            for (String rgName : addList) {
                ((CompletableFuture)this.pulsarService.getPulsarResources().getResourcegroupResources().getResourceGroupAsync(rgName).thenAcceptAsync(optionalRg -> {
                    ResourceGroup rg = (ResourceGroup)optionalRg.get();
                    this.createResourceGroup(rgName, rg);
                })).exceptionally(ex1 -> {
                    LOG.error("Failed to fetch resourceGroup", ex1);
                    return null;
                });
            }
        });
    }

    public synchronized void deleteResourceGroup(String rgName) {
        try {
            if (this.rgService.resourceGroupGet(rgName) != null) {
                LOG.info("Deleting resource group {}", (Object)rgName);
                this.rgService.resourceGroupDelete(rgName);
            }
        }
        catch (PulsarAdminException e) {
            LOG.error("Got exception while deleting resource group {}, {}", (Object)rgName, (Object)e);
        }
    }

    public synchronized void createResourceGroup(String rgName, ResourceGroup rg) {
        if (this.rgService.resourceGroupGet(rgName) == null) {
            LOG.info("Creating resource group {}, {}", (Object)rgName, (Object)rg.toString());
            try {
                this.rgService.resourceGroupCreate(rgName, rg);
            }
            catch (PulsarAdminException ex1) {
                LOG.error("Got an exception while creating RG {}", (Object)rgName, (Object)ex1);
            }
        }
    }

    private void updateResourceGroup(String rgName) {
        this.rgResources.getResourceGroupAsync(rgName).whenComplete((optionalRg, ex) -> {
            if (ex != null) {
                LOG.error("Exception when getting resource group {}", (Object)rgName, ex);
                return;
            }
            ResourceGroup rg = (ResourceGroup)optionalRg.get();
            try {
                LOG.info("Updating resource group {}, {}", (Object)rgName, (Object)rg);
                this.rgService.resourceGroupUpdate(rgName, rg);
            }
            catch (PulsarAdminException ex1) {
                LOG.error("Got an exception while creating resource group {}", (Object)rgName, (Object)ex1);
            }
        });
    }

    @Override
    public void accept(Notification notification) {
        String notifyPath = notification.getPath();
        if (!ResourceGroupResources.isResourceGroupPath(notifyPath)) {
            return;
        }
        LOG.info("Metadata store notification: Path {}, Type {}", (Object)notifyPath, (Object)notification.getType());
        Optional<String> rgName = ResourceGroupResources.resourceGroupNameFromPath(notifyPath);
        if (notification.getType() == NotificationType.ChildrenChanged || notification.getType() == NotificationType.Created) {
            this.loadAllResourceGroups();
        } else if (rgName.isPresent()) {
            switch (notification.getType()) {
                case Modified: {
                    this.updateResourceGroup(rgName.get());
                    break;
                }
            }
        }
    }
}

