/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.rest;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import org.apache.pulsar.broker.service.Topic;
import org.apache.pulsar.shade.io.netty.util.Recycler;
import org.apache.pulsar.shade.org.apache.bookkeeper.mledger.impl.PositionImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestMessagePublishContext
implements Topic.PublishContext {
    private static final Logger log = LoggerFactory.getLogger(RestMessagePublishContext.class);
    private Topic topic;
    private long startTimeNs;
    private CompletableFuture<PositionImpl> positionFuture;
    private final Recycler.Handle<RestMessagePublishContext> recyclerHandle;
    private static final Recycler<RestMessagePublishContext> RECYCLER = new Recycler<RestMessagePublishContext>(){

        @Override
        protected RestMessagePublishContext newObject(Recycler.Handle<RestMessagePublishContext> handle) {
            return new RestMessagePublishContext(handle);
        }
    };

    @Override
    public void completed(Exception exception, long ledgerId, long entryId) {
        if (exception != null) {
            this.positionFuture.completeExceptionally(exception);
            if (log.isInfoEnabled()) {
                log.info("Failed to write entry for rest produce request: ledgerId: {}, entryId: {}. triggered send callback.", (Object)ledgerId, (Object)entryId);
            }
        } else {
            if (log.isInfoEnabled()) {
                log.info("Success write topic for rest produce request: {}, ledgerId: {}, entryId: {}. triggered send callback.", new Object[]{this.topic.getName(), ledgerId, entryId});
            }
            this.topic.recordAddLatency(System.nanoTime() - this.startTimeNs, TimeUnit.NANOSECONDS);
            this.positionFuture.complete(PositionImpl.get(ledgerId, entryId));
        }
        this.recycle();
    }

    public static RestMessagePublishContext get(CompletableFuture<PositionImpl> positionFuture, Topic topic, long startTimeNs) {
        RestMessagePublishContext callback = RECYCLER.get();
        callback.positionFuture = positionFuture;
        callback.topic = topic;
        callback.startTimeNs = startTimeNs;
        return callback;
    }

    private RestMessagePublishContext(Recycler.Handle<RestMessagePublishContext> recyclerHandle) {
        this.recyclerHandle = recyclerHandle;
    }

    public void recycle() {
        this.topic = null;
        this.startTimeNs = -1L;
        this.recyclerHandle.recycle(this);
    }
}

