/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.service;

import java.nio.charset.StandardCharsets;
import javax.annotation.Nullable;
import org.apache.pulsar.shade.com.google.common.annotations.VisibleForTesting;
import org.apache.pulsar.shade.io.netty.buffer.ByteBuf;
import org.apache.pulsar.shade.org.apache.bookkeeper.mledger.Entry;
import org.apache.pulsar.shade.org.apache.bookkeeper.mledger.Position;
import org.apache.pulsar.shade.org.apache.pulsar.common.api.proto.MessageMetadata;
import org.apache.pulsar.shade.org.apache.pulsar.common.protocol.Commands;

public class EntryAndMetadata
implements Entry {
    private final Entry entry;
    @Nullable
    private final MessageMetadata metadata;

    private EntryAndMetadata(Entry entry, @Nullable MessageMetadata metadata) {
        this.entry = entry;
        this.metadata = metadata;
    }

    public static EntryAndMetadata create(Entry entry, MessageMetadata metadata) {
        return new EntryAndMetadata(entry, metadata);
    }

    @VisibleForTesting
    static EntryAndMetadata create(Entry entry) {
        return EntryAndMetadata.create(entry, Commands.peekAndCopyMessageMetadata(entry.getDataBuffer(), "", -1L));
    }

    public byte[] getStickyKey() {
        if (this.metadata != null) {
            if (this.metadata.hasOrderingKey()) {
                return this.metadata.getOrderingKey();
            }
            if (this.metadata.hasPartitionKey()) {
                return this.metadata.getPartitionKey().getBytes(StandardCharsets.UTF_8);
            }
        }
        return "NONE_KEY".getBytes(StandardCharsets.UTF_8);
    }

    public String toString() {
        String s = this.entry.getLedgerId() + ":" + this.entry.getEntryId();
        if (this.metadata != null) {
            s = s + "@" + this.metadata.getProducerName() + "-" + this.metadata.getSequenceId();
            if (this.metadata.hasChunkId() && this.metadata.hasNumChunksFromMsg()) {
                s = s + "-" + this.metadata.getChunkId() + "-" + this.metadata.getNumChunksFromMsg();
            }
        }
        return s;
    }

    @Override
    public byte[] getData() {
        return this.entry.getData();
    }

    @Override
    public byte[] getDataAndRelease() {
        return this.entry.getDataAndRelease();
    }

    @Override
    public int getLength() {
        return this.entry.getLength();
    }

    @Override
    public ByteBuf getDataBuffer() {
        return this.entry.getDataBuffer();
    }

    @Override
    public Position getPosition() {
        return this.entry.getPosition();
    }

    @Override
    public long getLedgerId() {
        return this.entry.getLedgerId();
    }

    @Override
    public long getEntryId() {
        return this.entry.getEntryId();
    }

    @Override
    public boolean release() {
        return this.entry.release();
    }

    @Nullable
    public MessageMetadata getMetadata() {
        return this.metadata;
    }
}

