/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.stats;

import java.util.Arrays;
import java.util.HashMap;
import org.apache.pulsar.shade.com.google.common.collect.Maps;
import org.apache.pulsar.shade.org.apache.bookkeeper.mledger.impl.ManagedLedgerMBeanImpl;
import org.apache.pulsar.shade.org.apache.pulsar.common.stats.Metrics;

public class NamespaceStats {
    public double msgRateIn;
    public double msgThroughputIn;
    public double msgRateOut;
    public double msgThroughputOut;
    public double storageSize;
    public double msgBacklog;
    public double msgReplBacklog;
    public double maxMsgReplDelayInSeconds;
    public int consumerCount;
    public int producerCount;
    public int replicatorCount;
    public int subsCount;
    public static final String BRK_ADD_ENTRY_LATENCY_PREFIX = "brk_AddEntryLatencyBuckets";
    public long[] addLatencyBucket = new long[ManagedLedgerMBeanImpl.ENTRY_LATENCY_BUCKETS_USEC.length + 1];
    public static final String[] ADD_LATENCY_BUCKET_KEYS = new String[ManagedLedgerMBeanImpl.ENTRY_LATENCY_BUCKETS_USEC.length + 1];
    private int ratePeriodInSeconds = 1;

    public NamespaceStats(int ratePeriodInSeconds) {
        this.ratePeriodInSeconds = Math.max(1, ratePeriodInSeconds);
        this.reset();
    }

    public void reset() {
        this.msgRateIn = 0.0;
        this.msgThroughputIn = 0.0;
        this.msgRateOut = 0.0;
        this.msgThroughputOut = 0.0;
        this.storageSize = 0.0;
        this.msgBacklog = 0.0;
        this.msgReplBacklog = 0.0;
        this.maxMsgReplDelayInSeconds = 0.0;
        this.consumerCount = 0;
        this.producerCount = 0;
        this.replicatorCount = 0;
        this.subsCount = 0;
        NamespaceStats.clear(this.addLatencyBucket);
    }

    public Metrics add(String namespace) {
        HashMap<String, String> dimensionMap = Maps.newHashMap();
        dimensionMap.put("namespace", namespace);
        Metrics dMetrics = Metrics.create(dimensionMap);
        dMetrics.put("brk_in_rate", this.msgRateIn);
        dMetrics.put("brk_in_tp_rate", this.msgThroughputIn);
        dMetrics.put("brk_out_rate", this.msgRateOut);
        dMetrics.put("brk_out_tp_rate", this.msgThroughputOut);
        dMetrics.put("brk_storage_size", this.storageSize);
        dMetrics.put("brk_no_of_producers", this.producerCount);
        dMetrics.put("brk_no_of_subscriptions", this.subsCount);
        dMetrics.put("brk_no_of_replicators", this.replicatorCount);
        dMetrics.put("brk_no_of_consumers", this.consumerCount);
        dMetrics.put("brk_msg_backlog", this.msgBacklog);
        dMetrics.put("brk_replication_backlog", this.msgReplBacklog);
        dMetrics.put("brk_max_replication_delay_second", this.maxMsgReplDelayInSeconds);
        for (int i = 0; i < this.addLatencyBucket.length; ++i) {
            dMetrics.put(ADD_LATENCY_BUCKET_KEYS[i], this.addLatencyBucket[i] / (long)this.ratePeriodInSeconds);
        }
        return dMetrics;
    }

    public static void add(long[] src, long[] dest) {
        if (src != null && dest != null && src.length == dest.length) {
            for (int i = 0; i < src.length; ++i) {
                int n = i;
                dest[n] = dest[n] + src[i];
            }
        }
    }

    public static void clear(long[] list) {
        if (list != null) {
            Arrays.fill(list, 0L);
        }
    }

    static {
        for (int i = 0; i < ManagedLedgerMBeanImpl.ENTRY_LATENCY_BUCKETS_USEC.length + 1; ++i) {
            String key = i == 0 && ManagedLedgerMBeanImpl.ENTRY_LATENCY_BUCKETS_USEC.length > 0 ? String.format("%s_0.0_%1.1f", BRK_ADD_ENTRY_LATENCY_PREFIX, (double)ManagedLedgerMBeanImpl.ENTRY_LATENCY_BUCKETS_USEC[i] / 1000.0) : (i < ManagedLedgerMBeanImpl.ENTRY_LATENCY_BUCKETS_USEC.length ? String.format("%s_%1.1f_%1.1f", BRK_ADD_ENTRY_LATENCY_PREFIX, (double)ManagedLedgerMBeanImpl.ENTRY_LATENCY_BUCKETS_USEC[i - 1] / 1000.0, (double)ManagedLedgerMBeanImpl.ENTRY_LATENCY_BUCKETS_USEC[i] / 1000.0) : String.format("%s_OVERFLOW", BRK_ADD_ENTRY_LATENCY_PREFIX));
            NamespaceStats.ADD_LATENCY_BUCKET_KEYS[i] = key;
        }
    }
}

