/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.stats.prometheus;

import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.pulsar.PulsarVersion;
import org.apache.pulsar.broker.PulsarService;
import org.apache.pulsar.broker.stats.TimeWindow;
import org.apache.pulsar.broker.stats.WindowWrap;
import org.apache.pulsar.broker.stats.metrics.ManagedCursorMetrics;
import org.apache.pulsar.broker.stats.metrics.ManagedLedgerCacheMetrics;
import org.apache.pulsar.broker.stats.metrics.ManagedLedgerMetrics;
import org.apache.pulsar.broker.stats.prometheus.NamespaceStatsAggregator;
import org.apache.pulsar.broker.stats.prometheus.PrometheusMetricStreams;
import org.apache.pulsar.broker.stats.prometheus.PrometheusMetricsGeneratorUtils;
import org.apache.pulsar.broker.stats.prometheus.PrometheusRawMetricsProvider;
import org.apache.pulsar.broker.stats.prometheus.TransactionAggregator;
import org.apache.pulsar.shade.io.netty.buffer.ByteBuf;
import org.apache.pulsar.shade.io.netty.buffer.CompositeByteBuf;
import org.apache.pulsar.shade.io.netty.buffer.UnpooledByteBufAllocator;
import org.apache.pulsar.shade.io.prometheus.client.Collector;
import org.apache.pulsar.shade.io.prometheus.client.CollectorRegistry;
import org.apache.pulsar.shade.io.prometheus.client.Gauge;
import org.apache.pulsar.shade.io.prometheus.client.hotspot.DefaultExports;
import org.apache.pulsar.shade.org.apache.bookkeeper.stats.NullStatsProvider;
import org.apache.pulsar.shade.org.apache.bookkeeper.stats.StatsProvider;
import org.apache.pulsar.shade.org.apache.pulsar.common.allocator.PulsarByteBufAllocator;
import org.apache.pulsar.shade.org.apache.pulsar.common.stats.JvmMetrics;
import org.apache.pulsar.shade.org.apache.pulsar.common.stats.Metrics;
import org.apache.pulsar.shade.org.apache.pulsar.common.util.DirectMemoryUtils;
import org.apache.pulsar.shade.org.apache.pulsar.common.util.SimpleTextOutputStream;
import org.apache.pulsar.shade.org.eclipse.jetty.server.HttpOutput;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrometheusMetricsGenerator {
    private static final Logger log = LoggerFactory.getLogger(PrometheusMetricsGenerator.class);
    private static volatile TimeWindow<ByteBuf> timeWindow;
    private static final int MAX_COMPONENTS = 64;

    public static void generate(PulsarService pulsar, boolean includeTopicMetrics, boolean includeConsumerMetrics, boolean includeProducerMetrics, OutputStream out) throws IOException {
        PrometheusMetricsGenerator.generate(pulsar, includeTopicMetrics, includeConsumerMetrics, includeProducerMetrics, false, out, null);
    }

    public static void generate(PulsarService pulsar, boolean includeTopicMetrics, boolean includeConsumerMetrics, boolean includeProducerMetrics, boolean splitTopicAndPartitionIndexLabel, OutputStream out) throws IOException {
        PrometheusMetricsGenerator.generate(pulsar, includeTopicMetrics, includeConsumerMetrics, includeProducerMetrics, splitTopicAndPartitionIndexLabel, out, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void generate(PulsarService pulsar, boolean includeTopicMetrics, boolean includeConsumerMetrics, boolean includeProducerMetrics, boolean splitTopicAndPartitionIndexLabel, OutputStream out, List<PrometheusRawMetricsProvider> metricsProviders) throws IOException {
        ByteBuf buffer;
        boolean exposeBufferMetrics = pulsar.getConfiguration().isMetricsBufferResponse();
        if (!exposeBufferMetrics) {
            buffer = PrometheusMetricsGenerator.generate0(pulsar, includeTopicMetrics, includeConsumerMetrics, includeProducerMetrics, splitTopicAndPartitionIndexLabel, metricsProviders);
        } else {
            WindowWrap<ByteBuf> window;
            if (null == timeWindow) {
                int period = pulsar.getConfiguration().getManagedLedgerStatsPeriodSeconds();
                timeWindow = new TimeWindow(1, (int)TimeUnit.SECONDS.toMillis(period));
            }
            if (null == (window = timeWindow.current(oldBuf -> {
                if (oldBuf != null && oldBuf.refCnt() > 0) {
                    oldBuf.release();
                    log.debug("Cached metrics buffer released");
                }
                try {
                    ByteBuf buf = PrometheusMetricsGenerator.generate0(pulsar, includeTopicMetrics, includeConsumerMetrics, includeProducerMetrics, splitTopicAndPartitionIndexLabel, metricsProviders);
                    log.debug("Generated metrics buffer size {}", (Object)buf.readableBytes());
                    return buf;
                }
                catch (IOException e) {
                    log.error("Generate metrics failed", (Throwable)e);
                    return PulsarByteBufAllocator.DEFAULT.heapBuffer(0);
                }
            })) || null == window.value()) {
                return;
            }
            buffer = window.value();
            log.debug("Current window start {}, current cached buf size {}", (Object)window.start(), (Object)buffer.readableBytes());
        }
        try {
            if (out instanceof HttpOutput) {
                ByteBuffer[] buffers;
                HttpOutput output = (HttpOutput)out;
                for (ByteBuffer buffer0 : buffers = buffer.nioBuffers()) {
                    output.write(buffer0);
                }
            } else {
                int readIndex = buffer.readerIndex();
                int readableBytes = buffer.readableBytes();
                for (int i = 0; i < readableBytes; ++i) {
                    out.write(buffer.getByte(readIndex + i));
                }
            }
        }
        finally {
            if (!exposeBufferMetrics && buffer.refCnt() > 0) {
                buffer.release();
                log.debug("Metrics buffer released.");
            }
        }
    }

    private static ByteBuf generate0(PulsarService pulsar, boolean includeTopicMetrics, boolean includeConsumerMetrics, boolean includeProducerMetrics, boolean splitTopicAndPartitionIndexLabel, List<PrometheusRawMetricsProvider> metricsProviders) throws IOException {
        CompositeByteBuf buf = UnpooledByteBufAllocator.DEFAULT.compositeDirectBuffer(64);
        boolean exceptionHappens = false;
        PrometheusMetricStreams metricStreams = new PrometheusMetricStreams();
        try {
            SimpleTextOutputStream stream = new SimpleTextOutputStream(buf);
            PrometheusMetricsGeneratorUtils.generateSystemMetrics(stream, pulsar.getConfiguration().getClusterName());
            NamespaceStatsAggregator.generate(pulsar, includeTopicMetrics, includeConsumerMetrics, includeProducerMetrics, splitTopicAndPartitionIndexLabel, metricStreams);
            if (pulsar.getWorkerServiceOpt().isPresent()) {
                pulsar.getWorkerService().generateFunctionsStats(stream);
            }
            if (pulsar.getConfiguration().isTransactionCoordinatorEnabled()) {
                TransactionAggregator.generate(pulsar, metricStreams, includeTopicMetrics);
            }
            metricStreams.flushAllToStream(stream);
            PrometheusMetricsGenerator.generateBrokerBasicMetrics(pulsar, stream);
            PrometheusMetricsGenerator.generateManagedLedgerBookieClientMetrics(pulsar, stream);
            if (metricsProviders != null) {
                for (PrometheusRawMetricsProvider metricsProvider : metricsProviders) {
                    metricsProvider.generate(stream);
                }
            }
            CompositeByteBuf compositeByteBuf = buf;
            return compositeByteBuf;
        }
        catch (Throwable t) {
            exceptionHappens = true;
            throw t;
        }
        finally {
            metricStreams.releaseAll();
            if (exceptionHappens) {
                buf.release();
            }
        }
    }

    private static void generateBrokerBasicMetrics(PulsarService pulsar, SimpleTextOutputStream stream) {
        String clusterName = pulsar.getConfiguration().getClusterName();
        PrometheusMetricsGenerator.parseMetricsToPrometheusMetrics(new ManagedLedgerCacheMetrics(pulsar).generate(), clusterName, Collector.Type.GAUGE, stream);
        if (pulsar.getConfiguration().isExposeManagedLedgerMetricsInPrometheus()) {
            PrometheusMetricsGenerator.parseMetricsToPrometheusMetrics(new ManagedLedgerMetrics(pulsar).generate(), clusterName, Collector.Type.GAUGE, stream);
        }
        if (pulsar.getConfiguration().isExposeManagedCursorMetricsInPrometheus()) {
            PrometheusMetricsGenerator.parseMetricsToPrometheusMetrics(new ManagedCursorMetrics(pulsar).generate(), clusterName, Collector.Type.GAUGE, stream);
        }
        PrometheusMetricsGenerator.parseMetricsToPrometheusMetrics(Collections.singletonList(pulsar.getBrokerService().getPulsarStats().getBrokerOperabilityMetrics().generateConnectionMetrics()), clusterName, Collector.Type.GAUGE, stream);
        PrometheusMetricsGenerator.parseMetricsToPrometheusMetrics(pulsar.getLoadManager().get().getLoadBalancingMetrics(), clusterName, Collector.Type.GAUGE, stream);
    }

    private static void parseMetricsToPrometheusMetrics(Collection<Metrics> metrics, String cluster, Collector.Type metricType, SimpleTextOutputStream stream) {
        HashSet<String> names = new HashSet<String>();
        for (Metrics metrics1 : metrics) {
            for (Map.Entry<String, Object> entry : metrics1.getMetrics().entrySet()) {
                String value;
                block8: {
                    value = null;
                    if (entry.getKey().contains(".")) {
                        try {
                            String key = entry.getKey();
                            int dotIndex = key.indexOf(".");
                            int nameIndex = key.substring(0, dotIndex).lastIndexOf("_");
                            if (nameIndex == -1) continue;
                            String name = key.substring(0, nameIndex);
                            value = key.substring(nameIndex + 1);
                            if (!names.contains(name)) {
                                stream.write("# TYPE ").write(name.replace("brk_", "pulsar_")).write(' ').write(PrometheusMetricsGeneratorUtils.getTypeStr(metricType)).write("\n");
                                names.add(name);
                            }
                            stream.write(name.replace("brk_", "pulsar_")).write("{cluster=\"").write(cluster).write('\"');
                            break block8;
                        }
                        catch (Exception e) {
                            continue;
                        }
                    }
                    String name = entry.getKey();
                    if (!names.contains(name)) {
                        stream.write("# TYPE ").write(entry.getKey().replace("brk_", "pulsar_")).write(' ').write(PrometheusMetricsGeneratorUtils.getTypeStr(metricType)).write('\n');
                        names.add(name);
                    }
                    stream.write(name.replace("brk_", "pulsar_")).write("{cluster=\"").write(cluster).write('\"');
                }
                boolean appendedQuantile = false;
                for (Map.Entry<String, String> metric : metrics1.getDimensions().entrySet()) {
                    if (metric.getKey().isEmpty() || "cluster".equals(metric.getKey())) continue;
                    stream.write(", ").write(metric.getKey()).write("=\"").write(metric.getValue()).write('\"');
                    if (value == null || value.isEmpty() || appendedQuantile) continue;
                    stream.write(", ").write("quantile=\"").write(value).write('\"');
                    appendedQuantile = true;
                }
                stream.write("} ").write(String.valueOf(entry.getValue())).write("\n");
            }
        }
    }

    private static void generateManagedLedgerBookieClientMetrics(PulsarService pulsar, SimpleTextOutputStream stream) {
        StatsProvider statsProvider = pulsar.getManagedLedgerClientFactory().getStatsProvider();
        if (statsProvider instanceof NullStatsProvider) {
            return;
        }
        try {
            StringWriter writer = new StringWriter();
            statsProvider.writeAllMetrics(writer);
            stream.write(((Object)writer).toString());
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    static {
        DefaultExports.initialize();
        ((Collector)Gauge.build("jvm_memory_direct_bytes_used", "-").create().setChild(new Gauge.Child(){

            @Override
            public double get() {
                return JvmMetrics.getJvmDirectMemoryUsed();
            }
        }, new String[0])).register(CollectorRegistry.defaultRegistry);
        ((Collector)Gauge.build("jvm_memory_direct_bytes_max", "-").create().setChild(new Gauge.Child(){

            @Override
            public double get() {
                return DirectMemoryUtils.jvmMaxDirectMemory();
            }
        }, new String[0])).register(CollectorRegistry.defaultRegistry);
        ((Collector)((Gauge.Builder)Gauge.build("pulsar_version_info", "-").labelNames("version", "commit")).create().setChild(new Gauge.Child(){

            @Override
            public double get() {
                return 1.0;
            }
        }, PulsarVersion.getVersion(), PulsarVersion.getGitSha())).register(CollectorRegistry.defaultRegistry);
    }
}

